/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.recyclerview;

import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.android.car.ui.recyclerview.CarUiLayoutStyle;

public final class CarUiLinearLayoutStyle
implements CarUiLayoutStyle {
    private int mLayoutOrientation = 1;
    private boolean mReverseLayout = false;
    private int mSize = 2;

    @Nullable
    public static CarUiLinearLayoutStyle from(@Nullable RecyclerView.LayoutManager layoutManager) {
        if (layoutManager == null) {
            return null;
        }
        if (!(layoutManager instanceof LinearLayoutManager)) {
            throw new AssertionError((Object)"LinearLayoutManager required.");
        }
        CarUiLinearLayoutStyle layoutStyle = new CarUiLinearLayoutStyle();
        switch (((LinearLayoutManager)layoutManager).getOrientation()) {
            case 0: {
                layoutStyle.setOrientation(0);
                break;
            }
            case 1: {
                layoutStyle.setOrientation(1);
            }
        }
        layoutStyle.setReverseLayout(((LinearLayoutManager)layoutManager).getReverseLayout());
        return layoutStyle;
    }

    @Override
    public int getSpanCount() {
        return 1;
    }

    @Override
    public int getLayoutType() {
        return 0;
    }

    @Override
    public int getOrientation() {
        return this.mLayoutOrientation;
    }

    public void setOrientation(int orientation) {
        this.mLayoutOrientation = orientation;
    }

    @Override
    public boolean getReverseLayout() {
        return this.mReverseLayout;
    }

    public void setReverseLayout(boolean reverseLayout) {
        this.mReverseLayout = reverseLayout;
    }

    @Override
    public int getSize() {
        return this.mSize;
    }

    public void setSize(int size) {
        this.mSize = size;
    }
}

