/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.recyclerview;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.RadioButton;
import android.widget.Switch;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.android.car.ui.R;
import com.android.car.ui.SecureView;
import com.android.car.ui.recyclerview.CarUiContentListItem;
import com.android.car.ui.recyclerview.CarUiHeaderListItem;
import com.android.car.ui.recyclerview.CarUiListItem;
import com.android.car.ui.recyclerview.CarUiRecyclerView;
import com.android.car.ui.utils.CarUiUtils;
import com.android.car.ui.widget.CarUiTextView;
import java.util.List;

public class CarUiListItemAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements CarUiRecyclerView.ItemCap {
    static final int VIEW_TYPE_LIST_HEADER = 0;
    static final int VIEW_TYPE_LIST_ITEM_FULL_TOUCH_INTERCEPTOR = 1;
    static final int VIEW_TYPE_LIST_ITEM_SPLIT_TOUCH_INTERCEPTOR = 2;
    private final List<? extends CarUiListItem> mItems;
    private final boolean mCompactLayout;
    private int mMaxItems = -1;

    public CarUiListItemAdapter(List<? extends CarUiListItem> items) {
        this(items, false);
    }

    public CarUiListItemAdapter(List<? extends CarUiListItem> items, boolean useCompactLayout) {
        this.mItems = items;
        this.mCompactLayout = useCompactLayout;
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        switch (viewType) {
            case 1: 
            case 2: {
                if (this.mCompactLayout) {
                    return new ListItemViewHolder(inflater.inflate(R.layout.car_ui_list_item_compact, parent, false), viewType == 1);
                }
                return new ListItemViewHolder(inflater.inflate(R.layout.car_ui_list_item_2, parent, false), viewType == 1);
            }
            case 0: {
                return new HeaderViewHolder(inflater.inflate(R.layout.car_ui_header_list_item, parent, false));
            }
        }
        throw new IllegalStateException("Unknown item type.");
    }

    @NonNull
    public List<? extends CarUiListItem> getItems() {
        return this.mItems;
    }

    public int getItemViewType(int position) {
        if (this.mItems.get(position) instanceof CarUiContentListItem) {
            CarUiContentListItem item = (CarUiContentListItem)this.mItems.get(position);
            if (item.getAction() == CarUiContentListItem.Action.ICON && item.getSupplementalIconOnClickListener() != null) {
                return 2;
            }
            return 1;
        }
        if (this.mItems.get(position) instanceof CarUiHeaderListItem) {
            return 0;
        }
        throw new IllegalStateException("Unknown view type.");
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        switch (holder.getItemViewType()) {
            case 1: 
            case 2: {
                if (!(holder instanceof ListItemViewHolder)) {
                    throw new IllegalStateException("Incorrect view holder type for list item.");
                }
                CarUiListItem item = this.mItems.get(position);
                if (!(item instanceof CarUiContentListItem)) {
                    throw new IllegalStateException("Expected item to be bound to viewHolder to be instance of CarUiContentListItem.");
                }
                ((ListItemViewHolder)holder).bind((CarUiContentListItem)item);
                break;
            }
            case 0: {
                if (!(holder instanceof HeaderViewHolder)) {
                    throw new IllegalStateException("Incorrect view holder type for list item.");
                }
                CarUiListItem header = this.mItems.get(position);
                if (!(header instanceof CarUiHeaderListItem)) {
                    throw new IllegalStateException("Expected item to be bound to viewHolder to be instance of CarUiHeaderListItem.");
                }
                ((HeaderViewHolder)holder).bind((CarUiHeaderListItem)header);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown item view type.");
            }
        }
    }

    public int getItemCount() {
        return this.mMaxItems == -1 ? this.mItems.size() : Math.min(this.mItems.size(), this.mMaxItems);
    }

    @Override
    public void setMaxItems(int maxItems) {
        this.mMaxItems = maxItems;
    }

    static class ListItemViewHolder
    extends RecyclerView.ViewHolder {
        final View mTouchInterceptor;
        final View mReducedTouchInterceptor;
        final View mActionContainerTouchInterceptor;
        final CarUiTextView mTitle;
        final CarUiTextView mBody;
        final ImageView mIcon;
        final ImageView mContentIcon;
        final ImageView mAvatarIcon;
        final ViewGroup mIconContainer;
        final ViewGroup mActionContainer;
        final View mActionDivider;
        final Switch mSwitch;
        final CheckBox mCheckBox;
        final RadioButton mRadioButton;
        final ImageView mSupplementalIcon;
        final boolean mUsesFullTouchInterceptor;

        ListItemViewHolder(@NonNull View itemView, boolean usesFullTouchInterceptor) {
            super(itemView);
            if (usesFullTouchInterceptor) {
                CarUiUtils.requireViewByRefId(itemView, R.id.car_ui_list_item_touch_interceptor).setVisibility(0);
            } else {
                CarUiUtils.requireViewByRefId(itemView, R.id.car_ui_list_item_reduced_touch_interceptor).setVisibility(0);
                CarUiUtils.requireViewByRefId(itemView, R.id.car_ui_list_item_action_container_touch_interceptor).setVisibility(0);
            }
            this.mTouchInterceptor = CarUiUtils.requireViewByRefId(itemView, R.id.car_ui_list_item_touch_interceptor);
            this.mReducedTouchInterceptor = CarUiUtils.requireViewByRefId(itemView, R.id.car_ui_list_item_reduced_touch_interceptor);
            this.mActionContainerTouchInterceptor = CarUiUtils.requireViewByRefId(itemView, R.id.car_ui_list_item_action_container_touch_interceptor);
            this.mTitle = (CarUiTextView)((Object)CarUiUtils.requireViewByRefId(itemView, R.id.car_ui_list_item_title));
            this.mBody = (CarUiTextView)((Object)CarUiUtils.requireViewByRefId(itemView, R.id.car_ui_list_item_body));
            this.mIcon = (ImageView)CarUiUtils.requireViewByRefId(itemView, R.id.car_ui_list_item_icon);
            this.mContentIcon = (ImageView)CarUiUtils.requireViewByRefId(itemView, R.id.car_ui_list_item_content_icon);
            this.mAvatarIcon = (ImageView)CarUiUtils.requireViewByRefId(itemView, R.id.car_ui_list_item_avatar_icon);
            this.mIconContainer = (ViewGroup)CarUiUtils.requireViewByRefId(itemView, R.id.car_ui_list_item_icon_container);
            this.mActionContainer = (ViewGroup)CarUiUtils.requireViewByRefId(itemView, R.id.car_ui_list_item_action_container);
            this.mActionDivider = CarUiUtils.requireViewByRefId(itemView, R.id.car_ui_list_item_action_divider);
            this.mSwitch = (Switch)CarUiUtils.requireViewByRefId(itemView, R.id.car_ui_list_item_switch_widget);
            this.mCheckBox = (CheckBox)CarUiUtils.requireViewByRefId(itemView, R.id.car_ui_list_item_checkbox_widget);
            this.mRadioButton = (RadioButton)CarUiUtils.requireViewByRefId(itemView, R.id.car_ui_list_item_radio_button_widget);
            this.mSupplementalIcon = (ImageView)CarUiUtils.requireViewByRefId(itemView, R.id.car_ui_list_item_supplemental_icon);
            this.mUsesFullTouchInterceptor = usesFullTouchInterceptor;
        }

        void bind(@NonNull CarUiContentListItem item) {
            if (item.getTitle() != null) {
                this.mTitle.setText(item.getTitle());
                this.mTitle.setVisibility(0);
            } else {
                this.mTitle.setVisibility(8);
            }
            if (item.getBody() != null) {
                this.mBody.setText(item.getBody());
                this.mBody.setVisibility(0);
            } else {
                this.mBody.setVisibility(8);
            }
            this.mIcon.setVisibility(8);
            this.mContentIcon.setVisibility(8);
            this.mAvatarIcon.setVisibility(8);
            Drawable icon = item.getIcon();
            if (icon != null) {
                this.mIconContainer.setVisibility(0);
                switch (item.getPrimaryIconType()) {
                    case CONTENT: {
                        this.mContentIcon.setVisibility(0);
                        this.mContentIcon.setImageDrawable(icon);
                        break;
                    }
                    case STANDARD: {
                        this.mIcon.setVisibility(0);
                        this.mIcon.setImageDrawable(icon);
                        break;
                    }
                    case AVATAR: {
                        this.mAvatarIcon.setVisibility(0);
                        this.mAvatarIcon.setImageDrawable(icon);
                        this.mAvatarIcon.setClipToOutline(true);
                    }
                }
            } else {
                this.mIconContainer.setVisibility(8);
            }
            boolean logWarning = false;
            if (this.mUsesFullTouchInterceptor) {
                if (this.mTouchInterceptor instanceof SecureView) {
                    ((SecureView)this.mTouchInterceptor).setSecure(item.isSecure());
                } else {
                    logWarning = true;
                }
            } else {
                if (this.mReducedTouchInterceptor instanceof SecureView) {
                    ((SecureView)this.mReducedTouchInterceptor).setSecure(item.isSecure());
                } else {
                    logWarning = true;
                }
                if (this.mActionContainerTouchInterceptor instanceof SecureView) {
                    ((SecureView)this.mActionContainerTouchInterceptor).setSecure(item.isSecure());
                } else {
                    logWarning = true;
                }
            }
            if (logWarning) {
                Log.w((String)"carui", (String)"List item doesn't have a SecureView, but security was requested!");
            }
            this.mActionDivider.setVisibility(item.isActionDividerVisible() ? 0 : 8);
            this.mSwitch.setVisibility(8);
            this.mCheckBox.setVisibility(8);
            this.mRadioButton.setVisibility(8);
            this.mSupplementalIcon.setVisibility(8);
            CarUiContentListItem.OnClickListener itemOnClickListener = item.getOnClickListener();
            switch (item.getAction()) {
                case NONE: {
                    this.mActionContainer.setVisibility(8);
                    this.mTouchInterceptor.setVisibility(0);
                    this.mTouchInterceptor.setOnClickListener(v -> {
                        if (itemOnClickListener != null) {
                            itemOnClickListener.onClick(item);
                        }
                    });
                    this.mTouchInterceptor.setClickable(itemOnClickListener != null);
                    this.mReducedTouchInterceptor.setVisibility(8);
                    this.mActionContainerTouchInterceptor.setVisibility(8);
                    break;
                }
                case SWITCH: {
                    this.bindCompoundButton(item, (CompoundButton)this.mSwitch, itemOnClickListener);
                    break;
                }
                case CHECK_BOX: {
                    this.bindCompoundButton(item, (CompoundButton)this.mCheckBox, itemOnClickListener);
                    break;
                }
                case RADIO_BUTTON: {
                    this.bindCompoundButton(item, (CompoundButton)this.mRadioButton, itemOnClickListener);
                    break;
                }
                case CHEVRON: {
                    this.mSupplementalIcon.setVisibility(0);
                    this.mSupplementalIcon.setImageDrawable(this.itemView.getContext().getDrawable(R.drawable.car_ui_preference_icon_chevron));
                    this.mActionContainer.setVisibility(0);
                    this.mTouchInterceptor.setVisibility(0);
                    this.mTouchInterceptor.setOnClickListener(v -> {
                        if (itemOnClickListener != null) {
                            itemOnClickListener.onClick(item);
                        }
                    });
                    this.mTouchInterceptor.setClickable(itemOnClickListener != null);
                    this.mReducedTouchInterceptor.setVisibility(8);
                    this.mActionContainerTouchInterceptor.setVisibility(8);
                    break;
                }
                case ICON: {
                    this.mSupplementalIcon.setVisibility(0);
                    this.mSupplementalIcon.setImageDrawable(item.getSupplementalIcon());
                    this.mActionContainer.setVisibility(0);
                    if (item.getSupplementalIconOnClickListener() == null) {
                        this.mTouchInterceptor.setVisibility(0);
                        this.mTouchInterceptor.setOnClickListener(v -> {
                            if (itemOnClickListener != null) {
                                itemOnClickListener.onClick(item);
                            }
                        });
                        this.mTouchInterceptor.setClickable(itemOnClickListener != null);
                        this.mReducedTouchInterceptor.setVisibility(8);
                        this.mActionContainerTouchInterceptor.setVisibility(8);
                        break;
                    }
                    this.mReducedTouchInterceptor.setVisibility(0);
                    this.mReducedTouchInterceptor.setOnClickListener(v -> {
                        if (itemOnClickListener != null) {
                            itemOnClickListener.onClick(item);
                        }
                    });
                    this.mReducedTouchInterceptor.setClickable(itemOnClickListener != null);
                    this.mActionContainerTouchInterceptor.setVisibility(0);
                    this.mActionContainerTouchInterceptor.setOnClickListener(container -> {
                        if (item.getSupplementalIconOnClickListener() != null) {
                            item.getSupplementalIconOnClickListener().onClick(item);
                        }
                    });
                    this.mActionContainerTouchInterceptor.setClickable(item.getSupplementalIconOnClickListener() != null);
                    this.mTouchInterceptor.setVisibility(8);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown secondary action type.");
                }
            }
            this.itemView.setActivated(item.isActivated());
            this.setEnabled(this.itemView, item.isEnabled());
        }

        void setEnabled(View view, boolean enabled) {
            view.setEnabled(enabled);
            if (view instanceof ViewGroup) {
                ViewGroup group = (ViewGroup)view;
                for (int i = 0; i < group.getChildCount(); ++i) {
                    this.setEnabled(group.getChildAt(i), enabled);
                }
            }
        }

        void bindCompoundButton(@NonNull CarUiContentListItem item, @NonNull CompoundButton compoundButton, @Nullable CarUiContentListItem.OnClickListener itemOnClickListener) {
            compoundButton.setVisibility(0);
            compoundButton.setOnCheckedChangeListener(null);
            compoundButton.setChecked(item.isChecked());
            compoundButton.setOnCheckedChangeListener((buttonView, isChecked) -> item.setChecked(isChecked));
            this.mTouchInterceptor.setVisibility(0);
            this.mTouchInterceptor.setOnClickListener(v -> {
                compoundButton.toggle();
                if (itemOnClickListener != null) {
                    itemOnClickListener.onClick(item);
                }
            });
            this.mTouchInterceptor.setClickable(true);
            this.mReducedTouchInterceptor.setVisibility(8);
            this.mActionContainerTouchInterceptor.setVisibility(8);
            this.mActionContainer.setVisibility(0);
            this.mActionContainer.setClickable(false);
        }
    }

    static class HeaderViewHolder
    extends RecyclerView.ViewHolder {
        private final TextView mTitle;
        private final TextView mBody;

        HeaderViewHolder(@NonNull View itemView) {
            super(itemView);
            this.mTitle = (TextView)CarUiUtils.requireViewByRefId(itemView, R.id.car_ui_list_item_title);
            this.mBody = (TextView)CarUiUtils.requireViewByRefId(itemView, R.id.car_ui_list_item_body);
        }

        private void bind(@NonNull CarUiHeaderListItem item) {
            this.mTitle.setText(item.getTitle());
            CharSequence body = item.getBody();
            if (!TextUtils.isEmpty((CharSequence)body)) {
                this.mBody.setText(body);
            } else {
                this.mBody.setVisibility(8);
            }
        }
    }
}

