/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.recyclerview;

import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.android.car.ui.plugin.oemapis.recyclerview.AdapterOEMV2;
import com.android.car.ui.plugin.oemapis.recyclerview.ViewHolderOEMV1;

public final class CarUiListItemAdapterAdapterV2
extends RecyclerView.Adapter<ViewHolderWrapper> {
    @NonNull
    private AdapterOEMV2 mAdapter;

    public CarUiListItemAdapterAdapterV2(@NonNull AdapterOEMV2 adapter) {
        this.mAdapter = adapter;
        CarUiListItemAdapterAdapterV2.super.setHasStableIds(adapter.hasStableIds());
    }

    public int getItemCount() {
        return this.mAdapter.getItemCount();
    }

    public long getItemId(int position) {
        return this.mAdapter.getItemId(position);
    }

    public int getItemViewType(int position) {
        return this.mAdapter.getItemViewType(position);
    }

    public void onBindViewHolder(ViewHolderWrapper holder, int position) {
        this.mAdapter.bindViewHolder(holder.getViewHolder(), position);
    }

    public ViewHolderWrapper onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolderWrapper(this.mAdapter.createViewHolder(parent, viewType));
    }

    public boolean onFailedToRecycleView(ViewHolderWrapper holder) {
        return this.mAdapter.onFailedToRecycleView(holder.getViewHolder());
    }

    public void onViewAttachedToWindow(ViewHolderWrapper holder) {
        this.mAdapter.onViewAttachedToWindow(holder.getViewHolder());
    }

    public void onViewDetachedFromWindow(ViewHolderWrapper holder) {
        this.mAdapter.onViewDetachedFromWindow(holder.getViewHolder());
    }

    public void onViewRecycled(ViewHolderWrapper holder) {
        this.mAdapter.onViewRecycled(holder.getViewHolder());
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        this.mAdapter.onAttachedToRecyclerView(null);
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        this.mAdapter.onDetachedFromRecyclerView(null);
    }

    public void setStateRestorationPolicy(RecyclerView.Adapter.StateRestorationPolicy policy) {
        switch (policy) {
            case PREVENT: {
                this.mAdapter.setStateRestorationPolicy(2);
                break;
            }
            case PREVENT_WHEN_EMPTY: {
                this.mAdapter.setStateRestorationPolicy(1);
                break;
            }
            default: {
                this.mAdapter.setStateRestorationPolicy(0);
            }
        }
        switch (this.mAdapter.getStateRestorationPolicyInt()) {
            case 2: {
                super.setStateRestorationPolicy(RecyclerView.Adapter.StateRestorationPolicy.PREVENT);
                break;
            }
            case 1: {
                super.setStateRestorationPolicy(RecyclerView.Adapter.StateRestorationPolicy.PREVENT_WHEN_EMPTY);
                break;
            }
            default: {
                super.setStateRestorationPolicy(RecyclerView.Adapter.StateRestorationPolicy.ALLOW);
            }
        }
    }

    public static class ViewHolderWrapper
    extends RecyclerView.ViewHolder {
        @NonNull
        private final ViewHolderOEMV1 mViewHolder;

        ViewHolderWrapper(@NonNull ViewHolderOEMV1 viewHolder) {
            super(viewHolder.getItemView());
            this.mViewHolder = viewHolder;
            this.setIsRecyclable(viewHolder.isRecyclable());
        }

        @NonNull
        public ViewHolderOEMV1 getViewHolder() {
            return this.mViewHolder;
        }
    }
}

