/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.recyclerview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.android.car.ui.R;
import com.android.car.ui.recyclerview.CarUiContentListItem;
import com.android.car.ui.recyclerview.CarUiListItem;
import com.android.car.ui.recyclerview.CarUiListItemAdapter;
import com.android.car.ui.recyclerview.CarUiRadioButtonListItem;
import java.util.List;

public class CarUiRadioButtonListItemAdapter
extends CarUiListItemAdapter {
    private int mSelectedIndex = -1;

    public CarUiRadioButtonListItemAdapter(List<CarUiRadioButtonListItem> items) {
        super(items);
        for (int i = 0; i < items.size(); ++i) {
            CarUiRadioButtonListItem item = items.get(i);
            if (item.isChecked() && this.mSelectedIndex >= 0) {
                throw new IllegalStateException("At most one item in a CarUiRadioButtonListItemAdapter can be checked");
            }
            if (!item.isChecked()) continue;
            this.mSelectedIndex = i;
        }
    }

    @Override
    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        if (viewType == 1 || viewType == 2) {
            return new RadioButtonListItemViewHolder(inflater.inflate(R.layout.car_ui_list_item, parent, false));
        }
        return super.onCreateViewHolder(parent, viewType);
    }

    @Override
    @SuppressLint(value={"Correctness"})
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        if (holder.getItemViewType() == 1 || holder.getItemViewType() == 2) {
            if (!(holder instanceof RadioButtonListItemViewHolder)) {
                throw new IllegalStateException("Incorrect view holder type for list item.");
            }
            CarUiListItem item = this.getItems().get(position);
            if (!(item instanceof CarUiRadioButtonListItem)) {
                throw new IllegalStateException("Expected item to be bound to viewHolder to be instance of CarUiRadioButtonListItem.");
            }
            RadioButtonListItemViewHolder actualHolder = (RadioButtonListItemViewHolder)holder;
            actualHolder.bind((CarUiRadioButtonListItem)item);
            actualHolder.setOnCheckedChangeListener(isChecked -> {
                if (isChecked && this.mSelectedIndex >= 0) {
                    CarUiRadioButtonListItem previousSelectedItem = (CarUiRadioButtonListItem)this.getItems().get(this.mSelectedIndex);
                    previousSelectedItem.setChecked(false);
                    this.notifyItemChanged(this.mSelectedIndex);
                }
                if (isChecked) {
                    this.mSelectedIndex = position;
                    CarUiRadioButtonListItem currentSelectedItem = (CarUiRadioButtonListItem)this.getItems().get(this.mSelectedIndex);
                    currentSelectedItem.setChecked(true);
                    this.notifyItemChanged(this.mSelectedIndex);
                }
            });
        } else {
            super.onBindViewHolder(holder, position);
        }
    }

    public int getSelectedItemPosition() {
        return this.mSelectedIndex;
    }

    static class RadioButtonListItemViewHolder
    extends CarUiListItemAdapter.ListItemViewHolder {
        @Nullable
        private OnCheckedChangeListener mListener;

        RadioButtonListItemViewHolder(@NonNull View itemView) {
            super(itemView, true);
        }

        public void setOnCheckedChangeListener(@Nullable OnCheckedChangeListener listener) {
            this.mListener = listener;
        }

        @Override
        void bind(@NonNull CarUiContentListItem item) {
            super.bind(item);
            this.mRadioButton.setOnCheckedChangeListener((buttonView, isChecked) -> {
                item.setChecked(isChecked);
                if (this.mListener != null) {
                    this.mListener.onCheckedChanged(isChecked);
                }
            });
        }

        public static interface OnCheckedChangeListener {
            public void onCheckedChanged(boolean var1);
        }
    }
}

