/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.recyclerview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.android.car.ui.pluginsupport.PluginFactorySingleton;
import com.android.car.ui.recyclerview.CarUiLayoutStyle;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SuppressLint(value={"Instantiatable"})
public interface CarUiRecyclerView {
    public static final int SIZE_SMALL = 0;
    public static final int SIZE_MEDIUM = 1;
    public static final int SIZE_LARGE = 2;
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_SETTLING = 2;

    public static CarUiRecyclerView create(Context context) {
        return PluginFactorySingleton.get(context).createRecyclerView(context, null);
    }

    public static CarUiRecyclerView create(Context context, AttributeSet attributeSet) {
        return PluginFactorySingleton.get(context).createRecyclerView(context, attributeSet);
    }

    @Deprecated
    public void addItemDecoration(@NonNull RecyclerView.ItemDecoration var1);

    @Deprecated
    public void addItemDecoration(@NonNull RecyclerView.ItemDecoration var1, int var2);

    public void addOnChildAttachStateChangeListener(RecyclerView.OnChildAttachStateChangeListener var1);

    @Deprecated
    public void addOnLayoutChangeListener(View.OnLayoutChangeListener var1);

    public void addOnScrollListener(OnScrollListener var1);

    public void clearOnChildAttachStateChangeListeners();

    public void clearOnScrollListeners();

    public int findFirstCompletelyVisibleItemPosition();

    public int findFirstVisibleItemPosition();

    public int findLastCompletelyVisibleItemPosition();

    public int findLastVisibleItemPosition();

    @Deprecated
    public <T extends View> T findViewById(int var1);

    public View findViewByPosition(int var1);

    public RecyclerView.ViewHolder findViewHolderForAdapterPosition(int var1);

    public RecyclerView.ViewHolder findViewHolderForLayoutPosition(int var1);

    @Deprecated
    public void focusableViewAvailable(View var1);

    public RecyclerView.Adapter<?> getAdapter();

    @Deprecated
    public float getAlpha();

    @Deprecated
    @Nullable
    public View getChildAt(int var1);

    @Deprecated
    public int getChildCount();

    public int getChildLayoutPosition(View var1);

    @Deprecated
    public CharSequence getContentDescription();

    @Deprecated
    public Context getContext();

    @VisibleForTesting
    public int getDecoratedEnd(View var1);

    @VisibleForTesting
    public int getDecoratedMeasuredHeight(View var1);

    @VisibleForTesting
    public int getDecoratedMeasuredWidth(View var1);

    @VisibleForTesting
    public int getDecoratedMeasurement(View var1);

    @VisibleForTesting
    public int getDecoratedMeasurementInOther(View var1);

    @VisibleForTesting
    public int getDecoratedStart(View var1);

    @VisibleForTesting
    public int getEndAfterPadding();

    @Deprecated
    public int getHeight();

    @Deprecated
    @Nullable
    public RecyclerView.ItemDecoration getItemDecorationAt(int var1);

    @Deprecated
    public int getItemDecorationCount();

    @Nullable
    public CarUiLayoutStyle getLayoutStyle();

    public boolean hasFixedSize();

    @Deprecated
    public int getPaddingLeft();

    @Deprecated
    public int getPaddingRight();

    @Deprecated
    public int getPaddingBottom();

    @Deprecated
    public int getPaddingEnd();

    @Deprecated
    public int getPaddingStart();

    @Deprecated
    public int getPaddingTop();

    @Deprecated
    public ViewParent getParent();

    public int getRecyclerViewChildCount();

    @Nullable
    public View getRecyclerViewChildAt(int var1);

    @VisibleForTesting
    public int getRecyclerViewChildPosition(View var1);

    public int getScrollState();

    @VisibleForTesting
    public int getStartAfterPadding();

    @Deprecated
    public Object getTag();

    @VisibleForTesting
    public int getTotalSpace();

    @NonNull
    public View getView();

    @Deprecated
    public ViewTreeObserver getViewTreeObserver();

    @Deprecated
    public void invalidateItemDecorations();

    @Deprecated
    public boolean post(Runnable var1);

    @Deprecated
    public void removeItemDecoration(@NonNull RecyclerView.ItemDecoration var1);

    @Deprecated
    public void removeItemDecorationAt(int var1);

    public void removeOnChildAttachStateChangeListener(RecyclerView.OnChildAttachStateChangeListener var1);

    @Deprecated
    public void removeOnLayoutChangeListener(View.OnLayoutChangeListener var1);

    @Deprecated
    public void requestLayout();

    public void removeOnScrollListener(OnScrollListener var1);

    @Deprecated
    public <T extends View> T requireViewById(int var1);

    @Deprecated
    public void scrollBy(int var1, int var2);

    public void scrollToPosition(int var1);

    public void scrollToPositionWithOffset(int var1, int var2);

    public void setAdapter(RecyclerView.Adapter<?> var1);

    @Deprecated
    public void setAlpha(float var1);

    @Deprecated
    public void setClipToPadding(boolean var1);

    @Deprecated
    public void setContentDescription(CharSequence var1);

    public void setHasFixedSize(boolean var1);

    @Deprecated
    public void setFadingEdgeLength(int var1);

    public void setOnFlingListener(RecyclerView.OnFlingListener var1);

    @Deprecated
    public void setId(@IdRes int var1);

    @Deprecated
    public void setItemAnimator(RecyclerView.ItemAnimator var1);

    @Deprecated
    default public void setLayoutManager(@Nullable RecyclerView.LayoutManager layoutManager) {
    }

    public void setLayoutStyle(@Nullable CarUiLayoutStyle var1);

    @Deprecated
    public void setOnTouchListener(View.OnTouchListener var1);

    @Deprecated
    public void setPadding(int var1, int var2, int var3, int var4);

    @Deprecated
    public void setPaddingRelative(int var1, int var2, int var3, int var4);

    public void setSpanSizeLookup(@NonNull GridLayoutManager.SpanSizeLookup var1);

    @Deprecated
    public void setTag(Object var1);

    @Deprecated
    public void setVerticalFadingEdgeEnabled(boolean var1);

    @Deprecated
    public void setVerticalScrollBarEnabled(boolean var1);

    @Deprecated
    public void setVerticalScrollbarPosition(int var1);

    @Deprecated
    public void setVisibility(int var1);

    public void smoothScrollBy(int var1, int var2);

    public void smoothScrollToPosition(int var1);

    public static interface OnAttachListener {
        public void onAttachedToCarUiRecyclerView(@NonNull CarUiRecyclerView var1);

        public void onDetachedFromCarUiRecyclerView(@NonNull CarUiRecyclerView var1);
    }

    public static interface OnScrollListener {
        public void onScrolled(CarUiRecyclerView var1, int var2, int var3);

        public void onScrollStateChanged(CarUiRecyclerView var1, int var2);
    }

    public static interface ItemCap {
        public static final int UNLIMITED = -1;

        public void setMaxItems(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CarUiRecyclerViewLayout {
        public static final int LINEAR = 0;
        public static final int GRID = 1;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Size {
    }
}

