/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.recyclerview;

import android.annotation.SuppressLint;
import android.car.drivingstate.CarUxRestrictions;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.OrientationHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.android.car.ui.R;
import com.android.car.ui.plugin.oemapis.recyclerview.RecyclerViewAttributesOEMV1;
import com.android.car.ui.preference.PreferenceFragment;
import com.android.car.ui.recyclerview.CarUiGridLayoutStyle;
import com.android.car.ui.recyclerview.CarUiLayoutStyle;
import com.android.car.ui.recyclerview.CarUiLinearLayoutStyle;
import com.android.car.ui.recyclerview.CarUiRecyclerView;
import com.android.car.ui.recyclerview.CarUiRecyclerViewContainer;
import com.android.car.ui.recyclerview.DefaultScrollBar;
import com.android.car.ui.recyclerview.ScrollBar;
import com.android.car.ui.recyclerview.decorations.grid.GridDividerItemDecoration;
import com.android.car.ui.recyclerview.decorations.linear.LinearDividerItemDecoration;
import com.android.car.ui.utils.CarUiUtils;
import com.android.car.ui.utils.CarUxRestrictionsUtil;
import com.android.car.ui.utils.ViewUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@SuppressLint(value={"CustomViewStyleable"})
public final class CarUiRecyclerViewImpl
extends FrameLayout
implements CarUiRecyclerView,
ViewUtils.LazyLayoutView,
PreferenceFragment.AndroidxRecyclerViewProvider {
    private static final String TAG = "CarUiRecyclerView";
    private static final Class<?>[] LAYOUT_MANAGER_CONSTRUCTOR_SIGNATURE = new Class[]{Context.class, AttributeSet.class, Integer.TYPE, Integer.TYPE};
    @Nullable
    private RecyclerView.Adapter<?> mAdapter;
    @NonNull
    private RecyclerView mRecyclerView;
    private final CarUxRestrictionsUtil.OnUxRestrictionsChangedListener mListener = new UxRestrictionChangedListener();
    @NonNull
    private final CarUxRestrictionsUtil mCarUxRestrictionsUtil;
    private boolean mScrollBarEnabled;
    @Nullable
    private String mScrollBarClass;
    private int mScrollBarPaddingTop;
    private int mScrollBarPaddingBottom;
    @Nullable
    private ScrollBar mScrollBar;
    @Nullable
    private GridDividerItemDecoration mDividerItemDecorationGrid;
    @Nullable
    private RecyclerView.ItemDecoration mDividerItemDecorationLinear;
    private int mNumOfColumns;
    private int mSize;
    private boolean mIsInitialized;
    private boolean mEnableDividers;
    @NonNull
    private final Set<Runnable> mOnLayoutCompletedListeners = new HashSet<Runnable>();
    @Nullable
    private CarUiLayoutStyle mLayoutStyle;
    @NonNull
    private final List<CarUiRecyclerView.OnScrollListener> mScrollListeners = new ArrayList<CarUiRecyclerView.OnScrollListener>();
    @NonNull
    private final RecyclerView.OnScrollListener mOnScrollListener = new RecyclerView.OnScrollListener(){

        public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
            for (CarUiRecyclerView.OnScrollListener listener : CarUiRecyclerViewImpl.this.mScrollListeners) {
                listener.onScrollStateChanged(CarUiRecyclerViewImpl.this, CarUiRecyclerViewImpl.toInternalScrollState(newState));
            }
        }

        public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
            for (CarUiRecyclerView.OnScrollListener listener : CarUiRecyclerViewImpl.this.mScrollListeners) {
                listener.onScrolled(CarUiRecyclerViewImpl.this, dx, dy);
            }
        }
    };

    public CarUiRecyclerViewImpl(@NonNull Context context) {
        this(context, null, 0);
    }

    public CarUiRecyclerViewImpl(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CarUiRecyclerViewImpl(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mCarUxRestrictionsUtil = CarUxRestrictionsUtil.getInstance(context);
        this.init(context, attrs, null, defStyle);
    }

    public CarUiRecyclerViewImpl(@NonNull Context context, RecyclerViewAttributesOEMV1 attrs) {
        super(context, null, 0);
        this.mCarUxRestrictionsUtil = CarUxRestrictionsUtil.getInstance(context);
        this.init(context, null, attrs, 0);
    }

    public boolean canScrollHorizontally(int direction) {
        return this.mRecyclerView.canScrollHorizontally(direction);
    }

    public boolean canScrollVertically(int direction) {
        return this.mRecyclerView.canScrollVertically(direction);
    }

    private void init(Context context, @Nullable AttributeSet attrs, @Nullable RecyclerViewAttributesOEMV1 attrs2, int defStyleAttr) {
        String layoutManagerInXml;
        LayoutInflater factory;
        View rootView;
        ViewGroup recyclerViewContainer;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CarUiRecyclerView, defStyleAttr, 0);
        this.mScrollBarEnabled = context.getResources().getBoolean(R.bool.car_ui_scrollbar_enable);
        int layout2 = R.layout.car_ui_recycler_view_no_scrollbar;
        int n = this.mSize = attrs2 != null ? attrs2.getSize() : a.getInt(R.styleable.CarUiRecyclerView_carUiSize, 2);
        if (this.mScrollBarEnabled) {
            switch (this.mSize) {
                case 0: {
                    layout2 = R.layout.car_ui_recycler_view_small;
                    break;
                }
                case 1: {
                    layout2 = R.layout.car_ui_recycler_view_medium;
                    break;
                }
                case 2: {
                    layout2 = R.layout.car_ui_recycler_view;
                }
            }
        }
        this.mRecyclerView = (recyclerViewContainer = (ViewGroup)CarUiUtils.requireViewByRefId(rootView = (factory = LayoutInflater.from((Context)context)).inflate(layout2, (ViewGroup)this, true), R.id.car_ui_recycler_view)) instanceof CarUiRecyclerViewContainer ? (RecyclerView)recyclerViewContainer.getChildAt(0) : (RecyclerView)recyclerViewContainer;
        if (Build.VERSION.SDK_INT <= 32 && Build.VERSION.SDK_INT >= 29) {
            this.mRecyclerView.setVerticalScrollBarEnabled(this.isVerticalScrollBarEnabled());
            this.setVerticalScrollBarEnabled(false);
            this.mRecyclerView.setHorizontalScrollBarEnabled(this.isHorizontalScrollBarEnabled());
            this.setHorizontalScrollBarEnabled(false);
            this.mRecyclerView.setVerticalScrollbarThumbDrawable(this.getVerticalScrollbarThumbDrawable());
            this.mRecyclerView.setHorizontalScrollbarThumbDrawable(this.getHorizontalScrollbarThumbDrawable());
            this.mRecyclerView.setVerticalScrollbarTrackDrawable(this.getVerticalScrollbarTrackDrawable());
            this.mRecyclerView.setHorizontalScrollbarTrackDrawable(this.getHorizontalScrollbarTrackDrawable());
            this.mRecyclerView.setVerticalScrollbarPosition(this.getVerticalScrollbarPosition());
            this.mRecyclerView.setScrollBarSize(this.getScrollBarSize());
            this.mRecyclerView.setScrollBarStyle(this.getScrollBarStyle());
            if (this.isVerticalFadingEdgeEnabled()) {
                this.mRecyclerView.setVerticalFadingEdgeEnabled(true);
                this.mRecyclerView.setFadingEdgeLength(this.getVerticalFadingEdgeLength());
                this.setVerticalFadingEdgeEnabled(false);
                this.setFadingEdgeLength(0);
            }
            if (this.isHorizontalFadingEdgeEnabled()) {
                this.mRecyclerView.setHorizontalFadingEdgeEnabled(true);
                this.mRecyclerView.setFadingEdgeLength(this.getHorizontalFadingEdgeLength());
                this.setHorizontalFadingEdgeEnabled(false);
                this.setFadingEdgeLength(0);
            }
        }
        boolean rotaryScrollEnabled = attrs2 != null ? attrs2.isRotaryScrollEnabled() : a.getBoolean(R.styleable.CarUiRecyclerView_rotaryScrollEnabled, false);
        int orientation = attrs2 != null ? attrs2.getLayoutStyle().getOrientation() : a.getInt(R.styleable.CarUiRecyclerView_android_orientation, 1);
        this.initRotaryScroll((ViewGroup)this.mRecyclerView, rotaryScrollEnabled, orientation);
        this.mScrollBarPaddingTop = context.getResources().getDimensionPixelSize(R.dimen.car_ui_scrollbar_padding_top);
        this.mScrollBarPaddingBottom = context.getResources().getDimensionPixelSize(R.dimen.car_ui_scrollbar_padding_bottom);
        int carUiRecyclerViewLayout = attrs2 != null ? attrs2.getLayoutStyle().getLayoutType() : a.getInt(R.styleable.CarUiRecyclerView_layoutStyle, 0);
        this.mNumOfColumns = attrs2 != null ? attrs2.getLayoutStyle().getSpanCount() : a.getInt(R.styleable.CarUiRecyclerView_numOfColumns, 2);
        this.mEnableDividers = attrs2 == null && a.getBoolean(R.styleable.CarUiRecyclerView_enableDivider, false);
        this.mDividerItemDecorationLinear = new LinearDividerItemDecoration(ContextCompat.getDrawable((Context)context, (int)R.drawable.car_ui_recyclerview_divider));
        this.mDividerItemDecorationGrid = new GridDividerItemDecoration(ContextCompat.getDrawable((Context)context, (int)R.drawable.car_ui_divider), ContextCompat.getDrawable((Context)context, (int)R.drawable.car_ui_divider), this.mNumOfColumns);
        this.mIsInitialized = true;
        this.mRecyclerView.setClipToPadding(false);
        String string2 = layoutManagerInXml = attrs2 != null ? null : a.getString(R.styleable.CarUiRecyclerView_layoutManager);
        if (!TextUtils.isEmpty((CharSequence)layoutManagerInXml)) {
            this.createLayoutManager(context, layoutManagerInXml, attrs, defStyleAttr, 0);
        } else if (carUiRecyclerViewLayout == 1) {
            this.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.getContext(), this.mNumOfColumns));
        } else {
            this.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        }
        a.recycle();
        if (!this.mScrollBarEnabled) {
            return;
        }
        this.mRecyclerView.setVerticalScrollBarEnabled(false);
        this.mRecyclerView.setHorizontalScrollBarEnabled(false);
        this.mScrollBarClass = context.getResources().getString(R.string.car_ui_scrollbar_component);
        this.createScrollBarFromConfig(context, (View)CarUiUtils.requireViewByRefId(rootView, R.id.car_ui_scroll_bar));
    }

    @Override
    public void setLayoutManager(@Nullable RecyclerView.LayoutManager layoutManager) {
        if (layoutManager instanceof GridLayoutManager) {
            this.setLayoutStyle(CarUiGridLayoutStyle.from(layoutManager));
        } else {
            this.setLayoutStyle(CarUiLinearLayoutStyle.from(layoutManager));
        }
    }

    @Nullable
    public RecyclerView.LayoutManager getLayoutManager() {
        return this.mRecyclerView.getLayoutManager();
    }

    @Override
    public CarUiLayoutStyle getLayoutStyle() {
        return this.mLayoutStyle;
    }

    @Override
    public boolean hasFixedSize() {
        return false;
    }

    @Override
    public void setLayoutStyle(CarUiLayoutStyle layoutStyle) {
        Object layoutManager;
        this.mLayoutStyle = layoutStyle;
        if (layoutStyle == null) {
            this.mRecyclerView.setLayoutManager(null);
            return;
        }
        if (layoutStyle.getLayoutType() == 0) {
            layoutManager = new LinearLayoutManager(this.getContext(), layoutStyle.getOrientation(), layoutStyle.getReverseLayout()){

                public void onLayoutCompleted(RecyclerView.State state) {
                    super.onLayoutCompleted(state);
                    HashSet onLayoutCompletedListeners = new HashSet(CarUiRecyclerViewImpl.this.mOnLayoutCompletedListeners);
                    for (Runnable runnable : onLayoutCompletedListeners) {
                        runnable.run();
                    }
                }
            };
        } else {
            layoutManager = new GridLayoutManager(this.getContext(), layoutStyle.getSpanCount(), layoutStyle.getOrientation(), layoutStyle.getReverseLayout()){

                public void onLayoutCompleted(RecyclerView.State state) {
                    super.onLayoutCompleted(state);
                    HashSet onLayoutCompletedListeners = new HashSet(CarUiRecyclerViewImpl.this.mOnLayoutCompletedListeners);
                    for (Runnable runnable : onLayoutCompletedListeners) {
                        runnable.run();
                    }
                }
            };
            if (layoutStyle instanceof CarUiGridLayoutStyle) {
                ((GridLayoutManager)layoutManager).setSpanSizeLookup(((CarUiGridLayoutStyle)layoutStyle).getSpanSizeLookup());
            }
        }
        if (this.mIsInitialized) {
            this.addItemDecorations((RecyclerView.LayoutManager)layoutManager);
        }
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
    }

    @Override
    @NonNull
    public View getView() {
        return this;
    }

    @Override
    public void invalidateItemDecorations() {
        this.mRecyclerView.invalidateItemDecorations();
    }

    @Override
    public boolean isLayoutCompleted() {
        RecyclerView.Adapter<?> adapter = this.getAdapter();
        return adapter != null && adapter.getItemCount() > 0 && !this.mRecyclerView.isComputingLayout();
    }

    @Override
    public void addOnLayoutCompleteListener(@Nullable Runnable runnable) {
        if (runnable != null) {
            this.mOnLayoutCompletedListeners.add(runnable);
        }
    }

    @Override
    public void removeOnLayoutCompleteListener(@Nullable Runnable runnable) {
        if (runnable != null) {
            this.mOnLayoutCompletedListeners.remove(runnable);
        }
    }

    @Override
    public RecyclerView.ViewHolder findViewHolderForAdapterPosition(int position) {
        return this.mRecyclerView.findViewHolderForAdapterPosition(position);
    }

    @Override
    public RecyclerView.ViewHolder findViewHolderForLayoutPosition(int position) {
        return this.mRecyclerView.findViewHolderForLayoutPosition(position);
    }

    @Override
    public RecyclerView.Adapter<?> getAdapter() {
        return this.mRecyclerView.getAdapter();
    }

    @Override
    public int getChildLayoutPosition(View child) {
        return this.mRecyclerView.getChildLayoutPosition(child);
    }

    @Override
    public RecyclerView getRecyclerView() {
        return this.mRecyclerView;
    }

    @Override
    public int getRecyclerViewChildCount() {
        if (this.mRecyclerView.getLayoutManager() != null) {
            return this.mRecyclerView.getLayoutManager().getChildCount();
        }
        return 0;
    }

    @Override
    public View getRecyclerViewChildAt(int index) {
        if (this.mRecyclerView.getLayoutManager() != null) {
            return this.mRecyclerView.getLayoutManager().getChildAt(index);
        }
        return null;
    }

    @Override
    public int getRecyclerViewChildPosition(View child) {
        if (this.mRecyclerView.getLayoutManager() != null) {
            return this.mRecyclerView.getLayoutManager().getPosition(child);
        }
        return -1;
    }

    @Override
    public View findViewByPosition(int position) {
        if (this.mRecyclerView.getLayoutManager() != null) {
            return this.mRecyclerView.getLayoutManager().findViewByPosition(position);
        }
        return null;
    }

    private static int toInternalScrollState(int state) {
        int internalState = 0;
        switch (state) {
            case 1: {
                internalState = 1;
                break;
            }
            case 2: {
                internalState = 2;
            }
        }
        return internalState;
    }

    @Override
    public int getScrollState() {
        return CarUiRecyclerViewImpl.toInternalScrollState(this.mRecyclerView.getScrollState());
    }

    @Override
    public void addOnScrollListener(CarUiRecyclerView.OnScrollListener scrollListener) {
        if (this.mScrollListeners.isEmpty()) {
            this.mRecyclerView.addOnScrollListener(this.mOnScrollListener);
        }
        this.mScrollListeners.add(scrollListener);
    }

    @Override
    public void clearOnChildAttachStateChangeListeners() {
        this.mRecyclerView.clearOnChildAttachStateChangeListeners();
    }

    @Override
    public void clearOnScrollListeners() {
        this.mScrollListeners.clear();
        this.mRecyclerView.removeOnScrollListener(this.mOnScrollListener);
    }

    @Override
    public void addItemDecoration(@NonNull RecyclerView.ItemDecoration decor) {
        this.mRecyclerView.addItemDecoration(decor);
    }

    @Override
    public void addItemDecoration(@NonNull RecyclerView.ItemDecoration decor, int index) {
        this.mRecyclerView.addItemDecoration(decor, index);
    }

    @Override
    public void addOnChildAttachStateChangeListener(RecyclerView.OnChildAttachStateChangeListener listener) {
        this.mRecyclerView.addOnChildAttachStateChangeListener(listener);
    }

    @Override
    @NonNull
    public RecyclerView.ItemDecoration getItemDecorationAt(int index) {
        return this.mRecyclerView.getItemDecorationAt(index);
    }

    @Override
    public int getItemDecorationCount() {
        return this.mRecyclerView.getItemDecorationCount();
    }

    @Override
    public void removeItemDecorationAt(int index) {
        this.mRecyclerView.removeItemDecorationAt(index);
    }

    @Override
    public void removeOnChildAttachStateChangeListener(RecyclerView.OnChildAttachStateChangeListener listener) {
        this.mRecyclerView.removeOnChildAttachStateChangeListener(listener);
    }

    @Override
    public void removeItemDecoration(@NonNull RecyclerView.ItemDecoration decor) {
        this.mRecyclerView.removeItemDecoration(decor);
    }

    @Override
    public int findFirstCompletelyVisibleItemPosition() {
        return ((LinearLayoutManager)Objects.requireNonNull(this.mRecyclerView.getLayoutManager())).findFirstCompletelyVisibleItemPosition();
    }

    @Override
    public int findFirstVisibleItemPosition() {
        return ((LinearLayoutManager)Objects.requireNonNull(this.mRecyclerView.getLayoutManager())).findFirstVisibleItemPosition();
    }

    @Override
    public int findLastCompletelyVisibleItemPosition() {
        return ((LinearLayoutManager)Objects.requireNonNull(this.mRecyclerView.getLayoutManager())).findLastCompletelyVisibleItemPosition();
    }

    @Override
    public int findLastVisibleItemPosition() {
        return ((LinearLayoutManager)Objects.requireNonNull(this.mRecyclerView.getLayoutManager())).findLastVisibleItemPosition();
    }

    @Override
    public void setSpanSizeLookup(@NonNull GridLayoutManager.SpanSizeLookup spanSizeLookup) {
        if (this.mRecyclerView.getLayoutManager() instanceof GridLayoutManager) {
            ((GridLayoutManager)this.mRecyclerView.getLayoutManager()).setSpanSizeLookup(spanSizeLookup);
        }
    }

    private void addItemDecorations(RecyclerView.LayoutManager layoutManager) {
        this.mRecyclerView.removeItemDecoration((RecyclerView.ItemDecoration)Objects.requireNonNull(this.mDividerItemDecorationGrid));
        this.mRecyclerView.removeItemDecoration(Objects.requireNonNull(this.mDividerItemDecorationLinear));
        if (layoutManager instanceof GridLayoutManager) {
            if (this.mEnableDividers) {
                this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)Objects.requireNonNull(this.mDividerItemDecorationGrid));
            }
            this.setNumOfColumns(((GridLayoutManager)layoutManager).getSpanCount());
        } else if (this.mEnableDividers) {
            this.mRecyclerView.addItemDecoration(Objects.requireNonNull(this.mDividerItemDecorationLinear));
        }
    }

    private void initRotaryScroll(@NonNull ViewGroup recyclerView, boolean rotaryScrollEnabled, int orientation) {
        if (rotaryScrollEnabled) {
            ViewUtils.setRotaryScrollEnabled((View)recyclerView, orientation == 1);
        }
        recyclerView.setOnGenericMotionListener(rotaryScrollEnabled ? (v, event) -> {
            if (event.getAction() == 8 && event.getSource() == 0x400000) {
                MotionEvent mouseEvent = MotionEvent.obtain((MotionEvent)event);
                mouseEvent.setSource(8194);
                recyclerView.onGenericMotionEvent(mouseEvent);
                return true;
            }
            return false;
        } : null);
        recyclerView.setFocusable(rotaryScrollEnabled);
        recyclerView.setDescendantFocusability(131072);
        recyclerView.setDefaultFocusHighlightEnabled(false);
        recyclerView.setOnFocusChangeListener(rotaryScrollEnabled ? (v, hasFocus) -> {
            if (this.mScrollBar != null) {
                this.mScrollBar.setHighlightThumb(hasFocus);
            }
        } : null);
        if (!rotaryScrollEnabled) {
            recyclerView.setContentDescription((CharSequence)"com.android.car.ui.utils.ROTARY_CONTAINER");
        }
    }

    @Override
    public void removeOnScrollListener(CarUiRecyclerView.OnScrollListener scrollListener) {
        this.mScrollListeners.remove(scrollListener);
        if (this.mScrollListeners.isEmpty()) {
            this.mRecyclerView.removeOnScrollListener(this.mOnScrollListener);
        }
    }

    private void setNumOfColumns(int numberOfColumns) {
        this.mNumOfColumns = numberOfColumns;
        if (this.mDividerItemDecorationGrid != null) {
            this.mDividerItemDecorationGrid.setNumOfColumns(this.mNumOfColumns);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mCarUxRestrictionsUtil.register(this.mListener);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mCarUxRestrictionsUtil.unregister(this.mListener);
    }

    @Override
    public void setPadding(int left, int top, int right, int bottom) {
        int currentPosition = this.findFirstVisibleItemPosition();
        this.mRecyclerView.setPadding(0, top, 0, bottom);
        if (this.mScrollBarEnabled) {
            this.setScrollBarPadding(this.mScrollBarPaddingTop + top, this.mScrollBarPaddingBottom + bottom);
            this.scrollToPosition(currentPosition);
        }
        super.setPadding(left, 0, right, 0);
    }

    @Override
    public void setPaddingRelative(int start, int top, int end, int bottom) {
        int currentPosition = this.findFirstVisibleItemPosition();
        this.mRecyclerView.setPaddingRelative(0, top, 0, bottom);
        if (this.mScrollBarEnabled) {
            this.setScrollBarPadding(this.mScrollBarPaddingTop + top, this.mScrollBarPaddingBottom + bottom);
            this.scrollToPosition(currentPosition);
        }
        super.setPaddingRelative(start, 0, end, 0);
    }

    @Override
    public int getPaddingTop() {
        return this.mRecyclerView.getPaddingTop();
    }

    @Override
    public int getPaddingBottom() {
        return this.mRecyclerView.getPaddingBottom();
    }

    @Override
    public void smoothScrollBy(int dx, int dy) {
        this.mRecyclerView.smoothScrollBy(dx, dy);
    }

    @Override
    public void smoothScrollToPosition(int position) {
        this.mRecyclerView.smoothScrollToPosition(position);
    }

    @Override
    public boolean post(Runnable runnable) {
        return this.mRecyclerView.post(runnable);
    }

    @Override
    public void scrollToPosition(int position) {
        this.mRecyclerView.scrollToPosition(position);
    }

    @Override
    public void scrollToPositionWithOffset(int position, int offset) {
        ((LinearLayoutManager)Objects.requireNonNull(this.mRecyclerView.getLayoutManager())).scrollToPositionWithOffset(position, offset);
    }

    @Override
    public void scrollBy(int x, int y) {
        this.mRecyclerView.scrollBy(x, y);
    }

    private void setScrollBarPadding(int paddingTop, int paddingBottom) {
        if (this.mScrollBarEnabled && this.mScrollBar != null) {
            this.mScrollBar.setPadding(paddingTop, paddingBottom);
        }
    }

    @Override
    public void setContentDescription(CharSequence contentDescription) {
        boolean rotaryScrollEnabled = contentDescription != null && ("com.android.car.ui.utils.HORIZONTALLY_SCROLLABLE".contentEquals(contentDescription) || "com.android.car.ui.utils.VERTICALLY_SCROLLABLE".contentEquals(contentDescription));
        int orientation = this.getLayoutStyle() == null ? 1 : this.getLayoutStyle().getOrientation();
        this.initRotaryScroll((ViewGroup)this.mRecyclerView, rotaryScrollEnabled, orientation);
        if (!rotaryScrollEnabled) {
            super.setContentDescription(contentDescription);
        }
    }

    @Override
    public void setAdapter(@Nullable RecyclerView.Adapter<?> adapter) {
        if (this.mScrollBar != null) {
            this.mScrollBar.adapterChanged(adapter);
        }
        if (this.mAdapter instanceof CarUiRecyclerView.OnAttachListener) {
            ((CarUiRecyclerView.OnAttachListener)this.mAdapter).onDetachedFromCarUiRecyclerView(this);
        }
        this.mAdapter = adapter;
        this.mRecyclerView.setAdapter(adapter);
        if (adapter instanceof CarUiRecyclerView.OnAttachListener) {
            ((CarUiRecyclerView.OnAttachListener)adapter).onAttachedToCarUiRecyclerView(this);
        }
    }

    @Override
    public void setItemAnimator(RecyclerView.ItemAnimator itemAnimator) {
        this.mRecyclerView.setItemAnimator(itemAnimator);
    }

    @Override
    public void setHasFixedSize(boolean hasFixedSize) {
        this.mRecyclerView.setHasFixedSize(hasFixedSize);
    }

    @Override
    public void setOnFlingListener(RecyclerView.OnFlingListener listener) {
        this.mRecyclerView.setOnFlingListener(listener);
    }

    private OrientationHelper createOrientationHelper() {
        if (this.mLayoutStyle.getOrientation() == 1) {
            return OrientationHelper.createVerticalHelper((RecyclerView.LayoutManager)this.mRecyclerView.getLayoutManager());
        }
        return OrientationHelper.createHorizontalHelper((RecyclerView.LayoutManager)this.mRecyclerView.getLayoutManager());
    }

    @Override
    public int getEndAfterPadding() {
        if (this.mLayoutStyle == null) {
            return 0;
        }
        return this.createOrientationHelper().getEndAfterPadding();
    }

    @Override
    public int getStartAfterPadding() {
        if (this.mLayoutStyle == null) {
            return 0;
        }
        return this.createOrientationHelper().getStartAfterPadding();
    }

    @Override
    public int getTotalSpace() {
        if (this.mLayoutStyle == null) {
            return 0;
        }
        return this.createOrientationHelper().getTotalSpace();
    }

    @Override
    public int getDecoratedStart(View child) {
        if (this.mLayoutStyle == null) {
            return 0;
        }
        return this.createOrientationHelper().getDecoratedStart(child);
    }

    @Override
    public int getDecoratedEnd(View child) {
        if (this.mLayoutStyle == null) {
            return 0;
        }
        return this.createOrientationHelper().getDecoratedEnd(child);
    }

    @Override
    public int getDecoratedMeasuredHeight(View child) {
        if (this.mRecyclerView.getLayoutManager() != null) {
            return this.mRecyclerView.getLayoutManager().getDecoratedMeasuredHeight(child);
        }
        return 0;
    }

    @Override
    public int getDecoratedMeasuredWidth(View child) {
        if (this.mRecyclerView.getLayoutManager() != null) {
            return this.mRecyclerView.getLayoutManager().getDecoratedMeasuredWidth(child);
        }
        return 0;
    }

    @Override
    public int getDecoratedMeasurementInOther(View child) {
        if (this.mLayoutStyle == null) {
            return 0;
        }
        return this.createOrientationHelper().getDecoratedMeasurementInOther(child);
    }

    @Override
    public int getDecoratedMeasurement(View child) {
        if (this.mLayoutStyle == null) {
            return 0;
        }
        return this.createOrientationHelper().getDecoratedMeasurement(child);
    }

    private void createScrollBarFromConfig(Context context, View scrollView) {
        Class<DefaultScrollBar> cls;
        try {
            cls = !TextUtils.isEmpty((CharSequence)this.mScrollBarClass) ? this.getContext().getClassLoader().loadClass(this.mScrollBarClass) : DefaultScrollBar.class;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Error loading scroll bar component: " + this.mScrollBarClass, e);
        }
        try {
            Constructor cnst = cls.getDeclaredConstructor(new Class[0]);
            cnst.setAccessible(true);
            this.mScrollBar = (ScrollBar)cnst.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Error creating scroll bar component: " + this.mScrollBarClass, e);
        }
        this.mScrollBar.initialize(context, this.mRecyclerView, scrollView);
        this.setScrollBarPadding(this.mScrollBarPaddingTop + this.getPaddingTop(), this.mScrollBarPaddingBottom + this.getPaddingBottom());
    }

    private void createLayoutManager(Context context, String className, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (className != null && !(className = className.trim()).isEmpty()) {
            className = this.getFullClassName(context, className);
            try {
                Constructor<RecyclerView.LayoutManager> constructor;
                ClassLoader classLoader = this.isInEditMode() ? this.getClass().getClassLoader() : context.getClassLoader();
                Class<RecyclerView.LayoutManager> layoutManagerClass = Class.forName(className, false, classLoader).asSubclass(RecyclerView.LayoutManager.class);
                Object[] constructorArgs = null;
                try {
                    constructor = layoutManagerClass.getConstructor(LAYOUT_MANAGER_CONSTRUCTOR_SIGNATURE);
                    constructorArgs = new Object[]{context, attrs, defStyleAttr, defStyleRes};
                }
                catch (NoSuchMethodException e) {
                    try {
                        constructor = layoutManagerClass.getConstructor(new Class[0]);
                    }
                    catch (NoSuchMethodException e1) {
                        e1.initCause(e);
                        throw new IllegalStateException(attrs.getPositionDescription() + ": Error creating LayoutManager " + className, e1);
                    }
                }
                constructor.setAccessible(true);
                this.setLayoutManager(constructor.newInstance(constructorArgs));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(attrs.getPositionDescription() + ": Unable to find LayoutManager " + className, e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(attrs.getPositionDescription() + ": Could not instantiate the LayoutManager: " + className, e);
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(attrs.getPositionDescription() + ": Could not instantiate the LayoutManager: " + className, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(attrs.getPositionDescription() + ": Cannot access non-public constructor " + className, e);
            }
            catch (ClassCastException e) {
                throw new IllegalStateException(attrs.getPositionDescription() + ": Class is not a LayoutManager " + className, e);
            }
        }
    }

    private String getFullClassName(Context context, String className) {
        if (className.charAt(0) == '.') {
            return context.getPackageName() + className;
        }
        if (className.contains(".")) {
            return className;
        }
        return RecyclerView.class.getPackage().getName() + '.' + className;
    }

    private class UxRestrictionChangedListener
    implements CarUxRestrictionsUtil.OnUxRestrictionsChangedListener {
        private UxRestrictionChangedListener() {
        }

        @Override
        public void onRestrictionsChanged(@NonNull CarUxRestrictions carUxRestrictions) {
            RecyclerView.Adapter adapter = CarUiRecyclerViewImpl.this.mRecyclerView.getAdapter();
            if (!(adapter instanceof CarUiRecyclerView.ItemCap)) {
                return;
            }
            int maxItems = -1;
            if ((carUxRestrictions.getActiveRestrictions() & 0x20) != 0) {
                maxItems = carUxRestrictions.getMaxCumulativeContentItems();
            }
            int originalCount = adapter.getItemCount();
            ((CarUiRecyclerView.ItemCap)adapter).setMaxItems(maxItems);
            int newCount = adapter.getItemCount();
            if (newCount == originalCount) {
                return;
            }
            if (newCount < originalCount) {
                adapter.notifyItemRangeRemoved(newCount, originalCount - newCount);
            } else {
                adapter.notifyItemRangeInserted(originalCount, newCount - originalCount);
            }
        }
    }
}

