/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.recyclerview;

import android.content.Context;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.annotation.VisibleForTesting;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.RecyclerView;
import com.android.car.ui.R;
import com.android.car.ui.utils.CarUiUtils;

public class CarUiSmoothScroller
extends LinearSmoothScroller {
    @VisibleForTesting
    float mMillisecondsPerInch;
    @VisibleForTesting
    float mDecelerationTimeDivisor;
    @VisibleForTesting
    float mMillisecondsPerPixel;
    @VisibleForTesting
    Interpolator mInterpolator;
    @VisibleForTesting
    int mDensityDpi;

    public CarUiSmoothScroller(Context context) {
        super(context);
        this.init(context);
    }

    private void init(Context context) {
        this.mMillisecondsPerInch = CarUiUtils.getFloat(context.getResources(), R.dimen.car_ui_scrollbar_milliseconds_per_inch);
        this.mDecelerationTimeDivisor = CarUiUtils.getFloat(context.getResources(), R.dimen.car_ui_scrollbar_deceleration_times_divisor);
        this.mInterpolator = new DecelerateInterpolator(CarUiUtils.getFloat(context.getResources(), R.dimen.car_ui_scrollbar_decelerate_interpolator_factor));
        this.mDensityDpi = context.getResources().getDisplayMetrics().densityDpi;
        this.mMillisecondsPerPixel = this.mMillisecondsPerInch / (float)this.mDensityDpi;
    }

    protected int getVerticalSnapPreference() {
        return -1;
    }

    protected void onTargetFound(View targetView, RecyclerView.State state, RecyclerView.SmoothScroller.Action action) {
        int dy = this.calculateDyToMakeVisible(targetView, -1);
        if (dy == 0) {
            return;
        }
        int time = this.calculateTimeForDeceleration(dy);
        if (time > 0) {
            action.update(0, -dy, time, this.mInterpolator);
        }
    }

    protected int calculateTimeForScrolling(int dx) {
        return (int)Math.ceil((float)Math.abs(dx) * this.mMillisecondsPerPixel);
    }

    protected int calculateTimeForDeceleration(int dx) {
        return (int)Math.ceil((float)this.calculateTimeForScrolling(dx) / this.mDecelerationTimeDivisor);
    }
}

