/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.recyclerview;

import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearSnapHelper;
import androidx.recyclerview.widget.OrientationHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.android.car.ui.recyclerview.CarUiSmoothScroller;
import java.util.Objects;

class CarUiSnapHelper
extends LinearSnapHelper {
    private static final float VIEW_VISIBLE_THRESHOLD = 0.5f;
    private static final float LONG_ITEM_END_VISIBLE_THRESHOLD = 0.3f;
    private final Context mContext;
    @Nullable
    private RecyclerView mRecyclerView;
    @Nullable
    private OrientationHelper mVerticalHelper;
    @Nullable
    private OrientationHelper mHorizontalHelper;

    public CarUiSnapHelper(Context context) {
        this.mContext = context;
    }

    public int[] calculateDistanceToFinalSnap(@NonNull RecyclerView.LayoutManager layoutManager, @NonNull View targetView) {
        int[] out = new int[2];
        if (!this.mRecyclerView.isInTouchMode()) {
            return out;
        }
        if (layoutManager.canScrollHorizontally()) {
            out[0] = CarUiSnapHelper.distanceToTopMargin(targetView, this.getHorizontalHelper(layoutManager));
        }
        if (layoutManager.canScrollVertically()) {
            out[1] = CarUiSnapHelper.distanceToTopMargin(targetView, this.getVerticalHelper(layoutManager));
        }
        return out;
    }

    @Nullable
    public View findSnapView(RecyclerView.LayoutManager layoutManager) {
        int childCount = layoutManager.getChildCount();
        if (childCount == 0) {
            return null;
        }
        OrientationHelper orientationHelper = this.getOrientationHelper(layoutManager);
        if (childCount == 1) {
            View firstChild = layoutManager.getChildAt(0);
            return CarUiSnapHelper.isValidSnapView(firstChild, orientationHelper) ? firstChild : null;
        }
        if (this.mRecyclerView == null) {
            return null;
        }
        View firstChild = this.mRecyclerView.getChildAt(0);
        if (firstChild.getHeight() > this.mRecyclerView.getHeight() && orientationHelper.getDecoratedStart(firstChild) < 0 && (float)orientationHelper.getDecoratedEnd(firstChild) > (float)this.mRecyclerView.getHeight() * 0.3f) {
            return null;
        }
        View lastVisibleChild = Objects.requireNonNull(layoutManager.getChildAt(childCount - 1));
        boolean lastItemVisible = layoutManager.getPosition(lastVisibleChild) == layoutManager.getItemCount() - 1;
        float lastItemPercentageVisible = lastItemVisible ? CarUiSnapHelper.getPercentageVisible(lastVisibleChild, orientationHelper) : 0.0f;
        View closestChild = null;
        int closestDistanceToStart = Integer.MAX_VALUE;
        float closestPercentageVisible = 0.0f;
        for (int i = 0; i < childCount; ++i) {
            float percentageVisible;
            View child = layoutManager.getChildAt(i);
            int startOffset = orientationHelper.getDecoratedStart(child);
            if (Math.abs(startOffset) >= closestDistanceToStart || !((percentageVisible = CarUiSnapHelper.getPercentageVisible(child, orientationHelper)) > 0.5f) || !(percentageVisible > closestPercentageVisible)) continue;
            closestDistanceToStart = startOffset;
            closestChild = child;
            closestPercentageVisible = percentageVisible;
        }
        View childToReturn = closestChild;
        if (childToReturn == null || lastItemVisible && lastItemPercentageVisible > closestPercentageVisible) {
            childToReturn = lastVisibleChild;
        }
        return CarUiSnapHelper.isValidSnapView(childToReturn, orientationHelper) ? childToReturn : null;
    }

    private static int distanceToTopMargin(@NonNull View targetView, OrientationHelper helper) {
        int childTop = helper.getDecoratedStart(targetView);
        int containerTop = helper.getStartAfterPadding();
        return childTop - containerTop;
    }

    private static boolean isValidSnapView(View view, OrientationHelper helper) {
        return helper.getDecoratedMeasurement(view) <= helper.getTotalSpace();
    }

    static float getPercentageVisible(View view, OrientationHelper helper) {
        int start = helper.getStartAfterPadding();
        int end = helper.getEndAfterPadding();
        int viewStart = helper.getDecoratedStart(view);
        int viewEnd = helper.getDecoratedEnd(view);
        if (viewStart >= start && viewEnd <= end) {
            return 1.0f;
        }
        if (viewEnd <= start) {
            return 0.0f;
        }
        if (viewStart >= end) {
            return 0.0f;
        }
        if (viewStart <= start && viewEnd >= end) {
            return ((float)end - (float)start) / (float)helper.getDecoratedMeasurement(view);
        }
        if (viewStart < start) {
            return ((float)viewEnd - (float)start) / (float)helper.getDecoratedMeasurement(view);
        }
        return ((float)end - (float)viewStart) / (float)helper.getDecoratedMeasurement(view);
    }

    public void attachToRecyclerView(@Nullable RecyclerView recyclerView) {
        super.attachToRecyclerView(recyclerView);
        this.mRecyclerView = recyclerView;
    }

    protected RecyclerView.SmoothScroller createScroller(@NonNull RecyclerView.LayoutManager layoutManager) {
        return new CarUiSmoothScroller(this.mContext);
    }

    public int[] calculateScrollDistance(int velocityX, int velocityY) {
        int[] outDist = super.calculateScrollDistance(velocityX, velocityY);
        if (this.mRecyclerView == null) {
            return outDist;
        }
        RecyclerView.LayoutManager layoutManager = this.mRecyclerView.getLayoutManager();
        if (layoutManager == null || layoutManager.getChildCount() == 0) {
            return outDist;
        }
        int lastChildPosition = this.isAtEnd(layoutManager) ? 0 : layoutManager.getChildCount() - 1;
        View lastChild = Objects.requireNonNull(layoutManager.getChildAt(lastChildPosition));
        float percentageVisible = CarUiSnapHelper.getPercentageVisible(lastChild, this.getOrientationHelper(layoutManager));
        int maxDistance = layoutManager.getHeight();
        if (percentageVisible > 0.0f) {
            maxDistance -= layoutManager.getDecoratedMeasuredHeight(lastChild);
        }
        int minDistance = -maxDistance;
        outDist[0] = CarUiSnapHelper.clamp(outDist[0], minDistance, maxDistance);
        outDist[1] = CarUiSnapHelper.clamp(outDist[1], minDistance, maxDistance);
        return outDist;
    }

    public int estimateNextPositionDiffForScrollDistance(RecyclerView.LayoutManager layoutManager, int scrollDistance) {
        float distancePerChild = this.computeDistancePerChild(layoutManager);
        if (distancePerChild <= 0.0f) {
            return 0;
        }
        return Math.round((float)scrollDistance / distancePerChild);
    }

    private float computeDistancePerChild(RecyclerView.LayoutManager layoutManager) {
        View minPosView = null;
        View maxPosView = null;
        int minPos = Integer.MAX_VALUE;
        int maxPos = Integer.MIN_VALUE;
        int childCount = layoutManager.getChildCount();
        if (childCount == 0) {
            return 1.0f;
        }
        for (int i = 0; i < childCount; ++i) {
            View child = layoutManager.getChildAt(i);
            int pos = layoutManager.getPosition(child);
            if (pos == -1) continue;
            if (pos < minPos) {
                minPos = pos;
                minPosView = child;
            }
            if (pos <= maxPos) continue;
            maxPos = pos;
            maxPosView = child;
        }
        if (minPosView == null || maxPosView == null) {
            return 1.0f;
        }
        OrientationHelper helper = this.getOrientationHelper(layoutManager);
        int start = Math.min(helper.getDecoratedStart(minPosView), helper.getDecoratedStart(maxPosView));
        int end = Math.max(helper.getDecoratedEnd(minPosView), helper.getDecoratedEnd(maxPosView));
        int distance = end - start;
        if (distance == 0) {
            return 0.0f;
        }
        return 1.0f * (float)distance / (float)(maxPos - minPos + 1);
    }

    public boolean isAtStart(@Nullable RecyclerView.LayoutManager layoutManager) {
        if (layoutManager == null || layoutManager.getChildCount() == 0) {
            return true;
        }
        View firstChild = Objects.requireNonNull(layoutManager.getChildAt(0));
        OrientationHelper orientationHelper = this.getOrientationHelper(layoutManager);
        return orientationHelper.getDecoratedStart(firstChild) >= orientationHelper.getStartAfterPadding() && layoutManager.getPosition(firstChild) == 0;
    }

    public boolean isAtEnd(@Nullable RecyclerView.LayoutManager layoutManager) {
        if (layoutManager == null || layoutManager.getChildCount() == 0) {
            return true;
        }
        int childCount = layoutManager.getChildCount();
        OrientationHelper orientationHelper = this.getOrientationHelper(layoutManager);
        View lastVisibleChild = Objects.requireNonNull(layoutManager.getChildAt(childCount - 1));
        return layoutManager.getPosition(lastVisibleChild) == layoutManager.getItemCount() - 1 && layoutManager.getDecoratedBottom(lastVisibleChild) <= orientationHelper.getEndAfterPadding();
    }

    @NonNull
    private OrientationHelper getOrientationHelper(@NonNull RecyclerView.LayoutManager layoutManager) {
        return layoutManager.canScrollVertically() ? this.getVerticalHelper(layoutManager) : this.getHorizontalHelper(layoutManager);
    }

    @NonNull
    private OrientationHelper getVerticalHelper(@NonNull RecyclerView.LayoutManager layoutManager) {
        if (this.mVerticalHelper == null || this.mVerticalHelper.getLayoutManager() != layoutManager) {
            this.mVerticalHelper = OrientationHelper.createVerticalHelper((RecyclerView.LayoutManager)layoutManager);
        }
        return this.mVerticalHelper;
    }

    @NonNull
    private OrientationHelper getHorizontalHelper(@NonNull RecyclerView.LayoutManager layoutManager) {
        if (this.mHorizontalHelper == null || this.mHorizontalHelper.getLayoutManager() != layoutManager) {
            this.mHorizontalHelper = OrientationHelper.createHorizontalHelper((RecyclerView.LayoutManager)layoutManager);
        }
        return this.mHorizontalHelper;
    }

    private static int clamp(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }
}

