/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.recyclerview;

import android.util.Log;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import androidx.recyclerview.widget.RecyclerView;
import com.android.car.ui.recyclerview.ContentLimiting;
import com.android.car.ui.recyclerview.PassThroughFilter;
import com.android.car.ui.recyclerview.RangeFilter;
import com.android.car.ui.recyclerview.RangeFilterImpl;
import com.android.car.ui.recyclerview.ScrollingLimitedViewHolder;

public abstract class ContentLimitingAdapter<T extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements ContentLimiting {
    private static final String TAG = "ContentLimitingAdapter";
    private static final int SCROLLING_LIMITED_MESSAGE_VIEW_TYPE = Integer.MAX_VALUE;
    private Integer mScrollingLimitedMessageResId;
    @NonNull
    private RangeFilter mRangeFilter = new PassThroughFilter();
    private RecyclerView mRecyclerView;
    private boolean mIsLimiting = false;

    public int getScrollingLimitedMessageViewType() {
        return Integer.MAX_VALUE;
    }

    @NonNull
    public final RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == this.getScrollingLimitedMessageViewType()) {
            return ScrollingLimitedViewHolder.create(parent);
        }
        return this.onCreateViewHolderImpl(parent, viewType);
    }

    protected int indexToPosition(int index) {
        return this.mRangeFilter.indexToPosition(index);
    }

    protected int positionToIndex(int position) {
        return this.mRangeFilter.positionToIndex(position);
    }

    protected abstract T onCreateViewHolderImpl(@NonNull ViewGroup var1, int var2);

    public final void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof ScrollingLimitedViewHolder) {
            ScrollingLimitedViewHolder vh = (ScrollingLimitedViewHolder)holder;
            vh.bind(this.mScrollingLimitedMessageResId);
        } else {
            int index = this.mRangeFilter.positionToIndex(position);
            if (index != -1) {
                int size = this.getUnrestrictedItemCount();
                if (0 <= index && index < size) {
                    this.onBindViewHolderImpl(holder, index);
                } else {
                    Log.e((String)TAG, (String)("onBindViewHolder pos: " + position + " gave index: " + index + " out of bounds size: " + size + " " + this.mRangeFilter.toString()));
                }
            } else {
                Log.e((String)TAG, (String)("onBindViewHolder invalid position " + position + " " + this.mRangeFilter.toString()));
            }
        }
    }

    protected abstract void onBindViewHolderImpl(T var1, int var2);

    public final int getItemViewType(int position) {
        if (this.mRangeFilter.positionToIndex(position) == -1) {
            return this.getScrollingLimitedMessageViewType();
        }
        return this.getItemViewTypeImpl(this.mRangeFilter.positionToIndex(position));
    }

    protected int getItemViewTypeImpl(int position) {
        return super.getItemViewType(position);
    }

    @Deprecated
    protected int getScrollingLimitedMessagePosition() {
        return this.getItemCount() - 1;
    }

    public final int getItemCount() {
        if (this.mIsLimiting) {
            return this.mRangeFilter.getFilteredCount();
        }
        return this.getUnrestrictedItemCount();
    }

    protected abstract int getUnrestrictedItemCount();

    public final void onViewRecycled(@NonNull RecyclerView.ViewHolder holder) {
        super.onViewRecycled(holder);
        if (!(holder instanceof ScrollingLimitedViewHolder)) {
            this.onViewRecycledImpl(holder);
        }
    }

    protected void onViewRecycledImpl(@NonNull T holder) {
    }

    public final boolean onFailedToRecycleView(@NonNull RecyclerView.ViewHolder holder) {
        if (!(holder instanceof ScrollingLimitedViewHolder)) {
            return this.onFailedToRecycleViewImpl(holder);
        }
        return super.onFailedToRecycleView(holder);
    }

    protected boolean onFailedToRecycleViewImpl(@NonNull T holder) {
        return super.onFailedToRecycleView(holder);
    }

    public final void onViewAttachedToWindow(@NonNull RecyclerView.ViewHolder holder) {
        super.onViewAttachedToWindow(holder);
        if (!(holder instanceof ScrollingLimitedViewHolder)) {
            this.onViewAttachedToWindowImpl(holder);
        }
    }

    protected void onViewAttachedToWindowImpl(@NonNull T holder) {
    }

    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        this.mRecyclerView = recyclerView;
    }

    public final void onViewDetachedFromWindow(@NonNull RecyclerView.ViewHolder holder) {
        super.onViewDetachedFromWindow(holder);
        if (!(holder instanceof ScrollingLimitedViewHolder)) {
            this.onViewDetachedFromWindowImpl(holder);
        }
    }

    protected void onViewDetachedFromWindowImpl(@NonNull T holder) {
    }

    @Override
    public void setMaxItems(int maxItems) {
        this.mRangeFilter.removeFilter();
        if (maxItems >= 0) {
            this.mIsLimiting = true;
            this.mRangeFilter = new RangeFilterImpl(this, maxItems);
            this.mRangeFilter.recompute(this.getUnrestrictedItemCount(), this.computeAnchorIndexWhenRestricting());
            this.mRangeFilter.applyFilter();
            this.autoScrollWhenRestricted();
        } else {
            this.mIsLimiting = false;
            this.mRangeFilter = new PassThroughFilter();
            this.mRangeFilter.recompute(this.getUnrestrictedItemCount(), 0);
            this.mRangeFilter.applyFilter();
        }
    }

    protected int getScrollToPositionWhenRestricted() {
        return -1;
    }

    private void autoScrollWhenRestricted() {
        RecyclerView.LayoutManager layoutManager;
        int scrollToPosition = this.getScrollToPositionWhenRestricted();
        if (scrollToPosition >= 0 && this.mRecyclerView != null && (layoutManager = this.mRecyclerView.getLayoutManager()) != null) {
            layoutManager.scrollToPosition(scrollToPosition);
        }
    }

    protected int computeAnchorIndexWhenRestricting() {
        return 0;
    }

    public void updateUnderlyingDataChanged(int unrestrictedCount, int newPivotIndex) {
        this.mRangeFilter.recompute(unrestrictedCount, newPivotIndex);
    }

    public void notifyLimitingAnchorChanged(int newPivotIndex) {
        this.mRangeFilter.notifyPivotIndexChanged(newPivotIndex);
    }

    @Override
    public void setScrollingLimitedMessageResId(@StringRes int resId) {
        if (this.mScrollingLimitedMessageResId == null || this.mScrollingLimitedMessageResId != resId) {
            this.mScrollingLimitedMessageResId = resId;
            this.mRangeFilter.invalidateMessagePositions();
        }
    }
}

