/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.recyclerview;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.os.Handler;
import android.os.Looper;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.recyclerview.widget.OrientationHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.android.car.ui.R;
import com.android.car.ui.recyclerview.CarUiSnapHelper;
import com.android.car.ui.recyclerview.FastScroller;
import com.android.car.ui.recyclerview.OnContinuousScrollListener;
import com.android.car.ui.recyclerview.ScrollBar;
import com.android.car.ui.utils.CarUiUtils;

class DefaultScrollBar
implements ScrollBar {
    private final SparseArray<Integer> mChildHeightByAdapterPosition = new SparseArray();
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final Interpolator mPaginationInterpolator = new AccelerateDecelerateInterpolator();
    private final RecyclerView.AdapterDataObserver mAdapterChangeObserver = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            DefaultScrollBar.this.clearCachedHeights();
            DefaultScrollBar.this.updatePaginationButtons();
        }

        public void onItemRangeChanged(int positionStart, int itemCount, Object payload) {
            DefaultScrollBar.this.clearCachedHeights();
            DefaultScrollBar.this.updatePaginationButtons();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            DefaultScrollBar.this.clearCachedHeights();
            DefaultScrollBar.this.updatePaginationButtons();
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            DefaultScrollBar.this.clearCachedHeights();
            DefaultScrollBar.this.updatePaginationButtons();
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            DefaultScrollBar.this.clearCachedHeights();
            DefaultScrollBar.this.updatePaginationButtons();
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            DefaultScrollBar.this.clearCachedHeights();
            DefaultScrollBar.this.updatePaginationButtons();
        }
    };
    private float mButtonDisabledAlpha;
    private CarUiSnapHelper mSnapHelper;
    private View mScrollView;
    private View mScrollTrack;
    private View mScrollThumb;
    private View mUpButton;
    private View mDownButton;
    private int mScrollbarThumbMinHeight;
    private Context mContext;
    private RecyclerView mRecyclerView;
    private OrientationHelper mOrientationHelper;
    private OnContinuousScrollListener mPageUpOnContinuousScrollListener;
    private OnContinuousScrollListener mPageDownOnContinuousScrollListener;
    private final RecyclerView.OnScrollListener mRecyclerViewOnScrollListener = new RecyclerView.OnScrollListener(){

        public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
            DefaultScrollBar.this.updatePaginationButtons();
            DefaultScrollBar.this.cacheChildrenHeight(recyclerView.getLayoutManager());
        }
    };

    DefaultScrollBar() {
    }

    @Override
    public void initialize(Context context, RecyclerView rv, View scrollView) {
        this.mContext = context;
        this.mRecyclerView = rv;
        this.mScrollView = scrollView;
        Resources res = context.getResources();
        this.mButtonDisabledAlpha = CarUiUtils.getFloat(res, R.dimen.car_ui_button_disabled_alpha);
        this.mScrollbarThumbMinHeight = res.getDimensionPixelSize(R.dimen.car_ui_scrollbar_min_thumb_height);
        this.mUpButton = CarUiUtils.requireViewByRefId(this.mScrollView, R.id.car_ui_scrollbar_page_up);
        View.OnClickListener paginateUpButtonOnClickListener = v -> this.pageUp();
        this.mUpButton.setOnClickListener(paginateUpButtonOnClickListener);
        this.mPageUpOnContinuousScrollListener = new OnContinuousScrollListener(context, paginateUpButtonOnClickListener);
        this.mUpButton.setOnTouchListener((View.OnTouchListener)this.mPageUpOnContinuousScrollListener);
        this.mDownButton = CarUiUtils.requireViewByRefId(this.mScrollView, R.id.car_ui_scrollbar_page_down);
        View.OnClickListener paginateDownButtonOnClickListener = v -> this.pageDown();
        this.mDownButton.setOnClickListener(paginateDownButtonOnClickListener);
        this.mPageDownOnContinuousScrollListener = new OnContinuousScrollListener(context, paginateDownButtonOnClickListener);
        this.mDownButton.setOnTouchListener((View.OnTouchListener)this.mPageDownOnContinuousScrollListener);
        this.mScrollTrack = CarUiUtils.requireViewByRefId(this.mScrollView, R.id.car_ui_scrollbar_track);
        this.mScrollThumb = CarUiUtils.requireViewByRefId(this.mScrollView, R.id.car_ui_scrollbar_thumb);
        this.mSnapHelper = new CarUiSnapHelper(context);
        this.getRecyclerView().setOnFlingListener(null);
        this.mSnapHelper.attachToRecyclerView(this.getRecyclerView());
        FastScroller fastScroller = new FastScroller(this.mRecyclerView, this.mScrollTrack, this.mScrollView);
        fastScroller.enable();
        this.getRecyclerView().addOnScrollListener(this.mRecyclerViewOnScrollListener);
        this.mScrollView.setVisibility(8);
        this.mScrollView.addOnLayoutChangeListener((v, left, top, right, bottom, oldLeft, oldTop, oldRight, oldBottom) -> this.mHandler.post(this::updatePaginationButtons));
        if (this.mRecyclerView.getAdapter() != null) {
            this.adapterChanged(this.mRecyclerView.getAdapter());
        }
    }

    public RecyclerView getRecyclerView() {
        return this.mRecyclerView;
    }

    @Override
    public void requestLayout() {
        this.mScrollView.requestLayout();
    }

    @Override
    public void setPadding(int paddingStart, int paddingEnd) {
        this.mScrollView.setPadding(this.mScrollView.getPaddingLeft(), paddingStart, this.mScrollView.getPaddingRight(), paddingEnd);
        this.updatePaginationButtons();
    }

    @Override
    public void adapterChanged(@Nullable RecyclerView.Adapter adapter) {
        try {
            if (this.mRecyclerView.getAdapter() != null) {
                this.mRecyclerView.getAdapter().unregisterAdapterDataObserver(this.mAdapterChangeObserver);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            if (adapter != null) {
                adapter.registerAdapterDataObserver(this.mAdapterChangeObserver);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void setUpEnabled(boolean enabled) {
        if (!enabled) {
            this.mPageUpOnContinuousScrollListener.cancelPendingScroll();
        }
        this.mUpButton.setEnabled(enabled);
        this.mUpButton.setAlpha(enabled ? 1.0f : this.mButtonDisabledAlpha);
    }

    private void setDownEnabled(boolean enabled) {
        if (!enabled) {
            this.mPageDownOnContinuousScrollListener.cancelPendingScroll();
        }
        this.mDownButton.setEnabled(enabled);
        this.mDownButton.setAlpha(enabled ? 1.0f : this.mButtonDisabledAlpha);
    }

    private boolean isDownEnabled() {
        return this.mDownButton.isEnabled();
    }

    private void setParameters(@IntRange(from=0L) int range, @IntRange(from=0L) int offset, @IntRange(from=0L) int extent) {
        if (!this.mScrollView.isLaidOut()) {
            return;
        }
        if (this.mScrollView.getVisibility() != 0 || range == 0) {
            return;
        }
        int thumbLength = this.calculateScrollThumbLength(range, extent);
        int thumbOffset = this.calculateScrollThumbOffset(range, offset, thumbLength);
        ViewGroup.LayoutParams lp = this.mScrollThumb.getLayoutParams();
        if (lp.height != thumbLength || thumbLength < this.mScrollThumb.getHeight()) {
            lp.height = thumbLength;
            this.mScrollThumb.requestLayout();
        }
        this.moveY(this.mScrollThumb, thumbOffset);
    }

    private int calculateScrollThumbLength(int range, int extent) {
        return Math.max(Math.round((float)extent / (float)range * (float)this.mScrollTrack.getHeight()), Math.min(this.mScrollbarThumbMinHeight, this.mScrollTrack.getHeight()));
    }

    private int calculateScrollThumbOffset(int range, int offset, int thumbLength) {
        return this.mScrollTrack.getTop() + (this.isDownEnabled() ? Math.round((float)offset / (float)range * (float)(this.mScrollTrack.getHeight() - thumbLength)) : this.mScrollTrack.getHeight() - thumbLength);
    }

    private void moveY(View view, float newPosition) {
        view.animate().y(newPosition).setDuration(0L).setInterpolator((TimeInterpolator)this.mPaginationInterpolator).start();
    }

    private void clearCachedHeights() {
        this.mChildHeightByAdapterPosition.clear();
        this.cacheChildrenHeight(this.getLayoutManager());
    }

    private void cacheChildrenHeight(@Nullable RecyclerView.LayoutManager layoutManager) {
        if (layoutManager == null) {
            return;
        }
        for (int i = 0; i < layoutManager.getChildCount(); ++i) {
            View child = layoutManager.getChildAt(i);
            int childPosition = layoutManager.getPosition(child);
            if (this.mChildHeightByAdapterPosition.indexOfKey(childPosition) >= 0) continue;
            this.mChildHeightByAdapterPosition.put(childPosition, (Object)child.getHeight());
        }
    }

    private int estimateNextPositionScrollUp(int currentPos, int scrollDistance, OrientationHelper orientationHelper) {
        int nextPos = 0;
        int distance = 0;
        for (int i = currentPos - 1; i >= 0; --i) {
            if (this.mChildHeightByAdapterPosition.indexOfKey(i) < 0) {
                nextPos = this.mSnapHelper.estimateNextPositionDiffForScrollDistance(orientationHelper.getLayoutManager(), -scrollDistance);
                break;
            }
            if (distance + (Integer)this.mChildHeightByAdapterPosition.get(i) > Math.abs(scrollDistance)) {
                nextPos = i - currentPos + 1;
                break;
            }
            distance += ((Integer)this.mChildHeightByAdapterPosition.get(i)).intValue();
        }
        return nextPos;
    }

    private OrientationHelper getOrientationHelper(RecyclerView.LayoutManager layoutManager) {
        if (this.mOrientationHelper == null || this.mOrientationHelper.getLayoutManager() != layoutManager) {
            this.mOrientationHelper = OrientationHelper.createVerticalHelper((RecyclerView.LayoutManager)layoutManager);
        }
        return this.mOrientationHelper;
    }

    void pageUp() {
        int currentOffset = this.computeVerticalScrollOffset();
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager == null || layoutManager.getChildCount() == 0 || currentOffset == 0) {
            return;
        }
        OrientationHelper orientationHelper = this.getOrientationHelper(layoutManager);
        int scrollDistance = orientationHelper.getTotalSpace();
        View currentPosView = this.getFirstMostVisibleChild(orientationHelper);
        int currentPos = currentPosView != null ? this.getLayoutManager().getPosition(currentPosView) : 0;
        int nextPos = this.estimateNextPositionScrollUp(currentPos, scrollDistance - Math.max(0, orientationHelper.getStartAfterPadding() - orientationHelper.getDecoratedStart(currentPosView)), orientationHelper);
        if (nextPos == 0) {
            this.smoothScrollBy(0, -scrollDistance);
        } else {
            this.smoothScrollToPosition(Math.max(0, currentPos + nextPos));
        }
    }

    private View getFirstMostVisibleChild(OrientationHelper helper) {
        float mostVisiblePercent = 0.0f;
        View mostVisibleView = null;
        for (int i = 0; i < this.getLayoutManager().getChildCount(); ++i) {
            View child = this.getLayoutManager().getChildAt(i);
            float visiblePercentage = CarUiSnapHelper.getPercentageVisible(child, helper);
            if (visiblePercentage == 1.0f) {
                mostVisibleView = child;
                break;
            }
            if (!(visiblePercentage > mostVisiblePercent)) continue;
            mostVisiblePercent = visiblePercentage;
            mostVisibleView = child;
        }
        return mostVisibleView;
    }

    void pageDown() {
        View child;
        int screenSize;
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager == null || layoutManager.getChildCount() == 0) {
            return;
        }
        OrientationHelper orientationHelper = this.getOrientationHelper(layoutManager);
        int scrollDistance = screenSize = orientationHelper.getTotalSpace();
        View currentPosView = this.getFirstMostVisibleChild(orientationHelper);
        if (layoutManager.isViewPartiallyVisible(currentPosView, false, false) && orientationHelper.getDecoratedEnd(currentPosView) > orientationHelper.getEndAfterPadding()) {
            scrollDistance = Math.min(screenSize, orientationHelper.getDecoratedEnd(currentPosView) - orientationHelper.getEndAfterPadding());
        }
        for (int i = layoutManager.getChildCount() - 1; i >= 0 && orientationHelper.getDecoratedStart(child = layoutManager.getChildAt(i)) > orientationHelper.getDecoratedStart(currentPosView); --i) {
            if (orientationHelper.getDecoratedStart(child) - orientationHelper.getStartAfterPadding() > screenSize) continue;
            if (orientationHelper.getDecoratedEnd(child) <= orientationHelper.getEndAfterPadding()) {
                scrollDistance = orientationHelper.getDecoratedEnd(child) - orientationHelper.getStartAfterPadding();
                break;
            }
            scrollDistance = orientationHelper.getDecoratedStart(child) - orientationHelper.getStartAfterPadding();
            break;
        }
        this.smoothScrollBy(0, scrollDistance);
    }

    private void updatePaginationButtons() {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager == null) {
            this.mScrollView.setVisibility(8);
            return;
        }
        boolean isAtStart = this.isAtStart();
        boolean isAtEnd = this.isAtEnd();
        this.setUpEnabled(!isAtStart);
        this.setDownEnabled(!isAtEnd);
        boolean isScrollViewVisiblePreUpdate = this.mScrollView.getVisibility() == 0;
        boolean isLayoutRequired = false;
        if (isAtStart && isAtEnd || layoutManager.getItemCount() == 0) {
            this.mScrollView.setVisibility(8);
        } else {
            OrientationHelper orientationHelper = this.getOrientationHelper(layoutManager);
            int screenSize = orientationHelper.getTotalSpace();
            int touchTargetSize = this.mContext.getResources().getDimensionPixelSize(R.dimen.car_ui_touch_target_size);
            ViewGroup.MarginLayoutParams upButtonLayoutParam = (ViewGroup.MarginLayoutParams)this.mUpButton.getLayoutParams();
            int upButtonMargin = upButtonLayoutParam.topMargin + upButtonLayoutParam.bottomMargin;
            ViewGroup.MarginLayoutParams downButtonLayoutParam = (ViewGroup.MarginLayoutParams)this.mDownButton.getLayoutParams();
            int downButtonMargin = downButtonLayoutParam.topMargin + downButtonLayoutParam.bottomMargin;
            int margin = upButtonMargin + downButtonMargin;
            if (screenSize < 2 * touchTargetSize + margin) {
                if (isScrollViewVisiblePreUpdate) {
                    isLayoutRequired = true;
                }
                this.mScrollView.setVisibility(8);
            } else {
                ViewGroup.MarginLayoutParams trackLayoutParam = (ViewGroup.MarginLayoutParams)this.mScrollTrack.getLayoutParams();
                int trackMargin = trackLayoutParam.topMargin + trackLayoutParam.bottomMargin;
                if (screenSize < 2 * touchTargetSize + Math.max(touchTargetSize, this.mScrollbarThumbMinHeight) + (margin += trackMargin)) {
                    this.mScrollTrack.setVisibility(4);
                    this.mScrollThumb.setVisibility(4);
                } else {
                    this.mScrollTrack.setVisibility(0);
                    this.mScrollThumb.setVisibility(0);
                }
                if (!isScrollViewVisiblePreUpdate) {
                    isLayoutRequired = true;
                }
                this.mScrollView.setVisibility(0);
            }
        }
        if (layoutManager.canScrollVertically()) {
            this.setParameters(this.computeVerticalScrollRange(), this.computeVerticalScrollOffset(), this.computeVerticalScrollExtent());
        } else {
            this.setParameters(this.computeHorizontalScrollRange(), this.computeHorizontalScrollOffset(), this.computeHorizontalScrollExtent());
        }
        this.mScrollView.invalidate();
        if (isLayoutRequired) {
            this.mScrollView.post(() -> this.mScrollView.requestLayout());
        }
    }

    @Override
    public boolean isAtStart() {
        return this.mSnapHelper.isAtStart(this.getLayoutManager());
    }

    @Override
    public void setHighlightThumb(boolean highlight) {
        this.mScrollThumb.setActivated(highlight);
    }

    boolean isAtEnd() {
        return this.mSnapHelper.isAtEnd(this.getLayoutManager());
    }

    @VisibleForTesting
    RecyclerView.LayoutManager getLayoutManager() {
        return this.getRecyclerView().getLayoutManager();
    }

    @VisibleForTesting
    void smoothScrollToPosition(int max) {
        this.getRecyclerView().smoothScrollToPosition(max);
    }

    @VisibleForTesting
    void smoothScrollBy(int dx, int dy) {
        this.getRecyclerView().smoothScrollBy(dx, dy);
    }

    @VisibleForTesting
    int computeVerticalScrollRange() {
        return this.getRecyclerView().computeVerticalScrollRange();
    }

    @VisibleForTesting
    int computeVerticalScrollOffset() {
        return this.getRecyclerView().computeVerticalScrollOffset();
    }

    @VisibleForTesting
    int computeVerticalScrollExtent() {
        return this.getRecyclerView().computeVerticalScrollExtent();
    }

    @VisibleForTesting
    int computeHorizontalScrollRange() {
        return this.getRecyclerView().computeHorizontalScrollRange();
    }

    @VisibleForTesting
    int computeHorizontalScrollOffset() {
        return this.getRecyclerView().computeHorizontalScrollOffset();
    }

    @VisibleForTesting
    int computeHorizontalScrollExtent() {
        return this.getRecyclerView().computeHorizontalScrollExtent();
    }
}

