/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.recyclerview;

import android.annotation.SuppressLint;
import android.view.ViewGroup;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.android.car.ui.recyclerview.ContentLimitingAdapter;

public class DelegatingContentLimitingAdapter<T extends RecyclerView.ViewHolder>
extends ContentLimitingAdapter<T> {
    private static final int SCROLLING_LIMITED_MESSAGE_VIEW_TYPE = Integer.MAX_VALUE;
    private static final int SCROLLING_LIMITED_MESSAGE_DEFAULT_POSITION_OFFSET = -1;
    private final RecyclerView.Adapter<T> mDelegate;
    private final int mScrollingLimitedMessageViewType;
    private final int mScrollingLimitedMessagePositionOffset;
    @IdRes
    private final int mConfigId;
    @NonNull
    private final Observer mAdapterDataObserver;

    public DelegatingContentLimitingAdapter(RecyclerView.Adapter<T> delegate, @IdRes int configId) {
        this(delegate, configId, Integer.MAX_VALUE, -1);
    }

    @Deprecated
    public DelegatingContentLimitingAdapter(RecyclerView.Adapter<T> delegate, @IdRes int configId, int viewType, int offset) {
        this.mDelegate = delegate;
        this.mConfigId = configId;
        this.mScrollingLimitedMessageViewType = viewType;
        this.mScrollingLimitedMessagePositionOffset = offset;
        this.mAdapterDataObserver = new Observer();
    }

    public void registerAdapterDataObserver(@NonNull RecyclerView.AdapterDataObserver observer) {
        if (!this.hasObservers()) {
            this.mDelegate.registerAdapterDataObserver((RecyclerView.AdapterDataObserver)this.mAdapterDataObserver);
        }
        super.registerAdapterDataObserver(observer);
    }

    public void unregisterAdapterDataObserver(@NonNull RecyclerView.AdapterDataObserver observer) {
        super.unregisterAdapterDataObserver(observer);
        if (!this.hasObservers()) {
            this.mDelegate.unregisterAdapterDataObserver((RecyclerView.AdapterDataObserver)this.mAdapterDataObserver);
        }
    }

    @Override
    @NonNull
    public T onCreateViewHolderImpl(@NonNull ViewGroup parent, int viewType) {
        return (T)this.mDelegate.onCreateViewHolder(parent, viewType);
    }

    @Override
    public void onBindViewHolderImpl(T holder, int position) {
        this.mDelegate.onBindViewHolder(holder, position);
    }

    @Override
    public int getItemViewTypeImpl(int position) {
        return this.mDelegate.getItemViewType(position);
    }

    @Override
    protected void onViewRecycledImpl(@NonNull T holder) {
        this.mDelegate.onViewRecycled(holder);
    }

    @Override
    protected boolean onFailedToRecycleViewImpl(@NonNull T holder) {
        return this.mDelegate.onFailedToRecycleView(holder);
    }

    @Override
    protected void onViewAttachedToWindowImpl(@NonNull T holder) {
        this.mDelegate.onViewAttachedToWindow(holder);
    }

    @Override
    protected void onViewDetachedFromWindowImpl(@NonNull T holder) {
        this.mDelegate.onViewDetachedFromWindow(holder);
    }

    public void setHasStableIds(boolean hasStableIds) {
        this.mDelegate.setHasStableIds(hasStableIds);
    }

    public long getItemId(int position) {
        return this.mDelegate.getItemId(position);
    }

    @Override
    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.mDelegate.onAttachedToRecyclerView(recyclerView);
    }

    public void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        this.mDelegate.onDetachedFromRecyclerView(recyclerView);
    }

    @Override
    protected int computeAnchorIndexWhenRestricting() {
        if (this.mDelegate instanceof ContentLimiting) {
            return ((ContentLimiting)this.mDelegate).computeAnchorIndexWhenRestricting();
        }
        return 0;
    }

    @Override
    protected int getScrollToPositionWhenRestricted() {
        if (this.mDelegate instanceof ContentLimiting) {
            return ((ContentLimiting)this.mDelegate).getScrollToPositionWhenRestricted();
        }
        return -1;
    }

    @Override
    public int getUnrestrictedItemCount() {
        return this.mDelegate.getItemCount();
    }

    @Override
    @IdRes
    public int getConfigurationId() {
        return this.mConfigId;
    }

    @Override
    public int getScrollingLimitedMessageViewType() {
        return this.mScrollingLimitedMessageViewType;
    }

    @Override
    protected int getScrollingLimitedMessagePosition() {
        if (this.mScrollingLimitedMessagePositionOffset < 0) {
            return this.getItemCount() + this.mScrollingLimitedMessagePositionOffset;
        }
        return this.mScrollingLimitedMessagePositionOffset;
    }

    private class Observer
    extends RecyclerView.AdapterDataObserver {
        private Observer() {
        }

        @SuppressLint(value={"NotifyDataSetChanged"})
        public void onChanged() {
            DelegatingContentLimitingAdapter.this.notifyDataSetChanged();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            DelegatingContentLimitingAdapter.this.notifyItemRangeChanged(positionStart, itemCount);
        }

        public void onItemRangeChanged(int positionStart, int itemCount, @Nullable Object payload) {
            DelegatingContentLimitingAdapter.this.notifyItemRangeChanged(positionStart, itemCount, payload);
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            DelegatingContentLimitingAdapter.this.notifyItemRangeInserted(positionStart, itemCount);
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            DelegatingContentLimitingAdapter.this.notifyItemRangeRemoved(positionStart, itemCount);
        }

        @SuppressLint(value={"NotifyDataSetChanged"})
        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            DelegatingContentLimitingAdapter.this.notifyDataSetChanged();
        }
    }

    public static interface ContentLimiting {
        public int getScrollToPositionWhenRestricted();

        public int computeAnchorIndexWhenRestricting();
    }
}

