/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.recyclerview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.android.car.ui.R;
import com.android.car.ui.utils.CarUiUtils;

@SuppressLint(value={"ClickableViewAccessibility"})
class FastScroller
implements View.OnTouchListener {
    private float mTouchDownY = -1.0f;
    @NonNull
    private final View mScrollTrackView;
    @NonNull
    private final View mScrollThumb;
    @NonNull
    private final RecyclerView mRecyclerView;
    private final int mClickActionThreshold;

    FastScroller(@NonNull RecyclerView recyclerView, @NonNull View scrollTrackView, @NonNull View scrollView) {
        this.mRecyclerView = recyclerView;
        this.mScrollTrackView = scrollTrackView;
        this.mScrollThumb = CarUiUtils.requireViewByRefId(scrollView, R.id.car_ui_scrollbar_thumb);
        this.mClickActionThreshold = ViewConfiguration.get((Context)recyclerView.getContext()).getScaledTouchSlop();
    }

    void enable() {
        this.mScrollTrackView.setOnTouchListener((View.OnTouchListener)this);
    }

    public boolean onTouch(View v, MotionEvent me) {
        switch (me.getAction()) {
            case 0: {
                this.mTouchDownY = me.getY();
                break;
            }
            case 2: {
                float thumbBottom = this.mScrollThumb.getY() + (float)this.mScrollThumb.getHeight();
                if (!(me.getY() + this.mScrollTrackView.getY() < thumbBottom) || !(me.getY() + this.mScrollTrackView.getY() > this.mScrollThumb.getY())) {
                    return true;
                }
                float thumbCenter = this.mScrollThumb.getY() + (float)this.mScrollThumb.getHeight() / 2.0f;
                this.verticalScrollTo(thumbCenter + (me.getY() - this.mTouchDownY));
                this.mTouchDownY = me.getY();
                break;
            }
            default: {
                if (this.isClick(this.mTouchDownY, me.getY())) {
                    this.verticalScrollTo(me.getY() + this.mScrollTrackView.getY());
                }
                this.mTouchDownY = -1.0f;
            }
        }
        return true;
    }

    private boolean isClick(float startY, float endY) {
        return Math.abs(startY - endY) < (float)this.mClickActionThreshold;
    }

    private void verticalScrollTo(float y) {
        int scrollingBy = this.calculateScrollDistance(y);
        if (scrollingBy != 0) {
            this.mRecyclerView.scrollBy(0, scrollingBy);
        }
    }

    private int calculateScrollDistance(float newDragPos) {
        int[] scrollbarRange = this.getVerticalRange();
        int scrollbarLength = scrollbarRange[1] - scrollbarRange[0];
        float thumbCenter = this.mScrollThumb.getY() + (float)this.mScrollThumb.getHeight() / 2.0f;
        if (scrollbarLength == 0) {
            return 0;
        }
        float percentage = (newDragPos - thumbCenter) / (float)scrollbarLength;
        int totalPossibleOffset = this.mRecyclerView.computeVerticalScrollRange() - (this.mRecyclerView.getHeight() - this.mRecyclerView.getPaddingTop() - this.mRecyclerView.getPaddingBottom());
        return (int)(percentage * (float)totalPossibleOffset);
    }

    private int[] getVerticalRange() {
        int[] verticalRange = new int[]{(int)this.mScrollTrackView.getY() + this.mScrollThumb.getHeight() / 2, (int)this.mScrollTrackView.getY() + this.mScrollTrackView.getHeight() - this.mScrollThumb.getHeight() / 2};
        return verticalRange;
    }
}

