/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.recyclerview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.NonNull;
import com.android.car.ui.R;

@SuppressLint(value={"ClickableViewAccessibility"})
public class OnContinuousScrollListener
implements View.OnTouchListener {
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final int mInitialDelay;
    private final int mRepeatInterval;
    private final View.OnClickListener mOnClickListener;
    private View mTouchedView;
    private boolean mIsLongPressed;
    private final Runnable mPeriodicRunnable = new Runnable(){

        @Override
        public void run() {
            if (OnContinuousScrollListener.this.mTouchedView.isEnabled()) {
                OnContinuousScrollListener.this.mHandler.postDelayed((Runnable)this, (long)OnContinuousScrollListener.this.mRepeatInterval);
                OnContinuousScrollListener.this.mOnClickListener.onClick(OnContinuousScrollListener.this.mTouchedView);
                OnContinuousScrollListener.this.mIsLongPressed = true;
            } else {
                OnContinuousScrollListener.this.mIsLongPressed = false;
            }
        }
    };

    public OnContinuousScrollListener(@NonNull Context context, @NonNull View.OnClickListener clickListener) {
        this.mInitialDelay = context.getResources().getInteger(R.integer.car_ui_scrollbar_longpress_initial_delay);
        this.mRepeatInterval = context.getResources().getInteger(R.integer.car_ui_scrollbar_longpress_repeat_interval);
        if (this.mInitialDelay < 0 || this.mRepeatInterval < 0) {
            throw new IllegalArgumentException("negative intervals are not allowed");
        }
        this.mOnClickListener = clickListener;
    }

    public void cancelPendingScroll() {
        this.mHandler.removeCallbacks(this.mPeriodicRunnable);
        this.mIsLongPressed = false;
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        this.mTouchedView = view;
        switch (motionEvent.getAction()) {
            case 0: {
                this.mHandler.removeCallbacks(this.mPeriodicRunnable);
                this.mHandler.postDelayed(this.mPeriodicRunnable, (long)this.mInitialDelay);
                this.mTouchedView.setPressed(true);
                return true;
            }
            case 1: 
            case 3: {
                if (!this.mIsLongPressed) {
                    this.mOnClickListener.onClick(view);
                }
                this.mHandler.removeCallbacks(this.mPeriodicRunnable);
                this.mTouchedView.setPressed(false);
                this.mIsLongPressed = false;
                return true;
            }
        }
        return false;
    }
}

