/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.recyclerview;

import android.util.Log;
import androidx.annotation.VisibleForTesting;
import androidx.recyclerview.widget.RecyclerView;
import com.android.car.ui.recyclerview.RangeFilter;

public class RangeFilterImpl
implements RangeFilter {
    private static final String TAG = "RangeFilterImpl";
    private final RecyclerView.Adapter<?> mAdapter;
    private final int mMaxItems;
    private final int mMaxItemsFirstHalf;
    private final int mMaxItemsSecondHalf;
    private int mUnlimitedCount;
    @VisibleForTesting
    int mPivotIndex;
    private final ListRange mRange = new ListRange();

    public RangeFilterImpl(RecyclerView.Adapter<?> adapter, int maxItems) {
        this.mAdapter = adapter;
        if (maxItems <= 0) {
            this.mMaxItemsFirstHalf = 0;
            this.mMaxItemsSecondHalf = 0;
            this.mMaxItems = 0;
        } else {
            this.mMaxItemsFirstHalf = maxItems / 2;
            this.mMaxItemsSecondHalf = maxItems - this.mMaxItemsFirstHalf;
            this.mMaxItems = maxItems;
        }
    }

    public String toString() {
        return "RangeFilterImpl{mMaxItemsFirstHalf=" + this.mMaxItemsFirstHalf + "mMaxItemsSecondHalf=" + this.mMaxItemsSecondHalf + ", mUnlimitedCount=" + this.mUnlimitedCount + ", mPivotIndex=" + this.mPivotIndex + ", mRange=" + this.mRange.toString() + '}';
    }

    @Override
    public int getFilteredCount() {
        return this.mRange.mLimitedCount;
    }

    @Override
    public void invalidateMessagePositions() {
        if (this.mRange.mClampedHead > 0) {
            this.mAdapter.notifyItemChanged(0);
        }
        if (this.mRange.mClampedTail > 0) {
            this.mAdapter.notifyItemChanged(this.getFilteredCount() - 1);
        }
    }

    @Override
    public void applyFilter() {
        if (this.mRange.isTailClamped()) {
            this.mAdapter.notifyItemInserted(this.mUnlimitedCount);
            this.mAdapter.notifyItemRangeRemoved(this.mRange.mEndIndex, this.mUnlimitedCount - this.mRange.mEndIndex);
        }
        if (this.mRange.isHeadClamped()) {
            this.mAdapter.notifyItemRangeRemoved(0, this.mRange.mStartIndex);
            this.mAdapter.notifyItemInserted(0);
        }
    }

    @Override
    public void removeFilter() {
        if (this.mRange.isTailClamped()) {
            this.mAdapter.notifyItemRemoved(this.mRange.mLimitedCount - 1);
            this.mAdapter.notifyItemRangeInserted(this.mRange.mLimitedCount - 1, this.mUnlimitedCount - this.mRange.mEndIndex);
        }
        if (this.mRange.isHeadClamped()) {
            this.mAdapter.notifyItemRangeInserted(1, this.mRange.mStartIndex);
            this.mAdapter.notifyItemRemoved(0);
        }
    }

    @Override
    public void recompute(int newCount, int pivotIndex) {
        if (pivotIndex < 0 || newCount <= pivotIndex) {
            Log.e((String)TAG, (String)("Invalid pivotIndex: " + pivotIndex + " newCount: " + newCount));
            pivotIndex = 0;
        }
        this.mUnlimitedCount = newCount;
        this.mPivotIndex = pivotIndex;
        this.mRange.mClampedHead = 0;
        this.mRange.mClampedTail = 0;
        if (this.mUnlimitedCount <= this.mMaxItems) {
            this.mRange.mStartIndex = 0;
            this.mRange.mEndIndex = this.mUnlimitedCount;
            this.mRange.mLimitedCount = this.mUnlimitedCount;
        } else if (this.mMaxItems <= 0) {
            this.mRange.mStartIndex = 0;
            this.mRange.mEndIndex = 0;
            this.mRange.mLimitedCount = 1;
            this.mRange.mClampedTail = 1;
        } else if (this.mPivotIndex <= this.mMaxItemsFirstHalf) {
            this.mRange.mStartIndex = 0;
            this.mRange.mEndIndex = this.mMaxItems;
            this.mRange.mLimitedCount = this.mMaxItems + 1;
            this.mRange.mClampedTail = 1;
        } else if (this.mUnlimitedCount - 1 - this.mPivotIndex <= this.mMaxItemsSecondHalf) {
            this.mRange.mEndIndex = this.mUnlimitedCount;
            this.mRange.mStartIndex = this.mRange.mEndIndex - this.mMaxItems;
            this.mRange.mLimitedCount = this.mMaxItems + 1;
            this.mRange.mClampedHead = 1;
        } else {
            this.mRange.mStartIndex = this.mPivotIndex - this.mMaxItemsFirstHalf;
            this.mRange.mEndIndex = this.mPivotIndex + this.mMaxItemsSecondHalf;
            this.mRange.mLimitedCount = this.mMaxItems + 2;
            this.mRange.mClampedHead = 1;
            this.mRange.mClampedTail = 1;
        }
    }

    @Override
    public void notifyPivotIndexChanged(int pivotIndex) {
    }

    @Override
    public int indexToPosition(int index) {
        if (this.mRange.mStartIndex <= index && index < this.mRange.mEndIndex) {
            return this.mRange.indexToPosition(index);
        }
        return -1;
    }

    @Override
    public int positionToIndex(int position) {
        return this.mRange.positionToIndex(position);
    }

    @VisibleForTesting
    ListRange getRange() {
        return this.mRange;
    }

    static class ListRange {
        public static final int INVALID_INDEX = -1;
        @VisibleForTesting
        int mStartIndex;
        @VisibleForTesting
        int mEndIndex;
        @VisibleForTesting
        int mClampedHead;
        @VisibleForTesting
        int mClampedTail;
        @VisibleForTesting
        int mLimitedCount;

        ListRange() {
        }

        public void copyFrom(ListRange range) {
            this.mStartIndex = range.mStartIndex;
            this.mEndIndex = range.mEndIndex;
            this.mClampedHead = range.mClampedHead;
            this.mClampedTail = range.mClampedTail;
            this.mLimitedCount = range.mLimitedCount;
        }

        public String toString() {
            return "ListRange{mStartIndex=" + this.mStartIndex + ", mEndIndex=" + this.mEndIndex + ", mClampedHead=" + this.mClampedHead + ", mClampedTail=" + this.mClampedTail + ", mLimitedCount=" + this.mLimitedCount + '}';
        }

        public int indexToPosition(int index) {
            return index - this.mStartIndex + this.mClampedHead;
        }

        public int positionToIndex(int position) {
            int index = position - this.mClampedHead + this.mStartIndex;
            if (index < this.mStartIndex || this.mEndIndex <= index) {
                return -1;
            }
            return index;
        }

        public boolean isHeadClamped() {
            return this.mClampedHead == 1;
        }

        public boolean isTailClamped() {
            return this.mClampedTail == 1;
        }
    }
}

