/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.recyclerview;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.android.car.ui.plugin.oemapis.recyclerview.AdapterDataObserverOEMV1;
import com.android.car.ui.plugin.oemapis.recyclerview.AdapterOEMV1;
import com.android.car.ui.plugin.oemapis.recyclerview.RecyclerViewOEMV1;
import com.android.car.ui.plugin.oemapis.recyclerview.ViewHolderOEMV1;
import com.android.car.ui.recyclerview.CarUiRecyclerView;
import java.util.ArrayList;
import java.util.List;

public final class RecyclerViewAdapterAdapterV1
implements AdapterOEMV1<ViewHolderAdapterV1> {
    @NonNull
    private final RecyclerView.Adapter mAdapter;
    @NonNull
    private final Context mAppContext;
    @NonNull
    private List<AdapterDataObserverOEMV1> mAdapterDataObservers = new ArrayList<AdapterDataObserverOEMV1>();
    private RecyclerView.AdapterDataObserver mAdapterDataObserver = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            for (AdapterDataObserverOEMV1 observer : RecyclerViewAdapterAdapterV1.this.mAdapterDataObservers) {
                observer.onChanged();
            }
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            for (AdapterDataObserverOEMV1 observer : RecyclerViewAdapterAdapterV1.this.mAdapterDataObservers) {
                observer.onItemRangeChanged(positionStart, itemCount);
            }
        }

        public void onItemRangeChanged(int positionStart, int itemCount, @Nullable Object payload) {
            for (AdapterDataObserverOEMV1 observer : RecyclerViewAdapterAdapterV1.this.mAdapterDataObservers) {
                observer.onItemRangeChanged(positionStart, itemCount, payload);
            }
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            for (AdapterDataObserverOEMV1 observer : RecyclerViewAdapterAdapterV1.this.mAdapterDataObservers) {
                observer.onItemRangeInserted(positionStart, itemCount);
            }
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            for (AdapterDataObserverOEMV1 observer : RecyclerViewAdapterAdapterV1.this.mAdapterDataObservers) {
                observer.onItemRangeRemoved(positionStart, itemCount);
            }
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            for (AdapterDataObserverOEMV1 observer : RecyclerViewAdapterAdapterV1.this.mAdapterDataObservers) {
                for (int i = 0; i < itemCount; ++i) {
                    observer.onItemMoved(fromPosition + i, toPosition + i);
                }
            }
        }

        public void onStateRestorationPolicyChanged() {
            for (AdapterDataObserverOEMV1 observer : RecyclerViewAdapterAdapterV1.this.mAdapterDataObservers) {
                observer.onStateRestorationPolicyChanged();
            }
        }
    };

    public RecyclerViewAdapterAdapterV1(@NonNull Context appContext, @NonNull RecyclerView.Adapter<?> adapter) {
        this.mAppContext = appContext;
        this.mAdapter = adapter;
    }

    @NonNull
    public RecyclerView.Adapter getAdapter() {
        return this.mAdapter;
    }

    public int getItemCount() {
        return this.mAdapter.getItemCount();
    }

    public long getItemId(int position) {
        return this.mAdapter.getItemId(position);
    }

    public int getItemViewType(int position) {
        return this.mAdapter.getItemViewType(position);
    }

    public int getStateRestorationPolicyInt() {
        switch (this.mAdapter.getStateRestorationPolicy()) {
            case PREVENT: {
                return 2;
            }
            case PREVENT_WHEN_EMPTY: {
                return 1;
            }
        }
        return 0;
    }

    public void onAttachedToRecyclerView(RecyclerViewOEMV1 recyclerView) {
        this.mAdapter.onAttachedToRecyclerView(null);
        this.mAdapter.registerAdapterDataObserver(this.mAdapterDataObserver);
    }

    public void bindViewHolder(ViewHolderAdapterV1 holder, int position) {
        this.mAdapter.bindViewHolder(holder.getViewHolder(), position);
    }

    public ViewHolderAdapterV1 createViewHolder(ViewGroup parent, int viewType) {
        FrameLayout fakeParent = new FrameLayout(this.mAppContext);
        return new ViewHolderAdapterV1(this.mAdapter.createViewHolder((ViewGroup)fakeParent, viewType));
    }

    public void onDetachedFromRecyclerView(RecyclerViewOEMV1 recyclerView) {
        this.mAdapter.unregisterAdapterDataObserver(this.mAdapterDataObserver);
        this.mAdapter.onDetachedFromRecyclerView(null);
    }

    public boolean onFailedToRecycleView(ViewHolderAdapterV1 holder) {
        return this.mAdapter.onFailedToRecycleView(holder.getViewHolder());
    }

    public void onViewAttachedToWindow(ViewHolderAdapterV1 holder) {
        this.mAdapter.onViewAttachedToWindow(holder.getViewHolder());
    }

    public void onViewDetachedFromWindow(ViewHolderAdapterV1 holder) {
        this.mAdapter.onViewDetachedFromWindow(holder.getViewHolder());
    }

    public void onViewRecycled(ViewHolderAdapterV1 holder) {
        this.mAdapter.onViewRecycled(holder.getViewHolder());
    }

    public void registerAdapterDataObserver(AdapterDataObserverOEMV1 observer) {
        if (observer == null) {
            return;
        }
        this.mAdapterDataObservers.add(observer);
    }

    public void unregisterAdapterDataObserver(AdapterDataObserverOEMV1 observer) {
        if (observer == null) {
            return;
        }
        this.mAdapterDataObservers.remove(observer);
    }

    public boolean hasStableIds() {
        return this.mAdapter.hasStableIds();
    }

    public void setMaxItems(int maxItems) {
        if (this.mAdapter instanceof CarUiRecyclerView.ItemCap) {
            ((CarUiRecyclerView.ItemCap)this.mAdapter).setMaxItems(maxItems);
        }
    }

    static class ViewHolderAdapterV1
    implements ViewHolderOEMV1 {
        private RecyclerView.ViewHolder mViewHolder;

        ViewHolderAdapterV1(@NonNull RecyclerView.ViewHolder viewHolder) {
            this.mViewHolder = viewHolder;
        }

        @NonNull
        public RecyclerView.ViewHolder getViewHolder() {
            return this.mViewHolder;
        }

        public boolean isRecyclable() {
            return this.mViewHolder.isRecyclable();
        }

        @NonNull
        public View getItemView() {
            return this.mViewHolder.itemView;
        }
    }
}

