/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.recyclerview;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewPropertyAnimator;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.android.car.ui.plugin.oemapis.recyclerview.AdapterOEMV1;
import com.android.car.ui.plugin.oemapis.recyclerview.LayoutStyleOEMV1;
import com.android.car.ui.plugin.oemapis.recyclerview.OnChildAttachStateChangeListenerOEMV1;
import com.android.car.ui.plugin.oemapis.recyclerview.RecyclerViewAttributesOEMV1;
import com.android.car.ui.plugin.oemapis.recyclerview.RecyclerViewOEMV2;
import com.android.car.ui.plugin.oemapis.recyclerview.ViewHolderOEMV1;
import com.android.car.ui.preference.PreferenceFragment;
import com.android.car.ui.recyclerview.CarUiGridLayoutStyle;
import com.android.car.ui.recyclerview.CarUiLayoutStyle;
import com.android.car.ui.recyclerview.CarUiLinearLayoutStyle;
import com.android.car.ui.recyclerview.CarUiRecyclerView;
import com.android.car.ui.recyclerview.ProxyRecyclerView;
import com.android.car.ui.recyclerview.RecyclerViewAdapterAdapterV1;
import com.android.car.ui.utils.ViewUtils;
import java.util.ArrayList;
import java.util.List;

public final class RecyclerViewAdapterV2
extends FrameLayout
implements CarUiRecyclerView,
RecyclerViewOEMV2.OnScrollListenerOEMV2,
PreferenceFragment.AndroidxRecyclerViewProvider,
OnChildAttachStateChangeListenerOEMV1,
ViewUtils.LazyLayoutView {
    @Nullable
    private RecyclerViewOEMV2 mOEMRecyclerView;
    @Nullable
    private AdapterOEMV1 mOEMAdapter;
    @Nullable
    private RecyclerView.Adapter<?> mAdapter;
    @NonNull
    private final List<CarUiRecyclerView.OnScrollListener> mScrollListeners = new ArrayList<CarUiRecyclerView.OnScrollListener>();
    @Nullable
    private ProxyRecyclerView mRecyclerView;
    @Nullable
    private CarUiLayoutStyle mLayoutStyle;
    private int mHeight;
    private int mWidth;
    @NonNull
    private final List<RecyclerView.OnChildAttachStateChangeListener> mChildAttachStateChangeListeners = new ArrayList<RecyclerView.OnChildAttachStateChangeListener>();

    public RecyclerViewAdapterV2(@NonNull Context context) {
        this(context, null);
    }

    public RecyclerViewAdapterV2(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RecyclerViewAdapterV2(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle, 0);
        this.setBackground(null);
        this.setPadding(0, 0, 0, 0);
    }

    public void setOemRecyclerView(@NonNull RecyclerViewOEMV2 oemRecyclerView, @Nullable RecyclerViewAttributesOEMV1 oemAttrs) {
        CarUiLayoutStyle layoutStyle;
        this.mOEMRecyclerView = oemRecyclerView;
        LayoutStyleOEMV1 oemLayoutStyle = this.mOEMRecyclerView.getLayoutStyle();
        if (oemLayoutStyle.getLayoutType() == 1) {
            layoutStyle = new CarUiGridLayoutStyle();
            ((CarUiGridLayoutStyle)layoutStyle).setReverseLayout(oemLayoutStyle.getReverseLayout());
            ((CarUiGridLayoutStyle)layoutStyle).setSpanCount(oemLayoutStyle.getSpanCount());
            ((CarUiGridLayoutStyle)layoutStyle).setOrientation(oemLayoutStyle.getOrientation());
            ((CarUiGridLayoutStyle)layoutStyle).setSize(oemAttrs == null ? 2 : oemAttrs.getSize());
            this.mLayoutStyle = layoutStyle;
        } else {
            layoutStyle = new CarUiLinearLayoutStyle();
            ((CarUiLinearLayoutStyle)layoutStyle).setReverseLayout(oemLayoutStyle.getReverseLayout());
            ((CarUiLinearLayoutStyle)layoutStyle).setOrientation(oemLayoutStyle.getOrientation());
            ((CarUiLinearLayoutStyle)layoutStyle).setSize(oemAttrs == null ? 2 : oemAttrs.getSize());
            this.mLayoutStyle = layoutStyle;
        }
        FrameLayout parent = new FrameLayout(this.getContext());
        this.mRecyclerView = new ProxyRecyclerView(this.getContext(), this);
        parent.addView((View)this.mRecyclerView);
        this.mOEMRecyclerView.addOnScrollListener((RecyclerViewOEMV2.OnScrollListenerOEMV2)this);
        this.mOEMRecyclerView.addOnChildAttachStateChangeListener((OnChildAttachStateChangeListenerOEMV1)this);
        ViewGroup.MarginLayoutParams params = new ViewGroup.MarginLayoutParams(this.mWidth, this.mHeight);
        this.addView(this.mOEMRecyclerView.getView(), (ViewGroup.LayoutParams)params);
    }

    @Override
    public void setLayoutManager(@Nullable RecyclerView.LayoutManager layoutManager) {
        if (layoutManager instanceof GridLayoutManager) {
            this.setLayoutStyle(CarUiGridLayoutStyle.from(layoutManager));
        } else {
            this.setLayoutStyle(CarUiLinearLayoutStyle.from(layoutManager));
        }
    }

    public void setLayoutParams(ViewGroup.LayoutParams params) {
        Rect marginRect = null;
        if (params instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)params;
            marginRect = new Rect(Math.max(marginLayoutParams.leftMargin, marginLayoutParams.getMarginStart()), marginLayoutParams.topMargin, marginLayoutParams.rightMargin, Math.max(marginLayoutParams.bottomMargin, marginLayoutParams.getMarginEnd()));
            marginLayoutParams.setMargins(0, 0, 0, 0);
            marginLayoutParams.setMarginStart(0);
            marginLayoutParams.setMarginEnd(0);
        }
        if (this.mOEMRecyclerView != null) {
            ViewGroup.LayoutParams pluginLayoutParams = this.mOEMRecyclerView.getView().getLayoutParams();
            pluginLayoutParams.width = params.width == 0 ? -1 : params.width;
            int n = pluginLayoutParams.height = params.height == 0 ? -1 : params.height;
            if (marginRect != null && pluginLayoutParams instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.MarginLayoutParams rvMarginParams = (ViewGroup.MarginLayoutParams)pluginLayoutParams;
                rvMarginParams.setMargins(marginRect.left, marginRect.top, marginRect.right, marginRect.bottom);
            }
        }
        this.mWidth = params.width;
        this.mHeight = params.height;
        super.setLayoutParams(params);
    }

    public ViewPropertyAnimator animate() {
        if (this.mOEMRecyclerView != null) {
            return this.mOEMRecyclerView.getView().animate();
        }
        throw new IllegalStateException("OEMRecyclerView is not initialized!");
    }

    @Override
    public void setAlpha(float alpha) {
        if (this.mOEMRecyclerView != null) {
            this.mOEMRecyclerView.setAlpha(alpha);
        }
    }

    public void setBackground(Drawable background) {
        if (this.mOEMRecyclerView != null) {
            this.mOEMRecyclerView.getView().setBackground(background);
        }
    }

    public void setBackgroundColor(int color2) {
        if (this.mOEMRecyclerView != null) {
            this.mOEMRecyclerView.getView().setBackgroundColor(color2);
        }
    }

    public void setBackgroundResource(int resid) {
        if (this.mOEMRecyclerView != null) {
            Drawable background = this.getResources().getDrawable(resid);
            this.mOEMRecyclerView.getView().setBackground(background);
        }
    }

    @Override
    @Nullable
    public RecyclerView getRecyclerView() {
        return this.mRecyclerView;
    }

    @Override
    public int getRecyclerViewChildCount() {
        return this.mOEMRecyclerView.getRecyclerViewChildCount();
    }

    @Override
    public View getRecyclerViewChildAt(int index) {
        return this.mOEMRecyclerView.getRecyclerViewChildAt(index);
    }

    @Override
    public int getRecyclerViewChildPosition(View child) {
        return this.mOEMRecyclerView.getRecyclerViewChildPosition(child);
    }

    @Override
    public int getDecoratedStart(View child) {
        return this.mOEMRecyclerView.getDecoratedStart(child);
    }

    @Override
    public int getDecoratedEnd(View child) {
        return this.mOEMRecyclerView.getDecoratedEnd(child);
    }

    @Override
    public int getDecoratedMeasuredHeight(View child) {
        return this.mOEMRecyclerView.getDecoratedMeasuredHeight(child);
    }

    @Override
    public int getDecoratedMeasuredWidth(View child) {
        return this.mOEMRecyclerView.getDecoratedMeasuredWidth(child);
    }

    @Override
    public int getDecoratedMeasurementInOther(View child) {
        return this.mOEMRecyclerView.getDecoratedMeasurementInOther(child);
    }

    @Override
    public int getDecoratedMeasurement(View child) {
        return this.mOEMRecyclerView.getDecoratedMeasurement(child);
    }

    @Override
    public View findViewByPosition(int position) {
        return this.mOEMRecyclerView.findViewByPosition(position);
    }

    private static int toInternalScrollState(int state) {
        int internalState = 0;
        switch (state) {
            case 1: {
                internalState = 1;
                break;
            }
            case 2: {
                internalState = 2;
            }
        }
        return internalState;
    }

    @Override
    public int getScrollState() {
        return RecyclerViewAdapterV2.toInternalScrollState(this.mOEMRecyclerView.getScrollState());
    }

    @Override
    public int getEndAfterPadding() {
        return this.mOEMRecyclerView.getEndAfterPadding();
    }

    @Override
    public int getStartAfterPadding() {
        return this.mOEMRecyclerView.getStartAfterPadding();
    }

    @Override
    public int getTotalSpace() {
        return this.mOEMRecyclerView.getTotalSpace();
    }

    @Override
    @NonNull
    public View getView() {
        return this;
    }

    @Override
    public void invalidateItemDecorations() {
    }

    @Override
    public void removeItemDecoration(@NonNull RecyclerView.ItemDecoration decor) {
    }

    @Override
    public void removeItemDecorationAt(int index) {
    }

    @Override
    @Nullable
    public RecyclerView.ItemDecoration getItemDecorationAt(int index) {
        return null;
    }

    @Override
    public int getItemDecorationCount() {
        return 0;
    }

    @Override
    public void setContentDescription(CharSequence contentDescription) {
        super.setContentDescription(contentDescription);
        this.mOEMRecyclerView.setContentDescription(contentDescription);
    }

    @Override
    public void setAdapter(RecyclerView.Adapter<?> adapter) {
        if (adapter == null) {
            this.mAdapter = null;
            this.mOEMAdapter = null;
            this.mOEMRecyclerView.setAdapter(null);
        } else {
            if (this.mAdapter instanceof CarUiRecyclerView.OnAttachListener) {
                ((CarUiRecyclerView.OnAttachListener)this.mAdapter).onDetachedFromCarUiRecyclerView(this);
            }
            this.mAdapter = adapter;
            this.mOEMAdapter = new RecyclerViewAdapterAdapterV1(this.getContext(), adapter);
            this.mOEMRecyclerView.setAdapter(this.mOEMAdapter);
            if (adapter instanceof CarUiRecyclerView.OnAttachListener) {
                ((CarUiRecyclerView.OnAttachListener)adapter).onAttachedToCarUiRecyclerView(this);
            }
        }
    }

    @Override
    public void addItemDecoration(@NonNull RecyclerView.ItemDecoration decor) {
    }

    @Override
    public void addItemDecoration(@NonNull RecyclerView.ItemDecoration decor, int index) {
    }

    @Override
    public void addOnChildAttachStateChangeListener(RecyclerView.OnChildAttachStateChangeListener listener) {
        this.mChildAttachStateChangeListeners.add(listener);
    }

    @Override
    public void removeOnChildAttachStateChangeListener(RecyclerView.OnChildAttachStateChangeListener listener) {
        this.mChildAttachStateChangeListeners.remove(listener);
    }

    @Override
    public void clearOnChildAttachStateChangeListeners() {
        this.mChildAttachStateChangeListeners.clear();
        this.mOEMRecyclerView.clearOnScrollListeners();
    }

    @Override
    public void addOnScrollListener(@NonNull CarUiRecyclerView.OnScrollListener listener) {
        this.mScrollListeners.add(listener);
    }

    @Override
    public void removeOnScrollListener(@NonNull CarUiRecyclerView.OnScrollListener listener) {
        this.mScrollListeners.remove(listener);
    }

    @Override
    public void clearOnScrollListeners() {
        this.mScrollListeners.clear();
        this.mOEMRecyclerView.clearOnScrollListeners();
    }

    public void onScrollStateChanged(@NonNull RecyclerViewOEMV2 recyclerView, int newState) {
        for (CarUiRecyclerView.OnScrollListener listener : this.mScrollListeners) {
            listener.onScrollStateChanged(this, RecyclerViewAdapterV2.toInternalScrollState(newState));
        }
    }

    public void onScrolled(@NonNull RecyclerViewOEMV2 recyclerView, int dx, int dy) {
        for (CarUiRecyclerView.OnScrollListener listener : this.mScrollListeners) {
            listener.onScrolled(this, dx, dy);
        }
    }

    @Override
    public void scrollBy(int x, int y) {
        this.mOEMRecyclerView.getView().scrollBy(x, y);
    }

    @Override
    public void scrollToPosition(int position) {
        this.mOEMRecyclerView.scrollToPosition(position);
    }

    @Override
    public void scrollToPositionWithOffset(int position, int offset) {
        this.mOEMRecyclerView.scrollToPositionWithOffset(position, offset);
    }

    @Override
    public void smoothScrollBy(int dx, int dy) {
        this.mOEMRecyclerView.smoothScrollBy(dx, dy);
    }

    @Override
    public void smoothScrollToPosition(int position) {
        this.mOEMRecyclerView.smoothScrollToPosition(position);
    }

    @Override
    public RecyclerView.ViewHolder findViewHolderForAdapterPosition(int position) {
        ViewHolderOEMV1 viewHolder = this.mOEMRecyclerView.findViewHolderForAdapterPosition(position);
        if (viewHolder instanceof RecyclerViewAdapterAdapterV1.ViewHolderAdapterV1) {
            return ((RecyclerViewAdapterAdapterV1.ViewHolderAdapterV1)viewHolder).getViewHolder();
        }
        return null;
    }

    @Override
    public RecyclerView.ViewHolder findViewHolderForLayoutPosition(int position) {
        ViewHolderOEMV1 viewHolder = this.mOEMRecyclerView.findViewHolderForLayoutPosition(position);
        if (viewHolder instanceof RecyclerViewAdapterAdapterV1.ViewHolderAdapterV1) {
            return ((RecyclerViewAdapterAdapterV1.ViewHolderAdapterV1)viewHolder).getViewHolder();
        }
        return null;
    }

    @Override
    public RecyclerView.Adapter<?> getAdapter() {
        return this.mAdapter;
    }

    @Override
    public int getChildLayoutPosition(View child) {
        return this.mOEMRecyclerView.getChildLayoutPosition(child);
    }

    @Override
    public void setHasFixedSize(boolean hasFixedSize) {
        this.mOEMRecyclerView.setHasFixedSize(hasFixedSize);
    }

    @Override
    public void setOnFlingListener(RecyclerView.OnFlingListener listener) {
    }

    @Override
    public boolean hasFixedSize() {
        return this.mOEMRecyclerView.hasFixedSize();
    }

    @Deprecated
    @Nullable
    public RecyclerView.LayoutManager getLayoutManager() {
        return null;
    }

    @Override
    public CarUiLayoutStyle getLayoutStyle() {
        return this.mLayoutStyle;
    }

    public boolean canScrollHorizontally(int direction) {
        return this.mOEMRecyclerView.getView().canScrollHorizontally(direction);
    }

    public boolean canScrollVertically(int direction) {
        return this.mOEMRecyclerView.getView().canScrollVertically(direction);
    }

    @Override
    public void setLayoutStyle(final CarUiLayoutStyle layoutStyle) {
        this.mLayoutStyle = layoutStyle;
        if (layoutStyle == null) {
            this.mOEMRecyclerView.setLayoutStyle(null);
            return;
        }
        LayoutStyleOEMV1 oemLayoutStyle = new LayoutStyleOEMV1(){

            public int getSpanCount() {
                return layoutStyle.getSpanCount();
            }

            public int getLayoutType() {
                return layoutStyle.getLayoutType();
            }

            public int getOrientation() {
                return layoutStyle.getOrientation();
            }

            public boolean getReverseLayout() {
                return layoutStyle.getReverseLayout();
            }

            public int getSpanSize(int position) {
                if (layoutStyle instanceof CarUiGridLayoutStyle) {
                    return ((CarUiGridLayoutStyle)layoutStyle).getSpanSizeLookup().getSpanSize(position);
                }
                return 1;
            }
        };
        if (this.mOEMRecyclerView != null) {
            this.mOEMRecyclerView.setLayoutStyle(oemLayoutStyle);
        }
    }

    @Override
    public void setPadding(int left, int top, int right, int bottom) {
        if (this.mOEMRecyclerView != null) {
            this.mOEMRecyclerView.getView().setPadding(left, top, right, bottom);
        }
    }

    @Override
    public int getPaddingLeft() {
        if (this.mOEMRecyclerView != null) {
            return this.mOEMRecyclerView.getView().getPaddingLeft();
        }
        return super.getPaddingLeft();
    }

    @Override
    public int getPaddingTop() {
        if (this.mOEMRecyclerView != null) {
            return this.mOEMRecyclerView.getView().getPaddingTop();
        }
        return super.getPaddingTop();
    }

    @Override
    public int getPaddingRight() {
        if (this.mOEMRecyclerView != null) {
            return this.mOEMRecyclerView.getView().getPaddingRight();
        }
        return super.getPaddingRight();
    }

    @Override
    public int getPaddingBottom() {
        if (this.mOEMRecyclerView != null) {
            return this.mOEMRecyclerView.getView().getPaddingBottom();
        }
        return super.getPaddingBottom();
    }

    @Override
    public int getPaddingStart() {
        boolean isLtr;
        boolean bl = isLtr = this.getContext().getResources().getConfiguration().getLayoutDirection() == 0;
        if (isLtr) {
            return this.getPaddingLeft();
        }
        return this.getPaddingRight();
    }

    @Override
    public int getPaddingEnd() {
        boolean isLtr;
        boolean bl = isLtr = this.getContext().getResources().getConfiguration().getLayoutDirection() == 0;
        if (isLtr) {
            return this.getPaddingRight();
        }
        return this.getPaddingLeft();
    }

    @Override
    public void setPaddingRelative(int start, int top, int end, int bottom) {
        if (this.mOEMRecyclerView != null) {
            this.mOEMRecyclerView.getView().setPaddingRelative(start, top, end, bottom);
        }
    }

    @Override
    public void setClipToPadding(boolean clipToPadding) {
        if (this.mOEMRecyclerView != null) {
            this.mOEMRecyclerView.setClipToPadding(clipToPadding);
        }
    }

    @Override
    public void setItemAnimator(RecyclerView.ItemAnimator itemAnimator) {
    }

    @Override
    public int findFirstCompletelyVisibleItemPosition() {
        return this.mOEMRecyclerView != null ? this.mOEMRecyclerView.findFirstCompletelyVisibleItemPosition() : 0;
    }

    @Override
    public int findFirstVisibleItemPosition() {
        return this.mOEMRecyclerView != null ? this.mOEMRecyclerView.findFirstVisibleItemPosition() : 0;
    }

    @Override
    public int findLastCompletelyVisibleItemPosition() {
        return this.mOEMRecyclerView != null ? this.mOEMRecyclerView.findLastCompletelyVisibleItemPosition() : 0;
    }

    @Override
    public int findLastVisibleItemPosition() {
        return this.mOEMRecyclerView != null ? this.mOEMRecyclerView.findLastVisibleItemPosition() : 0;
    }

    @Override
    public void setSpanSizeLookup(@NonNull GridLayoutManager.SpanSizeLookup spanSizeLookup) {
        if (this.mLayoutStyle instanceof CarUiGridLayoutStyle) {
            ((CarUiGridLayoutStyle)this.mLayoutStyle).setSpanSizeLookup(spanSizeLookup);
            this.setLayoutStyle(this.mLayoutStyle);
        }
    }

    public void onChildViewAttachedToWindow(@NonNull View view) {
        for (RecyclerView.OnChildAttachStateChangeListener listener : this.mChildAttachStateChangeListeners) {
            listener.onChildViewAttachedToWindow(view);
        }
    }

    public void onChildViewDetachedFromWindow(@NonNull View view) {
        for (RecyclerView.OnChildAttachStateChangeListener listener : this.mChildAttachStateChangeListeners) {
            listener.onChildViewDetachedFromWindow(view);
        }
    }

    @Override
    public boolean isLayoutCompleted() {
        RecyclerView.Adapter<?> adapter = this.getAdapter();
        return adapter != null && adapter.getItemCount() > 0 && this.mOEMRecyclerView != null && !this.mOEMRecyclerView.isComputingLayout();
    }

    @Override
    public void addOnLayoutCompleteListener(@Nullable Runnable runnable) {
        if (this.mOEMRecyclerView != null) {
            this.mOEMRecyclerView.addOnLayoutCompleteListener(runnable);
        }
    }

    @Override
    public void removeOnLayoutCompleteListener(@Nullable Runnable runnable) {
        if (this.mOEMRecyclerView != null) {
            this.mOEMRecyclerView.removeOnLayoutCompleteListener(runnable);
        }
    }
}

