/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.recyclerview;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.recyclerview.widget.RecyclerView;
import com.android.car.ui.R;
import com.android.car.ui.utils.CarUiUtils;

public final class ScrollingLimitedViewHolder
extends RecyclerView.ViewHolder {
    private final TextView mMessage;

    public static ScrollingLimitedViewHolder create(@NonNull ViewGroup parent) {
        View rootView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.car_ui_list_limiting_message, parent, false);
        return new ScrollingLimitedViewHolder(rootView);
    }

    ScrollingLimitedViewHolder(@NonNull View itemView) {
        super(itemView);
        this.mMessage = (TextView)CarUiUtils.requireViewByRefId(itemView, R.id.car_ui_list_limiting_message);
    }

    public void bind(@StringRes @Nullable Integer messageId) {
        int resId = messageId != null ? messageId : R.string.car_ui_scrolling_limited_message;
        this.mMessage.setText((CharSequence)this.mMessage.getContext().getString(resId));
    }
}

