/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.recyclerview.decorations.grid;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.android.car.ui.R;
import java.util.Objects;

public class GridDividerItemDecoration
extends RecyclerView.ItemDecoration {
    private final Drawable mHorizontalDivider;
    private final Drawable mVerticalDivider;
    private int mNumColumns;

    public GridDividerItemDecoration(Drawable horizontalDivider, Drawable verticalDivider, int numColumns) {
        this.mHorizontalDivider = horizontalDivider;
        this.mVerticalDivider = verticalDivider;
        this.mNumColumns = numColumns;
    }

    public void onDrawOver(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        this.drawVerticalDividers(canvas, parent);
        this.drawHorizontalDividers(canvas, parent);
    }

    public void getItemOffsets(Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        outRect.set(0, 0, this.mHorizontalDivider.getIntrinsicWidth(), this.mHorizontalDivider.getIntrinsicHeight());
    }

    private void drawHorizontalDividers(Canvas canvas, RecyclerView parent) {
        RecyclerView.LayoutManager layoutManager = Objects.requireNonNull(parent.getLayoutManager());
        int childCount = layoutManager.getChildCount();
        int rowCount = childCount / this.mNumColumns;
        int lastRowChildCount = childCount % this.mNumColumns;
        int lastColumn = Math.min(childCount, this.mNumColumns);
        for (int i = 1; i < lastColumn; ++i) {
            int lastRowChildIndex = i < lastRowChildCount ? i + rowCount * this.mNumColumns : i + (rowCount - 1) * this.mNumColumns;
            View firstRowChild = layoutManager.getChildAt(i);
            View lastRowChild = layoutManager.getChildAt(lastRowChildIndex);
            int dividerTop = firstRowChild.getTop() + (int)parent.getContext().getResources().getDimension(R.dimen.car_ui_recyclerview_divider_top_margin);
            int dividerRight = firstRowChild.getLeft();
            int dividerLeft = dividerRight - this.mHorizontalDivider.getIntrinsicWidth();
            int dividerBottom = lastRowChild.getBottom() - (int)parent.getContext().getResources().getDimension(R.dimen.car_ui_recyclerview_divider_bottom_margin);
            this.mHorizontalDivider.setBounds(dividerLeft, dividerTop, dividerRight, dividerBottom);
            this.mHorizontalDivider.draw(canvas);
        }
    }

    public void setNumOfColumns(int numberOfColumns) {
        this.mNumColumns = numberOfColumns;
    }

    private void drawVerticalDividers(Canvas canvas, RecyclerView parent) {
        RecyclerView.LayoutManager layoutManager = Objects.requireNonNull(parent.getLayoutManager());
        double childCount = layoutManager.getChildCount();
        double rowCount = Math.ceil(childCount / (double)this.mNumColumns);
        int i = 1;
        while ((double)i <= rowCount) {
            if (i != 1) {
                int rightmostChildIndex = (double)i == rowCount ? (i - 1) * this.mNumColumns - 1 : i * this.mNumColumns - 1;
                View leftmostChild = layoutManager.getChildAt(this.mNumColumns * (i - 1));
                View rightmostChild = layoutManager.getChildAt(rightmostChildIndex);
                int dividerLeft = leftmostChild.getLeft() + (int)parent.getContext().getResources().getDimension(R.dimen.car_ui_recyclerview_divider_start_margin);
                int dividerBottom = leftmostChild.getTop();
                int dividerTop = dividerBottom - this.mVerticalDivider.getIntrinsicHeight();
                int dividerRight = rightmostChild.getRight() - (int)parent.getContext().getResources().getDimension(R.dimen.car_ui_recyclerview_divider_end_margin);
                this.mVerticalDivider.setBounds(dividerLeft, dividerTop, dividerRight, dividerBottom);
                this.mVerticalDivider.draw(canvas);
            }
            ++i;
        }
    }
}

