/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.recyclerview.decorations.linear;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.android.car.ui.R;
import java.util.Objects;

public class LinearDividerItemDecoration
extends RecyclerView.ItemDecoration {
    private final Drawable mDivider;
    private int mOrientation;

    public LinearDividerItemDecoration(Drawable divider) {
        this.mDivider = divider;
    }

    public void onDraw(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        if (this.mOrientation == 0) {
            this.drawHorizontalDividers(canvas, parent);
        } else if (this.mOrientation == 1) {
            this.drawVerticalDividers(canvas, parent);
        }
    }

    public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        super.getItemOffsets(outRect, view, parent, state);
        if (parent.getChildAdapterPosition(view) == 0) {
            return;
        }
        this.mOrientation = ((LinearLayoutManager)Objects.requireNonNull(parent.getLayoutManager())).getOrientation();
        if (this.mOrientation == 0) {
            outRect.left = this.mDivider.getIntrinsicWidth();
        } else if (this.mOrientation == 1) {
            outRect.top = this.mDivider.getIntrinsicHeight();
        }
    }

    private void drawHorizontalDividers(Canvas canvas, RecyclerView parent) {
        int parentTop = parent.getPaddingTop() + (int)parent.getContext().getResources().getDimension(R.dimen.car_ui_recyclerview_divider_top_margin);
        int parentBottom = parent.getHeight() - parent.getPaddingBottom() - (int)parent.getContext().getResources().getDimension(R.dimen.car_ui_recyclerview_divider_bottom_margin);
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        int childCount = layoutManager.getChildCount();
        for (int i = 0; i < childCount - 1; ++i) {
            View child = layoutManager.getChildAt(i);
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            int parentLeft = child.getRight() + params.rightMargin;
            int parentRight = parentLeft + this.mDivider.getIntrinsicWidth();
            this.mDivider.setBounds(parentLeft, parentTop, parentRight, parentBottom);
            this.mDivider.draw(canvas);
        }
    }

    private void drawVerticalDividers(Canvas canvas, RecyclerView parent) {
        int parentLeft = parent.getPaddingLeft() + (int)parent.getContext().getResources().getDimension(R.dimen.car_ui_recyclerview_divider_start_margin);
        int parentRight = parent.getWidth() - parent.getPaddingRight() - (int)parent.getContext().getResources().getDimension(R.dimen.car_ui_recyclerview_divider_end_margin);
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        int childCount = layoutManager.getChildCount();
        for (int i = 0; i < childCount - 1; ++i) {
            View child = layoutManager.getChildAt(i);
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            int parentTop = child.getBottom() + params.bottomMargin;
            int parentBottom = parentTop + this.mDivider.getIntrinsicHeight();
            this.mDivider.setBounds(parentLeft, parentTop, parentRight, parentBottom);
            this.mDivider.draw(canvas);
        }
    }
}

