/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.shortcutspopup;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.DrawableRes;
import androidx.annotation.GravityInt;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.android.car.ui.R;

public class CarUiArrowContainerView
extends LinearLayout {
    private final Paint mPaint = new Paint();
    private final Path mPath = new Path();
    private boolean mHasArrow;
    private boolean mArrowGravityLeft;
    private boolean mArrowGravityTop;
    private ColorStateList mArrowColorState;
    private float mArrowWidth;
    private float mArrowHeight;
    private float mArrowRadius;
    private float mArrowOffsetX;
    private float mArrowOffsetY;
    private View mArrowViewSpace;
    @IdRes
    private int mContentViewId;
    @DrawableRes
    private int mContentDrawableId;
    @GravityInt
    private static final int ARROW_GRAVITY_LEFT = 1;
    @GravityInt
    private static final int ARROW_GRAVITY_TOP = 2;
    @GravityInt
    private static final int ARROW_DEFAULT_GRAVITY = 3;
    private static final String TAG = CarUiArrowContainerView.class.getSimpleName();
    private static final String ARROW_VIEW_ATTACHED_TOP_TAG = "CAR_UI_ARROW_VIEW_TOP_TAG";
    private static final String ARROW_VIEW_ATTACHED_BOTTOM_TAG = "CAR_UI_ARROW_VIEW_BOTTOM_TAG";
    private static final int[] DISABLED_ATTR_STATE = new int[]{-16842766};

    private CarUiArrowContainerView(@NonNull Context context) {
        super(context);
    }

    public CarUiArrowContainerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(@NonNull Context context, @Nullable AttributeSet attrs) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CarUiArrowContainerView, 0, 0);
        this.mHasArrow = a.getBoolean(R.styleable.CarUiArrowContainerView_carUiHasArrow, false);
        this.mArrowColorState = a.hasValue(R.styleable.CarUiArrowContainerView_carUiArrowColor) ? a.getColorStateList(R.styleable.CarUiArrowContainerView_carUiArrowColor) : ContextCompat.getColorStateList((Context)this.getContext(), (int)R.color.car_ui_shortcuts_arrow_color);
        this.mArrowWidth = a.getDimension(R.styleable.CarUiArrowContainerView_carUiArrowWidth, 0.0f);
        this.mArrowHeight = a.getDimension(R.styleable.CarUiArrowContainerView_carUiArrowHeight, 0.0f);
        this.mArrowRadius = a.getDimension(R.styleable.CarUiArrowContainerView_carUiArrowRadius, 0.0f);
        this.mArrowOffsetX = a.getDimension(R.styleable.CarUiArrowContainerView_carUiOffsetX, 0.0f);
        this.mArrowOffsetY = a.getDimension(R.styleable.CarUiArrowContainerView_carUiOffsetY, 0.0f);
        this.mArrowGravityLeft = (a.getInt(R.styleable.CarUiArrowContainerView_carUiArrowGravity, 3) & 1) == 1;
        boolean bl = this.mArrowGravityTop = (a.getInt(R.styleable.CarUiArrowContainerView_carUiArrowGravity, 3) & 2) == 2;
        if (!a.hasValue(R.styleable.CarUiArrowContainerView_carUiContentView)) {
            throw new IllegalStateException("Attribute app:carUiContentView must be specified when using CarUiArrowContainerView");
        }
        this.mContentViewId = a.getResourceId(R.styleable.CarUiArrowContainerView_carUiContentView, 0);
        this.mContentDrawableId = a.getResourceId(R.styleable.CarUiArrowContainerView_carUiContentViewDrawable, R.drawable.car_ui_shortcuts_rounded_selector);
        this.mPaint.setColor(this.mArrowColorState.getDefaultColor());
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setAntiAlias(true);
        this.setOrientation(1);
        a.recycle();
        this.refreshArrowView(false);
        this.setWillNotDraw(false);
    }

    public void setArrowHeight(int arrowHeight) {
        if (this.mArrowHeight == (float)arrowHeight) {
            return;
        }
        this.mArrowHeight = arrowHeight;
        this.refreshArrowView(true);
        this.invalidate();
    }

    public void setArrowWidth(int arrowWidth) {
        if (this.mArrowWidth == (float)arrowWidth) {
            return;
        }
        this.mArrowWidth = arrowWidth;
        this.invalidate();
    }

    public void setArrowOffsetX(int offsetX) {
        if (this.mArrowOffsetX == (float)offsetX) {
            return;
        }
        this.mArrowOffsetX = offsetX;
        this.invalidate();
    }

    public void setArrowOffsetY(int offsetY) {
        if (this.mArrowOffsetY == (float)offsetY) {
            return;
        }
        this.mArrowOffsetY = offsetY;
        this.invalidate();
    }

    public void setArrowRadius(int arrowRadius) {
        if (this.mArrowRadius == (float)arrowRadius) {
            return;
        }
        this.mArrowRadius = arrowRadius;
        this.invalidate();
    }

    public void setContentDrawableId(@DrawableRes int drawableId) {
        if (this.mContentDrawableId == drawableId) {
            return;
        }
        this.mContentDrawableId = drawableId;
        this.invalidate();
    }

    public void setOrientation(int orientation) {
        super.setOrientation(1);
    }

    public void setHasArrow(boolean hasArrow) {
        if (this.mHasArrow == hasArrow) {
            return;
        }
        this.mHasArrow = hasArrow;
        this.refreshArrowView(false);
        this.invalidate();
    }

    public void setArrowGravityTop(boolean gravityTop) {
        if (this.mArrowGravityTop == gravityTop) {
            return;
        }
        this.mArrowGravityTop = gravityTop;
        this.refreshArrowView(false);
        this.invalidate();
    }

    public void setArrowGravityLeft(boolean gravityLeft) {
        if (this.mArrowGravityLeft == gravityLeft) {
            return;
        }
        this.mArrowGravityLeft = gravityLeft;
        this.refreshArrowView(false);
        this.invalidate();
    }

    private void refreshArrowView(boolean force) {
        String newArrowViewTag;
        String string2 = newArrowViewTag = this.mArrowGravityTop ? ARROW_VIEW_ATTACHED_TOP_TAG : ARROW_VIEW_ATTACHED_BOTTOM_TAG;
        if (this.mArrowViewSpace != null) {
            if (this.mHasArrow && this.mArrowViewSpace.getTag() == newArrowViewTag && !force) {
                return;
            }
            this.removeView(this.mArrowViewSpace);
        }
        if (!this.mHasArrow) {
            return;
        }
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, (int)this.mArrowHeight);
        this.mArrowViewSpace = new View(this.getContext());
        this.mArrowViewSpace.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mArrowViewSpace.setTag((Object)newArrowViewTag);
        this.addView(this.mArrowViewSpace, this.mArrowGravityTop ? 0 : 1);
    }

    public void setArrowHorizontalOffset(float offset) {
        if (this.mArrowOffsetX == offset) {
            return;
        }
        this.mArrowOffsetX = offset;
        this.invalidate();
    }

    public void setArrowVerticalOffset(float offset) {
        if (this.mArrowOffsetY == offset) {
            return;
        }
        this.mArrowOffsetY = offset;
        this.invalidate();
    }

    public int getArrowOffsetX() {
        return Math.round(this.mArrowOffsetX);
    }

    public int getArrowWidth() {
        return Math.round(this.mArrowWidth);
    }

    protected void onDraw(Canvas canvas) {
        this.mPath.reset();
        this.drawContentBody();
        if (this.mHasArrow) {
            this.mPath.op(this.drawArrow(this.mArrowViewSpace, this.mArrowWidth, this.mArrowHeight, this.mArrowRadius, this.mArrowGravityTop, this.mArrowGravityLeft, this.mArrowOffsetX, this.mArrowOffsetY), Path.Op.UNION);
        }
        this.mPath.close();
        if (this.isEnabled()) {
            this.mPaint.setColor(this.mArrowColorState.getDefaultColor());
        } else {
            this.mPaint.setColor(this.mArrowColorState.getColorForState(DISABLED_ATTR_STATE, -7829368));
        }
        canvas.drawPath(this.mPath, this.mPaint);
        super.onDraw(canvas);
    }

    private void drawContentBody() {
        View contentView = this.findViewById(this.mContentViewId);
        contentView.setBackgroundResource(this.mContentDrawableId);
    }

    public void setEnabled(boolean enabled) {
        if (enabled == this.isEnabled()) {
            return;
        }
        super.setEnabled(enabled);
        View contentView = this.findViewById(this.mContentViewId);
        this.setEnableNested(enabled, contentView);
        if (this.mHasArrow) {
            this.refreshArrowView(true);
            this.invalidate();
        }
    }

    private void setEnableNested(boolean enabled, View view) {
        view.setEnabled(enabled);
        if (!(view instanceof ViewGroup)) {
            return;
        }
        ViewGroup viewGroup = (ViewGroup)view;
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            this.setEnableNested(enabled, viewGroup.getChildAt(i));
        }
    }

    private Path drawArrow(View arrowViewSpace, float arrowWidth, float arrowHeight, float arrowRadius, boolean arrowGravityTop, boolean arrowGravityLeft, float arrowOffsetX, float arrowOffsetY) {
        if (arrowViewSpace == null) {
            return new Path();
        }
        float top = arrowViewSpace.getTop();
        float tanTheta = arrowWidth / (2.0f * arrowHeight);
        float theta = (float)Math.atan(tanTheta);
        float centerX = arrowWidth / 2.0f;
        float centerY = (float)((double)arrowHeight - (double)arrowRadius / Math.sin(theta));
        float lineFromP2ToP3 = arrowRadius / tanTheta;
        float lineFromP2ToC = (float)((double)lineFromP2ToP3 * Math.sin(theta));
        float lineFromP3ToC = (float)((double)arrowHeight - (double)lineFromP2ToP3 * Math.cos(theta));
        Path path = new Path();
        path.reset();
        path.moveTo(0.0f, top);
        path.lineTo(arrowWidth, top);
        path.lineTo(centerX + lineFromP2ToC, lineFromP3ToC + top);
        float thetaDeg = (float)Math.toDegrees(theta);
        path.arcTo(centerX - arrowRadius, centerY - arrowRadius + top, centerX + arrowRadius, centerY + arrowRadius + top, thetaDeg, 180.0f - 2.0f * thetaDeg, false);
        path.lineTo(0.0f, 0.0f + top);
        path.close();
        float blendInHeightOffset = this.mArrowOffsetY * -1.0f;
        if (arrowGravityTop) {
            blendInHeightOffset *= -1.0f;
            Matrix flipTransform = new Matrix();
            flipTransform.setRotate(180.0f, arrowWidth * 0.5f, arrowHeight * 0.5f);
            path.transform(flipTransform);
        }
        if (!arrowGravityLeft) {
            path.offset((float)this.getWidth() - arrowWidth - arrowOffsetX, blendInHeightOffset);
        } else {
            path.offset(arrowOffsetX, blendInHeightOffset);
        }
        return path;
    }
}

