/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.shortcutspopup;

import android.content.Context;
import android.graphics.Rect;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ListAdapter;
import android.widget.ListView;
import androidx.annotation.NonNull;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.ListPopupWindow;
import com.android.car.ui.R;
import com.android.car.ui.shortcutspopup.CarUiArrowContainerView;
import com.android.car.ui.shortcutspopup.ShortcutPopupAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CarUiShortcutsPopup
implements ShortcutPopupAdapter.ItemClickListener {
    private static final String TAG = CarUiShortcutsPopup.class.getSimpleName();
    private static final String CAR_UI_CONTENT_LEFT_DRAWABLE = "car_ui_content_left_drawable";
    private static final String CAR_UI_CONTENT_NAME = "car_ui_content_name";
    @NonNull
    private final List<ShortcutItem> mShortcuts;
    @NonNull
    private final ListPopupWindow mListPopupWindow;
    @NonNull
    private final ShortcutPopupAdapter mShortcutPopupAdapter;
    @NonNull
    private final View mAnchorView;
    @NonNull
    private final Context mContext;
    private final int mArrowCenterOffsetFromBoundary;
    private boolean mIsAboveAnchor;
    @NonNull
    private final Animation mCollapseAnimationAboveAnchor;
    @NonNull
    private final Animation mCollapseAnimationBelowAnchor;

    public CarUiShortcutsPopup(@NonNull Context context, @NonNull View anchorView, @NonNull List<ShortcutItem> shortcuts) {
        this.mShortcuts = shortcuts;
        this.mContext = context;
        this.mAnchorView = anchorView;
        CarUiArrowContainerView arrowView = (CarUiArrowContainerView)LayoutInflater.from((Context)this.mContext).inflate(R.layout.car_ui_shortcut_popup_item, null);
        this.mArrowCenterOffsetFromBoundary = arrowView.getArrowOffsetX() + (arrowView.getArrowWidth() >> 1);
        this.mListPopupWindow = this.initListPopupWindow(context, anchorView);
        this.mShortcutPopupAdapter = this.createAdapter(context, shortcuts);
        this.mListPopupWindow.setAdapter((ListAdapter)this.mShortcutPopupAdapter);
        this.mListPopupWindow.setAnimationStyle(0);
        this.mListPopupWindow.setOnDismissListener(this::animateCollapse);
        this.mCollapseAnimationAboveAnchor = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.car_ui_shortcutspopup_above_anchor_collapse_anim);
        this.mCollapseAnimationBelowAnchor = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.car_ui_shortcutspopup_below_anchor_collapse_anim);
    }

    private void animateCollapse() {
        if (this.mListPopupWindow.getListView() == null) {
            return;
        }
        Animation animation = this.mIsAboveAnchor ? this.mCollapseAnimationAboveAnchor : this.mCollapseAnimationBelowAnchor;
        this.mListPopupWindow.getListView().setAnimation(animation);
        this.mListPopupWindow.getListView().animate();
    }

    private ListPopupWindow initListPopupWindow(Context context, View anchorView) {
        ListPopupWindow listPopupWindow = new ListPopupWindow(context);
        listPopupWindow.setAnchorView(anchorView);
        listPopupWindow.setBackgroundDrawable(null);
        listPopupWindow.setWidth((int)context.getResources().getDimension(R.dimen.car_ui_shortcuts_popup_width));
        listPopupWindow.setModal(true);
        return listPopupWindow;
    }

    private ShortcutPopupAdapter createAdapter(Context context, List<ShortcutItem> shortcuts) {
        ArrayList adapterList = new ArrayList();
        for (ShortcutItem shortcut : shortcuts) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(CAR_UI_CONTENT_LEFT_DRAWABLE, shortcut.data().mLeftDrawable);
            map.put(CAR_UI_CONTENT_NAME, shortcut.data().mShortcutName);
            adapterList.add(map);
        }
        String[] from = new String[]{CAR_UI_CONTENT_LEFT_DRAWABLE, CAR_UI_CONTENT_NAME};
        int[] to = new int[]{R.id.car_ui_content_left_drawable, R.id.car_ui_content_name};
        return new ShortcutPopupAdapter(context, this, adapterList, R.layout.car_ui_shortcut_popup_item, from, to);
    }

    public void show() {
        int offset = this.measureHorizontalOffset();
        this.mListPopupWindow.setHorizontalOffset(offset);
        this.mShortcutPopupAdapter.setArrowGravityRight(offset < -this.mArrowCenterOffsetFromBoundary);
        this.mListPopupWindow.setEpicenterBounds(new Rect(offset, 0, (int)this.mContext.getResources().getDimension(R.dimen.car_ui_shortcuts_popup_width) + offset, 0));
        this.mListPopupWindow.show();
        if (this.mListPopupWindow.getListView() == null) {
            return;
        }
        this.mListPopupWindow.getListView().setFocusable(false);
        this.mListPopupWindow.getListView().setVisibility(0);
        this.mListPopupWindow.getListView().setDivider(AppCompatResources.getDrawable((Context)this.mContext, (int)R.drawable.car_ui_divider));
        this.mayBeReversePopupJustBeforeDrawingPopupWindow();
    }

    public boolean isShowing() {
        return this.mListPopupWindow.isShowing();
    }

    public void dismiss() {
        if (this.isShowing()) {
            this.mListPopupWindow.dismiss();
        }
    }

    public void dismissImmediate() {
        if (this.isShowing() && this.mListPopupWindow.getListView() != null) {
            this.mListPopupWindow.getListView().setVisibility(8);
            this.mListPopupWindow.dismiss();
        }
    }

    private void mayBeReversePopupJustBeforeDrawingPopupWindow() {
        if (this.mListPopupWindow.getListView() == null) {
            return;
        }
        ListView view = this.mListPopupWindow.getListView();
        ViewTreeObserver.OnPreDrawListener preDrawListener = new ViewTreeObserver.OnPreDrawListener(){
            final /* synthetic */ View val$view;
            {
                this.val$view = view;
            }

            public boolean onPreDraw() {
                this.val$view.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                int[] popupWindowLoc = new int[2];
                int[] anchorLoc = new int[2];
                this.val$view.getLocationOnScreen(popupWindowLoc);
                CarUiShortcutsPopup.this.mAnchorView.getLocationOnScreen(anchorLoc);
                if (popupWindowLoc[1] <= anchorLoc[1]) {
                    CarUiShortcutsPopup.this.mIsAboveAnchor = true;
                    CarUiShortcutsPopup.this.mShortcutPopupAdapter.setReverse(true);
                } else {
                    CarUiShortcutsPopup.this.mIsAboveAnchor = false;
                    CarUiShortcutsPopup.this.mShortcutPopupAdapter.setReverse(false);
                }
                CarUiShortcutsPopup.this.mShortcutPopupAdapter.notifyDataSetChanged();
                return true;
            }
        };
        view.getViewTreeObserver().addOnPreDrawListener(preDrawListener);
    }

    private int measureHorizontalOffset() {
        int[] anchorLoc = new int[2];
        this.mAnchorView.getLocationOnScreen(anchorLoc);
        Rect displayFrame = this.getWindowVisibleDisplayFrame(this.mAnchorView);
        int anchorCenterX = (this.mAnchorView.getWidth() >> 1) - this.mArrowCenterOffsetFromBoundary;
        int popupStartLoc = anchorLoc[0] + anchorCenterX;
        if (popupStartLoc + this.mListPopupWindow.getWidth() <= displayFrame.right) {
            return anchorCenterX;
        }
        return -1 * this.mListPopupWindow.getWidth() + (this.mArrowCenterOffsetFromBoundary << 1) + anchorCenterX;
    }

    private Rect getWindowVisibleDisplayFrame(View view) {
        Rect displayFrame = new Rect();
        View appRootView = view.getRootView();
        appRootView.getWindowVisibleDisplayFrame(displayFrame);
        return displayFrame;
    }

    @Override
    public void onClick(int position) {
        if (position < 0 || position >= this.mShortcuts.size()) {
            throw new ArrayIndexOutOfBoundsException("position: " + position + " is not within size " + this.mShortcuts.size());
        }
        if (this.mShortcuts.get(position).onClick()) {
            this.mListPopupWindow.dismiss();
        }
    }

    @Override
    public boolean isEnabled(int position) {
        if (position < 0 || position >= this.mShortcuts.size()) {
            Log.e((String)TAG, (String)("OnItemClick Out of Bounds " + position));
            return false;
        }
        return this.mShortcuts.get(position).isEnabled();
    }

    public static interface ShortcutItem {
        public ItemData data();

        public boolean onClick();

        public boolean isEnabled();
    }

    public static class ItemData {
        private final int mLeftDrawable;
        private final String mShortcutName;

        public ItemData(int leftDrawable, String shortcutName) {
            this.mLeftDrawable = leftDrawable;
            this.mShortcutName = shortcutName;
        }
    }

    public static class Builder {
        private final List<ShortcutItem> mShortcutList = new ArrayList<ShortcutItem>();

        public Builder addShortcut(ShortcutItem shortcut) {
            this.mShortcutList.add(shortcut);
            return this;
        }

        public CarUiShortcutsPopup build(Context context, View anchorView) {
            return new CarUiShortcutsPopup(context, anchorView, this.mShortcutList);
        }
    }
}

