/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.shortcutspopup;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.SimpleAdapter;
import androidx.annotation.NonNull;
import com.android.car.ui.R;
import com.android.car.ui.shortcutspopup.CarUiArrowContainerView;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class ShortcutPopupAdapter
extends SimpleAdapter {
    private boolean mReverse;
    private boolean mArrowGravityRight;
    @NonNull
    private final List<Map<String, ?>> mAdapterList;
    @NonNull
    private final ItemClickListener mItemClickListener;

    ShortcutPopupAdapter(@NonNull Context context, @NonNull ItemClickListener itemClickListener, @NonNull List<Map<String, ?>> data, int resource, @NonNull String[] from, @NonNull int[] to) {
        super(context, data, resource, from, to);
        this.mAdapterList = data;
        this.mItemClickListener = itemClickListener;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        CarUiArrowContainerView containerView = (CarUiArrowContainerView)super.getView(position, convertView, parent);
        boolean hasArrow = position == 0 && !this.mReverse || position == this.mAdapterList.size() - 1 && this.mReverse;
        containerView.setHasArrow(hasArrow);
        containerView.setArrowGravityTop(!this.mReverse);
        containerView.setArrowGravityLeft(!this.mArrowGravityRight);
        View contentView = containerView.findViewById(R.id.car_ui_shortcuts_contentView);
        if (contentView != null) {
            contentView.setOnClickListener(v -> this.mItemClickListener.onClick((int)this.getItemId(position)));
        }
        containerView.setEnabled(this.mItemClickListener.isEnabled((int)this.getItemId(position)));
        return containerView;
    }

    public long getItemId(int position) {
        int actualPosition = position;
        if (this.mReverse) {
            actualPosition = this.mAdapterList.size() - 1 - actualPosition;
        }
        return super.getItemId(actualPosition);
    }

    public int getItemViewType(int position) {
        return super.getItemViewType(position);
    }

    public void setReverse(boolean isReverse) {
        if (isReverse == this.mReverse) {
            return;
        }
        this.mReverse = isReverse;
        Collections.reverse(this.mAdapterList);
        this.notifyDataSetChanged();
    }

    public void setArrowGravityRight(boolean arrowGravityRight) {
        this.mArrowGravityRight = arrowGravityRight;
    }

    static interface ItemClickListener {
        public void onClick(int var1);

        public boolean isEnabled(int var1);
    }
}

