/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.toolbar;

import android.car.drivingstate.CarUxRestrictions;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.android.car.ui.R;
import com.android.car.ui.utils.CarUxRestrictionsUtil;
import java.lang.ref.WeakReference;

public class MenuItem {
    @NonNull
    private final WeakReference<Context> mContext;
    private final boolean mIsCheckable;
    private final boolean mIsActivatable;
    private final boolean mIsSearch;
    private final boolean mShowIconAndTitle;
    private final boolean mIsTinted;
    private final boolean mIsPrimary;
    private int mId;
    private CarUxRestrictions mCurrentRestrictions;
    private WeakReference<Listener> mListener = new WeakReference<Object>(null);
    private CharSequence mTitle;
    private Drawable mIcon;
    private OnClickListener mOnClickListener;
    private final DisplayBehavior mDisplayBehavior;
    private int mUxRestrictions;
    private boolean mIsEnabled;
    private boolean mIsChecked;
    private boolean mIsVisible;
    private boolean mIsActivated;
    private final CarUxRestrictionsUtil.OnUxRestrictionsChangedListener mUxRestrictionsListener = uxRestrictions -> {
        boolean wasRestricted = this.isRestricted();
        this.mCurrentRestrictions = uxRestrictions;
        if (this.isRestricted() != wasRestricted) {
            this.update();
        }
    };

    private MenuItem(Builder builder) {
        this.mContext = builder.mContext;
        this.mId = builder.mId;
        this.mIsCheckable = builder.mIsCheckable;
        this.mIsActivatable = builder.mIsActivatable;
        this.mTitle = builder.mTitle;
        this.mIcon = builder.mIcon;
        this.mOnClickListener = builder.mOnClickListener;
        this.mDisplayBehavior = builder.mDisplayBehavior;
        this.mIsEnabled = builder.mIsEnabled;
        this.mIsChecked = builder.mIsChecked;
        this.mIsVisible = builder.mIsVisible;
        this.mIsActivated = builder.mIsActivated;
        this.mIsSearch = builder.mIsSearch;
        this.mShowIconAndTitle = builder.mShowIconAndTitle;
        this.mIsTinted = builder.mIsTinted;
        this.mIsPrimary = builder.mIsPrimary;
        this.mUxRestrictions = builder.mUxRestrictions;
        CarUxRestrictionsUtil.getInstance((Context)this.mContext.get()).register(this.mUxRestrictionsListener);
    }

    private void update() {
        Listener listener = (Listener)this.mListener.get();
        if (listener != null) {
            listener.onMenuItemChanged(this);
        }
    }

    public void setId(int id2) {
        this.mId = id2;
        this.update();
    }

    public int getId() {
        return this.mId;
    }

    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.mIsEnabled = enabled;
        this.update();
    }

    public boolean isCheckable() {
        return this.mIsCheckable;
    }

    public boolean isChecked() {
        return this.mIsChecked;
    }

    public void setChecked(boolean checked) {
        if (!this.isCheckable()) {
            throw new IllegalStateException("Cannot call setChecked() on a non-checkable MenuItem");
        }
        this.mIsChecked = checked;
        this.update();
    }

    public boolean isTinted() {
        return this.mIsTinted;
    }

    public boolean isVisible() {
        return this.mIsVisible;
    }

    public void setVisible(boolean visible) {
        this.mIsVisible = visible;
        this.update();
    }

    public boolean isActivatable() {
        return this.mIsActivatable;
    }

    public boolean isActivated() {
        return this.mIsActivated;
    }

    public void setActivated(boolean activated) {
        if (!this.isActivatable()) {
            throw new IllegalStateException("Cannot call setActivated() on a non-activatable MenuItem");
        }
        this.mIsActivated = activated;
        this.update();
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public void setTitle(CharSequence title) {
        this.mTitle = title;
        this.update();
    }

    public void setTitle(int resId) {
        this.setTitle(((Context)this.mContext.get()).getString(resId));
    }

    public void setUxRestrictions(int uxRestrictions) {
        if (this.mUxRestrictions != uxRestrictions) {
            this.mUxRestrictions = uxRestrictions;
            this.update();
        }
    }

    public int getUxRestrictions() {
        return this.mUxRestrictions;
    }

    public OnClickListener getOnClickListener() {
        return this.mOnClickListener;
    }

    public boolean isShowingIconAndTitle() {
        return this.mShowIconAndTitle;
    }

    public void setOnClickListener(OnClickListener listener) {
        this.mOnClickListener = listener;
        this.update();
    }

    public boolean isRestricted() {
        return CarUxRestrictionsUtil.isRestricted(this.mUxRestrictions, this.mCurrentRestrictions);
    }

    @VisibleForTesting(otherwise=3)
    public void performClick() {
        if (!this.isEnabled() || !this.isVisible()) {
            return;
        }
        if (this.isRestricted()) {
            Toast.makeText((Context)((Context)this.mContext.get()), (int)R.string.car_ui_restricted_while_driving, (int)1).show();
            return;
        }
        if (this.isActivatable()) {
            this.setActivated(!this.isActivated());
        }
        if (this.isCheckable()) {
            this.setChecked(!this.isChecked());
        }
        if (this.mOnClickListener != null) {
            this.mOnClickListener.onClick(this);
        }
    }

    public DisplayBehavior getDisplayBehavior() {
        return this.mDisplayBehavior;
    }

    public Drawable getIcon() {
        return this.mIcon;
    }

    public void setIcon(Drawable icon) {
        this.mIcon = icon;
        this.update();
    }

    public void setIcon(int resId) {
        this.setIcon(resId == 0 ? null : ((Context)this.mContext.get()).getDrawable(resId));
    }

    public boolean isPrimary() {
        return this.mIsPrimary;
    }

    public boolean isSearch() {
        return this.mIsSearch;
    }

    public static Builder builder(Context context) {
        return new Builder(context);
    }

    public void setListener(@Nullable Listener listener) {
        this.mListener = new WeakReference<Listener>(listener);
    }

    public static final class Builder {
        @NonNull
        private final WeakReference<Context> mContext;
        private String mSearchTitle;
        private String mSettingsTitle;
        private Drawable mSearchIcon;
        private Drawable mSettingsIcon;
        private int mId = -1;
        private CharSequence mTitle;
        private Drawable mIcon;
        private OnClickListener mOnClickListener;
        private DisplayBehavior mDisplayBehavior = DisplayBehavior.ALWAYS;
        private boolean mIsTinted = true;
        private boolean mShowIconAndTitle = false;
        private boolean mIsEnabled = true;
        private boolean mIsCheckable = false;
        private boolean mIsChecked = false;
        private boolean mIsVisible = true;
        private boolean mIsActivatable = false;
        private boolean mIsActivated = false;
        private boolean mIsSearch = false;
        private boolean mIsSettings = false;
        private boolean mIsPrimary = false;
        private int mUxRestrictions = 0;

        public Builder(@NonNull Context c) {
            this.mContext = new WeakReference<Context>(c);
        }

        public MenuItem build() {
            if (this.mIsActivatable && (this.mShowIconAndTitle || this.mIcon == null)) {
                throw new IllegalStateException("Only simple icons can be activatable");
            }
            if (this.mIsCheckable && (this.mShowIconAndTitle || this.mIsActivatable)) {
                throw new IllegalStateException("Unsupported options for a checkable MenuItem");
            }
            if (this.mIsSearch && this.mIsSettings) {
                throw new IllegalStateException("Can't have both a search and settings MenuItem");
            }
            if (this.mIsActivatable && this.mDisplayBehavior == DisplayBehavior.NEVER) {
                throw new IllegalStateException("Activatable MenuItems not supported as Overflow");
            }
            if (this.mIsSearch && (!this.mSearchTitle.contentEquals(this.mTitle) || !this.mSearchIcon.equals(this.mIcon) || this.mIsCheckable || this.mIsActivatable || !this.mIsTinted || this.mShowIconAndTitle || this.mDisplayBehavior != DisplayBehavior.ALWAYS)) {
                throw new IllegalStateException("Invalid search MenuItem");
            }
            if (this.mIsSettings && (!this.mSettingsTitle.contentEquals(this.mTitle) || !this.mSettingsIcon.equals(this.mIcon) || this.mIsCheckable || this.mIsActivatable || !this.mIsTinted || this.mShowIconAndTitle || this.mDisplayBehavior != DisplayBehavior.ALWAYS)) {
                throw new IllegalStateException("Invalid settings MenuItem");
            }
            return new MenuItem(this);
        }

        public Builder setId(int id2) {
            this.mId = id2;
            return this;
        }

        public Builder setTitle(int resId) {
            this.setTitle(((Context)this.mContext.get()).getString(resId));
            return this;
        }

        public Builder setTitle(CharSequence title) {
            this.mTitle = title;
            return this;
        }

        public Builder setIcon(int resId) {
            this.mIcon = resId == 0 ? null : ((Context)this.mContext.get()).getDrawable(resId);
            return this;
        }

        public Builder setIcon(Drawable icon) {
            this.mIcon = icon;
            return this;
        }

        public Builder setTinted(boolean tinted) {
            this.mIsTinted = tinted;
            return this;
        }

        public Builder setVisible(boolean visible) {
            this.mIsVisible = visible;
            return this;
        }

        public Builder setActivatable() {
            this.mIsActivatable = true;
            return this;
        }

        public Builder setActivated(boolean activated) {
            this.setActivatable();
            this.mIsActivated = activated;
            return this;
        }

        public Builder setOnClickListener(OnClickListener listener) {
            this.mOnClickListener = listener;
            return this;
        }

        public Builder setShowIconAndTitle(boolean showIconAndTitle) {
            this.mShowIconAndTitle = showIconAndTitle;
            return this;
        }

        public Builder setDisplayBehavior(DisplayBehavior behavior) {
            this.mDisplayBehavior = behavior;
            return this;
        }

        public Builder setEnabled(boolean enabled) {
            this.mIsEnabled = enabled;
            return this;
        }

        public Builder setCheckable() {
            this.mIsCheckable = true;
            return this;
        }

        public Builder setChecked(boolean checked) {
            this.setCheckable();
            this.mIsChecked = checked;
            return this;
        }

        public Builder setPrimary(boolean primary) {
            this.mIsPrimary = primary;
            return this;
        }

        public Builder setUxRestrictions(int restrictions) {
            this.mUxRestrictions = restrictions;
            return this;
        }

        public Builder setToSearch() {
            this.mSearchTitle = ((Context)this.mContext.get()).getString(R.string.car_ui_toolbar_menu_item_search_title);
            this.mSearchIcon = ((Context)this.mContext.get()).getDrawable(R.drawable.car_ui_icon_search);
            this.mIsSearch = true;
            this.setTitle(this.mSearchTitle);
            this.setIcon(this.mSearchIcon);
            return this;
        }

        public Builder setToSettings() {
            this.mSettingsTitle = ((Context)this.mContext.get()).getString(R.string.car_ui_toolbar_menu_item_settings_title);
            this.mSettingsIcon = ((Context)this.mContext.get()).getDrawable(R.drawable.car_ui_icon_settings);
            this.mIsSettings = true;
            this.setTitle(this.mSettingsTitle);
            this.setIcon(this.mSettingsIcon);
            this.setUxRestrictions(64);
            return this;
        }

        @Deprecated
        public static MenuItem createSearch(Context c, OnClickListener listener) {
            return MenuItem.builder(c).setToSearch().setOnClickListener(listener).build();
        }

        @Deprecated
        public static MenuItem createSettings(Context c, OnClickListener listener) {
            return MenuItem.builder(c).setToSettings().setOnClickListener(listener).build();
        }
    }

    public static interface OnClickListener {
        public void onClick(MenuItem var1);
    }

    public static enum DisplayBehavior {
        ALWAYS,
        NEVER;

    }

    public static interface Listener {
        public void onMenuItemChanged(MenuItem var1);
    }
}

