/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.toolbar;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.car.ui.plugin.oemapis.toolbar.MenuItemOEMV1;
import com.android.car.ui.toolbar.MenuItem;
import com.android.car.ui.toolbar.ToolbarControllerAdapterV1;
import com.android.car.ui.toolbar.ToolbarControllerAdapterV2;
import com.android.car.ui.toolbar.ToolbarControllerAdapterV3;
import com.android.car.ui.utils.CarUiUtils;
import java.lang.invoke.LambdaMetafactory;

public class MenuItemAdapterV1 {
    @Nullable
    private ToolbarControllerAdapterV1 mToolbarV1;
    @Nullable
    private ToolbarControllerAdapterV2 mToolbarV2;
    @Nullable
    private ToolbarControllerAdapterV3 mToolbarV3;
    @NonNull
    private final MenuItem mClientMenuItem;
    @NonNull
    private MenuItemOEMV1 mPluginMenuItem = MenuItemOEMV1.builder().build();
    private final MenuItem.Listener mClientListener = menuItem -> {
        this.updateMenuItem();
        this.updateMenuItems();
    };

    public MenuItemAdapterV1(@NonNull ToolbarControllerAdapterV1 toolbar, @NonNull MenuItem item) {
        this.mToolbarV1 = toolbar;
        this.mClientMenuItem = item;
        item.setListener(this.mClientListener);
        this.updateMenuItem();
    }

    public MenuItemAdapterV1(@NonNull ToolbarControllerAdapterV2 toolbar, @NonNull MenuItem item) {
        this.mToolbarV2 = toolbar;
        this.mClientMenuItem = item;
        item.setListener(this.mClientListener);
        this.updateMenuItem();
    }

    public MenuItemAdapterV1(@NonNull ToolbarControllerAdapterV3 toolbar, @NonNull MenuItem item) {
        this.mToolbarV3 = toolbar;
        this.mClientMenuItem = item;
        item.setListener(this.mClientListener);
        this.updateMenuItem();
    }

    private void updateMenuItems() {
        if (this.mToolbarV3 != null) {
            this.mToolbarV3.updateMenuItems();
        } else if (this.mToolbarV2 != null) {
            this.mToolbarV2.updateMenuItems();
        } else if (this.mToolbarV1 != null) {
            this.mToolbarV1.updateMenuItems();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateMenuItem() {
        builder = this.mPluginMenuItem.copy().setKey(this.mClientMenuItem.hashCode()).setTitle(CarUiUtils.charSequenceToString(this.mClientMenuItem.getTitle())).setIcon(this.mClientMenuItem.getIcon()).setEnabled(this.mClientMenuItem.isEnabled()).setPrimary(this.mClientMenuItem.isPrimary()).setTinted(this.mClientMenuItem.isTinted()).setRestricted(this.mClientMenuItem.isRestricted()).setShowIconAndTitle(this.mClientMenuItem.isShowingIconAndTitle()).setDisplayBehavior(MenuItemAdapterV1.convertDisplayBehavior(this.mClientMenuItem.getDisplayBehavior()));
        if (this.mClientMenuItem.isCheckable()) {
            builder.setCheckable(true).setChecked(this.mClientMenuItem.isChecked());
        }
        if (this.mClientMenuItem.isActivatable()) {
            builder.setActivatable(true).setActivated(this.mClientMenuItem.isActivated());
        }
        if ((onClickListener = this.mClientMenuItem.getOnClickListener()) != null || this.mClientMenuItem.isActivatable() || this.mClientMenuItem.isCheckable()) ** GOTO lbl13
        if (this.mClientMenuItem.isRestricted()) {
lbl13:
            // 2 sources

            builder.setOnClickListener((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, performClick(), ()V)((MenuItem)this.mClientMenuItem));
        } else {
            builder.setOnClickListener(null);
        }
        this.mPluginMenuItem = builder.build();
    }

    @NonNull
    public MenuItemOEMV1 getPluginMenuItem() {
        return this.mPluginMenuItem;
    }

    @NonNull
    public MenuItem getClientMenuItem() {
        return this.mClientMenuItem;
    }

    public boolean isVisible() {
        return this.mClientMenuItem.isVisible();
    }

    private static int convertDisplayBehavior(MenuItem.DisplayBehavior displayBehavior) {
        switch (displayBehavior) {
            case ALWAYS: {
                return 0;
            }
            case NEVER: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Unknown display behavior!");
    }
}

