/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.toolbar;

import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.Switch;
import android.widget.TextView;
import androidx.asynclayoutinflater.view.AsyncLayoutInflater;
import com.android.car.ui.R;
import com.android.car.ui.toolbar.MenuItem;
import com.android.car.ui.utils.CarUiUtils;
import com.android.car.ui.uxr.DrawableStateView;
import java.util.function.Consumer;

class MenuItemRenderer
implements MenuItem.Listener {
    private static final int[] RESTRICTED_STATE = new int[]{R.attr.state_ux_restricted};
    private final int mMenuItemIconSize;
    private boolean mToolbarIsSearching;
    private final MenuItem mMenuItem;
    private final ViewGroup mParentView;
    private View mView;
    private View mIconContainer;
    private ImageView mIconView;
    private Switch mSwitch;
    private TextView mTextView;
    private TextView mTextWithIconView;
    private boolean mIndividualClickListeners;

    MenuItemRenderer(MenuItem item, ViewGroup parentView) {
        this.mMenuItem = item;
        this.mParentView = parentView;
        this.mMenuItem.setListener(this);
        this.mMenuItemIconSize = parentView.getContext().getResources().getDimensionPixelSize(R.dimen.car_ui_toolbar_menu_item_icon_size);
    }

    void setToolbarIsSearching(boolean searching) {
        if (searching != this.mToolbarIsSearching) {
            this.mToolbarIsSearching = searching;
            if (this.mMenuItem.isSearch()) {
                this.updateView();
            }
        }
    }

    @Override
    public void onMenuItemChanged(MenuItem changedItem) {
        this.updateView();
    }

    void createView(Consumer<View> callback) {
        AsyncLayoutInflater inflater = new AsyncLayoutInflater(this.mParentView.getContext());
        int layout2 = this.mMenuItem.isPrimary() ? R.layout.car_ui_toolbar_menu_item_primary : R.layout.car_ui_toolbar_menu_item;
        inflater.inflate(layout2, this.mParentView, (view, resid, parent) -> {
            this.mView = view;
            this.mIconContainer = CarUiUtils.requireViewByRefId(this.mView, R.id.car_ui_toolbar_menu_item_icon_container);
            this.mIconView = (ImageView)CarUiUtils.requireViewByRefId(this.mView, R.id.car_ui_toolbar_menu_item_icon);
            this.mSwitch = (Switch)CarUiUtils.requireViewByRefId(this.mView, R.id.car_ui_toolbar_menu_item_switch);
            this.mTextView = (TextView)CarUiUtils.requireViewByRefId(this.mView, R.id.car_ui_toolbar_menu_item_text);
            this.mTextWithIconView = (TextView)CarUiUtils.requireViewByRefId(this.mView, R.id.car_ui_toolbar_menu_item_text_with_icon);
            this.mIndividualClickListeners = this.mView.getContext().getResources().getBoolean(R.bool.car_ui_toolbar_menuitem_individual_click_listeners);
            this.updateView();
            callback.accept(this.mView);
        });
    }

    private void updateView() {
        Switch clickTarget;
        if (this.mView == null) {
            return;
        }
        this.mView.setId(this.mMenuItem.getId());
        boolean hasIcon = this.mMenuItem.getIcon() != null;
        boolean hasText = !TextUtils.isEmpty((CharSequence)this.mMenuItem.getTitle());
        boolean textAndIcon = this.mMenuItem.isShowingIconAndTitle();
        boolean checkable = this.mMenuItem.isCheckable();
        if (!this.mMenuItem.isVisible() || this.mMenuItem.isSearch() && this.mToolbarIsSearching || !checkable && !hasIcon && !hasText) {
            this.mView.setVisibility(8);
            return;
        }
        this.mView.setVisibility(0);
        this.mView.setContentDescription(this.mMenuItem.getTitle());
        if (checkable) {
            this.mSwitch.setChecked(this.mMenuItem.isChecked());
            clickTarget = this.mSwitch;
        } else if (hasText && hasIcon && textAndIcon) {
            this.mMenuItem.getIcon().setBounds(0, 0, this.mMenuItemIconSize, this.mMenuItemIconSize);
            this.mTextWithIconView.setCompoundDrawables(this.mMenuItem.getIcon(), null, null, null);
            this.mTextWithIconView.setText(this.mMenuItem.getTitle());
            clickTarget = this.mTextWithIconView;
        } else if (hasIcon) {
            this.mIconView.setImageDrawable(this.mMenuItem.getIcon());
            clickTarget = this.mIconContainer;
        } else {
            this.mTextView.setText(this.mMenuItem.getTitle());
            clickTarget = this.mTextView;
        }
        this.mIconContainer.setVisibility(clickTarget == this.mIconContainer ? 0 : 8);
        this.mTextView.setVisibility(clickTarget == this.mTextView ? 0 : 8);
        this.mTextWithIconView.setVisibility(clickTarget == this.mTextWithIconView ? 0 : 8);
        this.mSwitch.setVisibility(clickTarget == this.mSwitch ? 0 : 8);
        if (!this.mIndividualClickListeners) {
            clickTarget = this.mView;
        }
        if (!this.mMenuItem.isTinted() && hasIcon) {
            this.mMenuItem.getIcon().setTintList(null);
        }
        this.recursiveSetEnabledAndDrawableState(this.mView);
        this.mView.setActivated(this.mMenuItem.isActivated());
        if (this.mMenuItem.getOnClickListener() != null || this.mMenuItem.isCheckable() || this.mMenuItem.isActivatable()) {
            clickTarget.setOnClickListener(v -> this.mMenuItem.performClick());
        } else if (clickTarget == this.mView) {
            this.mView.setOnClickListener(null);
            this.mView.setClickable(false);
        }
    }

    private void recursiveSetEnabledAndDrawableState(View view) {
        int[] drawableState;
        view.setEnabled(this.mMenuItem.isEnabled());
        Object object = drawableState = (Object)(this.mMenuItem.isRestricted() ? RESTRICTED_STATE : null);
        if (view instanceof ImageView) {
            ((ImageView)view).setImageState(drawableState, true);
        } else if (view instanceof DrawableStateView) {
            ((DrawableStateView)view).setExtraDrawableState(drawableState, null);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                this.recursiveSetEnabledAndDrawableState(viewGroup.getChildAt(i));
            }
        }
    }
}

