/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.toolbar;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Xml;
import androidx.annotation.XmlRes;
import com.android.car.ui.R;
import com.android.car.ui.toolbar.MenuItem;
import com.android.car.ui.utils.CarUiUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MenuItemXmlParserUtil {
    private MenuItemXmlParserUtil() {
    }

    public static List<MenuItem> readMenuItemList(Context c, @XmlRes int resId) {
        ArrayList<MenuItem> arrayList;
        block10: {
            if (resId == 0) {
                return new ArrayList<MenuItem>();
            }
            XmlResourceParser parser = c.getResources().getXml(resId);
            try {
                AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
                ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
                parser.next();
                parser.next();
                parser.require(2, null, "MenuItems");
                while (parser.next() != 3) {
                    menuItems.add(MenuItemXmlParserUtil.readMenuItem(c, parser, attrs));
                }
                arrayList = menuItems;
                if (parser == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | XmlPullParserException e) {
                    throw new RuntimeException("Unable to parse Menu Items", e);
                }
            }
            parser.close();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MenuItem readMenuItem(Context c, XmlResourceParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        parser.require(2, null, "MenuItem");
        TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.CarUiToolbarMenuItem);
        try {
            int id2 = a.getResourceId(R.styleable.CarUiToolbarMenuItem_id, -1);
            String title = a.getString(R.styleable.CarUiToolbarMenuItem_title);
            Drawable icon = a.getDrawable(R.styleable.CarUiToolbarMenuItem_carUiIcon);
            boolean isSearch = a.getBoolean(R.styleable.CarUiToolbarMenuItem_search, false);
            boolean isSettings = a.getBoolean(R.styleable.CarUiToolbarMenuItem_settings, false);
            boolean tinted = a.getBoolean(R.styleable.CarUiToolbarMenuItem_tinted, true);
            boolean visible = a.getBoolean(R.styleable.CarUiToolbarMenuItem_visible, true);
            boolean showIconAndTitle = a.getBoolean(R.styleable.CarUiToolbarMenuItem_showIconAndTitle, false);
            boolean checkable = a.getBoolean(R.styleable.CarUiToolbarMenuItem_checkable, false);
            boolean checked = a.getBoolean(R.styleable.CarUiToolbarMenuItem_checked, false);
            boolean checkedExists = a.hasValue(R.styleable.CarUiToolbarMenuItem_checked);
            boolean activatable = a.getBoolean(R.styleable.CarUiToolbarMenuItem_activatable, false);
            boolean activated = a.getBoolean(R.styleable.CarUiToolbarMenuItem_activated, false);
            boolean activatedExists = a.hasValue(R.styleable.CarUiToolbarMenuItem_activated);
            int displayBehaviorInt = a.getInt(R.styleable.CarUiToolbarMenuItem_displayBehavior, 0);
            int uxRestrictions = a.getInt(R.styleable.CarUiToolbarMenuItem_uxRestrictions, 0);
            String onClickMethod = a.getString(R.styleable.CarUiToolbarMenuItem_onClick);
            MenuItem.OnClickListener onClickListener = null;
            if (onClickMethod != null) {
                Activity activity = CarUiUtils.getActivity(c);
                if (activity == null) {
                    throw new RuntimeException("Couldn't find an activity for the MenuItem");
                }
                try {
                    Method m = activity.getClass().getMethod(onClickMethod, MenuItem.class);
                    onClickListener = i -> {
                        try {
                            m.invoke((Object)activity, i);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeException("Couldn't call the MenuItem's listener", e);
                        }
                    };
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("OnClick method " + onClickMethod + "(MenuItem) not found in your activity", e);
                }
            }
            MenuItem.DisplayBehavior displayBehavior = displayBehaviorInt == 0 ? MenuItem.DisplayBehavior.ALWAYS : MenuItem.DisplayBehavior.NEVER;
            parser.next();
            parser.require(3, null, "MenuItem");
            MenuItem.Builder builder = MenuItem.builder(c).setId(id2).setTitle(title).setIcon(icon).setOnClickListener(onClickListener).setUxRestrictions(uxRestrictions).setTinted(tinted).setVisible(visible).setShowIconAndTitle(showIconAndTitle).setDisplayBehavior(displayBehavior);
            if (isSearch) {
                builder.setToSearch();
            }
            if (isSettings) {
                builder.setToSettings();
            }
            if (checkable || checkedExists) {
                builder.setChecked(checked);
            }
            if (activatable || activatedExists) {
                builder.setActivated(activated);
            }
            MenuItem menuItem = builder.build();
            return menuItem;
        }
        finally {
            a.recycle();
        }
    }
}

