/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.toolbar;

import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.Nullable;
import com.android.car.ui.imewidescreen.CarUiImeSearchListItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SearchConfig {
    @Nullable
    private final View mSearchResultsView;
    @Nullable
    private final Drawable mSearchResultsInputViewIcon;
    @Nullable
    private final List<? extends CarUiImeSearchListItem> mSearchResultItems;
    @Nullable
    private OnBackClickedListener mOnBackClickedListener;

    @Nullable
    public View getSearchResultsView() {
        return this.mSearchResultsView;
    }

    @Nullable
    public Drawable getSearchResultsInputViewIcon() {
        return this.mSearchResultsInputViewIcon;
    }

    @Nullable
    public List<? extends CarUiImeSearchListItem> getSearchResultItems() {
        return this.mSearchResultItems;
    }

    @Nullable
    public OnBackClickedListener getOnBackClickedListener() {
        return this.mOnBackClickedListener;
    }

    private SearchConfig(SearchConfigBuilder builder) {
        this.mSearchResultItems = builder.mSearchResultItems;
        this.mSearchResultsInputViewIcon = builder.mSearchResultsInputViewIcon;
        this.mSearchResultsView = builder.mSearchResultsView;
        this.mOnBackClickedListener = builder.mOnBackClickedListener;
    }

    public static SearchConfigBuilder builder() {
        return new SearchConfigBuilder();
    }

    public static final class SearchConfigBuilder {
        @Nullable
        private View mSearchResultsView;
        @Nullable
        private Drawable mSearchResultsInputViewIcon;
        @Nullable
        private List<? extends CarUiImeSearchListItem> mSearchResultItems;
        @Nullable
        private OnBackClickedListener mOnBackClickedListener;

        private SearchConfigBuilder() {
        }

        public SearchConfigBuilder setSearchResultsInputViewIcon(@Nullable Drawable drawable2) {
            this.mSearchResultsInputViewIcon = drawable2;
            return this;
        }

        public SearchConfigBuilder setOnBackClickedListener(OnBackClickedListener listener) {
            this.mOnBackClickedListener = listener;
            return this;
        }

        public SearchConfigBuilder setSearchResultItems(@Nullable List<? extends CarUiImeSearchListItem> searchItems) {
            this.mSearchResultItems = searchItems == null || searchItems.size() == 0 ? null : Collections.unmodifiableList(new ArrayList<CarUiImeSearchListItem>(searchItems));
            return this;
        }

        public SearchConfigBuilder setSearchResultsView(@Nullable View view) {
            this.mSearchResultsView = view;
            return this;
        }

        public SearchConfig build() {
            if (this.mSearchResultsView != null && this.mSearchResultItems != null) {
                throw new RuntimeException("Both searchResultItems and searchResultsView can't be set at the same time");
            }
            return new SearchConfig(this);
        }
    }

    public static interface OnBackClickedListener {
        public void onClick();
    }
}

