/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.toolbar;

import android.annotation.TargetApi;
import android.car.drivingstate.CarUxRestrictions;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.android.car.ui.R;
import com.android.car.ui.toolbar.CarUiEditText;
import com.android.car.ui.toolbar.SearchConfig;
import com.android.car.ui.toolbar.SearchWidescreenController;
import com.android.car.ui.toolbar.Toolbar;
import com.android.car.ui.utils.CarUiUtils;
import com.android.car.ui.utils.CarUxRestrictionsUtil;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

@TargetApi(value=30)
public class SearchView
extends ConstraintLayout {
    private final InputMethodManager mInputMethodManager;
    private final SearchWidescreenController mSearchWidescreenController;
    private final ImageView mIcon;
    private final EditText mSearchText;
    private CharSequence mSearchHint;
    private boolean mIsRestricted;
    private final View mCloseIcon;
    private final int mStartPaddingWithoutIcon;
    private final int mStartPadding;
    private final int mEndPadding;
    @NonNull
    private final CarUxRestrictionsUtil.OnUxRestrictionsChangedListener mListener = new UxRestrictionChangedListener();
    private Set<Consumer<String>> mSearchListeners = Collections.emptySet();
    private Set<Runnable> mSearchCompletedListeners = Collections.emptySet();
    private Set<Toolbar.OnSearchListener> mDeprecatedSearchListeners = Collections.emptySet();
    private Set<Toolbar.OnSearchCompletedListener> mDeprecatedSearchCompletedListeners = Collections.emptySet();
    private final TextWatcher mTextWatcher = new TextWatcher(){

        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        }

        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        }

        public void afterTextChanged(Editable editable) {
            SearchView.this.onSearch(editable.toString());
        }
    };
    private boolean mIsPlainText = false;
    private boolean mWasShown = false;

    public SearchView(Context context) {
        this(context, null);
    }

    public SearchView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SearchView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mInputMethodManager = (InputMethodManager)this.getContext().getSystemService(InputMethodManager.class);
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        inflater.inflate(R.layout.car_ui_toolbar_search_view, (ViewGroup)this, true);
        this.mSearchText = (EditText)CarUiUtils.requireViewByRefId((View)this, R.id.car_ui_toolbar_search_bar);
        this.mIcon = (ImageView)CarUiUtils.requireViewByRefId((View)this, R.id.car_ui_toolbar_search_icon);
        this.mCloseIcon = CarUiUtils.requireViewByRefId((View)this, R.id.car_ui_toolbar_search_close);
        this.mCloseIcon.setOnClickListener(view -> {
            if (view.isFocused()) {
                this.mSearchText.requestFocus();
                this.mInputMethodManager.showSoftInput((View)this.mSearchText, 0);
            }
            this.mSearchText.getText().clear();
        });
        this.mCloseIcon.setVisibility(8);
        this.mStartPaddingWithoutIcon = this.mSearchText.getPaddingStart();
        this.mStartPadding = context.getResources().getDimensionPixelSize(R.dimen.car_ui_toolbar_search_search_icon_container_width);
        this.mEndPadding = context.getResources().getDimensionPixelSize(R.dimen.car_ui_toolbar_search_close_icon_container_width);
        this.mSearchText.setSaveEnabled(false);
        this.mSearchText.setPaddingRelative(this.mStartPadding, 0, this.mEndPadding, 0);
        this.mSearchText.setOnClickListener(view -> this.mInputMethodManager.showSoftInput(view, 0));
        this.mSearchText.setOnFocusChangeListener((view, hasFocus) -> {
            if (!hasFocus) {
                this.mInputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
            }
        });
        this.mSearchText.addTextChangedListener(this.mTextWatcher);
        this.mSearchText.setOnEditorActionListener((v, actionId, event) -> {
            if (actionId == 6 || actionId == 3) {
                this.notifyQuerySubmit();
            } else if (this.isEnter(event)) {
                if (event.getAction() == 1) {
                    this.notifyQuerySubmit();
                }
                return true;
            }
            return false;
        });
        this.mSearchWidescreenController = new SearchWidescreenController(context);
        this.setSearchTextViewConsumer(this.mSearchWidescreenController::setTextView);
        this.setOnPrivateImeCommandListener(this.mSearchWidescreenController.getOnPrivateImeCommandListener());
    }

    public void setOnPrivateImeCommandListener(@Nullable BiConsumer<String, Bundle> biConsumer) {
        if (this.mSearchText instanceof CarUiEditText) {
            ((CarUiEditText)this.mSearchText).setOnPrivateImeCommandListener(biConsumer);
        }
    }

    public void setSearchTextViewConsumer(@Nullable Consumer<TextView> consumer) {
        if (consumer != null) {
            consumer.accept((TextView)this.mSearchText);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        CarUxRestrictionsUtil.getInstance(this.getContext()).register(this.mListener);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        CarUxRestrictionsUtil.getInstance(this.getContext()).unregister(this.mListener);
    }

    private boolean isEnter(KeyEvent event) {
        boolean result = false;
        if (event != null) {
            int keyCode = event.getKeyCode();
            result = keyCode == 66 || keyCode == 160 || keyCode == 84;
        }
        return result;
    }

    private void notifyQuerySubmit() {
        this.mSearchText.clearFocus();
        for (Runnable runnable : this.mSearchCompletedListeners) {
            runnable.run();
        }
        for (Toolbar.OnSearchCompletedListener onSearchCompletedListener : this.mDeprecatedSearchCompletedListeners) {
            onSearchCompletedListener.onSearchCompleted();
        }
    }

    public void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        boolean isShown = this.isShown();
        if (isShown && !this.mWasShown) {
            boolean hasQuery = this.mSearchText.getText().length() > 0;
            this.mCloseIcon.setVisibility(hasQuery ? 0 : 8);
            this.mSearchText.requestFocus();
            this.mInputMethodManager.showSoftInput((View)this.mSearchText, 0);
        } else if (!isShown && this.mWasShown) {
            this.mInputMethodManager.hideSoftInputFromWindow(this.mSearchText.getWindowToken(), 0);
        }
        this.mWasShown = isShown;
    }

    public void setSearchConfig(SearchConfig config) {
        this.mSearchWidescreenController.setSearchConfig(config);
    }

    public void setSearchListeners(Set<Toolbar.OnSearchListener> deprecatedListeners, Set<Consumer<String>> listeners) {
        this.mSearchListeners = listeners;
        this.mDeprecatedSearchListeners = deprecatedListeners;
    }

    public void setSearchCompletedListeners(Set<Toolbar.OnSearchCompletedListener> deprecatedListeners, Set<Runnable> listeners) {
        this.mSearchCompletedListeners = listeners;
        this.mDeprecatedSearchCompletedListeners = deprecatedListeners;
    }

    public void setHint(CharSequence hint) {
        this.mSearchHint = hint;
        if (this.mIsRestricted) {
            return;
        }
        this.mSearchText.setHint(hint);
    }

    public void setIcon(Drawable d) {
        if (d == null) {
            this.mIcon.setImageResource(R.drawable.car_ui_icon_search);
        } else {
            this.mIcon.setImageDrawable(d);
        }
    }

    public void setPlainText(boolean plainText) {
        if (plainText != this.mIsPlainText) {
            if (plainText) {
                this.mSearchText.setPaddingRelative(this.mStartPaddingWithoutIcon, 0, this.mEndPadding, 0);
                this.mSearchText.setImeOptions(6);
                this.mIcon.setVisibility(8);
            } else {
                this.mSearchText.setPaddingRelative(this.mStartPadding, 0, this.mEndPadding, 0);
                this.mSearchText.setImeOptions(3);
                this.mIcon.setVisibility(0);
            }
            this.mIsPlainText = plainText;
            this.mInputMethodManager.restartInput((View)this.mSearchText);
        }
    }

    private void onSearch(String query) {
        this.mCloseIcon.setVisibility(TextUtils.isEmpty((CharSequence)query) ? 8 : 0);
        for (Consumer<String> consumer : this.mSearchListeners) {
            consumer.accept(query);
        }
        for (Toolbar.OnSearchListener onSearchListener : this.mDeprecatedSearchListeners) {
            onSearchListener.onSearch(query);
        }
    }

    private void enableRestriction() {
        this.mIsRestricted = true;
        if (this.mSearchText == null) {
            return;
        }
        this.mSearchText.setHint((CharSequence)this.mSearchText.getContext().getString(R.string.car_ui_restricted_while_driving));
        this.mSearchText.setEnabled(false);
    }

    private void disableRestriction() {
        this.mIsRestricted = false;
        if (this.mSearchText == null) {
            return;
        }
        this.mSearchText.setHint(this.mSearchHint);
        this.mSearchText.setEnabled(true);
    }

    public void setSearchQuery(String query) {
        this.mSearchText.setText((CharSequence)query);
        this.mSearchText.setSelection(this.mSearchText.getText().length());
    }

    private class UxRestrictionChangedListener
    implements CarUxRestrictionsUtil.OnUxRestrictionsChangedListener {
        private UxRestrictionChangedListener() {
        }

        @Override
        public void onRestrictionsChanged(@NonNull CarUxRestrictions carUxRestrictions) {
            boolean isKeyboardRestricted;
            boolean bl = isKeyboardRestricted = (carUxRestrictions.getActiveRestrictions() & 8) != 0;
            if (isKeyboardRestricted) {
                SearchView.this.enableRestriction();
            } else if (!isKeyboardRestricted) {
                SearchView.this.disableRestriction();
            }
        }
    }
}

