/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.toolbar;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.hardware.display.DisplayManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcelable;
import android.provider.Settings;
import android.util.Log;
import android.view.Display;
import android.view.SurfaceControlViewHost;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.android.car.ui.CarUiText;
import com.android.car.ui.R;
import com.android.car.ui.core.SearchResultsProvider;
import com.android.car.ui.imewidescreen.CarUiImeSearchListItem;
import com.android.car.ui.recyclerview.CarUiContentListItem;
import com.android.car.ui.recyclerview.CarUiRecyclerView;
import com.android.car.ui.toolbar.SearchCapabilities;
import com.android.car.ui.toolbar.SearchConfig;
import com.android.car.ui.utils.CarUiUtils;
import java.util.List;
import java.util.function.BiConsumer;

@RequiresApi(value=30)
public class SearchWidescreenController {
    private static final String TAG = "SearchWidescreenController";
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final Context mContext;
    private final InputMethodManager mInputMethodManager;
    @Nullable
    private TextView mTextView;
    private SurfaceControlViewHost mSurfaceControlViewHost;
    private int mSurfaceHeight;
    private int mSurfaceWidth;
    private boolean mIsImeWidescreenViewSet = false;
    private ViewGroup mOriginalParent;
    private ViewGroup.LayoutParams mLayoutParams;
    @NonNull
    private SearchConfig mSearchConfig = SearchConfig.builder().build();

    public SearchWidescreenController(@NonNull Context context) {
        this.mContext = context;
        this.mInputMethodManager = (InputMethodManager)context.getSystemService(InputMethodManager.class);
    }

    public void setTextView(@Nullable TextView textView) {
        if (this.mTextView != null) {
            throw new IllegalStateException("TextView already set");
        }
        this.mTextView = textView;
        this.initializeWindowInsetsListener();
    }

    public void setSearchConfig(@Nullable SearchConfig searchConfig) {
        if (searchConfig == null) {
            searchConfig = SearchConfig.builder().build();
        }
        this.mSearchConfig = searchConfig;
    }

    @Nullable
    private View getSearchResultsView() {
        View view = this.mSearchConfig.getSearchResultsView();
        if (view instanceof CarUiRecyclerView) {
            return ((CarUiRecyclerView)view).getView();
        }
        return view;
    }

    private void initializeWindowInsetsListener() {
        final View.OnApplyWindowInsetsListener onApplyWindowInsetsListener = (v, insets) -> {
            if (Build.VERSION.SDK_INT < 30) {
                throw new IllegalStateException("Cannot check if the ime is visible pre R");
            }
            if (this.mTextView == null) {
                return v.onApplyWindowInsets(insets);
            }
            if (insets.isVisible(WindowInsets.Type.ime())) {
                FrameLayout wideScreenImeContentAreaViewContainer;
                View contentView = this.getSearchResultsView();
                if (!this.mIsImeWidescreenViewSet && contentView != null) {
                    this.mLayoutParams = contentView.getLayoutParams();
                    this.mOriginalParent = (ViewGroup)contentView.getParent();
                    if (this.mOriginalParent != null) {
                        this.mOriginalParent.removeView(contentView);
                    }
                    FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
                    View originalView = this.mSearchConfig.getSearchResultsView();
                    if (originalView instanceof CarUiRecyclerView) {
                        params.topMargin = -originalView.getPaddingTop();
                        params.bottomMargin = -originalView.getPaddingBottom();
                        params.leftMargin = -originalView.getPaddingLeft();
                        params.rightMargin = -originalView.getPaddingRight();
                    }
                    wideScreenImeContentAreaViewContainer = new FrameLayout(this.mContext);
                    wideScreenImeContentAreaViewContainer.addView(contentView, (ViewGroup.LayoutParams)params);
                } else {
                    wideScreenImeContentAreaViewContainer = null;
                }
                this.displaySearchWideScreen();
                this.mHandler.post(() -> {
                    if (this.mSurfaceControlViewHost != null && wideScreenImeContentAreaViewContainer != null && this.mSurfaceControlViewHost.getView() == null) {
                        this.mIsImeWidescreenViewSet = true;
                        this.mSurfaceControlViewHost.setView((View)wideScreenImeContentAreaViewContainer, this.mSurfaceWidth, this.mSurfaceHeight);
                    }
                });
            } else {
                this.removeView();
                this.mIsImeWidescreenViewSet = false;
            }
            return v.onApplyWindowInsets(insets);
        };
        if (Build.VERSION.SDK_INT >= 30 && this.mTextView != null) {
            if (this.mTextView.isAttachedToWindow()) {
                this.mTextView.getRootView().setOnApplyWindowInsetsListener(onApplyWindowInsetsListener);
            } else {
                this.mTextView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                    public void onViewAttachedToWindow(View v) {
                        SearchWidescreenController.this.mTextView.getRootView().setOnApplyWindowInsetsListener(onApplyWindowInsetsListener);
                        SearchWidescreenController.this.mTextView.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                    }

                    public void onViewDetachedFromWindow(View v) {
                    }
                });
            }
        }
    }

    private void displaySearchWideScreen() {
        Uri contentUri = SearchResultsProvider.getSearchResultsTableUri(this.mContext);
        this.mContext.getContentResolver().delete(contentUri, null, null);
        if (this.getSearchResultsView() != null && this.getSearchCapabilities().canShowSearchResultsView()) {
            return;
        }
        List<? extends CarUiImeSearchListItem> searchItems = this.mSearchConfig.getSearchResultItems();
        if (searchItems == null) {
            this.mInputMethodManager.sendAppPrivateCommand((View)this.mTextView, "automotive_wide_screen", null);
            return;
        }
        for (int id2 = 0; id2 < searchItems.size(); ++id2) {
            CarUiImeSearchListItem item = searchItems.get(id2);
            ContentValues values = new ContentValues();
            values.put("primaryId", Integer.valueOf(id2));
            values.put("secondary", Integer.valueOf(id2));
            BitmapDrawable icon = (BitmapDrawable)item.getIcon();
            values.put("primary_image", icon != null ? CarUiUtils.getBytesFromBitmap(icon.getBitmap()) : null);
            BitmapDrawable supplementalIcon = (BitmapDrawable)item.getSupplementalIcon();
            values.put("secondary_image", supplementalIcon != null ? CarUiUtils.getBytesFromBitmap(supplementalIcon.getBitmap()) : null);
            values.put("title", item.getTitle() != null ? item.getTitle().getPreferredText().toString() : null);
            values.put("subtitle", item.getBody() != null ? CarUiText.combineMultiLine(item.getBody()).toString() : null);
            this.mContext.getContentResolver().insert(contentUri, values);
        }
        this.mInputMethodManager.sendAppPrivateCommand((View)this.mTextView, "wide_screen_search_results", new Bundle());
    }

    private void removeView() {
        View contentView = this.getSearchResultsView();
        if (this.mOriginalParent != null && contentView != null) {
            this.mHandler.post(() -> {
                ViewGroup parent = (ViewGroup)contentView.getParent();
                if (parent != null) {
                    parent.removeView(contentView);
                }
                this.mOriginalParent.addView(contentView, this.mLayoutParams);
                this.mOriginalParent.requestLayout();
                this.mOriginalParent = null;
                this.mLayoutParams = null;
            });
        }
    }

    private void onItemClicked(String itemId) {
        CarUiContentListItem.OnClickListener listener;
        CarUiImeSearchListItem item;
        List<? extends CarUiImeSearchListItem> items = this.mSearchConfig.getSearchResultItems();
        CarUiImeSearchListItem carUiImeSearchListItem = item = items == null ? null : items.get(Integer.parseInt(itemId));
        if (item != null && (listener = item.getOnClickListener()) != null) {
            listener.onClick(item);
        }
    }

    private void onSecondaryImageClicked(String secondaryImageId) {
        CarUiContentListItem.OnClickListener listener;
        CarUiImeSearchListItem item;
        List<? extends CarUiImeSearchListItem> items = this.mSearchConfig.getSearchResultItems();
        CarUiImeSearchListItem carUiImeSearchListItem = item = items == null ? null : items.get(Integer.parseInt(secondaryImageId));
        if (item != null && (listener = item.getSupplementalIconOnClickListener()) != null) {
            listener.onClick(item);
        }
    }

    @SuppressLint(value={"DiscouragedApi"})
    private int getIMEServiceRequiredDimen(@NonNull Context context) {
        Resources r = context.getResources();
        int id2 = R.dimen.car_ui_primary_icon_size;
        try {
            InputMethodManager imeManager = (InputMethodManager)context.getSystemService(InputMethodManager.class);
            String defaultIme = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"default_input_method");
            for (InputMethodInfo info : imeManager.getInputMethodList()) {
                if (!info.getId().equals(defaultIme)) continue;
                Context imeContext = context.createPackageContext(info.getPackageName(), 0);
                r = imeContext.getResources();
                id2 = r.getIdentifier("car_ui_primary_icon_size", "dimen", info.getPackageName());
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w((String)"car-ui-lib", (String)"Unable to read `R.dimen.car_ui_primary_icon_size` from the IME service. Please make sure the IME service is exported via `android.view.InputMethod` intent-filter.", (Throwable)e);
        }
        return r.getDimensionPixelSize(id2);
    }

    private void onSurfaceInfo(int displayId, IBinder binder, int width, int height) {
        if (Build.VERSION.SDK_INT < 30) {
            throw new IllegalStateException("Views in the widescreen ime aren't supported pre R");
        }
        DisplayManager dm = (DisplayManager)this.mContext.getSystemService(DisplayManager.class);
        Display display = dm.getDisplay(displayId);
        this.mSurfaceControlViewHost = new SurfaceControlViewHost(this.mContext, display, binder);
        this.mSurfaceHeight = height;
        this.mSurfaceWidth = width;
        Bundle bundle = new Bundle();
        if (this.mSearchConfig.getSearchResultsInputViewIcon() != null) {
            Bitmap bitmap = CarUiUtils.drawableToBitmap(this.mSearchConfig.getSearchResultsInputViewIcon());
            int dimen2 = this.getIMEServiceRequiredDimen(this.mContext);
            Bitmap scaledBitmap = CarUiUtils.scaleBitmapAndKeepRatio(bitmap, dimen2, dimen2);
            byte[] byteArray = CarUiUtils.getBytesFromBitmap(scaledBitmap);
            bundle.putByteArray("extracted_text_icon", byteArray);
        }
        bundle.putParcelable("content_area_surface_package", (Parcelable)this.mSurfaceControlViewHost.getSurfacePackage());
        this.mInputMethodManager.sendAppPrivateCommand((View)this.mTextView, "automotive_wide_screen", bundle);
    }

    private void reLayout(int width, int height) {
        if (Build.VERSION.SDK_INT < 30) {
            throw new IllegalStateException("Views in the widescreen ime aren't supported pre R");
        }
        this.mSurfaceHeight = height;
        this.mSurfaceWidth = width;
        if (this.mSurfaceControlViewHost != null) {
            this.mSurfaceControlViewHost.relayout(width, height);
        }
    }

    private void onPostLoadSearchResults() {
        Uri contentUri = SearchResultsProvider.getSearchResultsTableUri(this.mContext);
        this.mContext.getContentResolver().delete(contentUri, null, null);
    }

    public BiConsumer<String, Bundle> getOnPrivateImeCommandListener() {
        return (action, data) -> {
            SearchConfig.OnBackClickedListener listener;
            if ("automotive_wide_screen_clear_data".equals(action) && this.mTextView != null) {
                this.mTextView.setText((CharSequence)"");
            }
            if ("automotive_wide_screen_post_load_search_results".equals(action)) {
                this.onPostLoadSearchResults();
            }
            if ("automotive_wide_screen_back_clicked".equals(action) && (listener = this.mSearchConfig.getOnBackClickedListener()) != null) {
                listener.onClick();
            }
            if (data == null) {
                return;
            }
            if (data.getString("search_result_item_id_list") != null) {
                this.onItemClicked(data.getString("search_result_item_id_list"));
            }
            if (data.getString("search_result_supplemental_icon_id_list") != null) {
                this.onSecondaryImageClicked(data.getString("search_result_supplemental_icon_id_list"));
            }
            int displayId = data.getInt("content_area_surface_display_id");
            int height = data.getInt("content_area_surface_height");
            int width = data.getInt("content_area_surface_width");
            IBinder binder = data.getBinder("content_area_surface_host_token");
            if (binder != null) {
                this.onSurfaceInfo(displayId, binder, width, height);
                return;
            }
            if (height != 0 || width != 0) {
                this.reLayout(width, height);
            }
        };
    }

    public SearchCapabilities getSearchCapabilities() {
        return SearchWidescreenController.getSearchCapabilities(this.mContext);
    }

    public static SearchCapabilities getSearchCapabilities(Context context) {
        boolean isWideScreenMode = CarUiUtils.getBooleanSystemProperty(context.getResources(), R.string.car_ui_ime_wide_screen_system_property_name, false) && Build.VERSION.SDK_INT >= 30;
        boolean allowAllAppsToShowSearchResultsView = context.getResources().getBoolean(R.bool.car_ui_ime_wide_screen_allow_app_hide_content_area);
        String[] allowedPackageNames = context.getResources().getStringArray(R.array.car_ui_ime_wide_screen_allowed_package_list);
        boolean packageNameAllowed = false;
        for (String name : allowedPackageNames) {
            if (!name.equals(context.getPackageName())) continue;
            packageNameAllowed = true;
            break;
        }
        boolean canShowSearchResultsView = isWideScreenMode && (packageNameAllowed || allowAllAppsToShowSearchResultsView);
        return SearchCapabilities.builder().setCanShowSearchResultsView(canShowSearchResultsView).setCanShowSearchResultItems(isWideScreenMode).build();
    }
}

