/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.toolbar;

import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.function.Consumer;

public final class Tab {
    @Nullable
    private final String mText;
    @Nullable
    private final Drawable mIcon;
    @Nullable
    private final Consumer<Tab> mSelectedListener;
    private final boolean mTinted;

    private Tab(@NonNull Builder builder) {
        this.mText = builder.mText;
        this.mIcon = builder.mIcon;
        this.mSelectedListener = builder.mSelectedListener;
        this.mTinted = builder.mTinted;
    }

    @Nullable
    public String getText() {
        return this.mText;
    }

    @Nullable
    public Drawable getIcon() {
        return this.mIcon;
    }

    @Nullable
    public Consumer<Tab> getSelectedListener() {
        return this.mSelectedListener;
    }

    public boolean isTinted() {
        return this.mTinted;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder copy() {
        return new Builder(this);
    }

    public static class Builder {
        @Nullable
        private String mText = null;
        @Nullable
        private Drawable mIcon = null;
        @Nullable
        private Consumer<Tab> mSelectedListener = null;
        private boolean mTinted = true;

        private Builder() {
        }

        private Builder(Tab tab) {
            this.mText = tab.mText;
            this.mIcon = tab.mIcon;
            this.mSelectedListener = tab.mSelectedListener;
            this.mTinted = tab.mTinted;
        }

        public Builder setText(String text) {
            this.mText = text;
            return this;
        }

        public Builder setIcon(Drawable icon) {
            this.mIcon = icon;
            return this;
        }

        public Builder setSelectedListener(Consumer<Tab> callback) {
            this.mSelectedListener = callback;
            return this;
        }

        public Builder setTinted(boolean tinted) {
            this.mTinted = tinted;
            return this;
        }

        public Tab build() {
            return new Tab(this);
        }
    }
}

