/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.toolbar;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.car.ui.R;
import com.android.car.ui.utils.CarUiUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class TabLayout
extends LinearLayout {
    @LayoutRes
    private final int mTabLayoutRes;
    @NonNull
    private List<com.android.car.ui.toolbar.Tab> mTabs = Collections.emptyList();
    private int mSelectedTab = -1;

    public TabLayout(@NonNull Context context) {
        this(context, null);
    }

    public TabLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TabLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        Resources resources = context.getResources();
        boolean tabFlexibleLayout = resources.getBoolean(R.bool.car_ui_toolbar_tab_flexible_layout);
        this.mTabLayoutRes = tabFlexibleLayout ? R.layout.car_ui_toolbar_tab_item_layout_flexible : R.layout.car_ui_toolbar_tab_item_layout;
    }

    public void setTabs(List<com.android.car.ui.toolbar.Tab> tabs, int selectedTab) {
        this.mTabs = tabs == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<com.android.car.ui.toolbar.Tab>(tabs));
        this.mSelectedTab = selectedTab;
        this.recreateViews();
    }

    public List<com.android.car.ui.toolbar.Tab> getTabs() {
        return this.mTabs;
    }

    public int getSelectedTab() {
        if (this.mTabs.isEmpty() && this.mSelectedTab != -1) {
            throw new IllegalStateException("mSelectedTab should've been -1");
        }
        return this.mSelectedTab;
    }

    public boolean hasTabs() {
        return !this.mTabs.isEmpty();
    }

    public void selectTab(int position) {
        if (position < 0 || position >= this.mTabs.size()) {
            throw new IllegalArgumentException("Tab position is invalid: " + position);
        }
        if (position == this.mSelectedTab) {
            return;
        }
        int oldPosition = this.mSelectedTab;
        this.mSelectedTab = position;
        this.presentTabView(oldPosition);
        this.presentTabView(position);
        com.android.car.ui.toolbar.Tab tab = this.mTabs.get(position);
        Consumer<com.android.car.ui.toolbar.Tab> listener = tab.getSelectedListener();
        if (listener != null) {
            listener.accept(tab);
        }
    }

    private void recreateViews() {
        this.removeAllViews();
        for (int i = 0; i < this.mTabs.size(); ++i) {
            View tabView = LayoutInflater.from((Context)this.getContext()).inflate(this.mTabLayoutRes, (ViewGroup)this, false);
            this.addView(tabView);
            this.presentTabView(i);
        }
    }

    private void presentTabView(int position) {
        if (position < 0 || position >= this.mTabs.size()) {
            throw new IllegalArgumentException("Tab position is invalid: " + position);
        }
        View tabView = this.getChildAt(position);
        com.android.car.ui.toolbar.Tab tab = this.mTabs.get(position);
        ImageView iconView = (ImageView)CarUiUtils.requireViewByRefId(tabView, R.id.car_ui_toolbar_tab_item_icon);
        TextView textView = (TextView)CarUiUtils.requireViewByRefId(tabView, R.id.car_ui_toolbar_tab_item_text);
        tabView.setOnClickListener(view -> this.selectTab(position));
        tabView.setActivated(position == this.mSelectedTab);
        if (tab.isTinted()) {
            iconView.setImageTintList(this.getContext().getColorStateList(R.color.car_ui_toolbar_tab_item_selector));
        } else {
            iconView.setImageTintList(null);
        }
        iconView.setImageDrawable(tab.getIcon());
        textView.setText((CharSequence)tab.getText());
        textView.setTextAppearance(position == this.mSelectedTab ? R.style.TextAppearance_CarUi_Widget_Toolbar_Tab_Selected : R.style.TextAppearance_CarUi_Widget_Toolbar_Tab);
    }

    @Deprecated
    public static class Tab {
        private final Drawable mIcon;
        private final CharSequence mText;

        public Tab(@Nullable Drawable icon, @Nullable CharSequence text) {
            this.mIcon = icon;
            this.mText = text;
        }

        protected void bindText(TextView textView) {
            textView.setText(this.mText);
        }

        protected void bindIcon(ImageView imageView) {
            imageView.setImageDrawable(this.mIcon);
        }
    }
}

