/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.toolbar;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.android.car.ui.CarUiText;
import com.android.car.ui.imewidescreen.CarUiImeSearchListItem;
import com.android.car.ui.plugin.oemapis.BiConsumer;
import com.android.car.ui.plugin.oemapis.Consumer;
import com.android.car.ui.plugin.oemapis.toolbar.ImeSearchInterfaceOEMV2;
import com.android.car.ui.plugin.oemapis.toolbar.MenuItemOEMV1;
import com.android.car.ui.plugin.oemapis.toolbar.ToolbarControllerOEMV2;
import com.android.car.ui.toolbar.DeprecatedTabWrapper;
import com.android.car.ui.toolbar.MenuItem;
import com.android.car.ui.toolbar.MenuItemAdapterV1;
import com.android.car.ui.toolbar.MenuItemXmlParserUtil;
import com.android.car.ui.toolbar.NavButtonMode;
import com.android.car.ui.toolbar.ProgressBarController;
import com.android.car.ui.toolbar.ProgressBarControllerAdapterV1;
import com.android.car.ui.toolbar.SearchCapabilities;
import com.android.car.ui.toolbar.SearchConfig;
import com.android.car.ui.toolbar.SearchMode;
import com.android.car.ui.toolbar.SearchWidescreenController;
import com.android.car.ui.toolbar.Tab;
import com.android.car.ui.toolbar.TabAdapterV1;
import com.android.car.ui.toolbar.TabLayout;
import com.android.car.ui.toolbar.Toolbar;
import com.android.car.ui.toolbar.ToolbarController;
import com.android.car.ui.utils.CarUiUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@TargetApi(value=30)
public final class ToolbarControllerAdapterV2
implements ToolbarController {
    private final ToolbarControllerOEMV2 mOemToolbar;
    private final Context mContext;
    private ToolbarAdapterState mAdapterState = new ToolbarAdapterState();
    private final Set<Toolbar.OnTabSelectedListener> mOnTabSelectedListeners = new HashSet<Toolbar.OnTabSelectedListener>();
    private final Set<Toolbar.OnBackListener> mDeprecatedBackListeners = new HashSet<Toolbar.OnBackListener>();
    private final Set<Supplier<Boolean>> mBackListeners = new HashSet<Supplier<Boolean>>();
    private final Set<Toolbar.OnSearchListener> mDeprecatedSearchListeners = new HashSet<Toolbar.OnSearchListener>();
    private final Set<Toolbar.OnSearchCompletedListener> mDeprecatedSearchCompletedListeners = new HashSet<Toolbar.OnSearchCompletedListener>();
    private final Set<java.util.function.Consumer<String>> mSearchListeners = new HashSet<java.util.function.Consumer<String>>();
    private final Set<Runnable> mSearchCompletedListeners = new HashSet<Runnable>();
    private final ProgressBarControllerAdapterV1 mProgressBar;
    private String mSearchHint;
    private final SearchConfig.SearchConfigBuilder mSearchConfigBuilder;
    private List<MenuItem> mClientMenuItems = Collections.emptyList();
    private final List<DeprecatedTabWrapper> mDeprecatedTabs = new ArrayList<DeprecatedTabWrapper>();
    private final SearchWidescreenController mSearchWidescreenController;
    private final boolean mSupportsImeSearch;
    private boolean mBackgroundShown = true;

    public ToolbarControllerAdapterV2(@NonNull Context context, @NonNull ToolbarControllerOEMV2 oemToolbar) {
        this.mOemToolbar = oemToolbar;
        this.mProgressBar = new ProgressBarControllerAdapterV1(this.mOemToolbar.getProgressBar());
        this.mContext = context;
        this.mSearchConfigBuilder = SearchConfig.builder();
        Activity activity = CarUiUtils.getActivity(this.mContext);
        this.mSearchWidescreenController = new SearchWidescreenController(context);
        ImeSearchInterfaceOEMV2 imeSearchInterface = this.mOemToolbar.getImeSearchInterface();
        boolean bl = this.mSupportsImeSearch = imeSearchInterface != null;
        if (imeSearchInterface != null) {
            imeSearchInterface.setOnPrivateImeCommandListener((BiConsumer)new BiConsumer<String, Bundle>(){

                public void accept(String action, Bundle data) {
                    ToolbarControllerAdapterV2.this.mSearchWidescreenController.getOnPrivateImeCommandListener().accept(action, data);
                }
            });
            imeSearchInterface.setSearchTextViewConsumer((Consumer)new Consumer<TextView>(){

                public void accept(TextView textView) {
                    ToolbarControllerAdapterV2.this.mSearchWidescreenController.setTextView(textView);
                }
            });
        }
        oemToolbar.setBackListener(() -> {
            boolean handled = false;
            for (Toolbar.OnBackListener onBackListener : this.mDeprecatedBackListeners) {
                handled |= onBackListener.onBack();
            }
            for (Supplier supplier : this.mBackListeners) {
                handled |= ((Boolean)supplier.get()).booleanValue();
            }
            if (!handled && activity != null) {
                activity.onBackPressed();
            }
        });
        oemToolbar.setSearchListener((Consumer)new Consumer<String>(){

            public void accept(String query) {
                for (Object listener : ToolbarControllerAdapterV2.this.mDeprecatedSearchListeners) {
                    listener.onSearch(query);
                }
                for (Object listener : ToolbarControllerAdapterV2.this.mSearchListeners) {
                    listener.accept(query);
                }
            }
        });
        oemToolbar.setSearchCompletedListener(() -> {
            for (Toolbar.OnSearchCompletedListener onSearchCompletedListener : this.mDeprecatedSearchCompletedListeners) {
                onSearchCompletedListener.onSearchCompleted();
            }
            for (Runnable runnable : this.mSearchCompletedListeners) {
                runnable.run();
            }
        });
    }

    @Override
    public void setTitle(int title) {
        this.setTitle(title == 0 ? null : this.mContext.getString(title));
    }

    @Override
    public void setTitle(CharSequence title) {
        this.update(this.mAdapterState.copy().setTitle(CarUiUtils.charSequenceToString(title)).build());
    }

    @Override
    public void setTitle(CarUiText title) {
        this.update(this.mAdapterState.copy().setTitle(CarUiUtils.charSequenceToString(title.toString())).build());
    }

    @Override
    public CharSequence getTitle() {
        return this.mAdapterState.getTitle();
    }

    @Override
    public void setSubtitle(int title) {
        this.setSubtitle(title == 0 ? null : this.mContext.getString(title));
    }

    @Override
    public void setSubtitle(CharSequence subtitle) {
        this.update(this.mAdapterState.copy().setSubtitle(CarUiUtils.charSequenceToString(subtitle)).build());
    }

    @Override
    public void setSubtitle(CarUiText subtitle) {
        this.update(this.mAdapterState.copy().setSubtitle(CarUiUtils.charSequenceToString(subtitle.getPreferredText())).build());
    }

    @Override
    public CharSequence getSubtitle() {
        return this.mAdapterState.getSubtitle();
    }

    @Override
    public void setTabs(@Nullable List<Tab> tabs) {
        this.setTabs(tabs, 0);
    }

    @Override
    public void setTabs(@Nullable List<Tab> tabs, int selectedTab) {
        this.mDeprecatedTabs.clear();
        if (tabs == null || tabs.isEmpty()) {
            selectedTab = -1;
        } else if (selectedTab < 0 || selectedTab >= tabs.size()) {
            throw new IllegalArgumentException("Tab position is invalid: " + selectedTab);
        }
        List<Tab> newTabs = CarUiUtils.convertList(tabs, tab -> {
            java.util.function.Consumer<Tab> originalListener = tab.getSelectedListener();
            return tab.copy().setSelectedListener(tab1 -> {
                int position = tabs.indexOf(tab);
                this.mAdapterState = this.mAdapterState.copy().setSelectedTab(position).build();
                if (originalListener != null) {
                    originalListener.accept((Tab)tab);
                }
            }).build();
        });
        this.update(this.mAdapterState.copy().setTabs(CarUiUtils.convertList(newTabs, TabAdapterV1::new)).setSelectedTab(selectedTab).build());
    }

    @Override
    public List<Tab> getTabs() {
        return Collections.unmodifiableList(this.mAdapterState.getTabs().stream().map(TabAdapterV1::getClientTab).collect(Collectors.toList()));
    }

    @Override
    public int getTabCount() {
        return this.mDeprecatedTabs.size();
    }

    @Override
    public int getTabPosition(TabLayout.Tab tab) {
        for (int i = 0; i < this.mDeprecatedTabs.size(); ++i) {
            if (this.mDeprecatedTabs.get(i).getDeprecatedTab() != tab) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void addTab(TabLayout.Tab clientTab) {
        this.mDeprecatedTabs.add(new DeprecatedTabWrapper(this.mContext, clientTab, this::updateModernTabsFromDeprecatedOnes, tab -> {
            for (Toolbar.OnTabSelectedListener listener : this.mOnTabSelectedListeners) {
                listener.onTabSelected(clientTab);
            }
        }));
        this.updateModernTabsFromDeprecatedOnes();
    }

    private void updateModernTabsFromDeprecatedOnes() {
        ArrayList<Tab> modernTabs = new ArrayList<Tab>();
        for (DeprecatedTabWrapper tab2 : this.mDeprecatedTabs) {
            modernTabs.add(tab2.getModernTab());
        }
        List<Tab> newTabs = CarUiUtils.convertList(modernTabs, tab -> {
            java.util.function.Consumer<Tab> originalListener = tab.getSelectedListener();
            return tab.copy().setSelectedListener(tab1 -> {
                int position = modernTabs.indexOf(tab);
                this.mAdapterState = this.mAdapterState.copy().setSelectedTab(position).build();
                if (originalListener != null) {
                    originalListener.accept((Tab)tab);
                }
            }).build();
        });
        this.update(this.mAdapterState.copy().setTabs(CarUiUtils.convertList(newTabs, TabAdapterV1::new)).build());
    }

    @Override
    public void clearAllTabs() {
        this.setTabs(Collections.emptyList());
    }

    @Override
    public TabLayout.Tab getTab(int position) {
        return this.mDeprecatedTabs.get(position).getDeprecatedTab();
    }

    @Override
    public void selectTab(int position) {
        if (position < 0 || position >= this.mAdapterState.getTabs().size()) {
            throw new IllegalArgumentException("Tab position is invalid: " + position);
        }
        this.update(this.mAdapterState.copy().setSelectedTab(position).build());
    }

    @Override
    public int getSelectedTab() {
        int selectedTab = this.mAdapterState.getSelectedTab();
        if (this.mAdapterState.getTabs().isEmpty() && selectedTab != -1) {
            throw new IllegalStateException("mSelectedTab should've been -1");
        }
        return selectedTab;
    }

    @Override
    public void setShowTabsInSubpage(boolean showTabs) {
        this.update(this.mAdapterState.copy().setShowTabsInSubpage(showTabs).build());
    }

    @Override
    public boolean getShowTabsInSubpage() {
        return this.mAdapterState.getShowTabsInSubpage();
    }

    @Override
    public void setLogo(@IdRes int resId) {
        this.setLogo(this.getDrawable(resId));
    }

    @Override
    public void setLogo(Drawable drawable2) {
        this.update(this.mAdapterState.copy().setLogo(drawable2).build());
    }

    @Override
    public void setOnLogoClickListener(@Nullable Runnable listener) {
    }

    @Override
    public void setSearchHint(int resId) {
        this.setSearchHint(this.mContext.getString(resId));
    }

    @Override
    public void setSearchHint(CharSequence hint) {
        this.mSearchHint = CarUiUtils.charSequenceToString(hint);
        this.mOemToolbar.setSearchHint(this.mSearchHint);
    }

    @Override
    public CharSequence getSearchHint() {
        return this.mSearchHint;
    }

    @Override
    public void setSearchIcon(int resId) {
        this.setSearchIcon(this.getDrawable(resId));
    }

    @Override
    public void setSearchIcon(Drawable d) {
        this.mOemToolbar.setSearchIcon(d);
    }

    @Override
    public void setSearchMode(SearchMode mode) {
        this.update(this.mAdapterState.copy().setSearchMode(mode).build());
    }

    @Override
    public SearchMode getSearchMode() {
        return this.mAdapterState.getSearchMode();
    }

    @Override
    public void setNavButtonMode(Toolbar.NavButtonMode style2) {
        switch (style2) {
            case BACK: {
                this.setNavButtonMode(NavButtonMode.BACK);
                break;
            }
            case DOWN: {
                this.setNavButtonMode(NavButtonMode.DOWN);
                break;
            }
            case CLOSE: {
                this.setNavButtonMode(NavButtonMode.CLOSE);
                break;
            }
            default: {
                this.setNavButtonMode(NavButtonMode.DISABLED);
            }
        }
    }

    @Override
    public void setNavButtonMode(NavButtonMode mode) {
        this.update(this.mAdapterState.copy().setNavButtonMode(mode).build());
    }

    @Override
    public NavButtonMode getNavButtonMode() {
        return this.mAdapterState.getNavButtonMode();
    }

    @Override
    public void setBackgroundShown(boolean shown) {
        this.mBackgroundShown = shown;
        this.mOemToolbar.setBackgroundShown(shown);
    }

    @Override
    public boolean getBackgroundShown() {
        return this.mBackgroundShown;
    }

    @Override
    public void setMenuItems(@Nullable List<MenuItem> items) {
        if (items == null) {
            items = Collections.emptyList();
        }
        this.mClientMenuItems = items;
        this.update(this.mAdapterState.copy().setMenuItems(CarUiUtils.convertList(items, item -> new MenuItemAdapterV1(this, (MenuItem)item))).build());
    }

    @Override
    public List<MenuItem> setMenuItems(int resId) {
        List<MenuItem> menuItems = MenuItemXmlParserUtil.readMenuItemList(this.mContext, resId);
        this.setMenuItems(menuItems);
        return menuItems;
    }

    @Override
    @NonNull
    public List<MenuItem> getMenuItems() {
        return this.mClientMenuItems;
    }

    @Override
    @Nullable
    public MenuItem findMenuItemById(int id2) {
        for (MenuItem item : this.getMenuItems()) {
            if (item.getId() != id2) continue;
            return item;
        }
        return null;
    }

    @Override
    @NonNull
    public MenuItem requireMenuItemById(int id2) {
        MenuItem result = this.findMenuItemById(id2);
        if (result == null) {
            throw new IllegalArgumentException("ID does not reference a MenuItem on this Toolbar");
        }
        return result;
    }

    @Override
    public void setShowMenuItemsWhileSearching(boolean showMenuItems) {
        this.update(this.mAdapterState.copy().setShowMenuItemsWhileSearching(showMenuItems).build());
    }

    @Override
    public boolean getShowMenuItemsWhileSearching() {
        return this.mAdapterState.getShowMenuItemsWhileSearching();
    }

    @Override
    public void setSearchQuery(String query) {
        this.mOemToolbar.setSearchQuery(query);
    }

    @Override
    public void setState(Toolbar.State state) {
        this.update(this.mAdapterState.copy().setState(state).build());
    }

    private void update(ToolbarAdapterState newAdapterState) {
        boolean losingTabs;
        ToolbarAdapterState oldAdapterState = this.mAdapterState;
        this.mAdapterState = newAdapterState;
        if (!TextUtils.equals((CharSequence)newAdapterState.getShownTitle(), (CharSequence)oldAdapterState.getShownTitle())) {
            this.mOemToolbar.setTitle(newAdapterState.getTitle());
        }
        if (!TextUtils.equals((CharSequence)newAdapterState.getShownSubtitle(), (CharSequence)oldAdapterState.getShownSubtitle())) {
            this.mOemToolbar.setSubtitle(newAdapterState.getSubtitle());
        }
        if (newAdapterState.getShownLogo() != oldAdapterState.getShownLogo()) {
            this.mOemToolbar.setLogo(newAdapterState.getShownLogo());
        } else if (newAdapterState.getShownLogo() != null && newAdapterState.getLogoDirty()) {
            this.mOemToolbar.setLogo(newAdapterState.getShownLogo());
        }
        if (newAdapterState.getSearchMode() != oldAdapterState.getSearchMode()) {
            switch (newAdapterState.getSearchMode()) {
                case SEARCH: {
                    this.mOemToolbar.setSearchMode(1);
                    break;
                }
                case EDIT: {
                    this.mOemToolbar.setSearchMode(2);
                    break;
                }
                default: {
                    this.mOemToolbar.setSearchMode(0);
                }
            }
        }
        if (oldAdapterState.getNavButtonMode() != newAdapterState.getNavButtonMode()) {
            if (newAdapterState.getNavButtonMode() == NavButtonMode.DISABLED) {
                this.mOemToolbar.setNavButtonMode(0);
            } else if (newAdapterState.getNavButtonMode() == NavButtonMode.CLOSE) {
                this.mOemToolbar.setNavButtonMode(2);
            } else if (newAdapterState.getNavButtonMode() == NavButtonMode.DOWN) {
                this.mOemToolbar.setNavButtonMode(3);
            } else {
                this.mOemToolbar.setNavButtonMode(1);
            }
        }
        boolean gainingTabs = newAdapterState.hasTabs() && !oldAdapterState.hasTabs();
        boolean bl = losingTabs = !newAdapterState.hasTabs() && oldAdapterState.hasTabs();
        if (gainingTabs) {
            this.mOemToolbar.setTabs(newAdapterState.getTabs().stream().map(TabAdapterV1::getPluginTab).collect(Collectors.toList()), newAdapterState.getSelectedTab());
        } else if (losingTabs) {
            this.mOemToolbar.setTabs(Collections.emptyList(), -1);
        } else if (newAdapterState.hasTabs() && newAdapterState.getTabsDirty()) {
            this.mOemToolbar.setTabs(newAdapterState.getTabs().stream().map(TabAdapterV1::getPluginTab).collect(Collectors.toList()), newAdapterState.getSelectedTab());
        } else if (newAdapterState.hasTabs() && newAdapterState.getSelectedTab() != oldAdapterState.getSelectedTab()) {
            this.mOemToolbar.selectTab(newAdapterState.getSelectedTab(), true);
        }
        if (!Objects.equals(newAdapterState.getShownMenuItems(), oldAdapterState.getShownMenuItems())) {
            this.mOemToolbar.setMenuItems(newAdapterState.getShownMenuItems());
        }
    }

    public void updateMenuItems() {
        this.mOemToolbar.setMenuItems(this.mAdapterState.getShownMenuItems());
    }

    @Override
    public Toolbar.State getState() {
        return this.mAdapterState.getState();
    }

    @Override
    public boolean isStateSet() {
        return this.mAdapterState.isStateSet();
    }

    @Override
    public void registerOnTabSelectedListener(Toolbar.OnTabSelectedListener listener) {
        this.mOnTabSelectedListeners.add(listener);
    }

    @Override
    public boolean unregisterOnTabSelectedListener(Toolbar.OnTabSelectedListener listener) {
        return this.mOnTabSelectedListeners.remove(listener);
    }

    @Override
    public void registerOnSearchListener(Toolbar.OnSearchListener listener) {
        this.mDeprecatedSearchListeners.add(listener);
    }

    @Override
    public boolean unregisterOnSearchListener(Toolbar.OnSearchListener listener) {
        return this.mDeprecatedSearchListeners.remove(listener);
    }

    @Override
    public void registerSearchListener(java.util.function.Consumer<String> listener) {
        this.mSearchListeners.add(listener);
    }

    @Override
    public boolean unregisterSearchListener(java.util.function.Consumer<String> listener) {
        return this.mSearchListeners.remove(listener);
    }

    @Override
    public void setSearchConfig(SearchConfig searchConfig) {
        this.mSearchWidescreenController.setSearchConfig(searchConfig);
    }

    @Override
    public SearchCapabilities getSearchCapabilities() {
        if (!this.mSupportsImeSearch) {
            return SearchCapabilities.builder().build();
        }
        return this.mSearchWidescreenController.getSearchCapabilities();
    }

    @Override
    public boolean canShowSearchResultItems() {
        return this.getSearchCapabilities().canShowSearchResultItems();
    }

    @Override
    public boolean canShowSearchResultsView() {
        return this.getSearchCapabilities().canShowSearchResultsView();
    }

    @Override
    public void setSearchResultsView(View view) {
        this.mSearchConfigBuilder.setSearchResultsView(view);
        this.setSearchConfig(this.mSearchConfigBuilder.build());
    }

    @Override
    public void setSearchResultsInputViewIcon(Drawable drawable2) {
        this.mSearchConfigBuilder.setSearchResultsInputViewIcon(drawable2);
        this.setSearchConfig(this.mSearchConfigBuilder.build());
    }

    @Override
    public void setSearchResultItems(List<? extends CarUiImeSearchListItem> searchItems) {
        this.mSearchConfigBuilder.setSearchResultItems(searchItems);
        this.setSearchConfig(this.mSearchConfigBuilder.build());
    }

    @Override
    public void registerOnSearchCompletedListener(Toolbar.OnSearchCompletedListener listener) {
        this.mDeprecatedSearchCompletedListeners.add(listener);
    }

    @Override
    public boolean unregisterOnSearchCompletedListener(Toolbar.OnSearchCompletedListener listener) {
        return this.mDeprecatedSearchCompletedListeners.remove(listener);
    }

    @Override
    public void registerSearchCompletedListener(Runnable listener) {
        this.mSearchCompletedListeners.add(listener);
    }

    @Override
    public boolean unregisterSearchCompletedListener(Runnable listener) {
        return this.mSearchCompletedListeners.remove(listener);
    }

    @Override
    public void registerOnBackListener(Toolbar.OnBackListener listener) {
        this.mDeprecatedBackListeners.add(listener);
    }

    @Override
    public boolean unregisterOnBackListener(Toolbar.OnBackListener listener) {
        return this.mDeprecatedBackListeners.remove(listener);
    }

    @Override
    public void registerBackListener(Supplier<Boolean> listener) {
        this.mBackListeners.add(listener);
    }

    @Override
    public boolean unregisterBackListener(Supplier<Boolean> listener) {
        return this.mBackListeners.remove(listener);
    }

    @Override
    public ProgressBarController getProgressBar() {
        return this.mProgressBar;
    }

    private Drawable getDrawable(@DrawableRes int drawable2) {
        if (drawable2 == 0) {
            return null;
        }
        return ContextCompat.getDrawable((Context)this.mContext, (int)drawable2);
    }

    private static class ToolbarAdapterState {
        private final Toolbar.State mState;
        private final boolean mStateSet;
        private final boolean mShowTabsInSubpage;
        @NonNull
        private final List<TabAdapterV1> mTabs;
        @NonNull
        private final List<MenuItemAdapterV1> mMenuItems;
        private final int mSelectedTab;
        private final String mTitle;
        private final String mSubtitle;
        private final Drawable mLogo;
        private final boolean mShowMenuItemsWhileSearching;
        private final boolean mTabsDirty;
        private final boolean mLogoDirty;
        private final NavButtonMode mNavButtonMode;
        private final SearchMode mSearchMode;

        ToolbarAdapterState() {
            this.mState = Toolbar.State.HOME;
            this.mStateSet = false;
            this.mShowTabsInSubpage = false;
            this.mTabs = Collections.emptyList();
            this.mMenuItems = Collections.emptyList();
            this.mSelectedTab = -1;
            this.mTitle = null;
            this.mSubtitle = null;
            this.mLogo = null;
            this.mShowMenuItemsWhileSearching = false;
            this.mTabsDirty = false;
            this.mLogoDirty = false;
            this.mNavButtonMode = NavButtonMode.DISABLED;
            this.mSearchMode = SearchMode.DISABLED;
        }

        private ToolbarAdapterState(Builder builder) {
            this.mState = builder.mState;
            this.mStateSet = builder.mStateSet;
            this.mShowTabsInSubpage = builder.mShowTabsInSubpage;
            this.mTabs = builder.mTabs;
            this.mMenuItems = builder.mMenuItems;
            this.mSelectedTab = builder.mSelectedTab;
            this.mTitle = builder.mTitle;
            this.mSubtitle = builder.mSubtitle;
            this.mLogo = builder.mLogo;
            this.mShowMenuItemsWhileSearching = builder.mShowMenuItemsWhileSearching;
            this.mTabsDirty = builder.mTabsDirty;
            this.mLogoDirty = builder.mLogoDirty;
            this.mNavButtonMode = builder.mNavButtonMode;
            this.mSearchMode = builder.mSearchMode;
        }

        public Toolbar.State getState() {
            return this.mState;
        }

        public boolean isStateSet() {
            return this.mStateSet;
        }

        public boolean getShowTabsInSubpage() {
            return this.mShowTabsInSubpage;
        }

        @NonNull
        public List<TabAdapterV1> getTabs() {
            return this.mTabs;
        }

        public boolean getTabsDirty() {
            return this.mTabsDirty;
        }

        public int getSelectedTab() {
            return this.mSelectedTab;
        }

        public String getTitle() {
            return this.mTitle == null ? "" : this.mTitle;
        }

        public String getShownTitle() {
            if (this.mStateSet && this.mState != Toolbar.State.HOME && this.mState != Toolbar.State.SUBPAGE) {
                return "";
            }
            return this.mTitle == null ? "" : this.mTitle;
        }

        public String getSubtitle() {
            return this.mSubtitle == null ? "" : this.mSubtitle;
        }

        public String getShownSubtitle() {
            if (this.mStateSet && this.mState != Toolbar.State.HOME && this.mState != Toolbar.State.SUBPAGE) {
                return "";
            }
            return this.mSubtitle == null ? "" : this.mSubtitle;
        }

        public Drawable getLogo() {
            return this.mLogo;
        }

        public Drawable getShownLogo() {
            if (this.mStateSet && this.mState != Toolbar.State.HOME && this.mState != Toolbar.State.SUBPAGE) {
                return null;
            }
            return this.mLogo;
        }

        public boolean getLogoDirty() {
            return this.mLogoDirty;
        }

        public boolean getShowMenuItemsWhileSearching() {
            return this.mShowMenuItemsWhileSearching;
        }

        public NavButtonMode getNavButtonMode() {
            if (this.mStateSet && this.mNavButtonMode == NavButtonMode.DISABLED && this.mState != Toolbar.State.HOME) {
                return NavButtonMode.BACK;
            }
            return this.mNavButtonMode;
        }

        private boolean hasTabs() {
            if (!this.mStateSet) {
                return !this.getTabs().isEmpty();
            }
            return (this.mState == Toolbar.State.HOME || this.mState == Toolbar.State.SUBPAGE && this.getShowTabsInSubpage()) && !this.getTabs().isEmpty();
        }

        private List<MenuItemOEMV1> getShownMenuItems() {
            SearchMode searchMode = this.getSearchMode();
            Stream<Object> stream = this.mMenuItems.stream();
            if (searchMode == SearchMode.EDIT && !this.mShowMenuItemsWhileSearching) {
                stream = Stream.empty();
            } else if (searchMode == SearchMode.SEARCH) {
                stream = this.mShowMenuItemsWhileSearching ? this.mMenuItems.stream().filter(item -> !item.getClientMenuItem().isSearch()) : Stream.empty();
            }
            return Collections.unmodifiableList(stream.filter(MenuItemAdapterV1::isVisible).map(MenuItemAdapterV1::getPluginMenuItem).collect(Collectors.toList()));
        }

        private SearchMode getSearchMode() {
            if (this.mStateSet) {
                if (this.mState == Toolbar.State.SEARCH) {
                    return SearchMode.SEARCH;
                }
                if (this.mState == Toolbar.State.EDIT) {
                    return SearchMode.EDIT;
                }
                return SearchMode.DISABLED;
            }
            return this.mSearchMode;
        }

        public Builder copy() {
            return new Builder(this);
        }

        public static class Builder {
            private final ToolbarAdapterState mStateClonedFrom;
            private boolean mWasChanged = false;
            private Toolbar.State mState;
            private boolean mStateSet;
            private boolean mShowTabsInSubpage;
            @NonNull
            private List<TabAdapterV1> mTabs;
            @NonNull
            private List<MenuItemAdapterV1> mMenuItems;
            private int mSelectedTab;
            private String mTitle;
            private String mSubtitle;
            private Drawable mLogo;
            private boolean mShowMenuItemsWhileSearching;
            private boolean mTabsDirty = false;
            private boolean mLogoDirty = false;
            private NavButtonMode mNavButtonMode;
            private SearchMode mSearchMode;

            Builder(ToolbarAdapterState state) {
                this.mStateClonedFrom = state;
                this.mState = state.mState;
                this.mStateSet = state.mStateSet;
                this.mShowTabsInSubpage = state.mShowTabsInSubpage;
                this.mTabs = state.mTabs;
                this.mMenuItems = state.mMenuItems;
                this.mShowMenuItemsWhileSearching = state.mShowMenuItemsWhileSearching;
                this.mSelectedTab = state.mSelectedTab;
                this.mTitle = state.mTitle;
                this.mSubtitle = state.mSubtitle;
                this.mLogo = state.mLogo;
                this.mNavButtonMode = state.mNavButtonMode;
                this.mSearchMode = state.mSearchMode;
            }

            public ToolbarAdapterState build() {
                if (!this.mWasChanged) {
                    return this.mStateClonedFrom;
                }
                return new ToolbarAdapterState(this);
            }

            public Builder setState(Toolbar.State state) {
                if (this.mSearchMode != SearchMode.DISABLED) {
                    throw new IllegalStateException("Cannot use setSearchMode() with setState()");
                }
                if (state != this.mState) {
                    this.mState = state;
                    this.mStateSet = true;
                    this.mWasChanged = true;
                }
                return this;
            }

            public Builder setShowTabsInSubpage(boolean showTabsInSubpage) {
                if (this.mShowTabsInSubpage != showTabsInSubpage) {
                    this.mShowTabsInSubpage = showTabsInSubpage;
                    this.mWasChanged = true;
                }
                return this;
            }

            public Builder setTabs(@Nullable List<TabAdapterV1> tabs) {
                if (tabs == null) {
                    tabs = Collections.emptyList();
                }
                if (!Objects.equals(tabs, this.mTabs)) {
                    this.mTabs = Collections.unmodifiableList(tabs);
                    this.mSelectedTab = this.mTabs.isEmpty() ? -1 : 0;
                    this.mWasChanged = true;
                    this.mTabsDirty = true;
                }
                return this;
            }

            public Builder addTab(@NonNull TabAdapterV1 tab) {
                ArrayList<TabAdapterV1> newTabs = new ArrayList<TabAdapterV1>(this.mTabs);
                newTabs.add(tab);
                this.mTabs = Collections.unmodifiableList(newTabs);
                this.mWasChanged = true;
                this.mTabsDirty = true;
                return this;
            }

            public Builder setSelectedTab(int selectedTab) {
                if (this.mSelectedTab != selectedTab) {
                    this.mSelectedTab = selectedTab;
                    this.mWasChanged = true;
                }
                return this;
            }

            public Builder setTitle(String title) {
                if (!Objects.equals(this.mTitle, title)) {
                    this.mTitle = title;
                    this.mWasChanged = true;
                }
                return this;
            }

            public Builder setSubtitle(String subtitle) {
                if (!Objects.equals(this.mSubtitle, subtitle)) {
                    this.mSubtitle = subtitle;
                    this.mWasChanged = true;
                }
                return this;
            }

            public Builder setLogo(Drawable logo) {
                if (this.mLogo != logo) {
                    this.mLogo = logo;
                    this.mWasChanged = true;
                    this.mLogoDirty = true;
                }
                return this;
            }

            public Builder setShowMenuItemsWhileSearching(boolean showMenuItemsWhileSearching) {
                if (this.mShowMenuItemsWhileSearching != showMenuItemsWhileSearching) {
                    this.mShowMenuItemsWhileSearching = showMenuItemsWhileSearching;
                    this.mWasChanged = true;
                }
                return this;
            }

            public Builder setMenuItems(List<MenuItemAdapterV1> menuItems) {
                if (menuItems == null) {
                    menuItems = Collections.emptyList();
                }
                if (!Objects.equals(this.mMenuItems, menuItems)) {
                    this.mMenuItems = menuItems;
                    this.mWasChanged = true;
                }
                return this;
            }

            public Builder setNavButtonMode(NavButtonMode newMode) {
                if (newMode != this.mNavButtonMode) {
                    this.mNavButtonMode = newMode;
                    this.mWasChanged = true;
                }
                return this;
            }

            public Builder setSearchMode(SearchMode searchMode) {
                if (this.mStateSet) {
                    throw new IllegalStateException("Cannot use setSearchMode() with setState()");
                }
                if (this.mSearchMode != searchMode) {
                    this.mSearchMode = searchMode;
                    this.mWasChanged = true;
                }
                return this;
            }
        }
    }
}

