/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.toolbar;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.annotation.XmlRes;
import androidx.core.content.ContextCompat;
import com.android.car.ui.AlertDialogBuilder;
import com.android.car.ui.CarUiText;
import com.android.car.ui.R;
import com.android.car.ui.imewidescreen.CarUiImeSearchListItem;
import com.android.car.ui.plugin.oemapis.Consumer;
import com.android.car.ui.plugin.oemapis.toolbar.ImeSearchInterfaceOEMV2;
import com.android.car.ui.recyclerview.CarUiContentListItem;
import com.android.car.ui.recyclerview.CarUiListItem;
import com.android.car.ui.recyclerview.CarUiListItemAdapter;
import com.android.car.ui.toolbar.DeprecatedTabWrapper;
import com.android.car.ui.toolbar.MenuItem;
import com.android.car.ui.toolbar.MenuItemRenderer;
import com.android.car.ui.toolbar.MenuItemXmlParserUtil;
import com.android.car.ui.toolbar.NavButtonMode;
import com.android.car.ui.toolbar.ProgressBarController;
import com.android.car.ui.toolbar.ProgressBarControllerImpl;
import com.android.car.ui.toolbar.SearchCapabilities;
import com.android.car.ui.toolbar.SearchConfig;
import com.android.car.ui.toolbar.SearchMode;
import com.android.car.ui.toolbar.SearchView;
import com.android.car.ui.toolbar.SearchWidescreenController;
import com.android.car.ui.toolbar.Tab;
import com.android.car.ui.toolbar.TabLayout;
import com.android.car.ui.toolbar.Toolbar;
import com.android.car.ui.toolbar.ToolbarController;
import com.android.car.ui.utils.CarUiUtils;
import com.android.car.ui.widget.CarUiTextView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

@TargetApi(value=30)
public final class ToolbarControllerImpl
implements ToolbarController {
    private static final String TAG = "CarUiToolbarController";
    @Nullable
    private View mBackground;
    private ImageView mNavIcon;
    private ImageView mLogoInNavIconSpace;
    private ViewGroup mNavIconContainer;
    private ViewGroup mTitleContainer;
    private CarUiTextView mTitle;
    @NonNull
    private CarUiText mTitleText = new CarUiText.Builder("").build();
    private CarUiTextView mSubtitle;
    @NonNull
    private CarUiText mSubtitleText = new CarUiText.Builder("").build();
    private ImageView mTitleLogo;
    private ViewGroup mTitleLogoContainer;
    private Runnable mOnLogoClickListener;
    private TabLayout mTabLayout;
    private ViewGroup mMenuItemsContainer;
    private SearchConfig.SearchConfigBuilder mSearchConfigBuilder;
    private final FrameLayout mSearchViewContainer;
    private SearchView mSearchView;
    private CharSequence mSearchHint;
    private Drawable mSearchIcon;
    private String mSearchQuery;
    @NonNull
    private final Context mContext;
    private final Set<java.util.function.Consumer<String>> mOnSearchListeners = new HashSet<java.util.function.Consumer<String>>();
    private final Set<Runnable> mOnSearchCompletedListeners = new HashSet<Runnable>();
    private final Set<Toolbar.OnSearchListener> mDeprecatedSearchListeners = new HashSet<Toolbar.OnSearchListener>();
    private final Set<Toolbar.OnSearchCompletedListener> mDeprecatedSearchCompletedListeners = new HashSet<Toolbar.OnSearchCompletedListener>();
    private final Set<Toolbar.OnBackListener> mDeprecatedBackListeners = new HashSet<Toolbar.OnBackListener>();
    private final Set<Supplier<Boolean>> mBackListeners = new HashSet<Supplier<Boolean>>();
    private final Set<Toolbar.OnTabSelectedListener> mOnTabSelectedListeners = new HashSet<Toolbar.OnTabSelectedListener>();
    private final MenuItem mOverflowButton;
    private final boolean mIsTabsInSecondRow;
    private boolean mShowTabsInSubpage = false;
    private boolean mHasLogo = false;
    private boolean mShowMenuItemsWhileSearching;
    private Toolbar.State mState = Toolbar.State.HOME;
    private boolean mStateSet = false;
    private NavButtonMode mNavButtonMode = NavButtonMode.DISABLED;
    private SearchMode mSearchMode = SearchMode.DISABLED;
    @NonNull
    private List<MenuItem> mMenuItems = Collections.emptyList();
    private List<MenuItem> mOverflowItems = new ArrayList<MenuItem>();
    private final List<CarUiListItem> mUiOverflowItems = new ArrayList<CarUiListItem>();
    private final CarUiListItemAdapter mOverflowAdapter;
    private final List<MenuItemRenderer> mMenuItemRenderers = new ArrayList<MenuItemRenderer>();
    private final List<DeprecatedTabWrapper> mDeprecatedTabs = new ArrayList<DeprecatedTabWrapper>();
    private View[] mMenuItemViews;
    private int mMenuItemsXmlId = 0;
    private AlertDialog mOverflowDialog;
    private final boolean mNavIconSpaceReserved;
    private final boolean mLogoFillsNavIconSpace;
    private final boolean mShowLogo;
    private SearchConfig mSearchConfigForWidescreen;
    private final ProgressBarController mProgressBar;
    private final MenuItem.Listener mOverflowItemListener = item -> {
        this.updateOverflowDialog(item);
        this.update();
    };
    private java.util.function.Consumer<TextView> mSearchTextViewConsumer = null;
    private BiConsumer<String, Bundle> mOnPrivateImeCommandListener = null;

    public ToolbarControllerImpl(@NonNull Context context, @NonNull View view) {
        this.mContext = context;
        this.mOverflowButton = MenuItem.builder(this.getContext()).setIcon(R.drawable.car_ui_icon_overflow_menu).setTitle(R.string.car_ui_toolbar_menu_item_overflow_title).setOnClickListener(v -> {
            if (this.mOverflowDialog == null) {
                if (Log.isLoggable((String)TAG, (int)6)) {
                    Log.e((String)TAG, (String)"Overflow dialog was null when trying to show it!");
                }
            } else {
                this.mOverflowDialog.show();
            }
        }).build();
        this.mIsTabsInSecondRow = this.getContext().getResources().getBoolean(R.bool.car_ui_toolbar_tabs_on_second_row);
        this.mNavIconSpaceReserved = this.getContext().getResources().getBoolean(R.bool.car_ui_toolbar_nav_icon_reserve_space);
        this.mLogoFillsNavIconSpace = this.getContext().getResources().getBoolean(R.bool.car_ui_toolbar_logo_fills_nav_icon_space);
        this.mShowLogo = this.getContext().getResources().getBoolean(R.bool.car_ui_toolbar_show_logo);
        this.mSearchHint = this.getContext().getString(R.string.car_ui_toolbar_default_search_hint);
        this.mBackground = CarUiUtils.findViewByRefId(view, R.id.car_ui_toolbar_background);
        this.mTabLayout = (TabLayout)((Object)CarUiUtils.requireViewByRefId(view, R.id.car_ui_toolbar_tabs));
        this.mNavIcon = (ImageView)CarUiUtils.requireViewByRefId(view, R.id.car_ui_toolbar_nav_icon);
        this.mLogoInNavIconSpace = (ImageView)CarUiUtils.requireViewByRefId(view, R.id.car_ui_toolbar_logo);
        this.mNavIconContainer = (ViewGroup)CarUiUtils.requireViewByRefId(view, R.id.car_ui_toolbar_nav_icon_container);
        this.mMenuItemsContainer = (ViewGroup)CarUiUtils.requireViewByRefId(view, R.id.car_ui_toolbar_menu_items_container);
        this.mTitleContainer = (ViewGroup)CarUiUtils.requireViewByRefId(view, R.id.car_ui_toolbar_title_container);
        this.mSubtitle = (CarUiTextView)((Object)CarUiUtils.requireViewByRefId(view, R.id.car_ui_toolbar_subtitle));
        this.mTitle = (CarUiTextView)((Object)CarUiUtils.requireViewByRefId(view, R.id.car_ui_toolbar_title));
        this.mTitleLogoContainer = (ViewGroup)CarUiUtils.requireViewByRefId(view, R.id.car_ui_toolbar_title_logo_container);
        this.mTitleLogo = (ImageView)CarUiUtils.requireViewByRefId(view, R.id.car_ui_toolbar_title_logo);
        this.mOnLogoClickListener = null;
        this.mSearchViewContainer = (FrameLayout)CarUiUtils.requireViewByRefId(view, R.id.car_ui_toolbar_search_view_container);
        this.mProgressBar = new ProgressBarControllerImpl((ProgressBar)CarUiUtils.requireViewByRefId(view, R.id.car_ui_toolbar_progress_bar));
        this.mSearchConfigBuilder = SearchConfig.builder();
        this.setBackgroundShown(true);
        this.mOverflowAdapter = new CarUiListItemAdapter(this.mUiOverflowItems);
        this.update();
    }

    private Context getContext() {
        return this.mContext;
    }

    private Drawable getDrawable(@DrawableRes int resId) {
        if (resId == 0) {
            return null;
        }
        return ContextCompat.getDrawable((Context)this.getContext(), (int)resId);
    }

    @Override
    public void setTitle(@StringRes int title) {
        this.setTitle(title == 0 ? null : this.getContext().getString(title));
    }

    @Override
    public void setTitle(CharSequence title) {
        this.mTitleText = title == null ? new CarUiText.Builder("").build() : new CarUiText.Builder(title).build();
        this.mTitle.setText(this.mTitleText);
        this.update();
    }

    @Override
    public void setTitle(CarUiText title) {
        this.mTitleText = title;
        this.mTitle.setText(this.mTitleText);
        this.update();
    }

    @Override
    public CharSequence getTitle() {
        return this.mTitleText.getPreferredText();
    }

    @Override
    public void setSubtitle(@StringRes int subTitle) {
        this.setSubtitle(subTitle == 0 ? null : this.getContext().getString(subTitle));
    }

    @Override
    public void setSubtitle(CharSequence subTitle) {
        this.mSubtitleText = subTitle == null ? new CarUiText.Builder("").build() : new CarUiText.Builder(subTitle).build();
        this.mSubtitle.setText(this.mSubtitleText);
        this.update();
    }

    @Override
    public void setSubtitle(CarUiText text) {
        this.mSubtitleText = text;
        this.mSubtitle.setText(this.mSubtitleText);
        this.update();
    }

    @Override
    public CharSequence getSubtitle() {
        return this.mSubtitleText.getPreferredText();
    }

    @Override
    public void setTabs(@Nullable List<Tab> tabs) {
        this.setTabs(tabs, 0);
    }

    @Override
    public void setTabs(@Nullable List<Tab> tabs, int selectedTab) {
        this.mDeprecatedTabs.clear();
        this.setTabsInternal(tabs, selectedTab);
    }

    @Override
    public List<Tab> getTabs() {
        return this.mTabLayout.getTabs();
    }

    private void setTabsInternal(@Nullable List<Tab> tabs, int selectedTab) {
        if (tabs == null || tabs.isEmpty()) {
            selectedTab = -1;
        } else if (selectedTab < 0 || selectedTab >= tabs.size()) {
            throw new IllegalArgumentException("Tab position is invalid: " + selectedTab);
        }
        this.mTabLayout.setTabs(tabs, selectedTab);
        this.update();
    }

    @Override
    public int getTabCount() {
        return this.mDeprecatedTabs.size();
    }

    @Override
    public int getTabPosition(TabLayout.Tab tab) {
        for (int i = 0; i < this.mDeprecatedTabs.size(); ++i) {
            if (this.mDeprecatedTabs.get(i).getDeprecatedTab() != tab) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void addTab(TabLayout.Tab newTab) {
        this.mDeprecatedTabs.add(new DeprecatedTabWrapper(this.getContext(), newTab, this::updateModernTabsFromDeprecatedOnes, tab -> {
            for (Toolbar.OnTabSelectedListener listener : this.mOnTabSelectedListeners) {
                listener.onTabSelected(newTab);
            }
        }));
        this.updateModernTabsFromDeprecatedOnes();
    }

    private void updateModernTabsFromDeprecatedOnes() {
        ArrayList<Tab> modernTabs = new ArrayList<Tab>();
        for (DeprecatedTabWrapper tab : this.mDeprecatedTabs) {
            modernTabs.add(tab.getModernTab());
        }
        this.setTabsInternal(modernTabs, 0);
    }

    @Override
    public void clearAllTabs() {
        this.mDeprecatedTabs.clear();
        this.setTabs(null);
    }

    @Override
    public TabLayout.Tab getTab(int position) {
        return this.mDeprecatedTabs.get(position).getDeprecatedTab();
    }

    @Override
    public void selectTab(int position) {
        this.mTabLayout.selectTab(position);
    }

    @Override
    public int getSelectedTab() {
        return this.mTabLayout.getSelectedTab();
    }

    @Override
    public void setShowTabsInSubpage(boolean showTabs) {
        if (showTabs != this.mShowTabsInSubpage) {
            this.mShowTabsInSubpage = showTabs;
            this.update();
        }
    }

    @Override
    public boolean getShowTabsInSubpage() {
        return this.mShowTabsInSubpage;
    }

    @Override
    public void setLogo(@DrawableRes int resId) {
        this.asyncSetLogo(resId, Runnable::run);
    }

    private void asyncSetLogo(int resId, Executor bgExecutor) {
        if (!this.mShowLogo) {
            return;
        }
        if (resId != 0) {
            bgExecutor.execute(() -> {
                Drawable drawable2 = this.getDrawable(resId);
                this.mTitleLogo.post(() -> {
                    this.mLogoInNavIconSpace.setImageDrawable(drawable2);
                    this.mTitleLogo.setImageDrawable(drawable2);
                });
            });
            this.mHasLogo = true;
        } else {
            this.mHasLogo = false;
        }
        this.update();
    }

    @Override
    public void setLogo(Drawable drawable2) {
        if (!this.mShowLogo) {
            return;
        }
        if (drawable2 != null) {
            this.mLogoInNavIconSpace.setImageDrawable(drawable2);
            this.mTitleLogo.setImageDrawable(drawable2);
            this.mHasLogo = true;
        } else {
            this.mHasLogo = false;
        }
        this.update();
    }

    @Override
    public void setOnLogoClickListener(@Nullable Runnable listener) {
        if (this.mOnLogoClickListener != listener) {
            this.mOnLogoClickListener = listener;
            this.update();
        }
    }

    @Override
    public void setSearchHint(@StringRes int resId) {
        this.setSearchHint(this.getContext().getString(resId));
    }

    @Override
    public void setSearchHint(CharSequence hint) {
        this.mSearchHint = hint;
        if (this.mSearchView != null) {
            this.mSearchView.setHint(this.mSearchHint);
        }
    }

    @Override
    public CharSequence getSearchHint() {
        return this.mSearchHint;
    }

    @Override
    public void setSearchIcon(@DrawableRes int resId) {
        this.setSearchIcon(this.getDrawable(resId));
    }

    @Override
    public void setSearchIcon(Drawable d) {
        if (!Objects.equals(d, this.mSearchIcon)) {
            this.mSearchIcon = d;
            if (this.mSearchView != null) {
                this.mSearchView.setIcon(this.mSearchIcon);
            }
        }
    }

    @Override
    public void setNavButtonMode(Toolbar.NavButtonMode mode) {
        NavButtonMode modernMode;
        switch (mode) {
            case BACK: {
                modernMode = NavButtonMode.BACK;
                break;
            }
            case DOWN: {
                modernMode = NavButtonMode.DOWN;
                break;
            }
            case CLOSE: {
                modernMode = NavButtonMode.CLOSE;
                break;
            }
            default: {
                modernMode = NavButtonMode.DISABLED;
            }
        }
        this.setNavButtonMode(modernMode);
    }

    @Override
    public void setNavButtonMode(NavButtonMode mode) {
        if (mode != this.mNavButtonMode) {
            this.mNavButtonMode = mode;
            this.update();
        }
    }

    @Override
    public NavButtonMode getNavButtonMode() {
        return this.mNavButtonMode;
    }

    @Override
    public void setBackgroundShown(boolean shown) {
        if (this.mBackground == null) {
            return;
        }
        if (shown) {
            this.mBackground.setBackground(this.getDrawable(R.drawable.car_ui_toolbar_background));
        } else {
            this.mBackground.setBackground(null);
        }
    }

    @Override
    public boolean getBackgroundShown() {
        if (this.mBackground == null) {
            return true;
        }
        return this.mBackground.getBackground() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMenuItemsInternal(@Nullable List<MenuItem> items) {
        if (items == null) {
            items = Collections.emptyList();
        }
        ArrayList<MenuItem> visibleMenuItems = new ArrayList<MenuItem>();
        ArrayList<MenuItem> overflowItems = new ArrayList<MenuItem>();
        AtomicInteger loadedMenuItems = new AtomicInteger(0);
        ToolbarControllerImpl toolbarControllerImpl = this;
        synchronized (toolbarControllerImpl) {
            if (items.equals(this.mMenuItems)) {
                return;
            }
            for (MenuItem item : items) {
                if (item.getDisplayBehavior() == MenuItem.DisplayBehavior.NEVER) {
                    overflowItems.add(item);
                    item.setListener(this.mOverflowItemListener);
                    continue;
                }
                visibleMenuItems.add(item);
            }
            this.mMenuItems = new ArrayList<MenuItem>(items);
            this.mOverflowItems = overflowItems;
            this.mMenuItemRenderers.clear();
            this.mMenuItemsContainer.removeAllViews();
            if (!overflowItems.isEmpty()) {
                visibleMenuItems.add(this.mOverflowButton);
                this.createOverflowDialog();
            }
            View[] menuItemViews = new View[visibleMenuItems.size()];
            this.mMenuItemViews = menuItemViews;
            for (int i = 0; i < visibleMenuItems.size(); ++i) {
                int index = i;
                MenuItem item = (MenuItem)visibleMenuItems.get(i);
                MenuItemRenderer renderer = new MenuItemRenderer(item, this.mMenuItemsContainer);
                this.mMenuItemRenderers.add(renderer);
                renderer.createView(view -> {
                    ToolbarControllerImpl toolbarControllerImpl = this;
                    synchronized (toolbarControllerImpl) {
                        if (menuItemViews != this.mMenuItemViews) {
                            return;
                        }
                        menuItemViews[index] = view;
                        if (loadedMenuItems.addAndGet(1) == menuItemViews.length) {
                            for (View v : menuItemViews) {
                                this.mMenuItemsContainer.addView(v);
                            }
                        }
                    }
                });
            }
        }
        this.update();
    }

    @Override
    public void setMenuItems(@Nullable List<MenuItem> items) {
        this.mMenuItemsXmlId = 0;
        this.setMenuItemsInternal(items);
    }

    @Override
    public List<MenuItem> setMenuItems(@XmlRes int resId) {
        if (this.mMenuItemsXmlId != 0 && this.mMenuItemsXmlId == resId) {
            return this.mMenuItems;
        }
        this.mMenuItemsXmlId = resId;
        List<MenuItem> menuItems = MenuItemXmlParserUtil.readMenuItemList(this.getContext(), resId);
        this.setMenuItemsInternal(menuItems);
        return menuItems;
    }

    @Override
    @NonNull
    public List<MenuItem> getMenuItems() {
        return Collections.unmodifiableList(this.mMenuItems);
    }

    @Override
    @Nullable
    public MenuItem findMenuItemById(int id2) {
        for (MenuItem item : this.mMenuItems) {
            if (item.getId() != id2) continue;
            return item;
        }
        return null;
    }

    @Override
    @NonNull
    public MenuItem requireMenuItemById(int id2) {
        MenuItem result = this.findMenuItemById(id2);
        if (result == null) {
            throw new IllegalArgumentException("ID does not reference a MenuItem on this Toolbar");
        }
        return result;
    }

    private int countVisibleOverflowItems() {
        int numVisibleItems = 0;
        for (MenuItem item : this.mOverflowItems) {
            if (!item.isVisible()) continue;
            ++numVisibleItems;
        }
        return numVisibleItems;
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    private void createOverflowDialog() {
        boolean isShowing = this.mOverflowDialog == null ? false : this.mOverflowDialog.isShowing();
        this.mUiOverflowItems.clear();
        for (MenuItem menuItem : this.mOverflowItems) {
            if (!menuItem.isVisible()) continue;
            this.mUiOverflowItems.add(this.toCarUiContentListItem(menuItem));
        }
        this.mOverflowDialog = new AlertDialogBuilder(this.getContext()).setAdapter(this.mOverflowAdapter).create();
        if (isShowing) {
            this.mOverflowAdapter.notifyDataSetChanged();
        }
    }

    private void updateOverflowDialog(MenuItem changedItem) {
        int itemIndex = this.mOverflowItems.indexOf(changedItem);
        if (itemIndex >= 0) {
            this.mUiOverflowItems.set(itemIndex, this.toCarUiContentListItem(changedItem));
            this.mOverflowAdapter.notifyItemChanged(itemIndex);
        } else {
            this.createOverflowDialog();
        }
    }

    private CarUiContentListItem toCarUiContentListItem(MenuItem menuItem) {
        CarUiContentListItem carUiItem = menuItem.isCheckable() ? new CarUiContentListItem(CarUiContentListItem.Action.SWITCH) : new CarUiContentListItem(CarUiContentListItem.Action.NONE);
        carUiItem.setIcon(menuItem.getIcon());
        carUiItem.setActivated(menuItem.isActivated());
        carUiItem.setChecked(menuItem.isChecked());
        carUiItem.setEnabled(menuItem.isEnabled());
        carUiItem.setTitle(menuItem.getTitle());
        carUiItem.setOnItemClickedListener(item -> {
            menuItem.performClick();
            this.mOverflowDialog.hide();
        });
        return carUiItem;
    }

    @Override
    public void setShowMenuItemsWhileSearching(boolean showMenuItems) {
        this.mShowMenuItemsWhileSearching = showMenuItems;
        this.update();
    }

    @Override
    public boolean getShowMenuItemsWhileSearching() {
        return this.mShowMenuItemsWhileSearching;
    }

    @Override
    public void setSearchQuery(String query) {
        if (this.mSearchView != null) {
            this.mSearchView.setSearchQuery(query);
        } else {
            this.mSearchQuery = query;
            for (Toolbar.OnSearchListener onSearchListener : this.mDeprecatedSearchListeners) {
                onSearchListener.onSearch(query);
            }
            for (java.util.function.Consumer consumer : this.mOnSearchListeners) {
                consumer.accept(query);
            }
        }
    }

    @Override
    public void setState(Toolbar.State state) {
        if (this.mState != state || !this.mStateSet) {
            this.mState = state;
            this.mStateSet = true;
            this.update();
        }
    }

    @Override
    public void setSearchMode(SearchMode mode) {
        if (this.mStateSet) {
            throw new IllegalStateException("Cannot set search mode when using setState()");
        }
        if (this.mSearchMode != mode) {
            this.mSearchMode = mode;
            this.update();
        }
    }

    @Override
    public SearchMode getSearchMode() {
        return this.mSearchMode;
    }

    private void update() {
        boolean hasLogoWithListener;
        boolean isSearching;
        NavButtonMode navButtonMode = this.mNavButtonMode;
        if (this.mStateSet) {
            if (this.mState == Toolbar.State.HOME) {
                navButtonMode = NavButtonMode.DISABLED;
            } else if (navButtonMode == NavButtonMode.DISABLED) {
                navButtonMode = NavButtonMode.BACK;
            }
        }
        SearchMode searchMode = this.mSearchMode;
        if (this.mStateSet) {
            searchMode = this.mState == Toolbar.State.SEARCH ? SearchMode.SEARCH : (this.mState == Toolbar.State.EDIT ? SearchMode.EDIT : SearchMode.DISABLED);
        }
        boolean hasLogo = this.mHasLogo;
        if (this.mStateSet && (this.mState == Toolbar.State.SEARCH || this.mState == Toolbar.State.EDIT)) {
            hasLogo = false;
        }
        boolean hasTabs = this.mTabLayout.hasTabs();
        if (this.mStateSet && this.mState != Toolbar.State.HOME && (this.mState != Toolbar.State.SUBPAGE || !this.mShowTabsInSubpage)) {
            hasTabs = false;
        }
        boolean bl = isSearching = searchMode != SearchMode.DISABLED;
        if (this.mSearchView == null && isSearching) {
            this.inflateSearchView();
        }
        for (MenuItemRenderer renderer : this.mMenuItemRenderers) {
            renderer.setToolbarIsSearching(searchMode == SearchMode.SEARCH);
        }
        View.OnClickListener backClickListener = v -> {
            Activity activity;
            boolean absorbed = false;
            ArrayList<Toolbar.OnBackListener> deprecatedListenersCopy = new ArrayList<Toolbar.OnBackListener>(this.mDeprecatedBackListeners);
            ArrayList<Supplier<Boolean>> listenersCopy = new ArrayList<Supplier<Boolean>>(this.mBackListeners);
            for (Toolbar.OnBackListener onBackListener : deprecatedListenersCopy) {
                absorbed = absorbed || onBackListener.onBack();
            }
            for (Supplier supplier : listenersCopy) {
                absorbed = absorbed || (Boolean)supplier.get() != false;
            }
            if (!absorbed && (activity = CarUiUtils.getActivity(this.getContext())) != null) {
                activity.onBackPressed();
            }
        };
        switch (navButtonMode) {
            case CLOSE: {
                this.mNavIcon.setImageResource(R.drawable.car_ui_icon_close);
                break;
            }
            case DOWN: {
                this.mNavIcon.setImageResource(R.drawable.car_ui_icon_down);
                break;
            }
            default: {
                this.mNavIcon.setImageResource(R.drawable.car_ui_icon_arrow_back);
            }
        }
        this.mNavIcon.setVisibility(navButtonMode != NavButtonMode.DISABLED ? 0 : 8);
        this.mLogoInNavIconSpace.setVisibility(hasLogo && navButtonMode == NavButtonMode.DISABLED && this.mLogoFillsNavIconSpace ? 0 : 4);
        this.mTitleLogoContainer.setVisibility(hasLogo && (navButtonMode != NavButtonMode.DISABLED || !this.mLogoFillsNavIconSpace) ? 0 : 8);
        this.mNavIconContainer.setVisibility(navButtonMode != NavButtonMode.DISABLED || hasLogo && this.mLogoFillsNavIconSpace ? 0 : (this.mNavIconSpaceReserved ? 4 : 8));
        boolean bl2 = hasLogoWithListener = hasLogo && this.mOnLogoClickListener != null;
        if (navButtonMode != NavButtonMode.DISABLED) {
            this.mNavIconContainer.setOnClickListener(backClickListener);
        } else if (hasLogoWithListener && this.mLogoFillsNavIconSpace) {
            this.mNavIconContainer.setOnClickListener(v -> this.mOnLogoClickListener.run());
        } else {
            this.mNavIconContainer.setOnClickListener(null);
        }
        this.mNavIconContainer.setClickable(this.mNavIconContainer.hasOnClickListeners());
        boolean logoListenerOnLogoContainer = hasLogoWithListener && (navButtonMode != NavButtonMode.DISABLED || !this.mLogoFillsNavIconSpace);
        this.mTitleLogoContainer.setOnClickListener(logoListenerOnLogoContainer ? v -> this.mOnLogoClickListener.run() : null);
        this.mTitleLogoContainer.setClickable(logoListenerOnLogoContainer);
        this.mNavIconContainer.setContentDescription(navButtonMode != NavButtonMode.DISABLED ? this.getContext().getString(R.string.car_ui_toolbar_nav_icon_content_description) : null);
        this.mTitleContainer.setVisibility((!hasTabs || this.mIsTabsInSecondRow) && !isSearching ? 0 : 8);
        this.mSubtitle.setVisibility(TextUtils.isEmpty((CharSequence)this.getSubtitle()) ? 8 : 0);
        this.mTabLayout.setVisibility(hasTabs && (this.mSearchMode == SearchMode.DISABLED || this.mIsTabsInSecondRow) ? 0 : 8);
        if (this.mSearchView != null) {
            if (isSearching) {
                this.mSearchView.setPlainText(searchMode == SearchMode.EDIT);
                this.mSearchView.setVisibility(0);
            } else {
                this.mSearchView.setVisibility(8);
            }
        }
        boolean showButtons = !isSearching || this.mShowMenuItemsWhileSearching;
        this.mMenuItemsContainer.setVisibility(showButtons ? 0 : 8);
        this.mOverflowButton.setVisible(showButtons && this.countVisibleOverflowItems() > 0);
    }

    private void inflateSearchView() {
        SearchView searchView = new SearchView(this.getContext());
        searchView.setHint(this.mSearchHint);
        searchView.setIcon(this.mSearchIcon);
        searchView.setSearchQuery(this.mSearchQuery);
        searchView.setSearchListeners(this.mDeprecatedSearchListeners, this.mOnSearchListeners);
        searchView.setSearchCompletedListeners(this.mDeprecatedSearchCompletedListeners, this.mOnSearchCompletedListeners);
        searchView.setVisibility(8);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        this.mSearchViewContainer.addView((View)searchView, (ViewGroup.LayoutParams)layoutParams);
        searchView.setSearchConfig(this.mSearchConfigForWidescreen);
        this.mSearchView = searchView;
        if (this.mSearchTextViewConsumer != null) {
            this.mSearchView.setSearchTextViewConsumer(tv -> this.mSearchTextViewConsumer.accept((TextView)tv));
        }
        if (this.mOnPrivateImeCommandListener != null) {
            this.mSearchView.setOnPrivateImeCommandListener((s, b) -> this.mOnPrivateImeCommandListener.accept((String)s, (Bundle)b));
        }
    }

    @Override
    public void setSearchResultsView(View view) {
        if (!this.getSearchCapabilities().canShowSearchResultsView()) {
            throw new IllegalStateException("not allowed to add view to wide screen IME, package name: " + this.getContext().getPackageName());
        }
        this.setSearchConfig(this.mSearchConfigBuilder.setSearchResultsView(view).build());
    }

    @Override
    public void setSearchResultsInputViewIcon(@NonNull Drawable drawable2) {
        this.setSearchConfig(this.mSearchConfigBuilder.setSearchResultsInputViewIcon(drawable2).build());
    }

    @Override
    public void setSearchResultItems(List<? extends CarUiImeSearchListItem> searchItems) {
        if (!this.getSearchCapabilities().canShowSearchResultItems()) {
            throw new IllegalStateException("system not in wide screen mode, not allowed to set search result items ");
        }
        this.setSearchConfig(this.mSearchConfigBuilder.setSearchResultItems(searchItems).build());
    }

    @Override
    public void setSearchConfig(SearchConfig searchConfig) {
        this.mSearchConfigForWidescreen = searchConfig;
        if (this.mSearchView != null) {
            this.mSearchView.setSearchConfig(this.mSearchConfigForWidescreen);
        }
    }

    @Override
    public SearchCapabilities getSearchCapabilities() {
        return SearchWidescreenController.getSearchCapabilities(this.mContext);
    }

    @Override
    public boolean canShowSearchResultItems() {
        return this.getSearchCapabilities().canShowSearchResultItems();
    }

    @Override
    public boolean canShowSearchResultsView() {
        return this.getSearchCapabilities().canShowSearchResultsView();
    }

    @Override
    public Toolbar.State getState() {
        return this.mState;
    }

    @Override
    public boolean isStateSet() {
        return this.mStateSet;
    }

    @Override
    public void registerOnTabSelectedListener(Toolbar.OnTabSelectedListener listener) {
        this.mOnTabSelectedListeners.add(listener);
    }

    @Override
    public boolean unregisterOnTabSelectedListener(Toolbar.OnTabSelectedListener listener) {
        return this.mOnTabSelectedListeners.remove(listener);
    }

    @Override
    public void registerOnSearchListener(Toolbar.OnSearchListener listener) {
        this.mDeprecatedSearchListeners.add(listener);
    }

    @Override
    public boolean unregisterOnSearchListener(Toolbar.OnSearchListener listener) {
        return this.mDeprecatedSearchListeners.remove(listener);
    }

    @Override
    public void registerSearchListener(java.util.function.Consumer<String> listener) {
        this.mOnSearchListeners.add(listener);
    }

    @Override
    public boolean unregisterSearchListener(java.util.function.Consumer<String> listener) {
        return this.mOnSearchListeners.remove(listener);
    }

    @Override
    public void registerOnSearchCompletedListener(Toolbar.OnSearchCompletedListener listener) {
        this.mDeprecatedSearchCompletedListeners.add(listener);
    }

    @Override
    public boolean unregisterOnSearchCompletedListener(Toolbar.OnSearchCompletedListener listener) {
        return this.mDeprecatedSearchCompletedListeners.remove(listener);
    }

    @Override
    public void registerSearchCompletedListener(Runnable listener) {
        this.mOnSearchCompletedListeners.add(listener);
    }

    @Override
    public boolean unregisterSearchCompletedListener(Runnable listener) {
        return this.mOnSearchCompletedListeners.remove(listener);
    }

    @Override
    public void registerOnBackListener(Toolbar.OnBackListener listener) {
        this.mDeprecatedBackListeners.add(listener);
    }

    @Override
    public boolean unregisterOnBackListener(Toolbar.OnBackListener listener) {
        return this.mDeprecatedBackListeners.remove(listener);
    }

    @Override
    public void registerBackListener(Supplier<Boolean> listener) {
        this.mBackListeners.add(listener);
    }

    @Override
    public boolean unregisterBackListener(Supplier<Boolean> listener) {
        return this.mBackListeners.remove(listener);
    }

    @Override
    public ProgressBarController getProgressBar() {
        return this.mProgressBar;
    }

    public Object getImeSearchInterface() {
        return new ImeSearchInterfaceOEMV2(){

            public void setSearchTextViewConsumer(@Nullable Consumer<TextView> consumer) {
                ToolbarControllerImpl.this.mSearchTextViewConsumer = tv -> consumer.accept(tv);
            }

            public void setOnPrivateImeCommandListener(@Nullable com.android.car.ui.plugin.oemapis.BiConsumer<String, Bundle> biConsumer) {
                ToolbarControllerImpl.this.mOnPrivateImeCommandListener = (s, b) -> biConsumer.accept(s, b);
            }
        };
    }
}

