/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import androidx.annotation.DimenRes;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.annotation.UiThread;
import com.android.car.ui.R;
import com.android.car.ui.uxr.DrawableStateView;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public final class CarUiUtils {
    private static final String TAG = "CarUiUtils";
    private static final String READ_ONLY_SYSTEM_PROPERTY_PREFIX = "ro.";
    private static final SparseArray<String> READ_ONLY_SYSTEM_PROPERTY_MAP = new SparseArray();
    private static int[] sRestrictedState;

    private CarUiUtils() {
    }

    public static float getFloat(Resources res, @DimenRes int resId) {
        TypedValue outValue = new TypedValue();
        res.getValue(resId, outValue, true);
        return outValue.getFloat();
    }

    public static int getAttrResourceId(Context context, int attr2) {
        return CarUiUtils.getAttrResourceId(context, 0, attr2);
    }

    public static int getAttrResourceId(Context context, @StyleRes int styleResId, int attr2) {
        TypedArray ta = context.obtainStyledAttributes(styleResId, new int[]{attr2});
        int resId = ta.getResourceId(0, 0);
        ta.recycle();
        return resId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getThemeBoolean(Activity activity, int attr2) {
        TypedArray a = activity.getTheme().obtainStyledAttributes(new int[]{attr2});
        try {
            boolean bl = a.getBoolean(0, false);
            return bl;
        }
        finally {
            a.recycle();
        }
    }

    @Nullable
    public static Activity getActivity(@Nullable Context context) {
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    @Nullable
    @UiThread
    public static <T extends View> T findViewByRefId(@NonNull View root, @IdRes int id2) {
        if (Build.VERSION.SDK_INT >= 30) {
            return (T)root.findViewById(id2);
        }
        if (id2 == -1) {
            return null;
        }
        TypedValue value = new TypedValue();
        root.getResources().getValue(id2, value, true);
        return (T)root.findViewById(value.resourceId);
    }

    @NonNull
    @UiThread
    public static <T extends View> T requireViewByRefId(@NonNull View root, @IdRes int id2) {
        T view = CarUiUtils.findViewByRefId(root, id2);
        if (view == null) {
            throw new IllegalArgumentException("ID " + root.getResources().getResourceName(id2) + " does not reference a View inside this View");
        }
        return view;
    }

    public static boolean getBooleanSystemProperty(@NonNull Resources resources, int propertyResId, boolean defaultValue) {
        String value = CarUiUtils.getSystemProperty(resources, propertyResId);
        if (!TextUtils.isEmpty((CharSequence)value)) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getSystemProperty(@NonNull Resources resources, int propertyResId) {
        String propertyName = resources.getString(propertyResId);
        boolean isReadOnly = propertyName.startsWith(READ_ONLY_SYSTEM_PROPERTY_PREFIX);
        if (!isReadOnly) {
            return CarUiUtils.readSystemProperty(propertyName);
        }
        SparseArray<String> sparseArray = READ_ONLY_SYSTEM_PROPERTY_MAP;
        synchronized (sparseArray) {
            if (READ_ONLY_SYSTEM_PROPERTY_MAP.indexOfKey(propertyResId) >= 0) {
                return (String)READ_ONLY_SYSTEM_PROPERTY_MAP.get(propertyResId);
            }
            String value = CarUiUtils.readSystemProperty(propertyName);
            READ_ONLY_SYSTEM_PROPERTY_MAP.put(propertyResId, (Object)value);
            return value;
        }
    }

    @Nullable
    @SuppressLint(value={"PrivateApi"})
    private static String readSystemProperty(String propertyName) {
        Method getMethod;
        Class<?> systemPropertiesClass;
        try {
            systemPropertiesClass = Class.forName("android.os.SystemProperties");
        }
        catch (ClassNotFoundException e) {
            Log.w((String)TAG, (String)"Cannot find android.os.SystemProperties: ", (Throwable)e);
            return null;
        }
        try {
            getMethod = systemPropertiesClass.getMethod("get", String.class);
        }
        catch (NoSuchMethodException e) {
            Log.w((String)TAG, (String)"Cannot find SystemProperties.get(): ", (Throwable)e);
            return null;
        }
        try {
            Object[] params = new Object[]{propertyName};
            String value = (String)getMethod.invoke(systemPropertiesClass, params);
            return TextUtils.isEmpty((CharSequence)value) ? null : value;
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Failed to invoke SystemProperties.get(): ", (Throwable)e);
            return null;
        }
    }

    public static Bitmap drawableToBitmap(@NonNull Drawable drawable2) {
        BitmapDrawable bitmapDrawable;
        if (drawable2 instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable2).getBitmap() != null) {
            return bitmapDrawable.getBitmap();
        }
        Bitmap bitmap = drawable2.getIntrinsicWidth() <= 0 || drawable2.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    public static int getAttr(@NonNull Context context, int attr2, int fallbackAttr) {
        TypedValue value = new TypedValue();
        context.getTheme().resolveAttribute(attr2, value, true);
        if (value.resourceId != 0) {
            return attr2;
        }
        return fallbackAttr;
    }

    public static String charSequenceToString(@Nullable CharSequence charSequence) {
        return charSequence == null ? null : charSequence.toString();
    }

    public static <T, U> List<U> convertList(List<T> list, Function<T, U> f) {
        if (list == null) {
            return null;
        }
        ArrayList<U> result = new ArrayList<U>();
        for (T item : list) {
            result.add(f.apply(item));
        }
        return result;
    }

    public static void makeAllViewsUxRestricted(@Nullable View view, boolean restricted) {
        if (view == null) {
            return;
        }
        CarUiUtils.initializeRestrictedState(view);
        CarUiUtils.applyDrawableStatesToAllViews(view, (int[])(restricted ? sRestrictedState : null), null);
    }

    public static void makeAllViewsEnabled(@Nullable View view, boolean enabled) {
        int[] nArray;
        int[] statesToAdd;
        int[] nArray2;
        if (view == null) {
            return;
        }
        CarUiUtils.initializeRestrictedState(view);
        if (enabled) {
            int[] nArray3 = new int[1];
            nArray2 = nArray3;
            nArray3[0] = 16842910;
        } else {
            nArray2 = statesToAdd = null;
        }
        if (enabled) {
            nArray = null;
        } else {
            int[] nArray4 = new int[1];
            nArray = nArray4;
            nArray4[0] = 16842910;
        }
        int[] statesToRemove = nArray;
        CarUiUtils.applyDrawableStatesToAllViews(view, statesToAdd, statesToRemove);
    }

    public static void makeAllViewsEnabledAndUxRestricted(@Nullable View view, boolean enabled, boolean restricted) {
        int[] nArray;
        if (view == null) {
            return;
        }
        CarUiUtils.initializeRestrictedState(view);
        int[] statesToAdd = null;
        if (enabled) {
            if (restricted) {
                statesToAdd = new int[sRestrictedState.length + 1];
                statesToAdd[0] = 16842910;
                System.arraycopy(sRestrictedState, 0, statesToAdd, 1, sRestrictedState.length);
            } else {
                statesToAdd = new int[]{16842910};
            }
        } else if (restricted) {
            statesToAdd = sRestrictedState;
        }
        if (enabled) {
            nArray = null;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 16842910;
        }
        int[] statesToRemove = nArray;
        CarUiUtils.applyDrawableStatesToAllViews(view, statesToAdd, statesToRemove);
    }

    public static void applyDrawableStatesToAllViews(@NonNull View view, int[] statesToAdd, int[] statesToRemove) {
        if (view instanceof DrawableStateView) {
            ((DrawableStateView)view).setExtraDrawableState(statesToAdd, statesToRemove);
        }
        if (view instanceof ViewGroup) {
            ViewGroup vg = (ViewGroup)view;
            for (int i = 0; i < vg.getChildCount(); ++i) {
                CarUiUtils.applyDrawableStatesToAllViews(vg.getChildAt(i), statesToAdd, statesToRemove);
            }
        }
    }

    private static void initializeRestrictedState(@NonNull View view) {
        if (sRestrictedState != null) {
            return;
        }
        int androidStateUxRestricted = view.getResources().getIdentifier("state_ux_restricted", "attr", "android");
        sRestrictedState = androidStateUxRestricted == 0 ? new int[]{R.attr.state_ux_restricted} : new int[]{R.attr.state_ux_restricted, androidStateUxRestricted};
    }

    public static float dpToPixel(@NonNull Resources res, int dp) {
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)res.getDisplayMetrics());
    }

    public static Bitmap scaleBitmapAndKeepRatio(@NonNull Bitmap srcBmp, int reqWidthInPixels, int reqHeightInPixels) {
        return Bitmap.createScaledBitmap((Bitmap)srcBmp, (int)reqWidthInPixels, (int)reqHeightInPixels, (boolean)true);
    }

    public static byte[] getBytesFromBitmap(Bitmap bitmap) {
        byte[] result = null;
        if (bitmap != null) {
            try {
                Parcel parcel = Parcel.obtain();
                bitmap.writeToParcel(parcel, 0);
                byte[] bytes = parcel.marshall();
                parcel.recycle();
                result = bytes;
            }
            catch (RuntimeException e) {
                Log.e((String)TAG, (String)"failed to write bitmap", (Throwable)e);
            }
        }
        return result;
    }

    public static Context unwrapContext(Context context) {
        while (!(context instanceof Activity) && context instanceof ContextWrapper) {
            context = ((ContextWrapper)context).getBaseContext();
        }
        return context;
    }

    public static DisplayMetrics getDeviceDisplayMetrics(@NonNull Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        try {
            if (Build.VERSION.SDK_INT >= 30 && context.getDisplay() != null) {
                context.getDisplay().getRealMetrics(displayMetrics);
                return displayMetrics;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        WindowManager wm = (WindowManager)context.getSystemService(WindowManager.class);
        wm.getDefaultDisplay().getRealMetrics(displayMetrics);
        return displayMetrics;
    }

    public static String getAppPackageName(@NonNull Context context) {
        SparseArray<String> r = CarUiUtils.getAssignedPackageIdentifiers(context.getAssets());
        int n = r.size();
        for (int i = 0; i < n; ++i) {
            int id2 = r.keyAt(i);
            if (id2 != 127) continue;
            String packageName = (String)r.valueAt(i);
            if (context.getResources().getIdentifier("car_ui_plugin_package_provider_authority_name", "string", packageName) == 0) continue;
            return packageName;
        }
        return context.getPackageName();
    }

    private static SparseArray<String> getAssignedPackageIdentifiers(AssetManager am) {
        Throwable cause;
        Class<?> rClazz = am.getClass();
        try {
            Method callback = rClazz.getMethod("getAssignedPackageIdentifiers", new Class[0]);
            Object invoke = callback.invoke((Object)am, new Object[0]);
            return (SparseArray)invoke;
        }
        catch (NoSuchMethodException e) {
            return new SparseArray();
        }
        catch (IllegalAccessException e) {
            cause = e;
        }
        catch (InvocationTargetException e) {
            cause = e.getCause();
        }
        throw new RuntimeException("Failed to find R classes ", cause);
    }
}

