/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.utils;

import android.app.Activity;
import android.app.Application;
import android.car.Car;
import android.car.drivingstate.CarUxRestrictions;
import android.car.drivingstate.CarUxRestrictionsManager;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.android.car.ui.R;
import com.android.car.ui.utils.CarUiUtils;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class CarUxRestrictionsUtil {
    private static final String TAG = "CarUxRestrictionsUtil";
    private static final Map<Context, CarUxRestrictionsUtil> sContextToUtilMap = new WeakHashMap<Context, CarUxRestrictionsUtil>();
    @NonNull
    private CarUxRestrictions mCarUxRestrictions = CarUxRestrictionsUtil.getDefaultRestrictions();
    private Car mCar;
    private final Set<OnUxRestrictionsChangedListener> mObservers = Collections.newSetFromMap(new WeakHashMap());
    private final CarUxRestrictionsManager.OnUxRestrictionsChangedListener mListener = carUxRestrictions -> {
        this.mCarUxRestrictions = carUxRestrictions == null ? CarUxRestrictionsUtil.getDefaultRestrictions() : carUxRestrictions;
        for (OnUxRestrictionsChangedListener observer : this.mObservers) {
            observer.onRestrictionsChanged(this.mCarUxRestrictions);
        }
    };

    private CarUxRestrictionsUtil(@NonNull Context context) {
        try {
            if (Build.VERSION.SDK_INT >= 30) {
                Car.createCar((Context)context, null, (long)0L, (car, ready) -> {
                    if (ready) {
                        this.mCar = car;
                        this.registerCarUxRestrictionsListener(this.mListener);
                    } else {
                        Log.w((String)TAG, (String)"Car service disconnected, assuming fully restricted uxr");
                        this.mListener.onUxRestrictionsChanged(null);
                    }
                });
            } else {
                this.mCar = Car.createCar((Context)context);
                this.registerCarUxRestrictionsListener(this.mListener);
            }
        }
        catch (RuntimeException e) {
            Log.w((String)TAG, (String)"Unable to connect to car service, assuming unrestricted", (Throwable)e);
            this.mListener.onUxRestrictionsChanged(new CarUxRestrictions.Builder(false, 0, 0L).build());
        }
    }

    @NonNull
    private static CarUxRestrictions getDefaultRestrictions() {
        return new CarUxRestrictions.Builder(true, 511, 0L).build();
    }

    @NonNull
    public static CarUxRestrictionsUtil getInstance(@NonNull Context context) {
        CarUxRestrictionsUtil util = sContextToUtilMap.get(context);
        if (util != null) {
            return util;
        }
        util = new CarUxRestrictionsUtil(context);
        sContextToUtilMap.put(context, util);
        Activity activity = CarUiUtils.getActivity(context);
        if (activity == null) {
            return util;
        }
        if (Build.VERSION.SDK_INT >= 29) {
            activity.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

                public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
                }

                public void onActivityStarted(@NonNull Activity activity) {
                }

                public void onActivityResumed(@NonNull Activity activity) {
                }

                public void onActivityPaused(@NonNull Activity activity) {
                }

                public void onActivityStopped(@NonNull Activity activity) {
                }

                public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
                }

                public void onActivityDestroyed(@NonNull Activity activity) {
                    CarUxRestrictionsUtil util = (CarUxRestrictionsUtil)sContextToUtilMap.get(activity);
                    if (util != null && util.mCar != null) {
                        util.mCar.disconnect();
                    }
                }
            });
        }
        return util;
    }

    public void register(OnUxRestrictionsChangedListener listener) {
        this.mObservers.add(listener);
        listener.onRestrictionsChanged(this.mCarUxRestrictions);
    }

    public void unregister(OnUxRestrictionsChangedListener listener) {
        this.mObservers.remove(listener);
    }

    @NonNull
    public CarUxRestrictions getCurrentRestrictions() {
        return this.mCarUxRestrictions;
    }

    public static boolean isRestricted(int restrictionFlags, @Nullable CarUxRestrictions uxr) {
        return uxr == null || (uxr.getActiveRestrictions() & restrictionFlags) != 0;
    }

    public static String complyString(Context context, String str, CarUxRestrictions uxr) {
        if (CarUxRestrictionsUtil.isRestricted(4, uxr)) {
            int maxLength;
            int n = maxLength = uxr == null ? context.getResources().getInteger(R.integer.car_ui_default_max_string_length) : uxr.getMaxRestrictedStringLength();
            if (str.length() > maxLength) {
                return str.substring(0, maxLength) + context.getString(R.string.car_ui_ellipsis);
            }
        }
        return str;
    }

    @VisibleForTesting
    public void setUxRestrictions(CarUxRestrictions carUxRestrictions) {
        this.mCarUxRestrictions = carUxRestrictions;
        this.mListener.onUxRestrictionsChanged(this.mCarUxRestrictions);
    }

    public void disconnect() {
        if (this.mCar != null) {
            this.mCar.disconnect();
        }
    }

    private void registerCarUxRestrictionsListener(@NonNull CarUxRestrictionsManager.OnUxRestrictionsChangedListener listener) {
        try {
            CarUxRestrictionsManager carUxRestrictionsManager = (CarUxRestrictionsManager)this.mCar.getCarManager("uxrestriction");
            carUxRestrictionsManager.registerListener(listener);
            listener.onUxRestrictionsChanged(carUxRestrictionsManager.getCurrentCarUxRestrictions());
        }
        catch (NullPointerException e) {
            Log.e((String)TAG, (String)"Car not connected", (Throwable)e);
        }
    }

    public static interface OnUxRestrictionsChangedListener {
        public void onRestrictionsChanged(@NonNull CarUxRestrictions var1);
    }
}

