/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.utils;

import android.annotation.TargetApi;
import android.text.TextUtils;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;

public final class DirectManipulationHelper {
    @VisibleForTesting
    public static final String DIRECT_MANIPULATION = "com.android.car.ui.utils.DIRECT_MANIPULATION";

    private DirectManipulationHelper() {
    }

    public static boolean enableDirectManipulationMode(@NonNull View view, boolean enable) {
        AccessibilityManager accessibilityManager = (AccessibilityManager)view.getContext().getSystemService("accessibility");
        if (accessibilityManager == null || !accessibilityManager.isEnabled()) {
            return false;
        }
        AccessibilityEvent event = AccessibilityEvent.obtain();
        event.setClassName((CharSequence)DIRECT_MANIPULATION);
        event.setSource(view);
        event.setEventType(enable ? 32768 : 65536);
        accessibilityManager.sendAccessibilityEvent(event);
        return true;
    }

    public static boolean isDirectManipulation(@NonNull AccessibilityEvent event) {
        return TextUtils.equals((CharSequence)DIRECT_MANIPULATION, (CharSequence)event.getClassName());
    }

    @TargetApi(value=30)
    public static boolean supportRotateDirectly(@NonNull AccessibilityNodeInfo node) {
        return TextUtils.equals((CharSequence)DIRECT_MANIPULATION, (CharSequence)node.getContentDescription());
    }

    @TargetApi(value=30)
    public static void setSupportsRotateDirectly(@NonNull View view, boolean enable) {
        view.setContentDescription((CharSequence)(enable ? DIRECT_MANIPULATION : null));
    }

    @Deprecated
    public static boolean supportDirectManipulation(@NonNull AccessibilityNodeInfo node) {
        return DirectManipulationHelper.supportRotateDirectly(node);
    }

    @Deprecated
    public static void setSupportsDirectManipulation(@NonNull View view, boolean enable) {
        DirectManipulationHelper.setSupportsRotateDirectly(view, enable);
    }
}

