/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.utils;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Rect;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.android.car.ui.FocusParkingView;
import com.android.car.ui.IFocusArea;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.function.Predicate;

public final class ViewUtils {
    private static final String TAG = "ViewUtils";
    @VisibleForTesting
    static final int RESTORE_FOCUS_RETRY_DELAY_MS = 3000;
    @VisibleForTesting
    static final int NO_FOCUS = 1;
    @VisibleForTesting
    static final int SCROLLABLE_CONTAINER_FOCUS = 2;
    @VisibleForTesting
    static final int REGULAR_FOCUS = 3;
    @VisibleForTesting
    static final int SELECTED_FOCUS = 4;
    @VisibleForTesting
    static final int IMPLICIT_DEFAULT_FOCUS = 5;
    @VisibleForTesting
    static final int DEFAULT_FOCUS = 6;
    @VisibleForTesting
    static final int FOCUSED_BY_DEFAULT = 7;

    private ViewUtils() {
    }

    public static boolean isInMultiWindowMode(@NonNull View view) {
        Context context = view.getContext();
        Activity activity = ViewUtils.findActivity(context);
        return activity != null && activity.isInMultiWindowMode();
    }

    @Nullable
    public static Activity findActivity(@Nullable Context context) {
        while (context instanceof ContextWrapper && !(context instanceof Activity)) {
            context = ((ContextWrapper)context).getBaseContext();
        }
        if (context instanceof Activity) {
            return (Activity)context;
        }
        return null;
    }

    public static boolean isDescendant(@Nullable View descendant, @Nullable View view) {
        if (descendant == null || view == null) {
            return false;
        }
        for (ViewParent parent = descendant.getParent(); parent != null; parent = parent.getParent()) {
            if (parent != view) continue;
            return true;
        }
        return false;
    }

    public static boolean hideFocus(@NonNull View root) {
        FocusParkingView fpv = ViewUtils.findFocusParkingView(root);
        if (fpv == null) {
            return false;
        }
        if (fpv.isFocused()) {
            return true;
        }
        return fpv.performAccessibilityAction(1, null);
    }

    @VisibleForTesting
    public static FocusParkingView findFocusParkingView(@NonNull View root) {
        return (FocusParkingView)ViewUtils.depthFirstSearch(root, v -> v instanceof FocusParkingView, null);
    }

    @Nullable
    public static IFocusArea getAncestorFocusArea(@NonNull View view) {
        for (ViewParent parent = view.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof IFocusArea)) continue;
            return (IFocusArea)parent;
        }
        return null;
    }

    @Nullable
    public static ViewGroup getAncestorScrollableContainer(@Nullable View view) {
        if (view == null) {
            return null;
        }
        for (ViewParent parent = view.getParent(); parent != null && parent instanceof ViewGroup && !(parent instanceof IFocusArea); parent = parent.getParent()) {
            ViewGroup viewGroup = (ViewGroup)parent;
            if (!ViewUtils.isScrollableContainer((View)viewGroup)) continue;
            return viewGroup;
        }
        return null;
    }

    public static boolean requestFocus(@Nullable View view) {
        if (view == null || !ViewUtils.canTakeFocus(view)) {
            return false;
        }
        if (view.isFocused()) {
            return true;
        }
        return view.performAccessibilityAction(1, null);
    }

    public static boolean adjustFocus(@NonNull View root, @Nullable View currentFocus) {
        int currentLevel = ViewUtils.getFocusLevel(currentFocus);
        return ViewUtils.adjustFocus(root, currentLevel, null, false);
    }

    public static boolean adjustFocusImmediately(@NonNull View root, @Nullable View currentFocus) {
        int currentLevel = ViewUtils.getFocusLevel(currentFocus);
        return ViewUtils.adjustFocus(root, currentLevel, null, false, false);
    }

    public static boolean adjustFocusImmediately(@NonNull View root, @Nullable View cachedFocusedView, boolean defaultFocusOverridesHistory) {
        return ViewUtils.adjustFocus(root, 1, cachedFocusedView, defaultFocusOverridesHistory, false);
    }

    public static boolean initFocus(@NonNull View root, @Nullable View currentFocus) {
        int currentLevel = ViewUtils.getFocusLevel(currentFocus);
        if (currentLevel >= 3) {
            return false;
        }
        return ViewUtils.adjustFocus(root, currentLevel, null, false);
    }

    @VisibleForTesting
    static boolean adjustFocus(@NonNull View root, int currentLevel) {
        return ViewUtils.adjustFocus(root, currentLevel, null, false);
    }

    public static boolean adjustFocus(@NonNull View root, @Nullable View cachedFocusedView, boolean defaultFocusOverridesHistory) {
        return ViewUtils.adjustFocus(root, 1, cachedFocusedView, defaultFocusOverridesHistory);
    }

    private static boolean adjustFocus(@NonNull View root, int currentLevel, @Nullable View cachedFocusedView, boolean defaultFocusOverridesHistory) {
        return ViewUtils.adjustFocus(root, currentLevel, cachedFocusedView, defaultFocusOverridesHistory, true);
    }

    private static boolean adjustFocus(@NonNull View root, int currentLevel, @Nullable View cachedFocusedView, boolean defaultFocusOverridesHistory, boolean delayed) {
        LazyLayoutView lazyLayoutView;
        if (!defaultFocusOverridesHistory && ViewUtils.requestFocus(cachedFocusedView)) {
            return true;
        }
        if (currentLevel < 7 && ViewUtils.focusOnFocusedByDefaultView(root)) {
            return true;
        }
        if (currentLevel < 6 && ViewUtils.focusOnDefaultFocusView(root)) {
            return true;
        }
        if (currentLevel < 5 && ViewUtils.focusOnImplicitDefaultFocusView(root)) {
            return true;
        }
        if (currentLevel < 4 && ViewUtils.focusOnSelectedView(root)) {
            return true;
        }
        if (delayed && currentLevel < 5 && (lazyLayoutView = ViewUtils.findLazyLayoutView(root)) != null && !lazyLayoutView.isLayoutCompleted()) {
            ViewUtils.initFocusDelayed(lazyLayoutView);
            return false;
        }
        if (defaultFocusOverridesHistory && ViewUtils.requestFocus(cachedFocusedView)) {
            return true;
        }
        if (currentLevel < 3 && ViewUtils.focusOnFirstRegularView(root)) {
            return true;
        }
        if (currentLevel < 2) {
            return ViewUtils.focusOnScrollableContainer(root);
        }
        return false;
    }

    public static void initFocus(@NonNull LazyLayoutView lazyLayoutView) {
        if (ViewUtils.initFocusImmediately(lazyLayoutView)) {
            return;
        }
        ViewUtils.initFocusDelayed(lazyLayoutView);
    }

    @VisibleForTesting
    static void initFocusDelayed(@NonNull LazyLayoutView lazyLayoutView) {
        if (!(lazyLayoutView instanceof View)) {
            return;
        }
        View lazyView = (View)lazyLayoutView;
        Runnable[] onLayoutCompleteListener = new Runnable[1];
        Runnable[] delayedTask = new Runnable[1];
        ViewTreeObserver.OnGlobalLayoutListener[] onGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener[1];
        if (!lazyLayoutView.isLayoutCompleted()) {
            Log.v((String)TAG, (String)("The lazyLayoutView has not completed layout: " + lazyLayoutView));
            onLayoutCompleteListener[0] = () -> {
                Log.v((String)TAG, (String)("The lazyLayoutView completed layout: " + lazyLayoutView));
                if (ViewUtils.initFocusImmediately(lazyLayoutView)) {
                    Log.v((String)TAG, (String)"Focus restored after lazyLayoutView completed layout");
                    ViewUtils.removeCallbacks(lazyLayoutView, onGlobalLayoutListener, onLayoutCompleteListener, delayedTask);
                }
            };
            lazyLayoutView.addOnLayoutCompleteListener(onLayoutCompleteListener[0]);
        }
        if (!lazyView.isShown() || ViewUtils.findImplicitDefaultFocusView(lazyView) == null) {
            if (!lazyView.isShown()) {
                Log.d((String)TAG, (String)("The lazyLayoutView is not shown: " + lazyLayoutView));
            } else {
                Log.d((String)TAG, (String)("The lazyLayoutView is shown and has completed layout, but has no focusable descendants: " + lazyLayoutView));
            }
            onGlobalLayoutListener[0] = () -> {
                Log.d((String)TAG, (String)"onGlobalLayoutListener is called");
                if (lazyView.isShown()) {
                    Log.d((String)TAG, (String)"The lazyLayoutView is shown");
                    View implicitDefaultFocus = ViewUtils.findImplicitDefaultFocusView(lazyView);
                    Log.d((String)TAG, (String)("The implicitDefaultFocus of the lazyLayoutView is " + implicitDefaultFocus));
                    if (ViewUtils.requestFocus(implicitDefaultFocus)) {
                        Log.v((String)TAG, (String)"Focus restored after showing lazyLayoutView");
                        ViewUtils.removeCallbacks(lazyLayoutView, onGlobalLayoutListener, onLayoutCompleteListener, delayedTask);
                    }
                }
            };
            lazyView.getViewTreeObserver().addOnGlobalLayoutListener(onGlobalLayoutListener[0]);
        }
        delayedTask[0] = () -> {
            Log.d((String)TAG, (String)"Starting delayedTask");
            ViewUtils.removeCallbacks(lazyLayoutView, onGlobalLayoutListener, onLayoutCompleteListener, delayedTask);
            if (!ViewUtils.hasVisibleFocusInRoot(lazyView)) {
                if (lazyLayoutView.isLayoutCompleted() && lazyView.isShown()) {
                    Log.d((String)TAG, (String)"Last attempt to restore focus inside the lazyLayoutView");
                    if (ViewUtils.initFocusImmediately(lazyLayoutView)) {
                        Log.d((String)TAG, (String)"Restored focus inside the lazyLayoutView");
                        return;
                    }
                }
                ViewUtils.adjustFocus(lazyView.getRootView(), 1, null, false, false);
            }
        };
        lazyView.postDelayed(delayedTask[0], 3000L);
    }

    private static void removeCallbacks(@NonNull LazyLayoutView lazyLayoutView, ViewTreeObserver.OnGlobalLayoutListener[] onGlobalLayoutListener, Runnable[] onLayoutCompleteListener, Runnable[] delayedTask) {
        lazyLayoutView.removeOnLayoutCompleteListener(onLayoutCompleteListener[0]);
        if (!(lazyLayoutView instanceof View)) {
            return;
        }
        View lazyView = (View)lazyLayoutView;
        lazyView.removeCallbacks(delayedTask[0]);
        lazyView.getViewTreeObserver().removeOnGlobalLayoutListener(onGlobalLayoutListener[0]);
    }

    private static boolean initFocusImmediately(@NonNull LazyLayoutView lazyLayoutView) {
        if (!(lazyLayoutView instanceof View)) {
            return false;
        }
        View lazyView = (View)lazyLayoutView;
        if (ViewUtils.hasVisibleFocusInRoot(lazyView)) {
            return true;
        }
        return ViewUtils.adjustFocusImmediately(lazyView, null);
    }

    private static boolean hasVisibleFocusInRoot(@NonNull View view) {
        View focus = view.getRootView().findFocus();
        return focus != null && !(focus instanceof FocusParkingView);
    }

    @VisibleForTesting
    static int getFocusLevel(@Nullable View view) {
        if (view == null || view instanceof FocusParkingView || !view.isShown()) {
            return 1;
        }
        if (view.isFocusedByDefault()) {
            return 7;
        }
        if (ViewUtils.isDefaultFocus(view)) {
            return 6;
        }
        if (ViewUtils.isImplicitDefaultFocusView(view)) {
            return 5;
        }
        if (view.isSelected()) {
            return 4;
        }
        if (ViewUtils.isScrollableContainer(view)) {
            return 2;
        }
        return 3;
    }

    private static boolean isDefaultFocus(@NonNull View view) {
        IFocusArea parent = ViewUtils.getAncestorFocusArea(view);
        return parent != null && view == parent.getDefaultFocusView();
    }

    @VisibleForTesting
    static boolean isImplicitDefaultFocusView(@NonNull View view) {
        ViewGroup rotaryContainer = null;
        for (ViewParent parent = view.getParent(); parent != null && parent instanceof ViewGroup; parent = parent.getParent()) {
            ViewGroup viewGroup = (ViewGroup)parent;
            if (!ViewUtils.isRotaryContainer((View)viewGroup)) continue;
            rotaryContainer = viewGroup;
            break;
        }
        if (rotaryContainer == null) {
            return false;
        }
        return ViewUtils.findFirstSelectedFocusableDescendant(rotaryContainer) == view || ViewUtils.findFirstFocusableDescendant(rotaryContainer) == view;
    }

    private static boolean isRotaryContainer(@NonNull View view) {
        CharSequence contentDescription = view.getContentDescription();
        return TextUtils.equals((CharSequence)contentDescription, (CharSequence)"com.android.car.ui.utils.ROTARY_CONTAINER") || TextUtils.equals((CharSequence)contentDescription, (CharSequence)"com.android.car.ui.utils.VERTICALLY_SCROLLABLE") || TextUtils.equals((CharSequence)contentDescription, (CharSequence)"com.android.car.ui.utils.HORIZONTALLY_SCROLLABLE");
    }

    private static boolean isScrollableContainer(@NonNull View view) {
        CharSequence contentDescription = view.getContentDescription();
        return TextUtils.equals((CharSequence)contentDescription, (CharSequence)"com.android.car.ui.utils.VERTICALLY_SCROLLABLE") || TextUtils.equals((CharSequence)contentDescription, (CharSequence)"com.android.car.ui.utils.HORIZONTALLY_SCROLLABLE");
    }

    private static boolean isFocusDelegatingContainer(@NonNull View view) {
        CharSequence contentDescription = view.getContentDescription();
        return TextUtils.equals((CharSequence)contentDescription, (CharSequence)"com.android.car.ui.utils.FOCUS_DELEGATING_CONTAINER");
    }

    private static boolean focusOnDefaultFocusView(@NonNull View root) {
        View defaultFocus = ViewUtils.findDefaultFocusView(root);
        return ViewUtils.requestFocus(defaultFocus);
    }

    private static boolean focusOnFocusedByDefaultView(@NonNull View root) {
        View focusedByDefault = ViewUtils.findFocusedByDefaultView(root);
        return ViewUtils.requestFocus(focusedByDefault);
    }

    private static boolean focusOnImplicitDefaultFocusView(@NonNull View root) {
        View implicitDefaultFocus = ViewUtils.findImplicitDefaultFocusView(root);
        return ViewUtils.requestFocus(implicitDefaultFocus);
    }

    private static boolean focusOnSelectedView(@NonNull View root) {
        View selectedView = ViewUtils.findFirstSelectedFocusableDescendant(root);
        return ViewUtils.requestFocus(selectedView);
    }

    public static boolean focusOnFirstRegularView(@NonNull View root) {
        View focusedView = ViewUtils.depthFirstSearch(root, v -> v != root && !ViewUtils.isScrollableContainer(v) && ViewUtils.canTakeFocus(v) && ViewUtils.requestFocus(v), v -> !v.isShown());
        return focusedView != null;
    }

    private static boolean focusOnScrollableContainer(@NonNull View root) {
        View focusedView = ViewUtils.depthFirstSearch(root, v -> ViewUtils.isScrollableContainer(v) && ViewUtils.canTakeFocus(v), v -> !v.isShown());
        return ViewUtils.requestFocus(focusedView);
    }

    @Nullable
    private static View findDefaultFocusView(@NonNull View view) {
        if (!view.isShown()) {
            return null;
        }
        if (view instanceof IFocusArea) {
            IFocusArea focusArea = (IFocusArea)view;
            View defaultFocus = focusArea.getDefaultFocusView();
            if (defaultFocus != null && ViewUtils.canTakeFocus(defaultFocus)) {
                return defaultFocus;
            }
        } else if (view instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)view;
            for (int i = 0; i < parent.getChildCount(); ++i) {
                View child = parent.getChildAt(i);
                View defaultFocus = ViewUtils.findDefaultFocusView(child);
                if (defaultFocus == null) continue;
                return defaultFocus;
            }
        }
        return null;
    }

    @VisibleForTesting
    @Nullable
    static View findFocusedByDefaultView(@NonNull View view) {
        return ViewUtils.depthFirstSearch(view, v -> v != view && v.isFocusedByDefault() && ViewUtils.canTakeFocus(v), v -> !v.isShown());
    }

    @VisibleForTesting
    @Nullable
    static View findImplicitDefaultFocusView(@NonNull View view) {
        View rotaryContainer = ViewUtils.findRotaryContainer(view);
        if (rotaryContainer == null) {
            return null;
        }
        View selectedItem = ViewUtils.findFirstSelectedFocusableDescendant(rotaryContainer);
        return selectedItem != null ? selectedItem : ViewUtils.findFirstFocusableDescendant(rotaryContainer);
    }

    @VisibleForTesting
    @Nullable
    static View findFirstFocusableDescendant(@NonNull View view) {
        return ViewUtils.depthFirstSearch(view, v -> v != view && ViewUtils.canTakeFocus(v), v -> !v.isShown());
    }

    @VisibleForTesting
    @Nullable
    static View findFirstSelectedFocusableDescendant(@NonNull View view) {
        return ViewUtils.depthFirstSearch(view, v -> v != view && v.isSelected() && ViewUtils.canTakeFocus(v), v -> !v.isShown());
    }

    @Nullable
    private static View findRotaryContainer(@NonNull View view) {
        return ViewUtils.depthFirstSearch(view, ViewUtils::isRotaryContainer, v -> {
            if (!v.isShown()) {
                return true;
            }
            if (v instanceof LazyLayoutView) {
                LazyLayoutView lazyLayoutView = (LazyLayoutView)v;
                return !lazyLayoutView.isLayoutCompleted();
            }
            return false;
        });
    }

    @Nullable
    private static LazyLayoutView findLazyLayoutView(@NonNull View view) {
        return (LazyLayoutView)ViewUtils.depthFirstSearch(view, v -> v instanceof LazyLayoutView, v -> !v.isShown());
    }

    @Nullable
    private static View depthFirstSearch(@NonNull View view, @NonNull Predicate<View> targetPredicate, @Nullable Predicate<View> skipPredicate) {
        if (skipPredicate != null && skipPredicate.test(view)) {
            return null;
        }
        if (targetPredicate.test(view)) {
            return view;
        }
        if (view instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)view;
            for (int i = 0; i < parent.getChildCount(); ++i) {
                View child = parent.getChildAt(i);
                View target = ViewUtils.depthFirstSearch(child, targetPredicate, skipPredicate);
                if (target == null) continue;
                return target;
            }
        }
        return null;
    }

    private static boolean canTakeFocus(@NonNull View view) {
        boolean focusable = view.isFocusable() || ViewUtils.isFocusDelegatingContainer(view);
        return focusable && view.isEnabled() && view.isShown() && view.getWidth() > 0 && view.getHeight() > 0 && view.isAttachedToWindow() && !(view instanceof FocusParkingView) && (!ViewUtils.isScrollableContainer(view) || ViewUtils.findFirstFocusableDescendant(view) == null);
    }

    public static void setRotaryScrollEnabled(@NonNull View view, boolean isVertical) {
        view.setContentDescription((CharSequence)(isVertical ? "com.android.car.ui.utils.VERTICALLY_SCROLLABLE" : "com.android.car.ui.utils.HORIZONTALLY_SCROLLABLE"));
    }

    private static Rect getBounds(@NonNull View view) {
        int[] loc = new int[2];
        view.getLocationOnScreen(loc);
        return new Rect(loc[0], loc[1], loc[0] + view.getWidth(), loc[1] + view.getHeight());
    }

    public static boolean isCandidate(@NonNull View currentFocus, @NonNull View targetView, int direction) {
        Rect srcRect = ViewUtils.getBounds(currentFocus);
        Rect destRect = ViewUtils.getBounds(targetView);
        switch (direction) {
            case 17: {
                return (srcRect.right > destRect.right || srcRect.left >= destRect.right) && srcRect.left > destRect.left;
            }
            case 66: {
                return (srcRect.left < destRect.left || srcRect.right <= destRect.left) && srcRect.right < destRect.right;
            }
            case 33: {
                return (srcRect.bottom > destRect.bottom || srcRect.top >= destRect.bottom) && srcRect.top > destRect.top;
            }
            case 130: {
                return (srcRect.top < destRect.top || srcRect.bottom <= destRect.top) && srcRect.bottom < destRect.bottom;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    public static interface LazyLayoutView {
        public boolean isLayoutCompleted();

        public void addOnLayoutCompleteListener(@Nullable Runnable var1);

        public void removeOnLayoutCompleteListener(@Nullable Runnable var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface FocusLevel {
    }
}

