/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.uxr;

import android.view.View;
import androidx.annotation.Nullable;
import com.android.car.ui.uxr.DrawableStateView;
import java.util.Arrays;
import java.util.function.Function;

class DrawableStateUtil
implements DrawableStateView {
    private final View mView;
    @Nullable
    private int[] mStateToAdd;
    @Nullable
    private int[] mStateToRemove;

    DrawableStateUtil(View view) {
        this.mView = view;
    }

    public int[] onCreateDrawableState(int extraSpace, Function<Integer, int[]> callSuper) {
        int[] result = this.mStateToAdd == null ? callSuper.apply(extraSpace) : DrawableStateUtil.mergeDrawableStates(callSuper.apply(extraSpace + this.mStateToAdd.length), this.mStateToAdd);
        if (this.mStateToRemove != null && this.mStateToRemove.length != 0) {
            result = Arrays.stream(result).filter(state -> Arrays.stream(this.mStateToRemove).noneMatch(toRemove -> state == toRemove)).toArray();
        }
        return result;
    }

    @Override
    public void setExtraDrawableState(@Nullable int[] stateToAdd, @Nullable int[] stateToRemove) {
        this.mStateToAdd = stateToAdd;
        this.mStateToRemove = stateToRemove;
        this.mView.refreshDrawableState();
    }

    private static int[] mergeDrawableStates(int[] baseState, int[] additionalState) {
        int i;
        for (i = baseState.length - 1; i >= 0 && baseState[i] == 0; --i) {
        }
        System.arraycopy(additionalState, 0, baseState, i + 1, additionalState.length);
        return baseState;
    }
}

