/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.widget;

import android.content.Context;
import android.text.Layout;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.OneShotPreDrawListener;
import com.android.car.ui.CarUiText;
import com.android.car.ui.widget.CarUiTextView;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;

public final class CarUiTextViewImpl
extends CarUiTextView {
    @NonNull
    private List<CarUiText> mText = Collections.emptyList();
    private OneShotPreDrawListener mOneShotPreDrawListener;

    public CarUiTextViewImpl(Context context) {
        super(context);
    }

    public CarUiTextViewImpl(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public CarUiTextViewImpl(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public void setText(@NonNull List<CarUiText> textList) {
        this.mText = Objects.requireNonNull(textList);
        if (this.mOneShotPreDrawListener == null) {
            this.mOneShotPreDrawListener = OneShotPreDrawListener.add((View)this, this::updateText);
        }
        this.setText(CarUiText.combineMultiLine(textList));
    }

    @Override
    public void setText(@NonNull CarUiText text) {
        this.mText = Collections.singletonList(Objects.requireNonNull(text));
        if (this.mOneShotPreDrawListener == null) {
            this.mOneShotPreDrawListener = OneShotPreDrawListener.add((View)this, this::updateText);
        }
        this.setText(text.getPreferredText());
    }

    private void updateText() {
        Objects.requireNonNull(this.mText);
        if (this.getLayout() == null) {
            this.mOneShotPreDrawListener = OneShotPreDrawListener.add((View)this, this::updateText);
            return;
        }
        this.mOneShotPreDrawListener = null;
        if (this.mText.stream().allMatch(line -> line.getMaxLines() == Integer.MAX_VALUE && line.getMaxChars() == Integer.MAX_VALUE)) {
            return;
        }
        SpannableStringBuilder builder = new SpannableStringBuilder();
        String delimiter = "";
        for (int i = 0; i < this.mText.size(); ++i) {
            CarUiText line2 = this.mText.get(i);
            builder.append((CharSequence)delimiter).append(this.getBestVariant(line2));
            delimiter = "\n";
        }
        this.setText((CharSequence)builder);
    }

    private CharSequence getBestVariant(CarUiText text) {
        if (text.getTextVariants().size() > 1) {
            for (CharSequence variant : text.getTextVariants()) {
                if (variant.length() > text.getMaxChars() || !TextUtils.equals((CharSequence)variant, (CharSequence)this.getTruncatedText(variant, text.getMaxLines()))) continue;
                return variant;
            }
        }
        return this.getTruncatedText(text.getPreferredText(), text.getMaxLines());
    }

    private CharSequence getTruncatedText(CharSequence text, int maxLines) {
        Layout layout2 = Objects.requireNonNull(this.getLayout());
        int maxWidth = layout2.getWidth();
        if (maxLines == 1) {
            return TextUtils.ellipsize((CharSequence)text, (TextPaint)this.getPaint(), (float)maxWidth, (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
        }
        int lineCount = 0;
        int index = 0;
        int lastLineStart = 0;
        int length = text.length();
        boolean isTruncationComplete = false;
        while (!isTruncationComplete) {
            int lineBreak;
            lastLineStart = index;
            if ((lineBreak = TextUtils.indexOf((CharSequence)text, (CharSequence)"\n", (int)lastLineStart, (int)(index += this.getPaint().breakText(text, index, length, true, (float)maxWidth, null)))) != -1) {
                index = Math.min(index, lineBreak + 1);
            }
            if (++lineCount == maxLines || index > length - 1) {
                isTruncationComplete = true;
            }
            if (isTruncationComplete || Character.isWhitespace(text.charAt(index)) || index <= 0) continue;
            int offset = 0;
            while (!Character.isWhitespace(text.charAt(index - offset - 1))) {
                if (index - ++offset != lastLineStart && offset < index) continue;
                offset = 0;
                break;
            }
            index -= offset;
        }
        SpannableStringBuilder builder = new SpannableStringBuilder();
        builder.append(text.subSequence(0, lastLineStart));
        Scanner scanner = new Scanner(text.subSequence(lastLineStart, length).toString());
        if (scanner.hasNextLine()) {
            String lastLine = scanner.nextLine();
            builder.append(TextUtils.ellipsize((CharSequence)lastLine, (TextPaint)this.getPaint(), (float)maxWidth, (TextUtils.TruncateAt)TextUtils.TruncateAt.END));
            if (text instanceof Spanned) {
                TextUtils.copySpansFrom((Spanned)((Spanned)text), (int)0, (int)builder.length(), Object.class, (Spannable)builder, (int)0);
            }
        }
        return builder;
    }
}

