/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.uxr;

import android.content.Context;
import androidx.annotation.IdRes;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.annotation.XmlRes;
import com.android.car.uxr.CarUxRestrictionsAppConfigParser;
import java.util.Map;

public class CarUxRestrictionsAppConfig {
    private final Map<Integer, ListConfig> mMapping;
    private static CarUxRestrictionsAppConfig sInstance;

    CarUxRestrictionsAppConfig(Map<Integer, ListConfig> mapping) {
        this.mMapping = mapping;
    }

    public static CarUxRestrictionsAppConfig getInstance(Context context, @XmlRes int xmlRes) {
        if (sInstance == null) {
            sInstance = CarUxRestrictionsAppConfigParser.parseConfig(context, xmlRes);
        }
        return sInstance;
    }

    @Nullable
    public static Integer getContentLimit(Context context, @XmlRes int xmlRes, @IdRes int resId) {
        CarUxRestrictionsAppConfig uxr = CarUxRestrictionsAppConfig.getInstance(context, xmlRes);
        ListConfig cfg = uxr.getMapping().get(resId);
        return cfg != null ? cfg.getContentLimit() : null;
    }

    public Map<Integer, ListConfig> getMapping() {
        return this.mMapping;
    }

    public static class ListConfig {
        @IdRes
        private final int mId;
        private final Integer mContentLimit;
        @StringRes
        private final Integer mScrollingLimitedMessageResId;

        private ListConfig(@IdRes int id, @Nullable Integer contentLimit, @StringRes Integer scrollingLimitedMessageResId) {
            this.mId = id;
            this.mContentLimit = contentLimit;
            this.mScrollingLimitedMessageResId = scrollingLimitedMessageResId;
        }

        public static Builder builder(@IdRes int id) {
            return new Builder(id);
        }

        @IdRes
        public int getId() {
            return this.mId;
        }

        @Nullable
        public Integer getContentLimit() {
            return this.mContentLimit;
        }

        @Nullable
        @StringRes
        public Integer getScrollingLimitedMessageResId() {
            return this.mScrollingLimitedMessageResId;
        }

        public static class Builder {
            @IdRes
            private final int mId;
            private Integer mContentLimit;
            @StringRes
            private Integer mScrollingLimitedMessageResId;

            private Builder(@IdRes int id) {
                this.mId = id;
            }

            public Builder setContentLimit(int contentLimit) {
                this.mContentLimit = contentLimit;
                return this;
            }

            public Builder setScrollingLimitedMessageResId(@StringRes int scrollingLimitedMessageResId) {
                this.mScrollingLimitedMessageResId = scrollingLimitedMessageResId;
                return this;
            }

            public ListConfig build() {
                return new ListConfig(this.mId, this.mContentLimit, this.mScrollingLimitedMessageResId);
            }
        }
    }
}

