/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.uxr;

import android.content.Context;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import androidx.annotation.XmlRes;
import com.android.car.uxr.CarUxRestrictionsAppConfig;
import com.android.car.uxr.R;
import java.io.IOException;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class CarUxRestrictionsAppConfigParser {
    private static final String TAG = "UxrAppConfigParser";

    static CarUxRestrictionsAppConfig parseConfig(Context context, @XmlRes int xmlRes) {
        CarUxRestrictionsAppConfig carUxRestrictionsAppConfig;
        block9: {
            XmlResourceParser parser = context.getResources().getXml(xmlRes);
            try {
                AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
                HashMap<Integer, CarUxRestrictionsAppConfig.ListConfig> mapping = new HashMap<Integer, CarUxRestrictionsAppConfig.ListConfig>();
                parser.next();
                parser.next();
                parser.require(2, null, "Mapping");
                while (parser.next() != 3) {
                    CarUxRestrictionsAppConfig.ListConfig listConfig = CarUxRestrictionsAppConfigParser.parseListConfigItem(context, parser, attrs);
                    mapping.put(listConfig.getId(), listConfig);
                }
                carUxRestrictionsAppConfig = new CarUxRestrictionsAppConfig(mapping);
                if (parser == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | XmlPullParserException e) {
                    throw new RuntimeException("Unable to parse CarUxRestrictionsAppConfig", e);
                }
            }
            parser.close();
        }
        return carUxRestrictionsAppConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CarUxRestrictionsAppConfig.ListConfig parseListConfigItem(Context context, XmlResourceParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        parser.require(2, null, "ListConfig");
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CarUxRestrictionsAppConfig_ListConfig);
        try {
            int id = a.getResourceId(R.styleable.CarUxRestrictionsAppConfig_ListConfig_id, -1);
            if (id == -1) {
                throw new IllegalStateException("Id field is required");
            }
            boolean messageExists = a.hasValue(R.styleable.CarUxRestrictionsAppConfig_ListConfig_message);
            int messageResId = a.getResourceId(R.styleable.CarUxRestrictionsAppConfig_ListConfig_message, -1);
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)(messageExists ? "message field is set to " + messageResId : "message field not specified"));
            }
            boolean maxLengthExists = a.hasValue(R.styleable.CarUxRestrictionsAppConfig_ListConfig_maxLength);
            int maxLengthInt = a.getInt(R.styleable.CarUxRestrictionsAppConfig_ListConfig_maxLength, 0);
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)(maxLengthExists ? "maxLength field is set to " + maxLengthInt : "maxLength field not specified"));
            }
            parser.next();
            parser.require(3, null, "ListConfig");
            CarUxRestrictionsAppConfig.ListConfig.Builder builder = CarUxRestrictionsAppConfig.ListConfig.builder(id);
            if (maxLengthExists) {
                builder.setContentLimit(maxLengthInt);
            }
            if (messageExists) {
                builder.setScrollingLimitedMessageResId(messageResId);
            }
            CarUxRestrictionsAppConfig.ListConfig listConfig = builder.build();
            return listConfig;
        }
        finally {
            a.recycle();
        }
    }
}

