/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.uxr;

import android.car.drivingstate.CarUxRestrictions;
import android.content.Context;
import android.util.Log;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.XmlRes;
import com.android.car.ui.recyclerview.ContentLimiting;
import com.android.car.ui.utils.CarUxRestrictionsUtil;
import com.android.car.uxr.CarUxRestrictionsAppConfig;
import com.android.car.uxr.UxrContentLimiter;

public class UxrContentLimiterImpl
implements UxrContentLimiter {
    private ContentLimiting mAdapter;
    private CarUxRestrictionsAppConfig.ListConfig mListConfig;
    private final CarUxRestrictionsUtil mCarUxRestrictionsUtil;
    private final CarUxRestrictionsAppConfig mCarUxRestrictionsAppConfig;
    private final CarUxRestrictionsUtil.OnUxRestrictionsChangedListener mListener = new Listener();

    public UxrContentLimiterImpl(Context context, @XmlRes int xmlRes) {
        this.mCarUxRestrictionsUtil = CarUxRestrictionsUtil.getInstance((Context)context);
        this.mCarUxRestrictionsAppConfig = CarUxRestrictionsAppConfig.getInstance(context, xmlRes);
    }

    @Override
    public void setAdapter(ContentLimiting adapter) {
        this.mAdapter = adapter;
        int key = this.mAdapter.getConfigurationId();
        if (this.mCarUxRestrictionsAppConfig.getMapping().containsKey(key)) {
            this.mListConfig = this.mCarUxRestrictionsAppConfig.getMapping().get(key);
            Integer overriddenMessageResId = this.mListConfig.getScrollingLimitedMessageResId();
            if (overriddenMessageResId != null) {
                this.mAdapter.setScrollingLimitedMessageResId(overriddenMessageResId.intValue());
            }
        }
    }

    public void start() {
        this.mCarUxRestrictionsUtil.register(this.mListener);
    }

    public void stop() {
        this.mCarUxRestrictionsUtil.unregister(this.mListener);
    }

    private class Listener
    implements CarUxRestrictionsUtil.OnUxRestrictionsChangedListener {
        private static final String TAG = "ContentLimitListener";

        private Listener() {
        }

        public void onRestrictionsChanged(@NonNull CarUxRestrictions carUxRestrictions) {
            if (UxrContentLimiterImpl.this.mAdapter == null) {
                Log.w((String)TAG, (String)"No adapter registered.");
                return;
            }
            int maxItems = this.getMaxItemsToUse(carUxRestrictions, UxrContentLimiterImpl.this.mAdapter.getConfigurationId());
            this.logD("New limit " + maxItems);
            UxrContentLimiterImpl.this.mAdapter.setMaxItems(maxItems);
        }

        private int getMaxItemsToUse(CarUxRestrictions carUxRestrictions, @IdRes int id) {
            if ((carUxRestrictions.getActiveRestrictions() & 0x20) == 0) {
                this.logD("Lists are unrestricted.");
                return -1;
            }
            if (UxrContentLimiterImpl.this.mListConfig == null || UxrContentLimiterImpl.this.mListConfig.getContentLimit() == null) {
                this.logD("No configs found for adapter with the ID: " + id + " Using the default limit");
                return carUxRestrictions.getMaxCumulativeContentItems();
            }
            this.logD("Using the provided override.");
            return UxrContentLimiterImpl.this.mListConfig.getContentLimit();
        }

        private void logD(String s) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)s);
            }
        }
    }
}

