/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.oem.tokens;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.SharedLibraryInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.StyleRes;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.ContextCompat;
import com.android.car.oem.tokens.OemContextWrapper;
import com.android.car.oem.tokens.R;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class Token {
    private static final String TOKEN_SHARED_LIBRARY_NAME = "com.android.oem.tokens";
    private static final String TEST_TOKEN_SHARED_LIBRARY_NAME = "com.android.car.oem.tokens.test";
    private static boolean sTestingOverrideEnabled = false;

    static String getTokenSharedLibraryName() {
        if (sTestingOverrideEnabled) {
            return TEST_TOKEN_SHARED_LIBRARY_NAME;
        }
        return TOKEN_SHARED_LIBRARY_NAME;
    }

    @VisibleForTesting
    static void setTestingOverride(boolean enabled) {
        sTestingOverrideEnabled = enabled;
    }

    @Nullable
    public static String getTokenSharedLibPackageName(@NonNull PackageManager packageManager) {
        if (sTestingOverrideEnabled) {
            return TEST_TOKEN_SHARED_LIBRARY_NAME;
        }
        List sharedLibs = packageManager.getSharedLibraries(0);
        for (SharedLibraryInfo info : sharedLibs) {
            if (!info.getName().equals(Token.getTokenSharedLibraryName())) continue;
            return info.getDeclaringPackage().getPackageName();
        }
        return null;
    }

    public static boolean isTokenSharedLibInstalled(@NonNull PackageManager packageManager) {
        String packageName = Token.getTokenSharedLibPackageName(packageManager);
        if (packageName == null) {
            return false;
        }
        try {
            return packageManager.getApplicationInfo((String)packageName, (int)0).enabled;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    @NonNull
    public static Context createOemStyledContext(@NonNull Context context) {
        if (context instanceof OemContextWrapper) {
            return context;
        }
        int oemStyleOverride = context.getResources().getIdentifier("OemStyle", "style", Token.getTokenSharedLibraryName());
        if (oemStyleOverride == 0) {
            if (Token.isLightTheme(context)) {
                return new OemContextWrapper(context, R.style.OemTokensBaseLight);
            }
            return new OemContextWrapper(context, R.style.OemTokensBaseDark);
        }
        OemContextWrapper oemContext = new OemContextWrapper(context, R.style.OemTokens);
        if (Token.isLightTheme((Context)oemContext)) {
            oemContext.getTheme().applyStyle(R.style.OemTokensLight, true);
        } else {
            oemContext.getTheme().applyStyle(R.style.OemTokensDark, true);
        }
        oemContext.getTheme().applyStyle(oemStyleOverride, true);
        return oemContext;
    }

    static boolean isLightTheme(@NonNull Context context) {
        Resources.Theme deviceDefaultTheme = context.getResources().newTheme();
        deviceDefaultTheme.applyStyle(16974121, true);
        TypedValue value = new TypedValue();
        return deviceDefaultTheme.resolveAttribute(16844176, value, true) && value.data != 0;
    }

    @Px
    public static float getCornerRadius(@NonNull Context context, @AttrRes int attr2) {
        Token.checkContext(context);
        TypedValue tv = Token.getThemeTypedValue(context, attr2);
        return TypedValue.complexToDimension((int)tv.data, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    @StyleRes
    public static int getTextAppearance(@NonNull Context context, @AttrRes int attr2) {
        Token.checkContext(context);
        TypedValue tv = Token.getThemeTypedValue(context, attr2);
        return tv.resourceId;
    }

    @ColorInt
    public static int getColor(@NonNull Context context, @AttrRes int attr2) {
        Token.checkContext(context);
        TypedValue tv = Token.getThemeTypedValue(context, attr2);
        if (tv.resourceId == 0) {
            return tv.data;
        }
        return ContextCompat.getColor((Context)context, (int)tv.resourceId);
    }

    private static HashMap<String, String> createTokenMap(@NonNull Context context) {
        int[] attrs;
        context = Token.createOemStyledContext(context.getApplicationContext());
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i : attrs = Arrays.stream(R.styleable.OemTokens).toArray()) {
            String id = context.getResources().getResourceEntryName(i);
            TypedValue typedValue = Token.getThemeTypedValue(context, i);
            String value = Token.getAttributeValue(context, typedValue);
            map.put(id, value);
        }
        return map;
    }

    public static String dump(@NonNull Context context) {
        return Token.createTokenMap(context).toString();
    }

    public static int hashCode(@NonNull Context context) {
        return Token.createTokenMap(context).hashCode();
    }

    private static String getAttributeValue(Context context, TypedValue value) {
        int valueType = value.type;
        if (valueType == 0) {
            return "";
        }
        if (valueType == 1) {
            int resId = value.data;
            if (resId != 0) {
                try {
                    int[] attrs = new int[]{16842901, 16842904};
                    TypedArray array = context.obtainStyledAttributes(resId, attrs);
                    float size = array.getDimension(0, 0.0f);
                    TypedValue typedColor = new TypedValue();
                    array.getValue(1, typedColor);
                    String color = typedColor.coerceToString().toString();
                    return String.format("Text size: %f Text color %s", Float.valueOf(size), color);
                }
                catch (Exception e) {
                    return String.valueOf(resId);
                }
            }
            return "Invalid reference";
        }
        return value.coerceToString().toString();
    }

    public static boolean isOemStyled(Context context, @AttrRes int attr2) {
        int oemStyleOverride = (context = context.getApplicationContext()).getResources().getIdentifier("OemStyle", "style", Token.getTokenSharedLibraryName());
        if (oemStyleOverride == 0) {
            return false;
        }
        TypedArray libAttributes = context.getTheme().obtainStyledAttributes(R.style.OemTokens, new int[]{attr2});
        TypedValue tv = new TypedValue();
        if (libAttributes.getType(0) != 2) {
            libAttributes.recycle();
            return false;
        }
        libAttributes.getValue(0, tv);
        int[] attrs = new int[]{tv.data};
        TypedArray sharedLibAttributes = context.obtainStyledAttributes(oemStyleOverride, attrs);
        int type = sharedLibAttributes.getType(0);
        boolean isOemStyled = type != 0;
        libAttributes.recycle();
        sharedLibAttributes.recycle();
        return isOemStyled;
    }

    private static void checkContext(@NonNull Context context) {
        TypedArray attributes = context.getTheme().obtainStyledAttributes(new int[]{R.attr.oemColorPrimary});
        if (attributes.getType(0) == 0) {
            throw new IllegalArgumentException("Context must be token compatible.");
        }
        attributes.recycle();
    }

    @NonNull
    private static TypedValue getThemeTypedValue(@NonNull Context oemContext, @AttrRes int attr2) {
        TypedValue typedValue = new TypedValue();
        oemContext.getTheme().resolveAttribute(attr2, typedValue, true);
        return typedValue;
    }
}

