/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.oem.tokens;

import android.app.Activity;
import android.app.Application;
import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.car.oem.tokens.R;
import com.android.car.oem.tokens.Token;
import java.util.HashSet;

public class TokenInstaller
extends ContentProvider {
    private static final String TAG = "TokenInstaller";
    private static final HashSet<Application> sAppsRegistered = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasAlreadyRegistered(@NonNull Application application) {
        HashSet<Application> hashSet = sAppsRegistered;
        synchronized (hashSet) {
            return !sAppsRegistered.add(application);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean getThemeBoolean(@NonNull Activity activity, int attr2) {
        TypedArray a = activity.getTheme().obtainStyledAttributes(new int[]{attr2});
        try {
            boolean bl = a.getBoolean(0, false);
            return bl;
        }
        finally {
            a.recycle();
        }
    }

    public boolean onCreate() {
        Context context = this.getContext();
        if (context == null || !(context.getApplicationContext() instanceof Application)) {
            Log.e((String)TAG, (String)"TokenInstaller had a null context, unable to call register! Need app to call register by itself");
            return false;
        }
        Application application = (Application)context.getApplicationContext();
        this.register(application);
        return true;
    }

    public void register(@NonNull Application application) {
        if (TokenInstaller.hasAlreadyRegistered(application)) {
            return;
        }
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            private boolean shouldRun(Activity activity) {
                return TokenInstaller.getThemeBoolean(activity, R.attr.oemTokenOverrideEnabled);
            }

            public void onActivityPreCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
                boolean useOemToken;
                if (!this.shouldRun(activity)) {
                    return;
                }
                Log.i((String)TokenInstaller.TAG, (String)"Setting OEM token default values");
                if (Token.isLightTheme((Context)activity)) {
                    activity.getTheme().applyStyle(R.style.OemTokensBaseLight, true);
                } else {
                    activity.getTheme().applyStyle(R.style.OemTokensBaseDark, true);
                }
                int useOemTokenId = activity.getResources().getIdentifier("enable_oem_tokens", "bool", Token.getTokenSharedLibraryName());
                boolean bl = useOemToken = useOemTokenId != 0 && activity.getResources().getBoolean(useOemTokenId);
                if (useOemToken && Token.isTokenSharedLibInstalled(activity.getPackageManager())) {
                    Log.i((String)TokenInstaller.TAG, (String)"Setting shared lib OEM token default values");
                    activity.getTheme().applyStyle(R.style.OemTokens, true);
                    if (Token.isLightTheme((Context)activity)) {
                        activity.getTheme().applyStyle(R.style.OemTokensLight, true);
                    } else {
                        activity.getTheme().applyStyle(R.style.OemTokensDark, true);
                    }
                    int oemStyleOverride = activity.getResources().getIdentifier("OemStyle", "style", Token.getTokenSharedLibraryName());
                    if (oemStyleOverride == 0) {
                        Log.e((String)TokenInstaller.TAG, (String)"Unable to apply OEM design token overrides. Style with name OemStyle not found.");
                        return;
                    }
                    Log.i((String)TokenInstaller.TAG, (String)"Overriding OEM tokens with OEM values");
                    activity.getTheme().applyStyle(oemStyleOverride, true);
                }
            }

            public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
            }

            public void onActivityStarted(@NonNull Activity activity) {
            }

            public void onActivityResumed(@NonNull Activity activity) {
            }

            public void onActivityPaused(@NonNull Activity activity) {
            }

            public void onActivityStopped(@NonNull Activity activity) {
            }

            public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
            }

            public void onActivityDestroyed(@NonNull Activity activity) {
            }
        });
    }

    @Nullable
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        return null;
    }

    @Nullable
    public String getType(@NonNull Uri uri) {
        return null;
    }

    @Nullable
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues values) {
        return null;
    }

    public int delete(@NonNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }

    public int update(@NonNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }
}

