/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import android.os.Bundle;
import androidx.annotation.MainThread;
import androidx.annotation.RestrictTo;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.SavedStateHandle_androidKt;
import androidx.lifecycle.internal.SavedStateHandleImpl;
import androidx.lifecycle.internal.SavedStateHandleImpl_androidKt;
import androidx.savedstate.SavedStateReader;
import androidx.savedstate.SavedStateRegistry;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 +2\u00020\u0001:\u0002+,B\u001d\b\u0016\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003\u00a2\u0006\u0002\u0010\u0005B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0007J\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0004H\u0087\u0002J\u001e\u0010\u0011\u001a\u0004\u0018\u0001H\u0012\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u000e\u001a\u00020\u0004H\u0087\u0002\u00a2\u0006\u0002\u0010\u0013J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0015\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u000e\u001a\u00020\u0004H\u0007J)\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0015\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u0002H\u0012H\u0007\u00a2\u0006\u0002\u0010\u0017J1\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0015\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u0002H\u0012H\u0002\u00a2\u0006\u0002\u0010\u001aJ)\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00120\u001c\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u0002H\u0012H\u0007\u00a2\u0006\u0002\u0010\u001dJ)\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00120\u001f\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u0002H\u0012H\u0007\u00a2\u0006\u0002\u0010 J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\"H\u0007J\u001d\u0010#\u001a\u0004\u0018\u0001H\u0012\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u000e\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\u0013J\b\u0010$\u001a\u00020%H\u0007J&\u0010&\u001a\u00020\r\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u000e\u001a\u00020\u00042\b\u0010'\u001a\u0004\u0018\u0001H\u0012H\u0087\u0002\u00a2\u0006\u0002\u0010(J\u0018\u0010)\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010*\u001a\u00020%H\u0007R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Landroidx/lifecycle/SavedStateHandle;", "", "initialState", "", "", "(Ljava/util/Map;)V", "()V", "impl", "Landroidx/lifecycle/internal/SavedStateHandleImpl;", "liveDatas", "", "Landroidx/lifecycle/SavedStateHandle$SavingStateLiveData;", "clearSavedStateProvider", "", "key", "contains", "", "get", "T", "(Ljava/lang/String;)Ljava/lang/Object;", "getLiveData", "Landroidx/lifecycle/MutableLiveData;", "initialValue", "(Ljava/lang/String;Ljava/lang/Object;)Landroidx/lifecycle/MutableLiveData;", "getLiveDataInternal", "hasInitialValue", "(Ljava/lang/String;ZLjava/lang/Object;)Landroidx/lifecycle/MutableLiveData;", "getMutableStateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "(Ljava/lang/String;Ljava/lang/Object;)Lkotlinx/coroutines/flow/MutableStateFlow;", "getStateFlow", "Lkotlinx/coroutines/flow/StateFlow;", "(Ljava/lang/String;Ljava/lang/Object;)Lkotlinx/coroutines/flow/StateFlow;", "keys", "", "remove", "savedStateProvider", "Landroidx/savedstate/SavedStateRegistry$SavedStateProvider;", "set", "value", "(Ljava/lang/String;Ljava/lang/Object;)V", "setSavedStateProvider", "provider", "Companion", "SavingStateLiveData", "lifecycle-viewmodel-savedstate_release"})
@SourceDebugExtension(value={"SMAP\nSavedStateHandle.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SavedStateHandle.android.kt\nandroidx/lifecycle/SavedStateHandle\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,229:1\n1#2:230\n372#3,7:231\n*S KotlinDebug\n*F\n+ 1 SavedStateHandle.android.kt\nandroidx/lifecycle/SavedStateHandle\n*L\n115#1:231,7\n*E\n"})
public final class SavedStateHandle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, SavingStateLiveData<?>> liveDatas;
    @NotNull
    private SavedStateHandleImpl impl;

    public SavedStateHandle(@NotNull Map<String, ? extends Object> initialState) {
        Intrinsics.checkNotNullParameter(initialState, (String)"initialState");
        this.liveDatas = new LinkedHashMap();
        this.impl = new SavedStateHandleImpl(initialState);
    }

    public SavedStateHandle() {
        this.liveDatas = new LinkedHashMap();
        this.impl = new SavedStateHandleImpl(null, 1, null);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final SavedStateRegistry.SavedStateProvider savedStateProvider() {
        return this.impl.getSavedStateProvider();
    }

    @MainThread
    public final boolean contains(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.impl.contains(key);
    }

    @MainThread
    @NotNull
    public final <T> MutableLiveData<T> getLiveData(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        MutableLiveData<Object> mutableLiveData = this.getLiveDataInternal(key, false, null);
        Intrinsics.checkNotNull(mutableLiveData, (String)"null cannot be cast to non-null type androidx.lifecycle.MutableLiveData<T of androidx.lifecycle.SavedStateHandle.getLiveData>");
        return mutableLiveData;
    }

    @MainThread
    @NotNull
    public final <T> MutableLiveData<T> getLiveData(@NotNull String key, T initialValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getLiveDataInternal(key, true, initialValue);
    }

    private final <T> MutableLiveData<T> getLiveDataInternal(String key, boolean hasInitialValue, T initialValue) {
        SavingStateLiveData<Object> savingStateLiveData;
        if (!(!this.impl.getMutableFlows().containsKey(key))) {
            boolean $i$a$-require-SavedStateHandle$getLiveDataInternal$22 = false;
            String $i$a$-require-SavedStateHandle$getLiveDataInternal$22 = SavedStateHandle_androidKt.access$createMutuallyExclusiveErrorMessage(key);
            throw new IllegalArgumentException($i$a$-require-SavedStateHandle$getLiveDataInternal$22.toString());
        }
        Map<String, SavingStateLiveData<?>> $this$getOrPut$iv = this.liveDatas;
        boolean $i$f$getOrPut = false;
        SavingStateLiveData<?> value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            SavingStateLiveData<T> savingStateLiveData2;
            boolean bl = false;
            if (this.impl.getRegular().containsKey(key)) {
                savingStateLiveData2 = new SavingStateLiveData<T>(this, key, this.impl.getRegular().get(key));
            } else if (hasInitialValue) {
                this.impl.getRegular().put(key, initialValue);
                savingStateLiveData2 = new SavingStateLiveData<T>(this, key, initialValue);
            } else {
                savingStateLiveData2 = new SavingStateLiveData(this, key);
            }
            SavingStateLiveData<T> answer$iv = savingStateLiveData2;
            $this$getOrPut$iv.put(key, answer$iv);
            savingStateLiveData = answer$iv;
        } else {
            savingStateLiveData = value$iv;
        }
        SavingStateLiveData<?> liveData = savingStateLiveData;
        return liveData;
    }

    @MainThread
    @NotNull
    public final <T> StateFlow<T> getStateFlow(@NotNull String key, T initialValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.impl.getMutableFlows().containsKey(key) ? FlowKt.asStateFlow(this.impl.getMutableStateFlow(key, initialValue)) : this.impl.getStateFlow(key, initialValue);
    }

    @MainThread
    @NotNull
    public final <T> MutableStateFlow<T> getMutableStateFlow(@NotNull String key, T initialValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!(!this.liveDatas.containsKey(key))) {
            boolean bl = false;
            String string = SavedStateHandle_androidKt.access$createMutuallyExclusiveErrorMessage(key);
            throw new IllegalArgumentException(string.toString());
        }
        return this.impl.getMutableStateFlow(key, initialValue);
    }

    @MainThread
    @NotNull
    public final Set<String> keys() {
        return SetsKt.plus(this.impl.keys(), (Iterable)this.liveDatas.keySet());
    }

    @MainThread
    @Nullable
    public final <T> T get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.impl.get(key);
    }

    @MainThread
    public final <T> void set(@NotNull String key, @Nullable T value) {
        MutableLiveData mutableLiveData;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!Companion.validateValue(value)) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("Can't put value with type ");
            T t = value;
            Intrinsics.checkNotNull(t);
            String string = stringBuilder.append(t.getClass()).append(" into saved state").toString();
            throw new IllegalArgumentException(string.toString());
        }
        SavingStateLiveData<?> savingStateLiveData = this.liveDatas.get(key);
        MutableLiveData mutableLiveData2 = mutableLiveData = savingStateLiveData instanceof MutableLiveData ? (MutableLiveData)savingStateLiveData : null;
        if (mutableLiveData2 != null) {
            mutableLiveData2.setValue(value);
        }
        this.impl.set(key, value);
    }

    @MainThread
    @Nullable
    public final <T> T remove(@NotNull String key) {
        Object t;
        block0: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Object it = t = this.impl.remove(key);
            boolean bl = false;
            SavingStateLiveData<?> savingStateLiveData = this.liveDatas.remove(key);
            if (savingStateLiveData == null) break block0;
            savingStateLiveData.detach();
        }
        return t;
    }

    @MainThread
    public final void setSavedStateProvider(@NotNull String key, @NotNull SavedStateRegistry.SavedStateProvider provider) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.impl.setSavedStateProvider(key, provider);
    }

    @MainThread
    public final void clearSavedStateProvider(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.impl.clearSavedStateProvider(key);
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final SavedStateHandle createHandle(@Nullable Bundle restoredState, @Nullable Bundle defaultState) {
        return Companion.createHandle(restoredState, defaultState);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u00072\u000e\u0010\b\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007H\u0007J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0007\u00a8\u0006\f"}, d2={"Landroidx/lifecycle/SavedStateHandle$Companion;", "", "()V", "createHandle", "Landroidx/lifecycle/SavedStateHandle;", "restoredState", "Landroid/os/Bundle;", "Landroidx/savedstate/SavedState;", "defaultState", "validateValue", "", "value", "lifecycle-viewmodel-savedstate_release"})
    @SourceDebugExtension(value={"SMAP\nSavedStateHandle.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SavedStateHandle.android.kt\nandroidx/lifecycle/SavedStateHandle$Companion\n+ 2 SavedState.kt\nandroidx/savedstate/SavedStateKt__SavedStateKt\n*L\n1#1,229:1\n90#2:230\n*S KotlinDebug\n*F\n+ 1 SavedStateHandle.android.kt\nandroidx/lifecycle/SavedStateHandle$Companion\n*L\n217#1:230\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public final SavedStateHandle createHandle(@Nullable Bundle restoredState, @Nullable Bundle defaultState) {
            Bundle initialState;
            Bundle bundle = restoredState;
            if (bundle == null) {
                bundle = defaultState;
            }
            if ((initialState = bundle) == null) {
                return new SavedStateHandle();
            }
            ClassLoader classLoader = SavedStateHandle.class.getClassLoader();
            Intrinsics.checkNotNull((Object)classLoader);
            initialState.setClassLoader(classLoader);
            Bundle $this$read$iv = initialState;
            boolean $i$f$read = false;
            Bundle $this$createHandle_u24lambda_u240 = SavedStateReader.constructor-impl((Bundle)$this$read$iv);
            boolean bl = false;
            Map map = SavedStateReader.toMap-impl((Bundle)$this$createHandle_u24lambda_u240);
            return new SavedStateHandle(map);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public final boolean validateValue(@Nullable Object value) {
            return SavedStateHandleImpl_androidKt.isAcceptableType(value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B!\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\bB\u0019\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/lifecycle/SavedStateHandle$SavingStateLiveData;", "T", "Landroidx/lifecycle/MutableLiveData;", "handle", "Landroidx/lifecycle/SavedStateHandle;", "key", "", "value", "(Landroidx/lifecycle/SavedStateHandle;Ljava/lang/String;Ljava/lang/Object;)V", "(Landroidx/lifecycle/SavedStateHandle;Ljava/lang/String;)V", "detach", "", "setValue", "(Ljava/lang/Object;)V", "lifecycle-viewmodel-savedstate_release"})
    public static final class SavingStateLiveData<T>
    extends MutableLiveData<T> {
        @NotNull
        private String key;
        @Nullable
        private SavedStateHandle handle;

        public SavingStateLiveData(@Nullable SavedStateHandle handle, @NotNull String key, T value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            super(value);
            this.key = key;
            this.handle = handle;
        }

        public SavingStateLiveData(@Nullable SavedStateHandle handle, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.key = key;
            this.handle = handle;
        }

        public void setValue(T value) {
            Object object = this.handle;
            if (object != null && (object = ((SavedStateHandle)object).impl) != null) {
                ((SavedStateHandleImpl)object).set(this.key, value);
            }
            super.setValue(value);
        }

        public final void detach() {
            this.handle = null;
        }
    }
}

