/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle.internal;

import android.os.Bundle;
import androidx.annotation.MainThread;
import androidx.annotation.RestrictTo;
import androidx.core.os.BundleKt;
import androidx.savedstate.SavedStateRegistry;
import androidx.savedstate.SavedStateWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004H\u0007J\u0011\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0004H\u0087\u0002J\u001e\u0010\u0018\u001a\u0004\u0018\u0001H\u0019\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u0015\u001a\u00020\u0004H\u0087\u0002\u00a2\u0006\u0002\u0010\u001aJ)\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00190\b\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u0002H\u0019H\u0007\u00a2\u0006\u0002\u0010\u001dJ)\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001f\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u0002H\u0019H\u0007\u00a2\u0006\u0002\u0010 J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\"H\u0007J\u001d\u0010#\u001a\u0004\u0018\u0001H\u0019\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u0015\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u0010\u001a\u00020\rH\u0007J&\u0010$\u001a\u00020\u0014\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u0015\u001a\u00020\u00042\b\u0010%\u001a\u0004\u0018\u0001H\u0019H\u0087\u0002\u00a2\u0006\u0002\u0010&J\u0018\u0010'\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\rH\u0007R\"\u0010\u0006\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006)"}, d2={"Landroidx/lifecycle/internal/SavedStateHandleImpl;", "", "initialState", "", "", "(Ljava/util/Map;)V", "flows", "", "Lkotlinx/coroutines/flow/MutableStateFlow;", "mutableFlows", "getMutableFlows", "()Ljava/util/Map;", "providers", "Landroidx/savedstate/SavedStateRegistry$SavedStateProvider;", "regular", "getRegular", "savedStateProvider", "getSavedStateProvider", "()Landroidx/savedstate/SavedStateRegistry$SavedStateProvider;", "clearSavedStateProvider", "", "key", "contains", "", "get", "T", "(Ljava/lang/String;)Ljava/lang/Object;", "getMutableStateFlow", "initialValue", "(Ljava/lang/String;Ljava/lang/Object;)Lkotlinx/coroutines/flow/MutableStateFlow;", "getStateFlow", "Lkotlinx/coroutines/flow/StateFlow;", "(Ljava/lang/String;Ljava/lang/Object;)Lkotlinx/coroutines/flow/StateFlow;", "keys", "", "remove", "set", "value", "(Ljava/lang/String;Ljava/lang/Object;)V", "setSavedStateProvider", "provider", "lifecycle-viewmodel-savedstate_release"})
@SourceDebugExtension(value={"SMAP\nSavedStateHandleImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SavedStateHandleImpl.kt\nandroidx/lifecycle/internal/SavedStateHandleImpl\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 SavedState.android.kt\nandroidx/savedstate/SavedStateKt__SavedState_androidKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 SavedState.kt\nandroidx/savedstate/SavedStateKt__SavedStateKt\n+ 8 SavedState.android.kt\nandroidx/savedstate/SavedStateKt__SavedState_androidKt$savedState$1\n*L\n1#1,128:1\n372#2,7:129\n372#2,7:136\n27#3:143\n46#3:144\n32#3,4:145\n31#3,7:155\n125#4:149\n152#4,3:150\n37#5,2:153\n1#6:162\n106#7:163\n46#8:164\n*S KotlinDebug\n*F\n+ 1 SavedStateHandleImpl.kt\nandroidx/lifecycle/internal/SavedStateHandleImpl\n*L\n60#1:129,7\n76#1:136,7\n47#1:143\n47#1:144\n47#1:145,4\n47#1:155,7\n47#1:149\n47#1:150,3\n47#1:153,2\n47#1:162\n47#1:163\n47#1:164\n*E\n"})
public final class SavedStateHandleImpl {
    @NotNull
    private final Map<String, Object> regular;
    @NotNull
    private final Map<String, SavedStateRegistry.SavedStateProvider> providers;
    @NotNull
    private final Map<String, MutableStateFlow<Object>> flows;
    @NotNull
    private final Map<String, MutableStateFlow<Object>> mutableFlows;
    @NotNull
    private final SavedStateRegistry.SavedStateProvider savedStateProvider;

    public SavedStateHandleImpl(@NotNull Map<String, ? extends Object> initialState) {
        Intrinsics.checkNotNullParameter(initialState, (String)"initialState");
        this.regular = MapsKt.toMutableMap(initialState);
        this.providers = new LinkedHashMap();
        this.flows = new LinkedHashMap();
        this.mutableFlows = new LinkedHashMap();
        this.savedStateProvider = () -> SavedStateHandleImpl.savedStateProvider$lambda$0(this);
    }

    public /* synthetic */ SavedStateHandleImpl(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = MapsKt.emptyMap();
        }
        this(map);
    }

    @NotNull
    public final Map<String, Object> getRegular() {
        return this.regular;
    }

    @NotNull
    public final Map<String, MutableStateFlow<Object>> getMutableFlows() {
        return this.mutableFlows;
    }

    @NotNull
    public final SavedStateRegistry.SavedStateProvider getSavedStateProvider() {
        return this.savedStateProvider;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final SavedStateRegistry.SavedStateProvider savedStateProvider() {
        return this.savedStateProvider;
    }

    @MainThread
    public final boolean contains(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.regular.containsKey(key);
    }

    @MainThread
    @NotNull
    public final <T> StateFlow<T> getStateFlow(@NotNull String key, T initialValue) {
        MutableStateFlow mutableStateFlow;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Map<String, MutableStateFlow<Object>> $this$getOrPut$iv = this.flows;
        boolean $i$f$getOrPut = false;
        MutableStateFlow value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            boolean bl = false;
            if (!this.regular.containsKey(key)) {
                this.regular.put(key, initialValue);
            }
            MutableStateFlow answer$iv = StateFlowKt.MutableStateFlow((Object)this.regular.get(key));
            $this$getOrPut$iv.put(key, (MutableStateFlow<Object>)answer$iv);
            mutableStateFlow = answer$iv;
        } else {
            mutableStateFlow = value$iv;
        }
        MutableStateFlow flow = mutableStateFlow;
        StateFlow stateFlow = FlowKt.asStateFlow(flow);
        Intrinsics.checkNotNull((Object)stateFlow, (String)"null cannot be cast to non-null type kotlinx.coroutines.flow.StateFlow<T of androidx.lifecycle.internal.SavedStateHandleImpl.getStateFlow>");
        return stateFlow;
    }

    @MainThread
    @NotNull
    public final <T> MutableStateFlow<T> getMutableStateFlow(@NotNull String key, T initialValue) {
        MutableStateFlow mutableStateFlow;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Map<String, MutableStateFlow<Object>> $this$getOrPut$iv = this.mutableFlows;
        boolean $i$f$getOrPut = false;
        MutableStateFlow value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            boolean bl = false;
            if (!this.regular.containsKey(key)) {
                this.regular.put(key, initialValue);
            }
            MutableStateFlow answer$iv = StateFlowKt.MutableStateFlow((Object)this.regular.get(key));
            $this$getOrPut$iv.put(key, (MutableStateFlow<Object>)answer$iv);
            mutableStateFlow = answer$iv;
        } else {
            mutableStateFlow = value$iv;
        }
        MutableStateFlow flow = mutableStateFlow;
        Intrinsics.checkNotNull(flow, (String)"null cannot be cast to non-null type kotlinx.coroutines.flow.MutableStateFlow<T of androidx.lifecycle.internal.SavedStateHandleImpl.getMutableStateFlow>");
        return flow;
    }

    @MainThread
    @NotNull
    public final Set<String> keys() {
        return SetsKt.plus(this.regular.keySet(), (Iterable)this.providers.keySet());
    }

    @MainThread
    @Nullable
    public final <T> T get(@NotNull String key) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            Object object2 = this.mutableFlows.get(key);
            if (object2 == null || (object2 = object2.getValue()) == null) {
                object2 = this.regular.get(key);
            }
            object = object2;
        }
        catch (ClassCastException e) {
            this.remove(key);
            object = null;
        }
        return (T)object;
    }

    @MainThread
    public final <T> void set(@NotNull String key, @Nullable T value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.regular.put(key, value);
        MutableStateFlow<Object> mutableStateFlow = this.flows.get(key);
        if (mutableStateFlow != null) {
            mutableStateFlow.setValue(value);
        }
        MutableStateFlow<Object> mutableStateFlow2 = this.mutableFlows.get(key);
        if (mutableStateFlow2 != null) {
            mutableStateFlow2.setValue(value);
        }
    }

    @MainThread
    @Nullable
    public final <T> T remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object latestValue = this.regular.remove(key);
        this.flows.remove(key);
        return (T)latestValue;
    }

    @MainThread
    public final void setSavedStateProvider(@NotNull String key, @NotNull SavedStateRegistry.SavedStateProvider provider) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.providers.put(key, provider);
    }

    @MainThread
    public final void clearSavedStateProvider(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.providers.remove(key);
    }

    /*
     * WARNING - void declaration
     */
    private static final Bundle savedStateProvider$lambda$0(SavedStateHandleImpl this$0) {
        Bundle bundle;
        Pair[] pairArray;
        String key;
        for (Map.Entry entry : MapsKt.toMap(this$0.mutableFlows).entrySet()) {
            key = (String)entry.getKey();
            MutableStateFlow mutableFlow = (MutableStateFlow)entry.getValue();
            this$0.set(key, mutableFlow.getValue());
        }
        for (Map.Entry entry : MapsKt.toMap(this$0.providers).entrySet()) {
            key = (String)entry.getKey();
            SavedStateRegistry.SavedStateProvider provider = (SavedStateRegistry.SavedStateProvider)entry.getValue();
            this$0.set(key, provider.saveState());
        }
        Map<String, Object> initialState$iv = this$0.regular;
        boolean $i$f$savedState = false;
        if (initialState$iv.isEmpty()) {
            pairArray = new Pair[]{};
        } else {
            void $this$toTypedArray$iv$iv;
            void $this$mapTo$iv$iv$iv;
            Object $this$map$iv$iv = initialState$iv;
            boolean $i$f$map = false;
            Map<String, Object> map = $this$map$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList($this$map$iv$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv$iv$iv;
                Map.Entry entry = item$iv$iv$iv = iterator.next();
                Collection collection = destination$iv$iv$iv;
                boolean bl = false;
                String key$iv = (String)entry.getKey();
                Object value$iv = entry.getValue();
                collection.add(TuplesKt.to((Object)key$iv, value$iv));
            }
            $this$map$iv$iv = (List)destination$iv$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            pairArray = thisCollection$iv$iv.toArray(new Pair[0]);
        }
        Pair[] pairs$iv = pairArray;
        Bundle $this$savedState_u24lambda_u241$iv = bundle = BundleKt.bundleOf((Pair[])Arrays.copyOf(pairs$iv, pairs$iv.length));
        boolean bl = false;
        Bundle $this$write$iv$iv = $this$savedState_u24lambda_u241$iv;
        boolean $i$f$write = false;
        Bundle bundle2 = SavedStateWriter.constructor-impl((Bundle)$this$write$iv$iv);
        boolean bl2 = false;
        Bundle $this$null = bundle2;
        return bundle;
    }

    public SavedStateHandleImpl() {
        this(null, 1, null);
    }
}

