/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle.serialization;

import android.os.Bundle;
import androidx.lifecycle.SavedStateHandle;
import androidx.savedstate.serialization.SavedStateConfiguration;
import androidx.savedstate.serialization.SavedStateDecoderKt;
import androidx.savedstate.serialization.SavedStateEncoderKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u0002H\u00010\u0003B;\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u00a2\u0006\u0002\u0010\u000eJ\u001e\u0010\u0011\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00022\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002J$\u0010\u0015\u001a\u00028\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\u00022\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0096\u0002\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010\u0017\u001a\u0004\u0018\u00018\u00002\u0006\u0010\b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010\u001b\u001a\u00020\u001a2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00022\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u000f\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006\u001d"}, d2={"Landroidx/lifecycle/serialization/SavedStateHandleDelegate;", "T", "", "Lkotlin/properties/ReadWriteProperty;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "serializer", "Lkotlinx/serialization/KSerializer;", "key", "", "configuration", "Landroidx/savedstate/serialization/SavedStateConfiguration;", "init", "Lkotlin/Function0;", "(Landroidx/lifecycle/SavedStateHandle;Lkotlinx/serialization/KSerializer;Ljava/lang/String;Landroidx/savedstate/serialization/SavedStateConfiguration;Lkotlin/jvm/functions/Function0;)V", "value", "Ljava/lang/Object;", "createDefaultKey", "thisRef", "property", "Lkotlin/reflect/KProperty;", "getValue", "(Ljava/lang/Object;Lkotlin/reflect/KProperty;)Ljava/lang/Object;", "loadValue", "(Ljava/lang/String;)Ljava/lang/Object;", "registerSave", "", "setValue", "(Ljava/lang/Object;Lkotlin/reflect/KProperty;Ljava/lang/Object;)V", "lifecycle-viewmodel-savedstate_release"})
final class SavedStateHandleDelegate<T>
implements ReadWriteProperty<Object, T> {
    @NotNull
    private final SavedStateHandle savedStateHandle;
    @NotNull
    private final KSerializer<T> serializer;
    @Nullable
    private final String key;
    @NotNull
    private final SavedStateConfiguration configuration;
    @NotNull
    private final Function0<T> init;
    private T value;

    public SavedStateHandleDelegate(@NotNull SavedStateHandle savedStateHandle, @NotNull KSerializer<T> serializer, @Nullable String key, @NotNull SavedStateConfiguration configuration, @NotNull Function0<? extends T> init) {
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        this.savedStateHandle = savedStateHandle;
        this.serializer = serializer;
        this.key = key;
        this.configuration = configuration;
        this.init = init;
    }

    private final T loadValue(String key) {
        Object object;
        Bundle bundle = (Bundle)this.savedStateHandle.get(key);
        if (bundle != null) {
            Bundle it = bundle;
            boolean bl = false;
            object = SavedStateDecoderKt.decodeFromSavedState((DeserializationStrategy)((DeserializationStrategy)this.serializer), (Bundle)it, (SavedStateConfiguration)this.configuration);
        } else {
            object = null;
        }
        return (T)object;
    }

    private final void registerSave(String key) {
        this.savedStateHandle.setSavedStateProvider(key, () -> SavedStateHandleDelegate.registerSave$lambda$1(this));
    }

    private final String createDefaultKey(Object thisRef, KProperty<?> property) {
        String classNamePrefix = thisRef != null ? Reflection.getOrCreateKotlinClass(thisRef.getClass()).getQualifiedName() + '.' : "";
        return classNamePrefix + property.getName();
    }

    @NotNull
    public T getValue(@Nullable Object thisRef, @NotNull KProperty<?> property) {
        Object object;
        Intrinsics.checkNotNullParameter(property, (String)"property");
        if (this.value == null) {
            String string = this.key;
            if (string == null) {
                string = this.createDefaultKey(thisRef, property);
            }
            String qualifiedKey = string;
            this.registerSave(qualifiedKey);
            Object object2 = this.loadValue(qualifiedKey);
            if (object2 == null) {
                object2 = this.value = this.init.invoke();
            }
        }
        if ((object = this.value) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"value");
            object = Unit.INSTANCE;
        }
        return object;
    }

    public void setValue(@Nullable Object thisRef, @NotNull KProperty<?> property, @NotNull T value) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (this.value == null) {
            String string = this.key;
            if (string == null) {
                string = this.createDefaultKey(thisRef, property);
            }
            String qualifiedKey = string;
            this.registerSave(qualifiedKey);
        }
        this.value = value;
    }

    private static final Bundle registerSave$lambda$1(SavedStateHandleDelegate this$0) {
        SerializationStrategy serializationStrategy = (SerializationStrategy)this$0.serializer;
        Object object = this$0.value;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"value");
            object = Unit.INSTANCE;
        }
        return SavedStateEncoderKt.encodeToSavedState((SerializationStrategy)serializationStrategy, object, (SavedStateConfiguration)this$0.configuration);
    }
}

