/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.annotation.RestrictTo;
import androidx.paging.LoadState;
import androidx.paging.LoadType;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 $2\u00020\u0001:\u0001$B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J&\u0010\u0015\u001a\u00020\u00162\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00160\u0018H\u0087\b\u00f8\u0001\u0000J\u0015\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001cJ\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\u001d\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b!J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u00020\n8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000bR\u0011\u0010\f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006%"}, d2={"Landroidx/paging/LoadStates;", "", "refresh", "Landroidx/paging/LoadState;", "prepend", "append", "(Landroidx/paging/LoadState;Landroidx/paging/LoadState;Landroidx/paging/LoadState;)V", "getAppend", "()Landroidx/paging/LoadState;", "hasError", "", "()Z", "isIdle", "getPrepend", "getRefresh", "component1", "component2", "component3", "copy", "equals", "other", "forEach", "", "op", "Lkotlin/Function2;", "Landroidx/paging/LoadType;", "get", "loadType", "get$paging_common", "hashCode", "", "modifyState", "newState", "modifyState$paging_common", "toString", "", "Companion", "paging-common"})
public final class LoadStates {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LoadState refresh;
    @NotNull
    private final LoadState prepend;
    @NotNull
    private final LoadState append;
    private final boolean hasError;
    private final boolean isIdle;
    @NotNull
    private static final LoadStates IDLE = new LoadStates(LoadState.NotLoading.Companion.getIncomplete$paging_common(), LoadState.NotLoading.Companion.getIncomplete$paging_common(), LoadState.NotLoading.Companion.getIncomplete$paging_common());

    public LoadStates(@NotNull LoadState refresh, @NotNull LoadState prepend, @NotNull LoadState append) {
        Intrinsics.checkNotNullParameter((Object)refresh, (String)"refresh");
        Intrinsics.checkNotNullParameter((Object)prepend, (String)"prepend");
        Intrinsics.checkNotNullParameter((Object)append, (String)"append");
        this.refresh = refresh;
        this.prepend = prepend;
        this.append = append;
        this.hasError = this.refresh instanceof LoadState.Error || this.append instanceof LoadState.Error || this.prepend instanceof LoadState.Error;
        this.isIdle = this.refresh instanceof LoadState.NotLoading && this.append instanceof LoadState.NotLoading && this.prepend instanceof LoadState.NotLoading;
    }

    @NotNull
    public final LoadState getRefresh() {
        return this.refresh;
    }

    @NotNull
    public final LoadState getPrepend() {
        return this.prepend;
    }

    @NotNull
    public final LoadState getAppend() {
        return this.append;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void forEach(@NotNull Function2<? super LoadType, ? super LoadState, Unit> op) {
        Intrinsics.checkNotNullParameter(op, (String)"op");
        boolean $i$f$forEach = false;
        op.invoke((Object)LoadType.REFRESH, (Object)this.getRefresh());
        op.invoke((Object)LoadType.PREPEND, (Object)this.getPrepend());
        op.invoke((Object)LoadType.APPEND, (Object)this.getAppend());
    }

    @NotNull
    public final LoadStates modifyState$paging_common(@NotNull LoadType loadType, @NotNull LoadState newState) {
        LoadStates loadStates;
        Intrinsics.checkNotNullParameter((Object)((Object)loadType), (String)"loadType");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        switch (WhenMappings.$EnumSwitchMapping$0[loadType.ordinal()]) {
            case 1: {
                loadStates = LoadStates.copy$default(this, null, null, newState, 3, null);
                break;
            }
            case 2: {
                loadStates = LoadStates.copy$default(this, null, newState, null, 5, null);
                break;
            }
            case 3: {
                loadStates = LoadStates.copy$default(this, newState, null, null, 6, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return loadStates;
    }

    @NotNull
    public final LoadState get$paging_common(@NotNull LoadType loadType) {
        LoadState loadState;
        Intrinsics.checkNotNullParameter((Object)((Object)loadType), (String)"loadType");
        switch (WhenMappings.$EnumSwitchMapping$0[loadType.ordinal()]) {
            case 3: {
                loadState = this.refresh;
                break;
            }
            case 1: {
                loadState = this.append;
                break;
            }
            case 2: {
                loadState = this.prepend;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return loadState;
    }

    @JvmName(name="hasError")
    public final boolean hasError() {
        return this.hasError;
    }

    public final boolean isIdle() {
        return this.isIdle;
    }

    @NotNull
    public final LoadState component1() {
        return this.refresh;
    }

    @NotNull
    public final LoadState component2() {
        return this.prepend;
    }

    @NotNull
    public final LoadState component3() {
        return this.append;
    }

    @NotNull
    public final LoadStates copy(@NotNull LoadState refresh, @NotNull LoadState prepend, @NotNull LoadState append) {
        Intrinsics.checkNotNullParameter((Object)refresh, (String)"refresh");
        Intrinsics.checkNotNullParameter((Object)prepend, (String)"prepend");
        Intrinsics.checkNotNullParameter((Object)append, (String)"append");
        return new LoadStates(refresh, prepend, append);
    }

    public static /* synthetic */ LoadStates copy$default(LoadStates loadStates, LoadState loadState, LoadState loadState2, LoadState loadState3, int n, Object object) {
        if ((n & 1) != 0) {
            loadState = loadStates.refresh;
        }
        if ((n & 2) != 0) {
            loadState2 = loadStates.prepend;
        }
        if ((n & 4) != 0) {
            loadState3 = loadStates.append;
        }
        return loadStates.copy(loadState, loadState2, loadState3);
    }

    @NotNull
    public String toString() {
        return "LoadStates(refresh=" + this.refresh + ", prepend=" + this.prepend + ", append=" + this.append + ')';
    }

    public int hashCode() {
        int result = this.refresh.hashCode();
        result = result * 31 + this.prepend.hashCode();
        result = result * 31 + this.append.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LoadStates)) {
            return false;
        }
        LoadStates loadStates = (LoadStates)other;
        if (!Intrinsics.areEqual((Object)this.refresh, (Object)loadStates.refresh)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.prepend, (Object)loadStates.prepend)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.append, (Object)loadStates.append);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/paging/LoadStates$Companion;", "", "()V", "IDLE", "Landroidx/paging/LoadStates;", "getIDLE", "()Landroidx/paging/LoadStates;", "paging-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LoadStates getIDLE() {
            return IDLE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LoadType.values().length];
            try {
                nArray[LoadType.APPEND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoadType.PREPEND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoadType.REFRESH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

