/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.arch.core.util.Function;
import androidx.paging.DataSource;
import androidx.paging.LoadType;
import androidx.paging.WrapperPositionalDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Result;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="PositionalDataSource is deprecated and has been replaced by PagingSource", replaceWith=@ReplaceWith(expression="PagingSource<Int, T>", imports={"androidx.paging.PagingSource"}))
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\b'\u0018\u0000 '*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u0003:\u0005'()*+B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0017\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00028\u0000H\u0000\u00a2\u0006\u0004\b\r\u0010\u000eJ$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012H\u0080@\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\u0006\u0010\u0011\u001a\u00020\u0016H\u0081@\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001e\u0010\u0015\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH'J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\u0006\u0010\u0011\u001a\u00020\u001dH\u0082@\u00a2\u0006\u0002\u0010\u001eJ\u001e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u001d2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fH'J*\u0010 \u001a\b\u0012\u0004\u0012\u0002H!0\u0000\"\b\b\u0001\u0010!*\u00020\u00022\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H!0#J*\u0010 \u001a\b\u0012\u0004\u0012\u0002H!0\u0000\"\b\b\u0001\u0010!*\u00020\u00022\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H!0$J6\u0010%\u001a\b\u0012\u0004\u0012\u0002H!0\u0000\"\b\b\u0001\u0010!*\u00020\u00022\u001e\u0010\"\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000&\u0012\n\u0012\b\u0012\u0004\u0012\u0002H!0&0#J6\u0010%\u001a\b\u0012\u0004\u0012\u0002H!0\u0000\"\b\b\u0001\u0010!*\u00020\u00022\u001e\u0010\"\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000&\u0012\n\u0012\b\u0012\u0004\u0012\u0002H!0&0$R\u001a\u0010\u0006\u001a\u00020\u0007X\u0090D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0005\u001a\u0004\b\t\u0010\n\u00a8\u0006,"}, d2={"Landroidx/paging/PositionalDataSource;", "T", "", "Landroidx/paging/DataSource;", "", "()V", "isContiguous", "", "isContiguous$paging_common$annotations", "isContiguous$paging_common", "()Z", "getKeyInternal", "item", "getKeyInternal$paging_common", "(Ljava/lang/Object;)Ljava/lang/Integer;", "load", "Landroidx/paging/DataSource$BaseResult;", "params", "Landroidx/paging/DataSource$Params;", "load$paging_common", "(Landroidx/paging/DataSource$Params;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadInitial", "Landroidx/paging/PositionalDataSource$LoadInitialParams;", "loadInitial$paging_common", "(Landroidx/paging/PositionalDataSource$LoadInitialParams;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "callback", "Landroidx/paging/PositionalDataSource$LoadInitialCallback;", "loadRange", "Landroidx/paging/PositionalDataSource$LoadRangeParams;", "(Landroidx/paging/PositionalDataSource$LoadRangeParams;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Landroidx/paging/PositionalDataSource$LoadRangeCallback;", "map", "V", "function", "Lkotlin/Function1;", "Landroidx/arch/core/util/Function;", "mapByPage", "", "Companion", "LoadInitialCallback", "LoadInitialParams", "LoadRangeCallback", "LoadRangeParams", "paging-common"})
@SourceDebugExtension(value={"SMAP\nPositionalDataSource.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PositionalDataSource.jvm.kt\nandroidx/paging/PositionalDataSource\n+ 2 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,483:1\n314#2,11:484\n314#2,11:495\n1549#3:506\n1620#3,3:507\n1549#3:510\n1620#3,3:511\n*S KotlinDebug\n*F\n+ 1 PositionalDataSource.jvm.kt\nandroidx/paging/PositionalDataSource\n*L\n334#1:484,11\n403#1:495,11\n477#1:506\n477#1:507,3\n481#1:510\n481#1:511,3\n*E\n"})
public abstract class PositionalDataSource<T>
extends DataSource<Integer, T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isContiguous;

    public PositionalDataSource() {
        super(DataSource.KeyType.POSITIONAL);
    }

    @Override
    @Nullable
    public final Object load$paging_common(@NotNull DataSource.Params<Integer> params, @NotNull Continuation<? super DataSource.BaseResult<T>> $completion) {
        if (params.getType$paging_common() == LoadType.REFRESH) {
            int initialPosition = 0;
            int initialLoadSize = params.getInitialLoadSize();
            if (params.getKey() != null) {
                initialPosition = ((Number)params.getKey()).intValue();
                if (params.getPlaceholdersEnabled()) {
                    initialLoadSize = Math.max(initialLoadSize / params.getPageSize(), 2) * params.getPageSize();
                    int idealStart = initialPosition - initialLoadSize / 2;
                    initialPosition = Math.max(0, idealStart / params.getPageSize() * params.getPageSize());
                } else {
                    initialPosition = Math.max(0, initialPosition - initialLoadSize / 2);
                }
            }
            LoadInitialParams initParams = new LoadInitialParams(initialPosition, initialLoadSize, params.getPageSize(), params.getPlaceholdersEnabled());
            return this.loadInitial$paging_common(initParams, $completion);
        }
        Integer n = params.getKey();
        Intrinsics.checkNotNull((Object)n);
        int startIndex = ((Number)n).intValue();
        int loadSize = params.getPageSize();
        if (params.getType$paging_common() == LoadType.PREPEND) {
            loadSize = Math.min(loadSize, startIndex);
            startIndex -= loadSize;
        }
        return this.loadRange(new LoadRangeParams(startIndex, loadSize), $completion);
    }

    @VisibleForTesting
    @Nullable
    public final Object loadInitial$paging_common(@NotNull LoadInitialParams params, @NotNull Continuation<? super DataSource.BaseResult<T>> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super DataSource.BaseResult<T>> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation cont = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        this.loadInitial(params, new LoadInitialCallback<T>(this, cont, params){
            final /* synthetic */ PositionalDataSource<T> this$0;
            final /* synthetic */ CancellableContinuation<DataSource.BaseResult<T>> $cont;
            final /* synthetic */ LoadInitialParams $params;
            {
                this.this$0 = $receiver;
                this.$cont = $cont;
                this.$params = $params;
            }

            public void onResult(List<? extends T> data, int position, int totalCount) {
                Intrinsics.checkNotNullParameter(data, (String)"data");
                if (this.this$0.isInvalid()) {
                    ((Continuation)this.$cont).resumeWith(Result.constructor-impl(DataSource.BaseResult.Companion.empty$paging_common()));
                } else {
                    int nextKey = position + data.size();
                    this.resume(this.$params, new DataSource.BaseResult<T>(data, position == 0 ? null : Integer.valueOf(position), nextKey == totalCount ? null : Integer.valueOf(nextKey), position, totalCount - data.size() - position));
                }
            }

            public void onResult(List<? extends T> data, int position) {
                Intrinsics.checkNotNullParameter(data, (String)"data");
                if (this.this$0.isInvalid()) {
                    ((Continuation)this.$cont).resumeWith(Result.constructor-impl(DataSource.BaseResult.Companion.empty$paging_common()));
                } else {
                    this.resume(this.$params, new DataSource.BaseResult<T>(data, position == 0 ? null : Integer.valueOf(position), position + data.size(), position, Integer.MIN_VALUE));
                }
            }

            private final void resume(LoadInitialParams params, DataSource.BaseResult<T> result) {
                if (params.placeholdersEnabled) {
                    result.validateForInitialTiling$paging_common(params.pageSize);
                }
                ((Continuation)this.$cont).resumeWith(Result.constructor-impl(result));
            }
        });
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    private final Object loadRange(LoadRangeParams params, Continuation<? super DataSource.BaseResult<T>> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super DataSource.BaseResult<T>> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation cont = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        this.loadRange(params, new LoadRangeCallback<T>(params, this, cont){
            final /* synthetic */ LoadRangeParams $params;
            final /* synthetic */ PositionalDataSource<T> this$0;
            final /* synthetic */ CancellableContinuation<DataSource.BaseResult<T>> $cont;
            {
                this.$params = $params;
                this.this$0 = $receiver;
                this.$cont = $cont;
            }

            public void onResult(List<? extends T> data) {
                Intrinsics.checkNotNullParameter(data, (String)"data");
                Integer prevKey = this.$params.startPosition == 0 ? null : Integer.valueOf(this.$params.startPosition);
                if (this.this$0.isInvalid()) {
                    ((Continuation)this.$cont).resumeWith(Result.constructor-impl(DataSource.BaseResult.Companion.empty$paging_common()));
                } else {
                    ((Continuation)this.$cont).resumeWith(Result.constructor-impl(new DataSource.BaseResult<Value>(data, prevKey, this.$params.startPosition + data.size(), 0, 0, 24, null)));
                }
            }
        });
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    @WorkerThread
    public abstract void loadInitial(@NotNull LoadInitialParams var1, @NotNull LoadInitialCallback<T> var2);

    @WorkerThread
    public abstract void loadRange(@NotNull LoadRangeParams var1, @NotNull LoadRangeCallback<T> var2);

    @Override
    public boolean isContiguous$paging_common() {
        return this.isContiguous;
    }

    public static /* synthetic */ void isContiguous$paging_common$annotations() {
    }

    @Override
    @NotNull
    public final Integer getKeyInternal$paging_common(@NotNull T item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        throw new IllegalStateException("Cannot get key by item in positionalDataSource");
    }

    @NotNull
    public final <V> PositionalDataSource<V> mapByPage(@NotNull Function<List<T>, List<V>> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        return new WrapperPositionalDataSource<T, V>(this, function);
    }

    @NotNull
    public final <V> PositionalDataSource<V> mapByPage(@NotNull Function1<? super List<? extends T>, ? extends List<? extends V>> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        return this.mapByPage(arg_0 -> PositionalDataSource.mapByPage$lambda$2(function, arg_0));
    }

    @NotNull
    public final <V> PositionalDataSource<V> map(@NotNull Function<T, V> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        return this.mapByPage(arg_0 -> PositionalDataSource.map$lambda$4(function, arg_0));
    }

    @NotNull
    public final <V> PositionalDataSource<V> map(@NotNull Function1<? super T, ? extends V> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        return this.mapByPage(arg_0 -> PositionalDataSource.map$lambda$5(function, arg_0));
    }

    private static final List mapByPage$lambda$2(Function1 $function, List it) {
        Intrinsics.checkNotNull((Object)it);
        return (List)$function.invoke((Object)it);
    }

    /*
     * WARNING - void declaration
     */
    private static final List map$lambda$4(Function $function, List list) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNull((Object)list);
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add($function.apply((Object)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List map$lambda$5(Function1 $function, List list) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNull((Object)list);
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            destination$iv$iv.add($function.invoke(item$iv$iv));
        }
        return (List)destination$iv$iv;
    }

    @JvmStatic
    public static final int computeInitialLoadPosition(@NotNull LoadInitialParams params, int totalCount) {
        return Companion.computeInitialLoadPosition(params, totalCount);
    }

    @JvmStatic
    public static final int computeInitialLoadSize(@NotNull LoadInitialParams params, int initialLoadPosition, int totalCount) {
        return Companion.computeInitialLoadSize(params, initialLoadPosition, totalCount);
    }

    public static final /* synthetic */ Object access$loadRange(PositionalDataSource $this, LoadRangeParams params, Continuation $completion) {
        return $this.loadRange(params, $completion);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J \u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0007\u00a8\u0006\n"}, d2={"Landroidx/paging/PositionalDataSource$Companion;", "", "()V", "computeInitialLoadPosition", "", "params", "Landroidx/paging/PositionalDataSource$LoadInitialParams;", "totalCount", "computeInitialLoadSize", "initialLoadPosition", "paging-common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final int computeInitialLoadPosition(@NotNull LoadInitialParams params, int totalCount) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            int position = params.requestedStartPosition;
            int initialLoadSize = params.requestedLoadSize;
            int pageSize = params.pageSize;
            int pageStart = position / pageSize * pageSize;
            int maximumLoadPage = (totalCount - initialLoadSize + pageSize - 1) / pageSize * pageSize;
            pageStart = Math.min(maximumLoadPage, pageStart);
            pageStart = Math.max(0, pageStart);
            return pageStart;
        }

        @JvmStatic
        public final int computeInitialLoadSize(@NotNull LoadInitialParams params, int initialLoadPosition, int totalCount) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            return Math.min(totalCount - initialLoadPosition, params.requestedLoadSize);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u00072\u0006\u0010\b\u001a\u00020\tH&J&\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH&\u00a8\u0006\u000b"}, d2={"Landroidx/paging/PositionalDataSource$LoadInitialCallback;", "T", "", "()V", "onResult", "", "data", "", "position", "", "totalCount", "paging-common"})
    public static abstract class LoadInitialCallback<T> {
        public abstract void onResult(@NotNull List<? extends T> var1, int var2, int var3);

        public abstract void onResult(@NotNull List<? extends T> var1, int var2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0010\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/paging/PositionalDataSource$LoadInitialParams;", "", "requestedStartPosition", "", "requestedLoadSize", "pageSize", "placeholdersEnabled", "", "(IIIZ)V", "paging-common"})
    @SourceDebugExtension(value={"SMAP\nPositionalDataSource.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PositionalDataSource.jvm.kt\nandroidx/paging/PositionalDataSource$LoadInitialParams\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,483:1\n1#2:484\n*E\n"})
    public static class LoadInitialParams {
        @JvmField
        public final int requestedStartPosition;
        @JvmField
        public final int requestedLoadSize;
        @JvmField
        public final int pageSize;
        @JvmField
        public final boolean placeholdersEnabled;

        public LoadInitialParams(int requestedStartPosition, int requestedLoadSize, int pageSize, boolean placeholdersEnabled) {
            this.requestedStartPosition = requestedStartPosition;
            this.requestedLoadSize = requestedLoadSize;
            this.pageSize = pageSize;
            this.placeholdersEnabled = placeholdersEnabled;
            if (!(this.requestedStartPosition >= 0)) {
                boolean $i$a$-check-PositionalDataSource$LoadInitialParams$42 = false;
                String $i$a$-check-PositionalDataSource$LoadInitialParams$42 = "invalid start position: " + this.requestedStartPosition;
                throw new IllegalStateException($i$a$-check-PositionalDataSource$LoadInitialParams$42.toString());
            }
            if (!(this.requestedLoadSize >= 0)) {
                boolean $i$a$-check-PositionalDataSource$LoadInitialParams$52 = false;
                String $i$a$-check-PositionalDataSource$LoadInitialParams$52 = "invalid load size: " + this.requestedLoadSize;
                throw new IllegalStateException($i$a$-check-PositionalDataSource$LoadInitialParams$52.toString());
            }
            if (!(this.pageSize >= 0)) {
                boolean bl = false;
                String string = "invalid page size: " + this.pageSize;
                throw new IllegalStateException(string.toString());
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\b&\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007H&\u00a8\u0006\b"}, d2={"Landroidx/paging/PositionalDataSource$LoadRangeCallback;", "T", "", "()V", "onResult", "", "data", "", "paging-common"})
    public static abstract class LoadRangeCallback<T> {
        public abstract void onResult(@NotNull List<? extends T> var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/paging/PositionalDataSource$LoadRangeParams;", "", "startPosition", "", "loadSize", "(II)V", "paging-common"})
    public static class LoadRangeParams {
        @JvmField
        public final int startPosition;
        @JvmField
        public final int loadSize;

        public LoadRangeParams(int startPosition, int loadSize) {
            this.startPosition = startPosition;
            this.loadSize = loadSize;
        }
    }
}

