/*
 * Decompiled with CFR 0.152.
 */
package androidx.slice.builders;

import android.app.PendingIntent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.graphics.drawable.IconCompat;
import androidx.core.util.Pair;
import androidx.remotecallback.RemoteCallback;
import androidx.slice.builders.SliceAction;
import java.util.ArrayList;
import java.util.List;

@RequiresApi(value=19)
public class GridRowBuilder {
    private final List<CellBuilder> mCells = new ArrayList<CellBuilder>();
    private boolean mHasSeeMore;
    private CellBuilder mSeeMoreCell;
    private PendingIntent mSeeMoreIntent;
    private SliceAction mPrimaryAction;
    private CharSequence mDescription;
    private int mLayoutDirection = -1;

    @NonNull
    public GridRowBuilder addCell(@NonNull CellBuilder builder) {
        this.mCells.add(builder);
        return this;
    }

    @NonNull
    public GridRowBuilder setSeeMoreCell(@NonNull CellBuilder builder) {
        if (this.mHasSeeMore) {
            throw new IllegalStateException("Trying to add see more cell when one has already been added");
        }
        this.mSeeMoreCell = builder;
        this.mHasSeeMore = true;
        return this;
    }

    @NonNull
    public GridRowBuilder setSeeMoreAction(@NonNull PendingIntent intent) {
        if (this.mHasSeeMore) {
            throw new IllegalStateException("Trying to add see more action when one has already been added");
        }
        this.mSeeMoreIntent = intent;
        this.mHasSeeMore = true;
        return this;
    }

    @NonNull
    public GridRowBuilder setSeeMoreAction(@NonNull RemoteCallback callback) {
        if (this.mHasSeeMore) {
            throw new IllegalStateException("Trying to add see more action when one has already been added");
        }
        this.mSeeMoreIntent = callback.toPendingIntent();
        this.mHasSeeMore = true;
        return this;
    }

    @NonNull
    public GridRowBuilder setPrimaryAction(@NonNull SliceAction action) {
        this.mPrimaryAction = action;
        return this;
    }

    @NonNull
    public GridRowBuilder setContentDescription(@NonNull CharSequence description) {
        this.mDescription = description;
        return this;
    }

    @NonNull
    public GridRowBuilder setLayoutDirection(int layoutDirection) {
        this.mLayoutDirection = layoutDirection;
        return this;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public SliceAction getPrimaryAction() {
        return this.mPrimaryAction;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public List<CellBuilder> getCells() {
        return this.mCells;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public CellBuilder getSeeMoreCell() {
        return this.mSeeMoreCell;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public PendingIntent getSeeMoreIntent() {
        return this.mSeeMoreIntent;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public CharSequence getDescription() {
        return this.mDescription;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public int getLayoutDirection() {
        return this.mLayoutDirection;
    }

    public static class CellBuilder {
        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public static final int TYPE_TEXT = 0;
        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public static final int TYPE_TITLE = 1;
        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public static final int TYPE_IMAGE = 2;
        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public static final int TYPE_OVERLAY = 3;
        private final List<Object> mObjects = new ArrayList<Object>();
        private final List<Integer> mTypes = new ArrayList<Integer>();
        private final List<Boolean> mLoadings = new ArrayList<Boolean>();
        private CharSequence mCellDescription;
        private PendingIntent mContentIntent;
        private SliceAction mSliceAction;

        @NonNull
        public CellBuilder addText(@NonNull CharSequence text) {
            return this.addText(text, false);
        }

        @NonNull
        public CellBuilder addText(@Nullable CharSequence text, boolean isLoading) {
            this.mObjects.add(text);
            this.mTypes.add(0);
            this.mLoadings.add(isLoading);
            return this;
        }

        @NonNull
        public CellBuilder addTitleText(@NonNull CharSequence text) {
            return this.addTitleText(text, false);
        }

        @NonNull
        public CellBuilder addTitleText(@Nullable CharSequence text, boolean isLoading) {
            this.mObjects.add(text);
            this.mTypes.add(1);
            this.mLoadings.add(isLoading);
            return this;
        }

        @NonNull
        public CellBuilder addImage(@NonNull IconCompat image, int imageMode) {
            return this.addImage(image, imageMode, false);
        }

        @NonNull
        public CellBuilder addImage(@Nullable IconCompat image, int imageMode, boolean isLoading) {
            this.mObjects.add(new Pair((Object)image, (Object)imageMode));
            this.mTypes.add(2);
            this.mLoadings.add(isLoading);
            return this;
        }

        @NonNull
        public CellBuilder addOverlayText(@NonNull CharSequence text) {
            return this.addOverlayText(text, false);
        }

        @NonNull
        public CellBuilder addOverlayText(@Nullable CharSequence text, boolean isLoading) {
            this.mObjects.add(text);
            this.mTypes.add(3);
            this.mLoadings.add(isLoading);
            return this;
        }

        @NonNull
        public CellBuilder setContentIntent(@NonNull PendingIntent intent) {
            this.mContentIntent = intent;
            return this;
        }

        @NonNull
        public CellBuilder setContentIntent(@NonNull RemoteCallback callback) {
            this.mContentIntent = callback.toPendingIntent();
            return this;
        }

        @NonNull
        public CellBuilder setContentDescription(@NonNull CharSequence description) {
            this.mCellDescription = description;
            return this;
        }

        @NonNull
        public CellBuilder setSliceAction(@NonNull SliceAction action) {
            this.mSliceAction = action;
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public List<Object> getObjects() {
            return this.mObjects;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public List<Integer> getTypes() {
            return this.mTypes;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public List<Boolean> getLoadings() {
            return this.mLoadings;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public CharSequence getCellDescription() {
            return this.mCellDescription;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public PendingIntent getContentIntent() {
            return this.mContentIntent;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public CharSequence getTitle() {
            for (int i = 0; i < this.mObjects.size(); ++i) {
                if (this.mTypes.get(i) != 1) continue;
                return (CharSequence)this.mObjects.get(i);
            }
            return null;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public CharSequence getSubtitle() {
            for (int i = 0; i < this.mObjects.size(); ++i) {
                if (this.mTypes.get(i) != 0) continue;
                return (CharSequence)this.mObjects.get(i);
            }
            return null;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public SliceAction getSliceAction() {
            return this.mSliceAction;
        }
    }
}

